/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.videocall.notification;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.views.calls.audiocallnotification.CallBasePane;
import net.sipsnet.client.views.calls.audiocallnotification.ICallNotificationPaneResize;
import net.sipsnet.client.views.calls.videocall.IVideoProcessor;
import net.sipsnet.client.views.calls.videocall.VideoFrameView;

public class VideoNotificationPane
extends CallBasePane
implements IGUIObservable {
    private VBox fx_RootPane;
    private HBox fx_VideoFramePane;
    private VideoFrameView videoImageViewer;
    private VideoFrameView cameraImageViewer;
    private CallViewButton muteCallImageButton;
    private final IVideoProcessor iVideoProcessor;
    private double xOffset;
    private double yOffset;
    private final Stage stage;
    private StackPane fx_MainName;
    private CallViewButton callVideoCapturing;
    private HBox fx_ivVideoCapturing;
    private boolean videoPlaying;

    public VideoNotificationPane(Stage stage, IVideoProcessor iVideoProcessor, ICallNotificationPaneResize iCallNotificationPaneResize) {
        super(stage, iCallNotificationPaneResize);
        this.stage = stage;
        this.iVideoProcessor = iVideoProcessor;
        this.initComponents();
        this.initObservable();
    }

    @Override
    public void setCurrentSize() {
        this.setNodeWidth(318);
        this.setNodeHeight(243);
    }

    @Override
    public Pane setLineInfoParameters() {
        boolean isMute = AudioCaller.isMute();
        this.muteCallImageButton.setImageView(isMute ? "notification/call/callpanel_mute_on.png" : "notification/call/callpanel_mute_off.png");
        this.muteCallImageButton.setTooltip(isMute ? "tooltip_unmute" : "tooltip_mute");
        ClientSingleton.toLog(this.getClass().getSimpleName(), "isMute=" + isMute);
        this.callVideoCapturing.setImagePath(this.iVideoProcessor.isCapturing() ? "notification/call/callpanel_vid_on.png" : "notification/call/callpanel_vid_off.png");
        this.callVideoCapturing.setTooltip(!this.iVideoProcessor.isCapturing() ? "tooltip_disable_video" : "tooltip_video");
        return this.fx_RootPane;
    }

    private void initComponents() {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/line/notification/videocallnotificationpane.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        try {
            this.fx_RootPane = (VBox)loader.load();
            this.fx_RootPane.setStyle("-fx-background-color:black;");
            this.fx_MainName = (StackPane)loader.getNamespace().get((Object)"fx_MainName");
            this.fx_MainName.setPrefWidth(this.fx_RootPane.getPrefWidth());
            this.fx_MainName.setPrefHeight(this.fx_RootPane.getPrefHeight());
            this.fx_VideoFramePane = (HBox)loader.getNamespace().get((Object)"fx_VideoFramePane");
            this.fx_VideoFramePane.setPrefWidth(this.fx_RootPane.getPrefWidth());
            this.fx_VideoFramePane.setPrefHeight(this.fx_RootPane.getPrefHeight());
            this.fx_VideoFramePane.setAlignment(Pos.CENTER);
            this.videoImageViewer = VideoFrameView.getInstance("Notification view", 2);
            this.iVideoProcessor.addImageViewer(this.videoImageViewer);
            Pane vImageView = this.videoImageViewer.getFrameView();
            vImageView.prefWidthProperty().bind((ObservableValue)this.fx_VideoFramePane.prefWidthProperty());
            vImageView.prefHeightProperty().bind((ObservableValue)this.fx_VideoFramePane.prefHeightProperty());
            vImageView.prefWidthProperty().addListener((event, oldValue, newValue) -> {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Constants.FRAME_SIZE_CHANGED=" + this.stage.getHeight() + "x" + newValue.doubleValue());
                if (this.stage.getHeight() < newValue.doubleValue()) {
                    this.stage.setHeight(newValue.doubleValue());
                }
            });
            vImageView.prefHeightProperty().addListener((event, oldValue, newValue) -> {
                if (this.stage.getWidth() < newValue.doubleValue()) {
                    this.stage.setWidth(newValue.doubleValue());
                }
            });
            ClientSingleton.getInstance().setMouseCursor((Node)vImageView);
            vImageView.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "action.equals(Constants.OPEN_SESSION) event.getClickCount() =" + event.getClickCount() + " lineInfo.getSessionInfo()=" + this.getLineInfo().getSessionInfo());
                if (event.getClickCount() == 2 && this.getLineInfo() != null && this.getLineInfo().getSessionInfo() != null) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("sessionInfo", this.getLineInfo().getSessionInfo());
                    ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "Constants.OPEN_SESSION");
                }
            });
            vImageView.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
                this.xOffset = this.stage.getX() - event.getScreenX();
                this.yOffset = this.stage.getY() - event.getScreenY();
            });
            vImageView.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
                this.stage.setX(event.getScreenX() + this.xOffset);
                this.stage.setY(event.getScreenY() + this.yOffset);
            });
            this.fx_VideoFramePane.getChildren().add(0, (Object)vImageView);
            Pane fx_pCameraPane = (Pane)loader.getNamespace().get((Object)"fx_pCameraPane");
            this.cameraImageViewer = VideoFrameView.getInstance("Notification camera", 3);
            this.iVideoProcessor.addImageViewer(this.cameraImageViewer);
            Pane viewPane = this.cameraImageViewer.getFrameView();
            viewPane.prefWidthProperty().bind((ObservableValue)fx_pCameraPane.prefWidthProperty());
            viewPane.prefHeightProperty().bind((ObservableValue)fx_pCameraPane.prefHeightProperty());
            fx_pCameraPane.getChildren().add((Object)viewPane);
            HBox fx_hbButtonPane1 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane4");
            fx_hbButtonPane1.getChildren().add((Object)new CallViewButton(true, "notification/call/callpanel_add_user.png", (EventHandler<MouseEvent>)((EventHandler)str -> {
                ClientSingleton.getInstance().addParticipantToCall(this.getLineInfo(), false, true);
                str.consume();
            })));
            CallViewButton shareScreen = new CallViewButton(true, "notification/call/widget_show_screen.png", (EventHandler<MouseEvent>)((EventHandler)str -> {
                this.iVideoProcessor.setShowingDesktop(!this.iVideoProcessor.isDesktopShowing());
                str.consume();
            }));
            shareScreen.setTooltip("tooltip_enable_share_screen");
            HBox fx_hbButtonPane2 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane1");
            fx_hbButtonPane2.getChildren().add((Object)shareScreen);
            HBox fx_hbButtonPane3 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane2");
            this.callVideoCapturing = new CallViewButton(true, this.iVideoProcessor.isCapturing() ? "notification/call/callpanel_vid_on.png" : "notification/call/callpanel_vid_off.png", (EventHandler<MouseEvent>)((EventHandler)str -> {
                this.iVideoProcessor.setCapturing(!this.iVideoProcessor.isCapturing());
                this.callVideoCapturing.setTooltip(this.iVideoProcessor.isCapturing() ? "tooltip_disable_video" : "tooltip_video");
                str.consume();
            }));
            fx_hbButtonPane3.getChildren().add((Object)this.callVideoCapturing);
            HBox fx_hbButtonPane4 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane3");
            this.muteCallImageButton = new CallViewButton(true, "notification/call/callpanel_mute_off.png", (EventHandler<MouseEvent>)((EventHandler)str -> {
                AudioCaller.setMute();
                str.consume();
            }));
            fx_hbButtonPane4.getChildren().add((Object)this.muteCallImageButton);
            HBox fx_hbButtonPane5 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane5");
            CallViewButton hangupButton = new CallViewButton(true, WhiteLabels.isCustomHangupButton() ? "hangup_button/callpanel_hangup.png" : "notification/call/hangup.png", (EventHandler<MouseEvent>)((EventHandler)str -> {
                AudioCaller.dropCall(this.getLineInfo());
                str.consume();
            }));
            fx_hbButtonPane5.getChildren().add((Object)hangupButton);
            HBox fx_hbVBottomButtonsPane = (HBox)loader.getNamespace().get((Object)"fx_hbVBottomButtonsPane");
            this.fx_RootPane.setOnMouseExited(event -> {
                if (fx_hbVBottomButtonsPane.isVisible()) {
                    fx_hbVBottomButtonsPane.setVisible(false);
                }
            });
            this.fx_RootPane.setOnMouseEntered(event -> {
                if (!fx_hbVBottomButtonsPane.isVisible()) {
                    fx_hbVBottomButtonsPane.setVisible(true);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isVideoPlaying() {
        return this.videoPlaying;
    }

    public void startPlaying() {
        if (this.callVideoCapturing != null) {
            this.callVideoCapturing.setImagePath(this.iVideoProcessor.isCapturing() ? "notification/call/callpanel_vid_on.png" : "notification/call/callpanel_vid_off.png");
        }
        this.videoPlaying = true;
        this.videoImageViewer.startPlaying();
        this.cameraImageViewer.startPlaying();
    }

    public void stopPlaying() {
        this.videoPlaying = false;
        this.videoImageViewer.stopPlaying();
        this.cameraImageViewer.stopPlaying();
    }

    private void initObservable() {
        String[] actions = new String[]{"smile.uccproject.CHANGE_CAPTURING_STATE", IntentConstants.LINE_INFO_MUTE_LINE};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        if (action.equals("smile.uccproject.CHANGE_CAPTURING_STATE")) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Constants.CHANGE_CAPTURING_STATE=" + this.iVideoProcessor.isCapturing());
            if (this.callVideoCapturing != null) {
                Platform.runLater(() -> this.callVideoCapturing.setImagePath(this.iVideoProcessor.isCapturing() ? "notification/call/callpanel_vid_on.png" : "notification/call/callpanel_vid_off.png"));
            }
        } else if (action.equals(IntentConstants.LINE_INFO_MUTE_LINE)) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                boolean isMute = clientConnector.getMute();
                Platform.runLater(() -> {
                    this.muteCallImageButton.setImageView(isMute ? "notification/call/callpanel_mute_on.png" : "notification/call/callpanel_mute_off.png");
                    this.muteCallImageButton.setTooltip(isMute ? "tooltip_unmute" : "tooltip_mute");
                });
            });
        }
    }

    public void continueDrawingFrame() {
        this.videoImageViewer.continueDrawFrame();
        this.cameraImageViewer.continueDrawFrame();
    }

    public void stopDrawingFrame() {
        this.videoImageViewer.stopDrawFrame();
        this.cameraImageViewer.stopDrawFrame();
    }
}

