/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.videocall.videoscreen;

import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.stage.IStageResized;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttoncombobox.MenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.views.calls.videocall.VideoFrameView;
import net.sipsnet.client.views.calls.videocall.VideoProcessor;
import net.sipsnet.client.views.calls.videocall.videoscreen.IVCScreenController;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;

public class VideoPaneController
implements Initializable,
IStageResized,
IGUIObservable {
    public StackPane fx_spTopPane;
    public HBox fx_VideoPane;
    public HBox fx_hbCallTopPane;
    public HBox fx_BottomPane;
    public MenuImageButton fx_ivCallTopMenu;
    public VBox fx_vbCallAvatar;
    public MyLabel fx_lbCallContactName;
    public ImageButton fx_ivVideoSmall;
    public AnchorPane fx_CameraVideoPane;
    public ImageButton fx_ivChat;
    public ImageButton fx_ivMute;
    public ImageButton fx_ivShareScreen;
    public ImageButton fx_ivAddUser;
    public ImageButton fx_ivHangUp;
    public ImageButton fx_ivVideo;
    public HBox fx_hbBottomPane;
    public VBox fx_vbCallInfoButtons;
    public ImageButton fx_ivInfo;
    public ImageButton fx_ivActivity;
    public ImageButton fx_ivComment;
    public VBox fx_vbHangUp;
    private VideoProcessor videoProcessor;
    private VideoFrameView videoImageViewer;
    private VideoFrameView cameraImageViewer;
    private boolean isChatOpened;
    public static final int INFO_PROFILE = 0;
    private final int INFO_ACTIVITY = 1;
    private final int INFO_COMMENT = 2;
    private int currentVisibleInfoPane = -1;
    private SessionInfo sessionInfo;
    public HBox fx_RootPane;
    private LineInfo lineInfo;
    private IVCScreenController ivcScreenController;
    private final SimpleBooleanProperty isProfileOpened = new SimpleBooleanProperty((Object)false, "isProfileOpened");

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public HBox getFx_RootPane() {
        return this.fx_RootPane;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.fx_RootPane.setId(this.getClass().getSimpleName());
        this.initMenu();
        if (Theme.getInstance().isDarkTheme()) {
            Theme.getInstance().applyTo(Constants.BASE_COLOR, (Pane)this.fx_spTopPane);
        } else {
            this.fx_spTopPane.setStyle("-fx-background-color:black;");
        }
        this.fx_hbCallTopPane.setStyle("-fx-background-color: linear-gradient(to bottom,rgba(0, 0, 0), rgba(0, 0, 0, 0, 0.64));");
        this.fx_CameraVideoPane.setStyle("-fx-background-color: linear-gradient(to top,rgba(0, 0, 0), rgba(0, 0, 0, 0, 0.46));");
        this.fx_BottomPane.setStyle("-fx-background-color: linear-gradient(to top,rgba(0, 0, 0), rgba(0, 0, 0, 0, 0.46));");
        this.fx_ivVideoSmall.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            ClientSingleton.getInstance().doNotify(Constants.RESIZE_TABS_PANE);
            TimerExecutor.getInstance().setMyAction(() -> {
                ClientSingleton.getInstance().setFullVideoScreen();
                this.fx_ivVideoSmall.setTooltip(ClientSingleton.getInstance().isFullScreenMode() ? "tooltip_disable_full_screen" : "tooltip_enable_full_screen");
            }).startWithDelay(500L);
        });
        this.fx_ivVideoSmall.setTooltip("tooltip_enable_full_screen");
        this.fx_hbCallTopPane.setMinWidth(0.0);
        this.fx_hbBottomPane.setMinWidth(0.0);
        this.fx_spTopPane.prefWidthProperty().bind((ObservableValue)this.fx_RootPane.widthProperty());
        this.fx_spTopPane.prefHeightProperty().bind((ObservableValue)this.fx_RootPane.heightProperty());
        StackPane.setAlignment((Node)this.fx_VideoPane, (Pos)Pos.CENTER);
        this.fx_VideoPane.setAlignment(Pos.CENTER);
        this.fx_VideoPane.prefWidthProperty().bind((ObservableValue)this.fx_RootPane.widthProperty());
        this.fx_VideoPane.prefHeightProperty().bind((ObservableValue)this.fx_RootPane.heightProperty());
        this.fx_VideoPane.prefWidthProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue == null || oldValue != null && Math.abs(oldValue.intValue() - newValue.intValue()) <= 2) {
                return;
            }
            TimerExecutor.getInstance().setMyAction(() -> {
                if (newValue.intValue() < 600) {
                    if (this.fx_BottomPane.isVisible()) {
                        this.fx_BottomPane.setVisible(false);
                        this.fx_ivCallTopMenu.setVisible(true);
                    }
                } else if (!this.fx_BottomPane.isVisible()) {
                    this.fx_BottomPane.setVisible(true);
                    this.fx_ivCallTopMenu.setVisible(false);
                }
            }).startWithDelayInGUIThread(10L);
        });
        this.fx_hbCallTopPane.prefWidthProperty().bind((ObservableValue)this.fx_RootPane.widthProperty());
        this.fx_hbBottomPane.prefWidthProperty().bind((ObservableValue)this.fx_RootPane.widthProperty());
        this.fx_VideoPane.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> ClientSingleton.getInstance().runLater(() -> {
            this.fx_hbCallTopPane.setVisible(true);
            this.fx_BottomPane.setVisible(true);
            this.fx_vbCallInfoButtons.setVisible(true);
        }));
        this.fx_hbCallTopPane.visibleProperty().addListener((event, oldValue, newValue) -> {
            if (this.lineInfo != null && newValue.booleanValue()) {
                this.makeCoverPaneVisible();
                this.hideCoverPane();
            }
        });
        this.fx_ivMute.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> AudioCaller.setMute()));
        this.fx_ivMute.setTooltip(AudioCaller.isMute() ? "tooltip_unmute" : "tooltip_mute");
        this.fx_ivChat.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            if (this.ivcScreenController != null) {
                if (this.isChatOpened) {
                    this.ivcScreenController.closeChatView();
                    this.setChatOpened(false);
                } else {
                    if (this.currentVisibleInfoPane != -1) {
                        this.setInfoPaneImages(this.currentVisibleInfoPane);
                        this.ivcScreenController.closePaneView();
                    }
                    this.ivcScreenController.openChatView();
                    this.setChatOpened(true);
                }
            }
        }));
        this.fx_ivChat.setTooltip("tooltip_open_chat");
        this.fx_ivAddUser.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ClientSingleton.getInstance().addParticipantToCall(this.lineInfo, true)));
        this.fx_ivAddUser.setTooltip("tooltip_add_call");
        this.fx_ivShareScreen.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.videoProcessor.setShowingDesktop(!this.videoProcessor.isDesktopShowing())));
        this.fx_ivShareScreen.setTooltip("tooltip_enable_share_screen");
        this.fx_ivVideo.setClickImages(new String[]{"callscreen/callscreen_video_on.png", "callscreen/callscreen_video_off.png"});
        this.fx_ivVideo.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            this.videoProcessor.setCapturing(!this.videoProcessor.isCapturing());
            this.fx_ivVideo.setTooltip(this.videoProcessor.isCapturing() ? "tooltip_disable_video" : "tooltip_video");
        }));
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_ivHangUp.getImageViewButton());
        this.fx_ivHangUp.getImageViewButton().setOnMousePressed(mouseEvent -> TimerExecutor.getInstance().start(() -> AudioCaller.dropCall(this.getLineInfo())));
        this.fx_ivHangUp.setImagePath(WhiteLabels.isCustomHangupButton() ? "hangup_button/callscreen_hangup.png" : "callscreen/callscreen_hangup.png");
        this.fx_ivHangUp.setSize(42, 42);
        this.fx_ivHangUp.getImageViewButton().setFitWidth(42.0);
        this.fx_ivHangUp.getImageViewButton().setFitHeight(42.0);
        this.fx_ivHangUp.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            TimerExecutor.getInstance().start(() -> AudioCaller.dropCall(this.getLineInfo()));
            mouseEvent.consume();
        }));
        this.fx_ivHangUp.setTooltip("tooltip_hang_up");
        this.fx_ivInfo.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "fx_ivInfo sessionInfo.getStatus()=" + this.sessionInfo.getStatus());
            if (this.sessionInfo.getStatus() <= 3 && this.ivcScreenController != null) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "fx_ivInfo currentVisibleInfoPane=" + this.currentVisibleInfoPane);
                if (this.setInfoPaneImages(0)) {
                    if (this.isChatOpened) {
                        this.ivcScreenController.closeChatView();
                        this.setChatOpened(false);
                    }
                    this.ivcScreenController.openProfile(this.sessionInfo);
                } else {
                    this.ivcScreenController.closePaneView();
                }
            }
        }));
        this.fx_ivInfo.setTooltip("tooltip_open_profile");
        this.fx_ivActivity.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.ivcScreenController != null) {
                if (this.setInfoPaneImages(1)) {
                    if (this.isChatOpened) {
                        this.ivcScreenController.closeChatView();
                        this.setChatOpened(false);
                    }
                    this.ivcScreenController.openCallHistory(this.lineInfo);
                } else {
                    this.ivcScreenController.closePaneView();
                }
            }
        }));
        this.fx_ivActivity.setTooltip("tooltip_open_activities");
        this.fx_ivComment.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.ivcScreenController != null) {
                if (this.setInfoPaneImages(2)) {
                    if (this.isChatOpened) {
                        this.ivcScreenController.closeChatView();
                        this.setChatOpened(false);
                    }
                    this.ivcScreenController.openCallActivity(this.lineInfo);
                } else {
                    this.ivcScreenController.closePaneView();
                }
            }
        }));
        this.fx_ivComment.setTooltip("tooltip_open_call_activity");
        this.initObservable();
    }

    public void initMenu() {
        this.fx_ivCallTopMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_video_menu_item1"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            if (this.ivcScreenController != null) {
                if (this.isChatOpened) {
                    this.ivcScreenController.closeChatView();
                    this.setChatOpened(false);
                } else {
                    this.ivcScreenController.openChatView();
                    this.setChatOpened(true);
                }
            }
            this.fx_ivCallTopMenu.hideMenu();
        }));
        this.fx_ivCallTopMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_video_menu_item2"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            AudioCaller.setMute();
            this.fx_ivCallTopMenu.hideMenu();
        }));
        this.fx_ivCallTopMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_video_menu_item3"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            this.videoProcessor.setCapturing(!this.videoProcessor.isCapturing());
            this.fx_ivCallTopMenu.hideMenu();
        }));
        this.fx_ivCallTopMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_video_menu_item4"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            this.fx_ivCallTopMenu.hideMenu();
            this.videoProcessor.setShowingDesktop(!this.videoProcessor.isDesktopShowing());
        }));
        this.fx_ivCallTopMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_video_menu_item5"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            ClientSingleton.getInstance().addParticipantToCall(this.lineInfo, true);
            this.fx_ivCallTopMenu.hideMenu();
        }));
        this.fx_ivCallTopMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_video_menu_item6"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            this.fx_ivCallTopMenu.hideMenu();
            AudioCaller.dropCall(this.getLineInfo());
        }));
    }

    public void setIvcScreenController(IVCScreenController ivcScreenController) {
        this.ivcScreenController = ivcScreenController;
    }

    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    public void setLineInfo(LineInfo lineInfo) {
        if (lineInfo == null) {
            this.setChatOpened(false);
            this.lineInfo = null;
            if (ClientSingleton.getInstance().getClientConnector().get().getMute()) {
                AudioCaller.setMute();
            }
            this.videoImageViewer.stopPlaying();
            this.cameraImageViewer.stopPlaying();
            return;
        }
        this.lineInfo = lineInfo;
        this.fx_ivCallTopMenu.setVisible(false);
        this.setChatOpened(false);
        this.sessionInfo = ClientSingleton.getInstance().getSessionInfo(lineInfo);
        try {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setLineInfo lineInfo=" + lineInfo);
            this.videoProcessor.setOutputPixFormat((int)this.fx_VideoPane.getPrefWidth(), (int)this.fx_VideoPane.getPrefHeight());
            this.videoImageViewer.startPlaying();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.cameraImageViewer.startPlaying();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        AvatarPane avatarPane = AvatarPane.getInstance(this.sessionInfo, 32, 16, false);
        this.fx_vbCallAvatar.getChildren().clear();
        this.fx_vbCallAvatar.getChildren().add((Object)avatarPane);
        this.fx_lbCallContactName.setText(lineInfo.getPartyName());
        this.makeCoverPaneVisible();
        this.hideCoverPane();
        this.fx_ivShareScreen.setTooltip("tooltip_enable_share_screen");
        this.fx_ivVideo.setTooltip(this.videoProcessor.isCapturing() ? "tooltip_disable_video" : "tooltip_video");
    }

    private void makeCoverPaneVisible() {
        if (!this.fx_hbCallTopPane.isVisible()) {
            this.fx_hbCallTopPane.setVisible(true);
            this.fx_BottomPane.setVisible(true);
            this.fx_vbCallInfoButtons.setVisible(true);
        }
    }

    private void hideCoverPane() {
        TimerExecutor.getInstance().setMyAction(() -> {
            this.fx_hbCallTopPane.setVisible(false);
            this.fx_BottomPane.setVisible(false);
            this.fx_vbCallInfoButtons.setVisible(false);
        }).startWithDelayInGUIThread(4000L);
    }

    private void initObservable() {
        String[] actions = new String[]{Constants.FRAME_SIZE_CHANGED, IntentConstants.LINE_INFO_MUTE_LINE};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        if (!action.equals(Constants.FRAME_SIZE_CHANGED) && action.equals(IntentConstants.LINE_INFO_MUTE_LINE)) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> ClientSingleton.getInstance().runLater(() -> {
                boolean isMute = clientConnector.getMute();
                this.fx_ivMute.setImagePath(isMute ? "callscreen/callscreen_mute_on.png" : "callscreen/callscreen_mute_off.png");
                this.fx_ivMute.setTooltip(isMute ? "tooltip_unmute" : "tooltip_mute");
            }));
        }
    }

    public void setVideoProcessor(VideoProcessor videoProcessor) {
        this.videoProcessor = videoProcessor;
        this.fx_VideoPane.prefWidthProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.getLineInfo() != null && this.getLineInfo().isVideoEnabled()) {
                videoProcessor.setOutputPixFormat(newValue.intValue(), (int)this.fx_VideoPane.getPrefHeight());
            }
        });
        this.fx_VideoPane.prefHeightProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.getLineInfo() != null && this.getLineInfo().isVideoEnabled()) {
                videoProcessor.setOutputPixFormat((int)this.fx_VideoPane.getPrefWidth(), newValue.intValue());
            }
        });
        this.videoImageViewer = VideoFrameView.getInstance("Video pane viewer", 4).setIsWithNotification(true);
        videoProcessor.addImageViewer(this.videoImageViewer);
        Pane viewPane = this.videoImageViewer.getFrameView();
        viewPane.prefWidthProperty().bind((ObservableValue)this.fx_VideoPane.prefWidthProperty());
        viewPane.prefHeightProperty().bind((ObservableValue)this.fx_VideoPane.prefHeightProperty());
        this.fx_VideoPane.getChildren().add((Object)viewPane);
        this.fx_VideoPane.setAlignment(Pos.CENTER);
        this.cameraImageViewer = VideoFrameView.getInstance("Video pane camera", 0).setResizeFitToPane((Pair<Double, Double>)new Pair((Object)this.fx_CameraVideoPane.getMaxWidth(), (Object)this.fx_CameraVideoPane.getMaxHeight()));
        videoProcessor.addImageViewer(this.cameraImageViewer);
        Pane imageView = this.cameraImageViewer.getFrameView();
        imageView.setPrefWidth(this.fx_CameraVideoPane.getMaxHeight());
        imageView.setPrefHeight(this.fx_CameraVideoPane.getMaxWidth());
        this.fx_CameraVideoPane.getChildren().add((Object)imageView);
        AnchorPane.setLeftAnchor((Node)imageView, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)imageView, (Double)10.0);
        AnchorPane.setRightAnchor((Node)imageView, (Double)0.0);
        AnchorPane.setTopAnchor((Node)imageView, (Double)0.0);
    }

    public void setChatOpened(boolean chatOpened) {
        this.isChatOpened = chatOpened;
        this.chatIsOpened();
    }

    public boolean isChatOpened() {
        return this.isChatOpened;
    }

    private void chatIsOpened() {
        this.fx_ivChat.setImagePath(this.isChatOpened ? "callscreen/callscreen_chat_on.png" : "callscreen/callscreen_chat_off.png");
    }

    public void setInfoButtonImage(boolean mode) {
        this.setIsProfileOpened(mode);
    }

    private boolean isIsProfileOpened() {
        return this.isProfileOpened.get();
    }

    private void setIsProfileOpened(boolean isProfileOpened) {
        this.isProfileOpened.set(isProfileOpened);
    }

    public boolean setInfoPaneImages(int mode) {
        if (this.currentVisibleInfoPane == mode) {
            switch (mode) {
                case 0: {
                    this.fx_ivInfo.setImagePath("chat/messagecell/info_panel_white_border.png");
                    break;
                }
                case 1: {
                    this.fx_ivActivity.setImagePath("chat/messagecell/activity_panel_white_border.png");
                    break;
                }
                case 2: {
                    this.fx_ivComment.setImagePath("chat/messagecell/comments_panel_white_border.png");
                }
            }
            this.currentVisibleInfoPane = -1;
            return false;
        }
        switch (mode) {
            case 0: {
                this.fx_ivInfo.setImagePath("chat/messagecell/panel_close_white.png");
                this.fx_ivActivity.setImagePath("chat/messagecell/activity_panel_white_border.png");
                this.fx_ivComment.setImagePath("chat/messagecell/comments_panel_white_border.png");
                break;
            }
            case 1: {
                this.fx_ivInfo.setImagePath("chat/messagecell/info_panel_white_border.png");
                this.fx_ivActivity.setImagePath("chat/messagecell/panel_close_white.png");
                this.fx_ivComment.setImagePath("chat/messagecell/comments_panel_white_border.png");
                break;
            }
            case 2: {
                this.fx_ivInfo.setImagePath("chat/messagecell/info_panel_white_border.png");
                this.fx_ivActivity.setImagePath("chat/messagecell/activity_panel_white_border.png");
                this.fx_ivComment.setImagePath("chat/messagecell/panel_close_white.png");
            }
        }
        this.currentVisibleInfoPane = mode;
        return true;
    }

    public boolean getCurrentInfoMode() {
        return this.currentVisibleInfoPane != -1;
    }

    @Override
    public void resize(double deltaWidth, double deltaHeight) {
    }

    public void setCapturing() {
        this.videoProcessor.setCapturing();
    }
}

