/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.changepassword;

import java.io.IOException;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.views.mainview.MainViewSceneController;

public class ChangePasswordController {
    @FXML
    private VBox fx_vbRoot;
    private boolean isShowOldPassword;
    private boolean isShowNewPassword;
    private boolean isShowConfirmPassword;
    @FXML
    private ImageView fx_imgLogo;
    @FXML
    private ImageView fx_ivBackground;
    @FXML
    private ImageView fx_imgLogoBottom;
    @FXML
    private TextField fx_etOldTextPass;
    @FXML
    private PasswordField fx_etOldPass;
    @FXML
    private ImageView fx_cbOldEye;
    @FXML
    private TextField fx_etNewTextPass;
    @FXML
    private PasswordField fx_etNewPass;
    @FXML
    private ImageView fx_cbNewEye;
    @FXML
    private TextField fx_etConfirmTextPass;
    @FXML
    private PasswordField fx_etConfirmPass;
    @FXML
    private ImageView fx_cbConfirmEye;
    @FXML
    private CloseImageButton fx_CloseStage;
    @FXML
    private Button fx_btnSave;
    @FXML
    private Label fx_lbTitle;
    @FXML
    private StackPane fx_LoginStack;

    public ChangePasswordController() {
        try {
            this.initComponents();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initComponents() throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/changepassword/changepassword.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        StackPane fx_MainPane = (StackPane)loader.load();
        fx_MainPane.setMaxWidth(330.0);
        fx_MainPane.setMaxHeight(625.0);
        fx_MainPane.setMinWidth(330.0);
        fx_MainPane.setMinHeight(625.0);
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgLogo, "main_emblem.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_imgLogoBottom, "bottom_emblem.png");
        this.fx_btnSave.getStylesheets().add((Object)MyUtils.getResourceUrl(MainViewSceneController.class, "/extracss/myunselectedbutton.css"));
        this.fx_btnSave.getStyleClass().add((Object)"buttonsStyleClass");
        Theme.getInstance().applyTo(Constants.LOGIN_BUTTON_BACKGROUND_STYLE, (Labeled)this.fx_btnSave);
        Theme.getInstance().applyTo(Constants.LOGIN_LABEL_TEXT_FILL, (Labeled)this.fx_lbTitle);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_cbOldEye);
        this.fx_etOldTextPass.setVisible(false);
        this.makeEye(this.fx_etOldTextPass, this.fx_etOldPass, this.fx_cbOldEye, this.isShowOldPassword);
        this.fx_cbOldEye.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.isShowOldPassword = !this.isShowOldPassword;
            this.makeEye(this.fx_etOldTextPass, this.fx_etOldPass, this.fx_cbOldEye, this.isShowOldPassword);
        });
        this.fx_etOldTextPass.textProperty().bindBidirectional((Property)this.fx_etOldPass.textProperty());
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_cbNewEye);
        this.fx_etNewTextPass.setVisible(false);
        this.makeEye(this.fx_etNewTextPass, this.fx_etNewPass, this.fx_cbNewEye, this.isShowNewPassword);
        this.fx_cbNewEye.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.isShowNewPassword = !this.isShowNewPassword;
            this.makeEye(this.fx_etNewTextPass, this.fx_etNewPass, this.fx_cbNewEye, this.isShowNewPassword);
        });
        this.fx_etNewTextPass.textProperty().bindBidirectional((Property)this.fx_etNewPass.textProperty());
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_cbConfirmEye);
        this.fx_etConfirmTextPass.setVisible(false);
        this.makeEye(this.fx_etConfirmTextPass, this.fx_etConfirmPass, this.fx_cbConfirmEye, this.isShowConfirmPassword);
        this.fx_cbConfirmEye.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            this.isShowConfirmPassword = !this.isShowConfirmPassword;
            this.makeEye(this.fx_etConfirmTextPass, this.fx_etConfirmPass, this.fx_cbConfirmEye, this.isShowConfirmPassword);
        });
        this.fx_etConfirmTextPass.textProperty().bindBidirectional((Property)this.fx_etConfirmPass.textProperty());
        ClientSingleton.getInstance().runLater(() -> this.fx_vbRoot.requestFocus());
        Optional<String> optionalB = ClientSingleton.getInstance().getStyle(Constants.HAS_LOGIN_BACKGROUND_IMAGE);
        if (optionalB.isPresent() && "false".equals(optionalB.get())) {
            Theme.getInstance().applyTo(Constants.LOGIN_BACKGROUND_STYLE, (Pane)this.fx_vbRoot);
            Theme.getInstance().applyTo(Constants.LOGIN_BACKGROUND_STYLE, (Pane)fx_MainPane);
            this.fx_LoginStack.getChildren().remove((Object)this.fx_ivBackground);
        } else {
            ClientSingleton.getInstance().setBackgroundImage(this.fx_ivBackground, "login/ic_login_background.png");
            Theme.getInstance().applyTo(Constants.BASE_COLOR, (Pane)fx_MainPane);
        }
        MyPopupWindow myPopupWindow = MyPopupWindow.getNewInstance((Pane)fx_MainPane).setAlwaysOnTop(false).initMotionListeners((Node)this.fx_vbRoot);
        ClientSingleton.getInstance().setImageToImageView(this.fx_CloseStage, "login/win_close.png");
        this.fx_CloseStage.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> myPopupWindow.hide()));
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_btnSave);
        this.fx_btnSave.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                String p = this.fx_etOldPass.getText();
                String p1 = this.fx_etNewPass.getText();
                String p2 = this.fx_etConfirmPass.getText();
                if (!p1.equals(p2)) {
                    throw new Exception(ClientSingleton.getInstance().getString("cp_prompt_conf_error"));
                }
                myPopupWindow.hide();
                clientConnector.changePassword(p, p2);
            }
            catch (Exception e) {
                e.printStackTrace();
                ClientSingleton.getInstance().showAlert(e.getLocalizedMessage());
            }
        }));
        myPopupWindow.showInCenter();
    }

    private void makeEye(TextField fx_etTextPass, PasswordField fx_etPass, ImageView fx_imgEye, boolean isShowPassword) {
        fx_etTextPass.setVisible(isShowPassword);
        fx_etPass.setVisible(!isShowPassword);
        String imgPath = isShowPassword ? (WhiteLabels.isCustomIcons() ? "custom_icons/ic_login_eye_crossed.png" : "login/ic_login_eye_crossed.png") : (WhiteLabels.isCustomIcons() ? "custom_icons/ic_login_eye.png" : "login/ic_login_eye.png");
        ClientSingleton.getInstance().setImageToImageView(fx_imgEye, imgPath);
    }
}

