/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.cell;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.ClientUtil;
import smile.cti.client.ClientConnector;
import smile.cti.client.MessageInfo;
import smile.util.Utils;

public class MessageInfoDate
extends MessageInfo {
    public static final int DATE_STATUS = -100000;
    private String content = "";
    private long time;

    public MessageInfoDate(long time) {
        this.time = time;
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        optionalClientConnector.ifPresent(clientConnector -> {
            this.content = ClientSingleton.getInstance().getDateWMonthString(time);
        });
        this.setId(Utils.generateGUID((long)time));
    }

    public MessageInfoDate(String day) {
        this.content = day;
        SimpleDateFormat f = new SimpleDateFormat(ClientUtil.dayMessageFormat);
        try {
            Date d = f.parse(day);
            this.time = d.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.setId(Utils.generateGUID((long)this.time));
    }

    public long getTime() {
        return this.time;
    }

    public String getContent() {
        return this.content;
    }

    public String getId() {
        return super.getId() == null ? "" : super.getId();
    }

    public String toString() {
        return super.toString() + " " + this.content;
    }
}

