/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.audioplayer.AudioPlayer;
import net.sipsnet.client.utils.audioplayer.IAudioPlayer;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.slider.MySlider;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.ClientConnector;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MessageInfo;

public class AudioMessageViewerHolder
extends HBox
implements FileTransferListener,
IAudioPlayer,
IActionOnRelease {
    private VBox audioMessage;
    private final Label fx_lbPlayingTime;
    private final Label fx_lbTotalPlayingTime;
    private ProgressIndicator progressIndicator;
    private final StackPane fx_spPlaying;
    private final ImageButton fx_ivPlaying;
    private AudioPlayer audioPlayer;
    private FileInfo fileInfo;
    private Timer timer;
    private final TimerTask loadingTimerTask = new TimerTask(){

        @Override
        public void run() {
            if (AudioMessageViewerHolder.this.fileInfo != null && AudioMessageViewerHolder.this.fileInfo.isLoading()) {
                ClientSingleton.getInstance().runLater(() -> {
                    AudioMessageViewerHolder.this.fx_spPlaying.getChildren().remove((Object)AudioMessageViewerHolder.this.fx_ivPlaying);
                    if (!AudioMessageViewerHolder.this.fx_spPlaying.getChildren().contains((Object)AudioMessageViewerHolder.this.progressIndicator)) {
                        AudioMessageViewerHolder.this.fx_spPlaying.getChildren().add((Object)AudioMessageViewerHolder.this.progressIndicator);
                    }
                    AudioMessageViewerHolder.this.progressIndicator.setProgress((double)AudioMessageViewerHolder.this.fileInfo.getLoadingPercent());
                });
            } else {
                this.cancel();
                AudioMessageViewerHolder.this.timer.cancel();
                AudioMessageViewerHolder.this.timer.purge();
                AudioMessageViewerHolder.this.timer = null;
                AudioMessageViewerHolder.this.showDuration();
            }
        }
    };
    private final boolean isComment;

    public AudioMessageViewerHolder(MessageInfo messageInfo, int width, boolean isComment) {
        this.isComment = isComment;
        this.setPrefWidth(width);
        this.setAlignment(Pos.CENTER_LEFT);
        this.fx_spPlaying = new StackPane();
        HBox.setMargin((Node)this.fx_spPlaying, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        this.getChildren().add((Object)this.fx_spPlaying);
        this.fx_spPlaying.setPrefWidth(32.0);
        this.fx_spPlaying.setPrefHeight(32.0);
        this.fx_ivPlaying = new ImageButton();
        this.fx_ivPlaying.setSize(32, 32);
        this.fx_ivPlaying.setClickImages(new String[]{"chat/messagecell/play_recording.png", "chat/messagecell/pause_recording.png"});
        this.fx_ivPlaying.setIsRounded(true);
        HBox.setMargin((Node)this.fx_ivPlaying, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        this.fx_spPlaying.getChildren().add((Object)this.fx_ivPlaying);
        this.fx_lbPlayingTime = new Label("00:00");
        this.fx_lbPlayingTime.setMinWidth(40.0);
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_lbPlayingTime);
        HBox.setMargin((Node)this.fx_lbPlayingTime, (Insets)new Insets(0.0, 6.0, 0.0, 5.0));
        this.getChildren().add((Object)this.fx_lbPlayingTime);
        MySlider fx_Slider = new MySlider();
        HBox.setHgrow((Node)fx_Slider, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)fx_Slider, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)fx_Slider);
        this.fx_lbTotalPlayingTime = new Label("00:00");
        this.fx_lbTotalPlayingTime.setMinWidth(40.0);
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_lbTotalPlayingTime);
        HBox.setMargin((Node)this.fx_lbTotalPlayingTime, (Insets)new Insets(0.0, 6.0, 0.0, 5.0));
        this.getChildren().add((Object)this.fx_lbTotalPlayingTime);
        this.fx_ivPlaying.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.onPlayAction()));
        this.progressIndicator = new ProgressIndicator(0.0);
        this.progressIndicator.setMaxWidth(32.0);
        this.progressIndicator.setMaxHeight(32.0);
        if (this.audioPlayer == null) {
            this.audioPlayer = new AudioPlayer(fx_Slider, this);
        }
        this.bind(messageInfo);
        this.setPrefHeight(32.0);
    }

    private void onPlayAction() {
        if (!this.audioPlayer.isHasFile()) {
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            File file = null;
            try {
                file = optionalClientConnector.get().getFile(this.fileInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (file != null && file.exists()) {
                this.audioPlayer.setFile(file);
                this.audioPlayer.startPlayback();
            } else {
                this.fileInfo.addTransfrerListener((FileTransferListener)this);
                optionalClientConnector.get().loadFile(this.fileInfo);
            }
        } else if (!this.audioPlayer.isPlaying()) {
            this.audioPlayer.startPlayback();
        } else {
            this.audioPlayer.stopPlayback();
        }
    }

    public void transferStarted(FileInfo fileInfo) {
        ClientSingleton.getInstance().runLater(() -> this.fx_spPlaying.getChildren().add((Object)this.progressIndicator));
    }

    public void transferProgress(FileInfo fileInfo) {
        ClientSingleton.getInstance().runLater(() -> this.progressIndicator.setProgress((double)fileInfo.getLoadingPercent()));
    }

    public void transferEnded(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        fileInfo.removeTransfrerListener((FileTransferListener)this);
        try {
            this.showDuration();
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            if (optionalClientConnector.isPresent()) {
                File file = optionalClientConnector.get().getFile(fileInfo);
                if (file != null) {
                    this.audioPlayer.setFile(file);
                    this.audioPlayer.startPlayback();
                } else {
                    ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("call_record_not_found"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDuration() {
        ClientSingleton.getInstance().runLater(() -> {
            this.fx_spPlaying.getChildren().remove((Object)this.progressIndicator);
            if (!this.fx_spPlaying.getChildren().contains((Object)this.fx_ivPlaying)) {
                this.fx_spPlaying.getChildren().add((Object)this.fx_ivPlaying);
            }
            long mediaDuration = this.fileInfo.getMediaDuration();
            this.fx_lbTotalPlayingTime.setText(ClientSingleton.getInstance().getTimeDuration(mediaDuration));
            this.audioPlayer.setSliderMaxDuration(mediaDuration);
        });
    }

    @Override
    public void onStartPlayback() {
    }

    @Override
    public void onStopPlayback() {
    }

    @Override
    public void onEndPlayback() {
        ClientSingleton.getInstance().runLater(this.fx_ivPlaying::setSelectedImage);
    }

    @Override
    public void setTimeValue(long time) {
        ClientSingleton.getInstance().runLater(() -> this.fx_lbPlayingTime.setText(ClientSingleton.getInstance().getTimeDuration(time)));
    }

    @Override
    public void onRelease() {
        if (this.audioPlayer != null) {
            if (this.audioPlayer.isPlaying()) {
                this.audioPlayer.stopPlayback();
            }
            if (this.audioPlayer.isHasFile()) {
                this.audioPlayer.setFile(null);
            }
            this.audioPlayer = null;
        }
        this.progressIndicator = null;
        this.fileInfo = null;
    }

    private void bind(MessageInfo messageInfo) {
        this.fx_ivPlaying.setBackgroundColor(MessageInfoCellLabels.getCellBackground(messageInfo, false, this.isComment));
        this.fileInfo = (FileInfo)messageInfo;
        this.fx_lbPlayingTime.setText("00:00");
        long mediaDuration = this.fileInfo.getMediaDuration();
        if (this.fileInfo.isLoading()) {
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.schedule(this.loadingTimerTask, 0L, 50L);
            }
        } else if (mediaDuration == 0L) {
            try {
                File file = ClientSingleton.getInstance().getClientConnector().get().getFile(this.fileInfo);
                if (file != null && file.exists()) {
                    InputStream stream = this.audioPlayer.getAudioStream(new FileInputStream(file));
                    long bytes = stream.available();
                    stream.close();
                    mediaDuration = (int)(bytes / 16L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fx_lbTotalPlayingTime.setText(this.fileInfo != null && mediaDuration != 0L ? ClientSingleton.getInstance().getTimeDuration(mediaDuration) : "00:00");
        this.audioPlayer.setSliderMaxDuration(mediaDuration);
    }
}

