/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import java.util.Optional;
import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.IOnSliderPlay;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import smile.cti.client.ContactInfo;
import smile.cti.client.MessageInfo;

public class AvatarViewHolder
extends HBox
implements IActionOnRelease {
    private final AvatarPane avatarPane;
    private final int avatarWidth = 32;
    private final IOnSliderPlay ionSliderPlay;
    final Animation hideSidebar = new Transition(){
        {
            this.setCycleDuration(Duration.millis((double)200.0));
        }

        protected void interpolate(double frac) {
            double curWidth = 32.0 * (1.0 - frac);
            AvatarViewHolder.this.setCurrentWidth(curWidth);
        }
    };
    final Animation showSidebar = new Transition(){
        {
            this.setCycleDuration(Duration.millis((double)1000.0));
        }

        protected void interpolate(double frac) {
            double curWidth = 32.0 * frac;
            AvatarViewHolder.this.setCurrentWidth(curWidth);
        }
    };

    public AvatarViewHolder(MessageInfo messageInfo, IOnSliderPlay ionSliderPlay) {
        this.ionSliderPlay = ionSliderPlay;
        this.setStyle("fx-background-color: transparent;");
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.setAlignment(Pos.TOP_CENTER);
        this.setMaxHeight(32.0);
        this.setMaxWidth(32.0);
        this.setMinWidth(32.0);
        HBox.setMargin((Node)this, (Insets)new Insets(10.0, 13.0, 0.0, 0.0));
        this.avatarPane = AvatarPane.getInstance().setSize(32);
        this.getChildren().add((Object)this.avatarPane);
        this.bind(messageInfo);
    }

    @Override
    public void onRelease() {
        if (this.showSidebar.statusProperty().get() != Animation.Status.STOPPED) {
            this.showSidebar.stop();
        }
        this.avatarPane.onRelease();
    }

    public void showSlideProfilePane() {
        if (this.showSidebar.statusProperty().get() == Animation.Status.STOPPED && this.hideSidebar.statusProperty().get() == Animation.Status.STOPPED) {
            this.showSidebar.play();
        }
    }

    public void hideSlideProfilePane() {
        if (this.showSidebar.statusProperty().get() == Animation.Status.STOPPED && this.hideSidebar.statusProperty().get() == Animation.Status.STOPPED) {
            this.hideSidebar.play();
        }
    }

    private void setCurrentWidth(double curWidth) {
        this.setMaxWidth(curWidth);
        this.setMinWidth(curWidth);
        this.setPrefWidth(curWidth);
        if ((int)curWidth == 0) {
            this.ionSliderPlay.onStopPlaying(false);
            this.getChildren().remove((Object)this.avatarPane);
        } else if ((int)curWidth == 32) {
            if (!this.getChildren().contains((Object)this.avatarPane)) {
                this.getChildren().add((Object)this.avatarPane);
            }
            this.ionSliderPlay.onStopPlaying(true);
        }
    }

    private void bind(MessageInfo messageInfo) {
        if (messageInfo.getSenderId() != null && messageInfo.getSenderId().equals(ClientSingleton.getInstance().getUserId())) {
            this.avatarPane.setObjectInfo(ClientSingleton.getInstance().getUserInfo());
        } else {
            Optional<ContactInfo> optionalContactInfo = ClientSingleton.getInstance().getContactInfoByUserIdOrExt(messageInfo.getSenderId());
            if (optionalContactInfo.isEmpty()) {
                optionalContactInfo = ClientSingleton.getInstance().getContactInfoByNumber(messageInfo.getSenderId());
            }
            if (optionalContactInfo.isPresent()) {
                this.avatarPane.setObjectInfo(optionalContactInfo.get());
            } else {
                ClientSingleton.getInstance().getSessionInfo(messageInfo.getSessionId()).ifPresent(this.avatarPane::setObjectInfo);
            }
        }
        this.avatarPane.setDefaultBackgroundColor().build();
    }

    public void updateAvatar() {
        if (this.avatarPane != null) {
            this.avatarPane.updateAvatar();
        }
    }
}

