/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import java.io.File;
import java.util.Optional;
import javafx.scene.image.Image;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.views.chat.cell.IInvalidateListener;
import net.sipsnet.client.views.chat.holders.viewerholders.imageviewers.ImageViewer;
import net.sipsnet.client.views.tabs.UpdateLists;
import smile.cti.client.MessageInfo;

public class ImageHBoxViewerHolder
extends ImageViewer
implements IActionOnRelease {
    private boolean isSmall;
    private Disposable disposable;

    public ImageHBoxViewerHolder(IInvalidateListener iInvalidateListener, MessageInfo messageInfo) {
        super(iInvalidateListener, messageInfo);
        super.setFileInfoConsumer(this::setImage);
    }

    public void setSmall(boolean small) {
        this.isSmall = small;
    }

    private void setImage(File file) {
        this.disposable = Observable.just((Object)file).observeOn(UpdateLists.scheduler).flatMap(file1 -> {
            Optional<Image> optionalImage = this.getImage(this.getFileInfo().getId(), this.isSmall, file);
            if (optionalImage.isPresent()) {
                return Observable.just((Object)optionalImage.get());
            }
            return Observable.empty();
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(this::showImage);
    }

    @Override
    public void onRelease() {
        super.onRelease();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }
}

