/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjavafx.observables.JavaFxObservable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import net.sipsnet.client.click2dial.GetSelectedText;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.chat.cell.IRepliedMessage;
import net.sipsnet.client.views.chat.holders.viewerholders.imageviewers.ImageViewerUtil;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import net.sipsnet.client.views.tabs.UpdateLists;
import smile.cti.client.MessageInfo;

public class LinkHBoxViewHolder
extends ImageViewerUtil
implements IActionOnRelease {
    private final String withRadius = "-fx-background-color:transparent;-fx-border-radius: 10 10 10 10;-fx-background-radius: 10 10 10 10;";
    private VBox fx_tfMessage;
    private HBox hBox;
    private MessageInfo messageInfo;
    private boolean isOutgoing;
    private final ObservableMap<String, Double> paneHeight = FXCollections.observableHashMap();
    private final int paneWidth;
    public static String LINK_TITLE = "linkTitle";
    public static String LINK_DESCRIPTION = "linkDescription";
    public static String LINK_IMAGE_URL = "linkImageUrl";
    public static String LINK_IMAGE = "linkImage";
    public static int LINK_DATA_SIZE = 4;
    private final List<AnchorPane> anchorPanes = new ArrayList<AnchorPane>();
    private Disposable disposableImageAndTitle;
    private Disposable disposaHeight;
    private final Map<Integer, Pane> linkPanes = new HashMap<Integer, Pane>();
    private final IChatListCell iChatListCell;
    private final IRepliedMessage iRepliedMessage;
    private final boolean isComment;
    private MyStyledTextArea myStyledTextArea;
    private ContextMenu contextMenu;
    private String mContent;

    public LinkHBoxViewHolder(IRepliedMessage iRepliedMessage, IChatListCell iChatListCell, MessageInfo messageInfo, int width, boolean isComment, String inputText) {
        this.paneWidth = width;
        this.setStyle("-fx-background-color:transparent;-fx-border-radius: 10 10 10 10;-fx-background-radius: 10 10 10 10;");
        this.iChatListCell = iChatListCell;
        this.iRepliedMessage = iRepliedMessage;
        this.isComment = isComment;
        this.bind(messageInfo, inputText);
    }

    private void initContent() {
        PublishSubject publishSubject = PublishSubject.create();
        this.disposaHeight = publishSubject.debounce(200L, TimeUnit.MILLISECONDS, UpdateLists.scheduler).switchMap(Observable::just).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(heightMap -> {
            if (this.getParent() != null) {
                AtomicInteger atomicInteger = new AtomicInteger();
                heightMap.forEach((content, height) -> atomicInteger.addAndGet(height.intValue() + 5));
                this.setMaxHeight(atomicInteger.get());
                this.setMinHeight(atomicInteger.get());
                atomicInteger.addAndGet(this.iRepliedMessage.getRepliedMessagePaneHeight());
                ((Pane)this.getParent()).setMinHeight((double)atomicInteger.get());
                ((Pane)this.getParent()).setPrefHeight((double)atomicInteger.get());
            }
        });
        JavaFxObservable.emitOnChanged(this.paneHeight).subscribe((Observer)publishSubject);
        this.fx_tfMessage = new VBox();
        this.setAlignment(Pos.CENTER);
        this.fx_tfMessage.maxWidthProperty().bind((ObservableValue)this.minWidthProperty());
        this.fx_tfMessage.maxHeightProperty().bind((ObservableValue)this.minHeightProperty());
        this.fx_tfMessage.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.setMaxWidth(this.paneWidth + 10);
        this.setMinWidth(this.paneWidth + 10);
        this.fx_tfMessage.setStyle(MessageInfoCellLabels.getCellBackground(this.messageInfo, false, this.isComment));
        this.isOutgoing = MessageInfoCellLabels.isISendTheMessage(this.messageInfo);
        this.getChildren().add((Object)this.fx_tfMessage);
    }

    private void bind(MessageInfo messageInfo, String inputText) {
        this.messageInfo = messageInfo;
        this.initContent();
        this.mContent = messageInfo.getContent();
        if (JsonMessageParser.hasTag(this.mContent, "number\":\"") && JsonMessageParser.hasTag(this.mContent, "text\":\"")) {
            this.mContent = JsonMessageParser.getJsonTag(this.mContent, "text\":\"");
        }
        AnchorPane anchorPane = this.addStyledTextArea(this.mContent, false, true, inputText);
        anchorPane.setId(messageInfo.getContent());
        this.makeCallOnClick((Pane)anchorPane);
        this.fx_tfMessage.getChildren().add((Object)anchorPane);
    }

    private List<String> parseContent(String mContent, List<String> links) throws Exception {
        ArrayList<String> parsedContent = new ArrayList<String>();
        int index = 0;
        for (String link : links) {
            int index1 = mContent.indexOf(link, index);
            if (index == index1) continue;
            String message = mContent.substring(index, index1);
            parsedContent.add(message);
            parsedContent.add(link);
            index = index1 + link.length();
        }
        if (index < mContent.length()) {
            parsedContent.add(mContent.substring(index));
        }
        return parsedContent;
    }

    public void updateMessage(String text) {
        this.dispose();
        this.getChildren().clear();
        this.paneHeight.clear();
        this.bind(this.messageInfo, text);
    }

    private void setLinkData(Pane pane, Map<String, Object> lMessages) {
        String description;
        Pane linkPane = (Pane)pane.getChildren().get(1);
        int sideLength = 85;
        String title = (String)lMessages.get(LINK_TITLE);
        if (title != null && !title.isEmpty() && linkPane.getChildren().size() == 1) {
            Object text = title;
            if (((String)text).length() > 30) {
                text = title.substring(0, 30) + "...";
            }
            Text titleText = new Text((String)text);
            try {
                ClientSingleton.getInstance().setStyledTextFont(titleText, false, "#ffffff", 12);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            linkPane.getChildren().add(0, (Object)titleText);
        }
        if ((description = (String)lMessages.get(LINK_DESCRIPTION)) != null && !description.isEmpty() && linkPane.getChildren().size() == 2) {
            Object text = description;
            if (((String)text).length() > 42) {
                text = description.substring(0, 42) + "...";
            }
            Text descriptionText = new Text((String)text);
            try {
                ClientSingleton.getInstance().setStyledTextFont(descriptionText, false, "#ffffff", 10);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            linkPane.getChildren().add(linkPane.getChildren().size(), (Object)descriptionText);
        }
        Image image = null;
        if (lMessages.containsKey(LINK_IMAGE)) {
            image = (Image)lMessages.get(LINK_IMAGE);
            if (image.getWidth() != 0.0 && image.getHeight() != 0.0) {
                lMessages.put(LINK_IMAGE, image);
            } else {
                lMessages.remove(LINK_IMAGE);
            }
        }
        if (lMessages.containsKey(LINK_IMAGE)) {
            image = (Image)lMessages.get(LINK_IMAGE);
            Pane imagePane = (Pane)pane.getChildren().get(0);
            imagePane.getChildren().clear();
            ImageView imageView = this.createImageView(image);
            imagePane.getChildren().add((Object)imageView);
        }
    }

    private AnchorPane addStyledTextArea(String content, boolean isWithMenu, final boolean isWithPadding, String inputText) {
        if (content.isEmpty()) {
            return new AnchorPane();
        }
        String color = Theme.getInstance().getCommentTextFill(this.isComment);
        AnchorPane anchorPane = new AnchorPane();
        this.anchorPanes.add(anchorPane);
        anchorPane.minWidthProperty().bind((ObservableValue)this.fx_tfMessage.minWidthProperty());
        anchorPane.prefWidthProperty().bind((ObservableValue)this.fx_tfMessage.maxWidthProperty());
        anchorPane.maxWidthProperty().bind((ObservableValue)this.fx_tfMessage.maxWidthProperty());
        if (content.startsWith("\n")) {
            content = content.substring(1);
        }
        this.paneHeight.put((Object)content, (Object)(Math.max(30.0, (double)ClientSingleton.getInstance().getContentTextHeight(this.paneWidth - 50, content)) + (double)(isWithPadding ? 10 : 0)));
        final AtomicReference<String> atomicReference = new AtomicReference<String>(content);
        this.myStyledTextArea = new MyStyledTextArea(new IInnerMessageTextArea(){

            @Override
            public void resizeParent(int height, int linesCount) {
                height = Math.max(height, ClientSingleton.getInstance().getContentTextHeight(LinkHBoxViewHolder.this.paneWidth - 50, (String)atomicReference.get()));
                LinkHBoxViewHolder.this.paneHeight.put((Object)((String)atomicReference.get()), (Object)(height += isWithPadding ? 10 : 0));
            }

            @Override
            public void sendMessage(String message) {
            }

            @Override
            public void clearEditedMessage() {
            }

            @Override
            public void clearMessagePane(int height) {
            }
        }, null, color, 12);
        if (!isWithMenu) {
            this.myStyledTextArea.setContextMenu(null);
            this.myStyledTextArea.addEventHandler(MouseEvent.MOUSE_ENTERED, event -> this.myStyledTextArea.setCursor(Cursor.DEFAULT));
            this.myStyledTextArea.addEventHandler(MouseEvent.MOUSE_EXITED, event -> this.myStyledTextArea.setCursor(Cursor.HAND));
        }
        this.myStyledTextArea.setAutoHeight(true);
        this.myStyledTextArea.setEditable(false);
        this.myStyledTextArea.setMaxHeight(Double.MAX_VALUE);
        AnchorPane.setTopAnchor((Node)this.myStyledTextArea, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.myStyledTextArea, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.myStyledTextArea, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.myStyledTextArea, (Double)0.0);
        this.myStyledTextArea.setMinWidth(this.paneWidth);
        this.myStyledTextArea.setContentToStyledTextArea(content);
        this.myStyledTextArea.makeLinks();
        if (!inputText.isEmpty()) {
            int index = this.mContent.toLowerCase().indexOf(inputText.toLowerCase());
            ArrayList<IndexRange> indexRanges = new ArrayList<IndexRange>();
            while (index != -1) {
                indexRanges.add(new IndexRange(index, index + inputText.length()));
                index = this.mContent.toLowerCase().indexOf(inputText.toLowerCase(), index + 1);
            }
            if (!indexRanges.isEmpty()) {
                try {
                    this.myStyledTextArea.updateTextColor(indexRanges, "#8B8000");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        anchorPane.getChildren().add((Object)this.myStyledTextArea);
        return anchorPane;
    }

    public void refreshBackground() {
        this.myStyledTextArea.clearStyleInSelection();
    }

    private ImageView createImageView(Image writableImage) {
        ImageView imageView = new ImageView();
        imageView.setFitWidth(writableImage.getWidth());
        imageView.setFitHeight(writableImage.getHeight());
        imageView.setImage(writableImage);
        Rectangle clip = new Rectangle(imageView.getFitWidth(), imageView.getFitHeight());
        int ARC_WIDTH = 20;
        clip.setArcWidth((double)ARC_WIDTH);
        int ARC_HEIGHT = 20;
        clip.setArcHeight((double)ARC_HEIGHT);
        imageView.setClip((Node)clip);
        return imageView;
    }

    private void addContextMenu(MouseEvent mouseEvent, Pane pane, String url) {
        this.contextMenu = new ContextMenu();
        MenuItem menuItem1 = new MenuItem(ClientSingleton.getInstance().getString("linkItem1"));
        menuItem1.setOnAction(event -> ClientSingleton.getInstance().openWebBrowser(url));
        MenuItem menuItem2 = new MenuItem(ClientSingleton.getInstance().getString("linkItem2"));
        menuItem2.setOnAction(event -> {
            try {
                GetSelectedText.setClipboardText(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{menuItem1, menuItem2});
        this.contextMenu.show((Node)pane, mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    private void makeCallOnClick(Pane pane) {
        ClientSingleton.getInstance().setMouseCursor((Node)pane);
        pane.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            try {
                this.makeAction((MouseEvent)event, pane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void onRelease() {
        if (this.anchorPanes != null) {
            this.anchorPanes.forEach(anchorPane -> {
                MyStyledTextArea myStyledTextArea;
                anchorPane.prefWidthProperty().unbind();
                anchorPane.minWidthProperty().unbind();
                anchorPane.maxWidthProperty().unbind();
                if (!anchorPane.getChildren().isEmpty() && anchorPane.getChildren().get(0) instanceof MyStyledTextArea && (myStyledTextArea = (MyStyledTextArea)((Object)((Object)anchorPane.getChildren().get(0)))) != null) {
                    myStyledTextArea.prefWidthProperty().unbind();
                    myStyledTextArea.clear();
                    Object var1_1 = null;
                }
            });
            this.anchorPanes.clear();
        }
        this.fx_tfMessage.maxWidthProperty().unbind();
        this.fx_tfMessage.maxHeightProperty().unbind();
    }

    public void dispose() {
        if (this.disposableImageAndTitle != null) {
            this.disposableImageAndTitle.dispose();
        }
        if (this.disposaHeight != null) {
            this.disposaHeight.dispose();
        }
    }

    public void setLinkMap(int linkIndex, Map<String, Object> lMessages) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setLinkMap lMessages : " + lMessages);
        Pane pane = this.linkPanes.get(linkIndex);
        if (pane != null) {
            this.setLinkData(pane, lMessages);
        }
    }

    private void makeAction(MouseEvent event, Pane pane) throws Exception {
        if (this.contextMenu != null && this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
        List<String> urls = MyUtils.bindLink(this.messageInfo.getContent());
        int offset = this.myStyledTextArea.getCaretPosition();
        String text = this.myStyledTextArea.getText();
        char[] chars = text.toCharArray();
        if (offset < 0 || offset >= chars.length) {
            return;
        }
        String url = this.getWord(offset, text, chars, chr -> chr.charValue() == ' ' || chr.charValue() == '\n' || chr.charValue() == ')' || chr.charValue() == '(');
        if (url != null && !url.isEmpty() && urls.contains(url)) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "MOUSE_CLICKED url=" + url + " event.getButton()=" + event.getButton());
            this.addContextMenu(event, pane, url);
        }
    }

    private String getWord(int offset, String text, char[] chars, Predicate<Character> predicate) {
        int index2;
        int index1;
        String word = null;
        for (index1 = offset; index1 >= 0 && !predicate.test(Character.valueOf(chars[index1])); --index1) {
        }
        if (index1 > 1) {
            ++index1;
        }
        for (index2 = offset; index2 < chars.length && !predicate.test(Character.valueOf(chars[index2])); ++index2) {
        }
        index1 = Math.max(index1, 0);
        try {
            word = text.substring(index1, index2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return word;
    }
}

