/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;

public class TextBase
extends AnchorPane {
    protected boolean isComment;

    protected void addTextArea(String content, String inputText) {
        String color = Theme.getInstance().getCommentTextFill(this.isComment);
        TextFlow detailTextFlow = ClientSingleton.getInstance().addStyledTextArea(content, inputText, color, 12);
        detailTextFlow.setMinWidth(350.0);
        AnchorPane.setTopAnchor((Node)detailTextFlow, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)detailTextFlow, (Double)10.0);
        AnchorPane.setRightAnchor((Node)detailTextFlow, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)detailTextFlow, (Double)10.0);
        this.getChildren().add((Object)detailTextFlow);
        this.setTextHeight(detailTextFlow);
    }

    private void setTextHeight(TextFlow textFlow) {
        TimerExecutor.getInstance().setMyAction(() -> {
            double height = 0.0;
            height = Math.max(this.computePrefHeight((ObservableList<Node>)textFlow.getChildren()), 25.0) + 20.0;
            this.setPrefHeight(height);
            this.setMinHeight(height);
            this.setMaxHeight(height);
        }).startWithDelayInGUIThread(20L);
    }

    protected double computePrefHeight(ObservableList<Node> children) {
        double minY = 0.0;
        double maxY = 0.0;
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)children.get(i);
            if (!node.isManaged()) continue;
            double y = node.getLayoutBounds().getMinY() + node.getLayoutY();
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y + this.boundedSize(node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0)));
        }
        return maxY - minY;
    }

    double boundedSize(double value, double min, double max) {
        return Math.min(Math.max(value, min), Math.max(min, max));
    }
}

