/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders.callviewer;

import java.io.File;
import java.util.Optional;
import javafx.animation.AnimationTimer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.text.Text;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.audioplayer.IAudioPlayer;
import net.sipsnet.client.utils.audioplayer.MyMediaPlayer;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.slider.MySlider;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.Activity;
import smile.cti.client.ClientConnector;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MessageInfo;

public class CallViewerBase
extends VBox
implements FileTransferListener,
IAudioPlayer,
IActionOnRelease {
    private String fileName;
    private File file;
    private Label fx_lbPlayingTime;
    private Label fx_lbTotalPlayingTime;
    private HBox fx_hbPlayingContainer;
    private ProgressIndicator progressIndicator;
    private StackPane fx_spPlaying;
    private ImageButton fx_ivPlaying;
    private MyMediaPlayer myMediaPlayer;
    private String backgroundColor = "white";
    private String callDuration;
    private Text lookup;
    private boolean sendGetRecord = false;
    private FileInfo fileInfo;
    private MediaPlayer mediaPlayer;
    private IChatListCell iChatListCell;
    private float loadPercent = 0.05f;
    private final AnimationTimer programButtonAnimation = new AnimationTimer(){
        private long lastUpdate = 0L;

        public void handle(long now) {
            try {
                if (!CallViewerBase.this.fx_spPlaying.getChildren().contains((Object)CallViewerBase.this.progressIndicator)) {
                    CallViewerBase.this.fx_spPlaying.getChildren().add((Object)CallViewerBase.this.progressIndicator);
                }
                if (now - this.lastUpdate >= 50000000L) {
                    CallViewerBase.this.progressIndicator.setProgress((double)CallViewerBase.this.loadPercent);
                    this.lastUpdate = now;
                }
            }
            catch (Exception ex) {
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Error programButtonAnimation : " + ex.getMessage());
            }
        }
    };

    public CallViewerBase() {
    }

    public CallViewerBase(Activity activity) {
        this.callDuration = ClientSingleton.getInstance().getTimeDuration(activity.getAssignedDuration());
        this.fileName = activity.getFile();
        this.initPlayerPane();
    }

    public CallViewerBase(MessageInfo messageInfo) {
        this.setId("CallViewerBase");
        this.bind(messageInfo, null);
    }

    private void initPlayerPane() {
        this.fx_hbPlayingContainer = new HBox();
        VBox.setMargin((Node)this.fx_hbPlayingContainer, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.fx_hbPlayingContainer.setAlignment(Pos.CENTER_LEFT);
        VBox.setVgrow((Node)this.fx_hbPlayingContainer, (Priority)Priority.ALWAYS);
        this.fx_spPlaying = new StackPane();
        this.fx_spPlaying.setPrefWidth(32.0);
        this.fx_spPlaying.setPrefHeight(32.0);
        this.addPrefHeight(32.0);
        this.fx_ivPlaying = new ImageButton();
        this.fx_ivPlaying.setSize(32, 32);
        this.fx_ivPlaying.setIsRounded(true);
        this.fx_ivPlaying.setClickImages(new String[]{"chat/messagecell/play_recording.png", "chat/messagecell/pause_recording.png"});
        this.fx_ivPlaying.setBackgroundColor(this.backgroundColor);
        this.fx_spPlaying.getChildren().add((Object)this.fx_ivPlaying);
        this.fx_hbPlayingContainer.getChildren().add((Object)this.fx_spPlaying);
        this.fx_lbPlayingTime = new Label("0:00");
        this.fx_lbPlayingTime.setMinWidth(40.0);
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_lbPlayingTime);
        HBox.setMargin((Node)this.fx_lbPlayingTime, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        this.fx_hbPlayingContainer.getChildren().add((Object)this.fx_lbPlayingTime);
        MySlider fx_Slider = new MySlider();
        HBox.setHgrow((Node)fx_Slider, (Priority)Priority.ALWAYS);
        this.fx_hbPlayingContainer.getChildren().add((Object)fx_Slider);
        this.fx_lbTotalPlayingTime = new Label("0:00");
        this.fx_lbTotalPlayingTime.setMinWidth(40.0);
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_lbTotalPlayingTime);
        HBox.setMargin((Node)this.fx_lbTotalPlayingTime, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        this.fx_hbPlayingContainer.getChildren().add((Object)this.fx_lbTotalPlayingTime);
        if (this.myMediaPlayer == null) {
            this.myMediaPlayer = new MyMediaPlayer(fx_Slider, this.fx_lbTotalPlayingTime, this);
        }
        this.progressIndicator = new ProgressIndicator(0.0);
        this.progressIndicator.setMaxWidth(32.0);
        this.progressIndicator.setMaxHeight(32.0);
        this.progressIndicator.getStylesheets().add((Object)this.getClass().getResource("/extracss/labellessprogressindicator.css").toExternalForm());
        this.progressIndicator.progressProperty().addListener((obs, n, n1) -> {
            if (this.lookup == null) {
                this.lookup = (Text)this.fx_spPlaying.lookup(".percentage");
            }
            if (this.lookup != null) {
                this.lookup.setText(this.lookup.getText().replace("%", ""));
            }
        });
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_ivPlaying);
        this.fx_ivPlaying.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (this.fileName != null) {
                if (!this.myMediaPlayer.isPlaying()) {
                    if (this.file == null) {
                        if (!this.sendGetRecord) {
                            this.sendGetRecord = true;
                            this.programButtonAnimation.start();
                            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
                            optionalClientConnector.ifPresent(clientConnector -> clientConnector.getRecord(this.fileName, (FileTransferListener)this));
                        }
                    } else {
                        if (this.iChatListCell != null) {
                            this.iChatListCell.stopAllPlayers();
                        }
                        this.myMediaPlayer.setFile(this.file);
                        this.myMediaPlayer.startPlayback();
                    }
                } else {
                    this.stopPlayback();
                }
            }
        });
    }

    public void stopPlayback() {
        if (this.myMediaPlayer != null && this.myMediaPlayer.isPlaying()) {
            this.myMediaPlayer.stopPlayback();
        }
    }

    public void bind(MessageInfo messageInfo, IChatListCell iChatListCell) {
        boolean hasRecordFile = MessageInfoCellLabels.hasRecordFile(messageInfo);
        if (hasRecordFile) {
            this.iChatListCell = iChatListCell;
            this.backgroundColor = MessageInfoCellLabels.getBaseBackgroundColor(messageInfo);
            this.callDuration = this.getCallDuration(messageInfo);
            this.fileName = messageInfo.getActivity().getFile();
            if (this.fx_hbPlayingContainer == null) {
                this.initPlayerPane();
            }
            this.fx_lbPlayingTime.setText("00:00");
            try {
                ClientSingleton.getInstance().getClientConnector().get().getRecord(this.fileName, (FileTransferListener)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.getChildren().add((Object)this.fx_hbPlayingContainer);
        } else if (this.fx_hbPlayingContainer != null) {
            this.getChildren().remove((Object)this.fx_hbPlayingContainer);
        }
    }

    public String getCallDuration(MessageInfo messageInfo) {
        int duration = messageInfo.getCallDuration();
        if (duration <= 0) {
            return null;
        }
        return ClientSingleton.getInstance().getTimeDuration((long)duration * 1000L);
    }

    public void unbind() {
        this.getChildren().remove((Object)this.fx_hbPlayingContainer);
        this.fileInfo = null;
    }

    public void transferStarted(FileInfo fileInfo) {
    }

    public void transferProgress(FileInfo fileInfo) {
        this.loadPercent = fileInfo.getLoadingPercent();
    }

    public void transferEnded(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        this.programButtonAnimation.stop();
        this.loadPercent = 0.05f;
        fileInfo.removeTransfrerListener((FileTransferListener)this);
        ClientSingleton.getInstance().runLater(() -> {
            if (this.progressIndicator != null) {
                this.progressIndicator.setProgress(1.0);
                this.fx_spPlaying.getChildren().remove((Object)this.progressIndicator);
            }
        });
        if (!this.sendGetRecord) {
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            if (optionalClientConnector.isPresent()) {
                File audioFile = null;
                try {
                    audioFile = optionalClientConnector.get().getFile(fileInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (audioFile != null && audioFile.exists()) {
                    final Media media = new Media(audioFile.toURI().toString());
                    media.durationProperty().addListener((ChangeListener)new ChangeListener<Duration>(){

                        public void changed(ObservableValue<? extends Duration> observable, Duration oldValue, Duration newValue) {
                            CallViewerBase.this.fx_lbTotalPlayingTime.setText(ClientSingleton.getInstance().getTimeDuration((long)newValue.toMillis()));
                            if (CallViewerBase.this.myMediaPlayer != null) {
                                CallViewerBase.this.myMediaPlayer.setSliderMaxValue(newValue);
                            }
                            if (CallViewerBase.this.mediaPlayer != null) {
                                CallViewerBase.this.mediaPlayer.dispose();
                                CallViewerBase.this.mediaPlayer = null;
                            }
                            media.durationProperty().removeListener((ChangeListener)this);
                        }
                    });
                    this.mediaPlayer = new MediaPlayer(media);
                }
            }
        } else {
            try {
                Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
                if (optionalClientConnector.isPresent()) {
                    File file = optionalClientConnector.get().getFile(fileInfo);
                    if (file != null && file.exists()) {
                        if (this.iChatListCell != null) {
                            this.iChatListCell.stopAllPlayers();
                        }
                        this.myMediaPlayer.setFile(file);
                        this.myMediaPlayer.startPlayback();
                    } else {
                        ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("call_record_not_found"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sendGetRecord = false;
        }
    }

    @Override
    public void onStartPlayback() {
        this.fx_ivPlaying.setImagePath("chat/messagecell/pause_recording.png");
    }

    @Override
    public void onStopPlayback() {
        ClientSingleton.getInstance().runLater(() -> this.fx_ivPlaying.setImagePath("chat/messagecell/play_recording.png"));
    }

    @Override
    public void onEndPlayback() {
        ClientSingleton.getInstance().runLater(() -> this.fx_ivPlaying.setImagePath("chat/messagecell/play_recording.png"));
    }

    @Override
    public void setTimeValue(long time) {
        ClientSingleton.getInstance().runLater(() -> this.fx_lbPlayingTime.setText(ClientSingleton.getInstance().getTimeDuration(time)));
    }

    @Override
    public void onRelease() {
        if (this.myMediaPlayer != null) {
            if (this.myMediaPlayer.isPlaying()) {
                this.myMediaPlayer.stopPlayback();
            }
            if (this.myMediaPlayer.isMediaPlayerCreated()) {
                this.myMediaPlayer.setFile(null);
                this.myMediaPlayer.dispose();
            }
            this.myMediaPlayer = null;
            this.progressIndicator = null;
        }
        this.fileInfo = null;
    }

    public void addPrefHeight(double height) {
        this.setPrefHeight(this.getPrefHeight() + height);
    }
}

