/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders.callviewer;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.views.chat.holders.viewerholders.callviewer.CallViewerBase;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import org.json.smile.JSONException;
import smile.cti.client.MessageInfo;

public class CallViewerHolder
extends CallViewerBase {
    private final Label fx_bSubject;
    private final HBox secondLine;
    private final Label fx_lbCallLabel;
    private final MessageInfo messageInfo;

    public CallViewerHolder(MessageInfo messageInfo, IChatListCell iChatListCell) {
        Label callDuration;
        this.setAlignment(Pos.CENTER_LEFT);
        this.setPrefWidth(iChatListCell.isSimpleViewMode() ? 230.0 : 300.0);
        HBox callLabelBox = new HBox();
        callLabelBox.setAlignment(Pos.CENTER_LEFT);
        callLabelBox.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.fx_lbCallLabel = new Label();
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_lbCallLabel);
        callLabelBox.getChildren().add((Object)this.fx_lbCallLabel);
        this.addPrefHeight(24.0);
        this.getChildren().add((Object)callLabelBox);
        this.secondLine = new HBox();
        this.secondLine.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.secondLine.setAlignment(Pos.CENTER_LEFT);
        VBox.setMargin((Node)this.secondLine, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        this.getChildren().add((Object)this.secondLine);
        int cause = messageInfo.getCallCauseCode();
        if (cause != 26 && (cause & 0x7F) != 26) {
            HBox textLabelBox = new HBox();
            textLabelBox.setAlignment(Pos.CENTER_LEFT);
            textLabelBox.prefWidthProperty().bind((ObservableValue)this.widthProperty());
            Text text = new Text(ClientSingleton.getInstance().getString("chat_call_view_details"));
            VBox.setMargin((Node)text, (Insets)new Insets(10.0, 0.0, 5.0, 0.0));
            ClientSingleton.getInstance().setMouseCursor((Node)text);
            try {
                ClientSingleton.getInstance().setStyledTextFont(text, true, WhiteLabels.getCustomBlueColor(), 10);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            text.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.showSubjects());
            textLabelBox.getChildren().add((Object)text);
            this.getChildren().add((Object)textLabelBox);
            this.addPrefHeight(24.0);
        }
        HBox.setMargin((Node)this, (Insets)new Insets(16.0, 0.0, 0.0, 16.0));
        this.fx_bSubject = new Label();
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_bSubject);
        this.setPadding(new Insets(9.0, 5.0, 9.0, 16.0));
        this.messageInfo = messageInfo;
        super.bind(messageInfo, iChatListCell);
        boolean hasRecordFile = MessageInfoCellLabels.hasRecordFile(messageInfo);
        if (!hasRecordFile && (callDuration = this.addLastCallDuration()) != null) {
            callDuration.prefHeightProperty().bind((ObservableValue)callLabelBox.heightProperty());
            callLabelBox.getChildren().add((Object)callDuration);
        }
        Object label = "";
        if (messageInfo.getCallCallerNumber() != null && "Conference".equals(messageInfo.getCallCallerNumber()) && messageInfo.getCallCalledNumber() == null) {
            label = messageInfo.getCallCallerNumber();
        } else {
            AtomicReference<String> number = new AtomicReference<String>(messageInfo.getCallCalledNumber());
            ClientSingleton.getInstance().getContactInfoByUserId(number.get()).ifPresent(contactInfo -> number.set(contactInfo.toString()));
            label = ClientSingleton.getInstance().getString("call_to_with_trunk") + " " + number.get();
        }
        this.fx_lbCallLabel.setText((String)label);
        this.setSubject();
    }

    private Label addLastCallDuration() {
        String callDuration = this.getCallDuration(this.messageInfo);
        if (callDuration == null) {
            return null;
        }
        Label fx_lbDuration = new Label("(" + callDuration + ")");
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)fx_lbDuration);
        HBox.setMargin((Node)fx_lbDuration, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        return fx_lbDuration;
    }

    public void setSubject() {
        String subject;
        String string = subject = this.messageInfo.getActivity().getSubject() == null ? "" : this.messageInfo.getActivity().getSubject();
        if (subject != null && !subject.isEmpty()) {
            if (subject.startsWith("{") && subject.contains("\"number\":")) {
                Pair<String, Integer> pair = null;
                try {
                    pair = JsonMessageParser.getMessageString(subject, -1, false);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                subject = pair != null ? (String)pair.getKey() : "";
            }
            String str = ClientSingleton.getInstance().getString("call_subject") + " " + subject;
            this.fx_bSubject.setText(str);
            if (!this.secondLine.getChildren().contains((Object)this.fx_bSubject)) {
                this.secondLine.getChildren().add((Object)this.fx_bSubject);
                this.addPrefHeight(24.0);
            }
        } else if (!"Conference".equals(this.messageInfo.getCallCallerNumber()) && this.messageInfo.getCallCauseDescription() != null && !this.messageInfo.getCallCauseDescription().isEmpty()) {
            this.fx_bSubject.setText(JsonMessageParser.getCauseDescription(this.messageInfo.getCallCauseCode(), this.messageInfo.getStatus()));
            if (!this.secondLine.getChildren().contains((Object)this.fx_bSubject)) {
                this.secondLine.getChildren().add((Object)this.fx_bSubject);
                this.addPrefHeight(24.0);
            }
        } else {
            this.secondLine.getChildren().remove((Object)this.fx_bSubject);
            this.secondLine.setPrefHeight(0.0);
            this.addPrefHeight(0.0);
        }
    }

    private void showSubjects() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("messageInfo", this.messageInfo);
        ClientSingleton.getInstance().doNotify(Constants.OPEN_CALL_DETAILS, data);
    }
}

