/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders.callviewer;

import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.MessageInfo;

public class MissedCallViewHolder
extends HBox
implements IActionOnRelease {
    private final ImageButton fx_ivCallBack;
    private final Label fx_tfCallMessage;

    public MissedCallViewHolder(MessageInfo messageInfo, int width) {
        this.setMinWidth(width);
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)vBox, (Priority)Priority.ALWAYS);
        this.fx_tfCallMessage = new Label();
        vBox.getChildren().add((Object)this.fx_tfCallMessage);
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_tfCallMessage);
        this.fx_ivCallBack = new ImageButton();
        HBox.setMargin((Node)this.fx_ivCallBack, (Insets)new Insets(10.0, 10.0, 10.0, 0.0));
        this.fx_ivCallBack.setBackgroundColor("white");
        this.fx_ivCallBack.setSize(32, 32);
        this.fx_ivCallBack.setIsRounded(true);
        this.fx_ivCallBack.setImagePath("chat/messagecell/inmes_callback.png");
        this.fx_ivCallBack.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().getSessionInfo(messageInfo.getSessionId()).ifPresent(sessionInfo -> AudioCaller.makeCall(sessionInfo, false))));
        HBox.setMargin((Node)vBox, (Insets)new Insets(9.0, 5.0, 9.0, 16.0));
        this.getChildren().addAll((Object[])new Node[]{vBox, this.fx_ivCallBack});
        this.bind(messageInfo);
        this.setPrefHeight(64.0);
    }

    private void bind(MessageInfo messageInfo) {
        this.fx_tfCallMessage.setText(MessageInfoCellLabels.setContentLabel(messageInfo));
        String style = MessageInfoCellLabels.getCellBackground(messageInfo, true) + "-fx-text-fill: #656a7c;";
        this.setStyle(style);
    }

    @Override
    public void onRelease() {
        this.fx_tfCallMessage.setText("");
        this.getChildren().clear();
    }
}

