/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders.imageviewers;

import java.io.File;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import javafx.animation.AnimationTimer;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.views.chat.cell.IInvalidateListener;
import net.sipsnet.client.views.chat.holders.viewerholders.VideoImageHBoxViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.imageviewers.ImageViewerUtil;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.ClientConnector;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MessageInfo;

public class ImageViewer
extends ImageViewerUtil
implements FileTransferListener,
IActionOnRelease {
    private final boolean isMyMessage;
    private ImageView fx_ivImageViewer;
    private HBox fx_spPlaying;
    private ProgressIndicator progressIndicator;
    private Image image;
    private boolean hasBeenLoad = false;
    private final FileInfo fileInfo;
    private final SimpleBooleanProperty loadAndOpenImage = new SimpleBooleanProperty(false);
    protected final Pair<Integer, Integer> SIZE_PAIR = new Pair((Object)182, (Object)182);
    private Consumer<File> fileConsumer;
    private final IInvalidateListener iInvalidateListener;
    private final EventHandler<MouseEvent> exitedEvent = event -> ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
    private final EventHandler<MouseEvent> enteredEvent = event -> ((Node)event.getSource()).setCursor(Cursor.HAND);
    private final EventHandler<MouseEvent> clickedEvent = event -> {
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (optionalClientConnector.isPresent()) {
            try {
                FileInfo fileInfo1 = this.getFileInfo();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "clickedEvent fileInfo1.getFilePath() " + fileInfo1.getFilePath() + " isThumbnailImage=" + ClientSingleton.getInstance().isThumbnailImage(fileInfo1.getFilePath()));
                if (fileInfo1.getFilePath() != null && !ClientSingleton.getInstance().isThumbnailImage(fileInfo1.getFilePath())) {
                    if (MyUtils.setOriginalFileName(fileInfo1)) {
                        this.loadAndOpenImage.set(true);
                    }
                    if (fileInfo1.isLoaded()) {
                        try {
                            File file = optionalClientConnector.get().getFile(fileInfo1);
                            ClientSingleton.getInstance().openFile(file);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.loadAndOpenImage.set(true);
                    }
                } else {
                    this.loadAndOpenImage.set(true);
                }
            }
            catch (Exception ex) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Error clickedEvent: " + ex);
                this.loadAndOpenImage.set(true);
            }
        }
    };
    private float loadPercent = 0.0f;
    private final AnimationTimer programButtonAnimation = new AnimationTimer(){
        private long lastUpdate = 0L;

        public void handle(long now) {
            if (now - this.lastUpdate >= 50000000L) {
                if (ImageViewer.this.progressIndicator == null) {
                    ImageViewer.this.createIndicator();
                }
                ImageViewer.this.progressIndicator.setProgress((double)ImageViewer.this.loadPercent);
                this.lastUpdate = now;
            }
        }
    };
    private Timer timer;
    private final TimerTask loadingTimerTask = new TimerTask(){

        @Override
        public void run() {
            if (ImageViewer.this.fileInfo != null && ImageViewer.this.fileInfo.isLoading()) {
                ImageViewer.this.loadPercent = ImageViewer.this.fileInfo.getLoadingPercent();
            } else {
                this.cancel();
                ImageViewer.this.timer.cancel();
                ImageViewer.this.timer.purge();
                ImageViewer.this.timer = null;
                ImageViewer.this.stopLoading();
            }
        }
    };

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public ImageViewer(IInvalidateListener iInvalidateListener, MessageInfo messageInfo) {
        super.setAlignment(Pos.CENTER);
        this.iInvalidateListener = iInvalidateListener;
        this.createProgressIndicatorPane();
        this.fileInfo = (FileInfo)messageInfo;
        super.getChildren().add((Object)this.fx_spPlaying);
        this.isMyMessage = MessageInfoCellLabels.isMyMessage(messageInfo);
        this.loadAndOpenImage.addListener((observableValue, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "loadAndOpenImage getFileInfo().isLoading() " + this.getFileInfo().isLoading() + " isThumbnailImage=" + ClientSingleton.getInstance().isThumbnailImage(this.getFileInfo().getFilePath()));
                if (!this.getFileInfo().isLoading()) {
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                        if (ClientSingleton.getInstance().isThumbnailImage(this.getFileInfo().getFilePath())) {
                            MyUtils.setOriginalFileName(this.getFileInfo());
                        }
                        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("loading_image"));
                        this.getFileInfo().addTransfrerListener((FileTransferListener)this);
                        clientConnector.loadFile(this.getFileInfo());
                    });
                }
            }
        });
        this.setPrefHeight((Integer)this.SIZE_PAIR.getValue() + 10);
    }

    private void initImageView() {
        this.fx_ivImageViewer = new MyImageView((Integer)this.SIZE_PAIR.getKey(), (Integer)this.SIZE_PAIR.getValue());
        this.fx_ivImageViewer.setOnMouseExited(this.exitedEvent);
        this.fx_ivImageViewer.setOnMouseEntered(this.enteredEvent);
        this.fx_ivImageViewer.addEventHandler(MouseEvent.MOUSE_CLICKED, this.clickedEvent);
    }

    public void setFileInfoConsumer(Consumer<File> fileConsumer) {
        this.fileConsumer = fileConsumer;
    }

    private void loadFile() {
        this.initImageView();
        this.fx_ivImageViewer.setFitWidth((double)((Integer)this.SIZE_PAIR.getKey()).intValue());
        this.fx_ivImageViewer.setFitHeight((double)((Integer)this.SIZE_PAIR.getValue()).intValue());
        this.getFileInfo().addTransfrerListener((FileTransferListener)this);
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        FileInfo fileInfo1 = this.getFileInfo();
        MyUtils.setOriginalFileName(fileInfo1);
        optionalClientConnector.ifPresent(clientConnector -> clientConnector.loadFile(fileInfo1));
    }

    private void createProgressIndicatorPane() {
        this.createIndicator();
        this.fx_spPlaying = new HBox();
        this.fx_spPlaying.setMinWidth(100.0);
        this.fx_spPlaying.setMinHeight(100.0);
        this.fx_spPlaying.setMaxWidth(100.0);
        this.fx_spPlaying.setMaxHeight(100.0);
        this.fx_spPlaying.setAlignment(Pos.CENTER);
        this.fx_spPlaying.getChildren().add((Object)this.progressIndicator);
    }

    public void transferStarted(FileInfo fileInfo) {
        this.programButtonAnimation.start();
    }

    private void createIndicator() {
        this.progressIndicator = new ProgressIndicator(0.0);
        this.progressIndicator.setMaxWidth(60.0);
        this.progressIndicator.setMaxHeight(60.0);
        this.progressIndicator.setMinWidth(60.0);
        this.progressIndicator.setMinHeight(60.0);
        this.progressIndicator.progressProperty().addListener((observable, oldValue, newValue) -> {
            Text text = (Text)this.progressIndicator.lookup(".percentage");
            if (text != null) {
                text.setText("");
                text.setFont(new Font("Area", 0.0));
                this.progressIndicator.setPrefWidth(text.getLayoutBounds().getWidth());
            }
        });
    }

    public void transferProgress(FileInfo fileInfo) {
        this.loadPercent = fileInfo.getLoadingPercent();
        if (this.loadPercent > 1.0f) {
            this.loadPercent -= 1.0f;
        }
    }

    public void transferEnded(FileInfo fileInfo) {
        fileInfo.removeTransfrerListener((FileTransferListener)this);
        this.stopLoading();
        if (this.loadAndOpenImage.get()) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    File file = clientConnector.getFile(fileInfo);
                    ClientSingleton.getInstance().openFile(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private void stopLoading() {
        if (this.progressIndicator != null) {
            this.progressIndicator.setProgress(1.0);
        }
        this.programButtonAnimation.stop();
        this.loadPercent = 0.0f;
        this.hasBeenLoad = true;
        ClientSingleton.getInstance().removeLoadingPane();
        this.placeImageToViewer(this.fileInfo);
    }

    public void placeImageToViewer(FileInfo fileInfo) {
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (optionalClientConnector.isEmpty()) {
            return;
        }
        File file = null;
        try {
            file = optionalClientConnector.get().getFile(fileInfo);
            if (file == null || !file.exists()) {
                if (!this.hasBeenLoad && !this.isMyMessage) {
                    this.loadFile();
                }
                if (this.isMyMessage && fileInfo.getFilePath() != null && (file = new File(fileInfo.getFilePath())).exists() && this.fileConsumer != null) {
                    this.fileConsumer.accept(file);
                }
            } else if (this.fileConsumer != null) {
                this.fileConsumer.accept(file);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showImage(Image writableImage) {
        this.showImage(writableImage, false);
    }

    public void showImage(Image writableImage, boolean withRotate) {
        this.initImageView();
        this.fx_ivImageViewer.setImage(null);
        this.fx_ivImageViewer.setFitWidth(writableImage.getWidth());
        this.fx_ivImageViewer.setFitHeight(writableImage.getHeight());
        this.fx_ivImageViewer.setImage(writableImage);
        this.setMinHeight(writableImage.getHeight() + 10.0);
        this.setMaxHeight(writableImage.getHeight() + 10.0);
        this.setPrefHeight(writableImage.getHeight() + 10.0);
        Rectangle clip = new Rectangle(this.fx_ivImageViewer.getFitWidth(), this.fx_ivImageViewer.getFitHeight());
        int ARC_WIDTH = 20;
        clip.setArcWidth((double)ARC_WIDTH);
        int ARC_HEIGHT = 20;
        clip.setArcHeight((double)ARC_HEIGHT);
        this.fx_ivImageViewer.setClip((Node)clip);
        super.getChildren().clear();
        super.getChildren().add((Object)this.fx_ivImageViewer);
        if (this instanceof VideoImageHBoxViewerHolder) {
            ImageView imageView = this.addVideoPlayImg();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "getVideoFrame 4 imageView " + imageView);
            if (imageView != null) {
                StackPane stackPane = new StackPane();
                StackPane.setAlignment((Node)this.fx_ivImageViewer, (Pos)Pos.CENTER);
                if (!stackPane.getChildren().contains((Object)this.fx_ivImageViewer)) {
                    stackPane.getChildren().add((Object)this.fx_ivImageViewer);
                }
                if (!stackPane.getChildren().contains((Object)imageView)) {
                    stackPane.getChildren().add((Object)imageView);
                }
                super.getChildren().add((Object)stackPane);
            }
        }
        this.iInvalidateListener.invalidate(this.fx_ivImageViewer.getFitHeight());
    }

    public ImageView addVideoPlayImg() {
        ImageView fx_ivImageViewer = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(fx_ivImageViewer, "chat/messagecell/video_play.png");
        fx_ivImageViewer.addEventHandler(MouseEvent.MOUSE_CLICKED, this.clickedEvent);
        StackPane.setAlignment((Node)fx_ivImageViewer, (Pos)Pos.TOP_RIGHT);
        StackPane.setMargin((Node)fx_ivImageViewer, (Insets)new Insets(8.0, 8.0, 0.0, 0.0));
        ClientSingleton.getInstance().setMouseCursor((Node)fx_ivImageViewer);
        return fx_ivImageViewer;
    }

    @Override
    public void onRelease() {
        if (this.fx_ivImageViewer != null) {
            this.fx_ivImageViewer.setOnMouseExited(null);
            this.fx_ivImageViewer.setOnMouseEntered(null);
            this.fx_ivImageViewer.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.clickedEvent);
            this.fx_ivImageViewer = null;
        }
        this.fileConsumer = null;
        this.image = null;
        this.progressIndicator = null;
    }

    public void bind() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "bindImage fileInfo = " + this.fileInfo + " fileInfo.isLoading()=" + this.fileInfo.isLoading() + " isLoaded() = " + this.fileInfo.isLoaded() + " hasFile() = " + this.fileInfo.hasFile() + " isMyMessage = " + this.isMyMessage);
        if (this.fileInfo.isLoaded()) {
            MyThreadPoolManager.getInstance().execute(() -> this.placeImageToViewer(this.fileInfo));
        } else if (this.fileInfo.isLoading()) {
            this.getFileInfo().addTransfrerListener((FileTransferListener)this);
            this.programButtonAnimation.start();
            this.timer = new Timer();
            this.timer.schedule(this.loadingTimerTask, 0L, 100L);
        } else if (!this.isMyMessage || !this.fileInfo.hasFile() || this.fileInfo.getFilePath() == null) {
            this.loadFile();
        } else {
            MyThreadPoolManager.getInstance().execute(() -> this.placeImageToViewer(this.fileInfo));
        }
    }

    public void dispose() {
        if (this.fileInfo != null) {
            this.fileInfo.removeTransfrerListener((FileTransferListener)this);
        }
    }
}

