/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.messagepane;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Font;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;

public class InnerMessageTextArea
extends TextArea {
    private final double LINE_HEIGHT = 22.0;
    private final double TOP_PADDING = 2.0;
    private final double BOTTOM_PADDING = 2.0;
    private final int line = 26;
    private final IInnerMessageTextArea iInnerMessageTextArea;
    private int lastPressedKey;

    public InnerMessageTextArea(IInnerMessageTextArea iInnerMessageTextArea, ChangeListener<Boolean> listener) {
        this.iInnerMessageTextArea = iInnerMessageTextArea;
        this.setMinHeight(26.0);
        this.setPrefHeight(26.0);
        this.setWrapText(true);
        this.init(listener);
        this.setMyStyle();
    }

    private void init(ChangeListener<Boolean> listener) {
        this.setPromptText(ClientSingleton.getInstance().getString("write_message"));
        this.focusedProperty().addListener(listener);
        this.textProperty().addListener((observer, oldValue, newValue) -> {
            if (!oldValue.equals(newValue) && newValue.isEmpty()) {
                this.iInnerMessageTextArea.clearEditedMessage();
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.isControlDown() && keyEvent.getCode().getCode() == KeyCode.ENTER.getCode()) {
                if (this.getText().isEmpty()) {
                    this.setText("\n");
                    this.positionCaret(this.getText().length());
                } else if (this.getCaretPosition() >= this.getText().length()) {
                    this.setText(this.getText() + "\n ");
                    this.positionCaret(this.getText().length());
                } else {
                    int position = this.getCaretPosition();
                    StringBuilder stringBuilder = new StringBuilder(this.getText());
                    stringBuilder.insert(position, "\n ");
                    this.setText(stringBuilder.toString());
                    this.positionCaret(Math.min(position + 1, this.getText().length()));
                }
            } else if (keyEvent.getCode().getCode() == KeyCode.ENTER.getCode()) {
                keyEvent.consume();
                String message = this.getText();
                if (!message.isEmpty()) {
                    this.iInnerMessageTextArea.sendMessage(message);
                    this.clearMessage(null);
                }
            }
            this.lastPressedKey = keyEvent.getCode().getCode();
        });
        this.sceneProperty().addListener((observableNewScene, oldScene, newScene) -> {
            if (newScene != null) {
                this.applyCss();
                Node text = this.lookup(".text");
                this.prefHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    double height = 2.0 + text.getLayoutBounds().getHeight() + 4.0;
                    this.iInnerMessageTextArea.resizeParent((int)height, 1);
                    return height;
                }, (Observable[])new Observable[]{text.boundsInLocalProperty()}));
                text.boundsInLocalProperty().addListener((observableBoundsAfter, boundsBefore, boundsAfter) -> ClientSingleton.getInstance().runLater(() -> ((InnerMessageTextArea)this).requestLayout()));
            }
        });
    }

    public void clearMessage(String message) {
        if (message != null && !message.isEmpty()) {
            this.setText(message);
        } else {
            this.iInnerMessageTextArea.resizeParent(26, 1);
        }
    }

    private void setMyStyle() {
        Font currentFont = Font.font((String)"Roboto", (double)14.0);
        String style = " -fx-background-color: transparent;-fx-padding:  0;\n-fx-border-insets:  0;\n-fx-background-insets: 0;\n-fx-text-fill: #252b40;\n-fx-font-family:\"" + currentFont.getFamily() + "\";\n-fx-font-size: " + currentFont.getSize() + "px;\n-fx-control-inner-background: transparent;";
        this.setStyle(style);
    }
}

