/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.utils;

import java.util.Collection;
import javafx.beans.DefaultProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;

@DefaultProperty(value="children")
public class EllipsingTextFlow
extends TextFlow {
    private static final String DEFAULT_ELLIPSIS_STRING = "...";
    private StringProperty ellipsisString;
    private final ObservableList<Node> allChildren = FXCollections.observableArrayList();
    private final ChangeListener<Number> widthChangeListener = (observableValue, number, newValue) -> {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "sizeChangeListener width = " + newValue);
        this.adjustText();
    };
    private final ChangeListener<Number> heightChangeListener = (observableValue, number, newValue) -> {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "sizeChangeListener height = " + newValue);
        this.adjustText();
    };

    public EllipsingTextFlow() {
        this.allChildren.addListener(this::adjustChildren);
        this.widthProperty().addListener(this.widthChangeListener);
        this.heightProperty().addListener(this.heightChangeListener);
        this.adjustText();
    }

    public ObservableList<Node> getChildren() {
        return this.allChildren;
    }

    private void adjustChildren(ListChangeListener.Change<? extends Node> change) {
        while (change.next()) {
            if (change.wasRemoved()) {
                super.getChildren().remove(change.getFrom(), change.getTo());
                continue;
            }
            if (!change.wasAdded()) continue;
            super.getChildren().addAll(change.getFrom(), (Collection)change.getAddedSubList());
        }
        this.adjustText();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustText() {
        Node lastChildAsShown;
        this.widthProperty().removeListener(this.widthChangeListener);
        this.heightProperty().removeListener(this.heightChangeListener);
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "sizeChangeListener getHeight() = " + this.getHeight() + " getMaxHeight() = " + this.getMaxHeight());
        while (this.getHeight() > this.getMaxHeight() || this.getWidth() > this.getMaxWidth()) {
            if (super.getChildren().isEmpty()) {
                this.widthProperty().addListener(this.widthChangeListener);
                this.heightProperty().addListener(this.heightChangeListener);
                return;
            }
            super.getChildren().remove(super.getChildren().size() - 1);
            super.autosize();
        }
        while (this.getHeight() <= this.getMaxHeight() && this.getWidth() <= this.getMaxWidth()) {
            if (super.getChildren().size() == this.allChildren.size()) {
                if (!this.allChildren.isEmpty()) {
                    lastChildAsShown = (Node)super.getChildren().get(super.getChildren().size() - 1);
                    Node lastChild = (Node)this.allChildren.get(this.allChildren.size() - 1);
                    if (lastChildAsShown instanceof Text && ((Text)lastChildAsShown).getText().length() < ((Text)lastChild).getText().length()) {
                        ((Text)lastChildAsShown).setText(((Text)lastChild).getText());
                    } else {
                        this.widthProperty().addListener(this.widthChangeListener);
                        this.heightProperty().addListener(this.heightChangeListener);
                        return;
                    }
                }
            } else {
                super.getChildren().add((Object)((Node)this.allChildren.get(super.getChildren().size())));
            }
            super.autosize();
        }
        while (true) {
            if (!(this.getHeight() > this.getMaxHeight()) && !(this.getWidth() > this.getMaxWidth())) {
                this.widthProperty().addListener(this.widthChangeListener);
                this.heightProperty().addListener(this.heightChangeListener);
                return;
            }
            lastChildAsShown = (Node)super.getChildren().remove(super.getChildren().size() - 1);
            while (this.getEllipsisString().equals(((Text)lastChildAsShown).getText())) {
                if (super.getChildren().isEmpty()) {
                    this.widthProperty().addListener(this.widthChangeListener);
                    this.heightProperty().addListener(this.heightChangeListener);
                    return;
                }
                lastChildAsShown = (Node)super.getChildren().remove(super.getChildren().size() - 1);
            }
            if (((Text)lastChildAsShown).getText().isEmpty()) {
                return;
            }
            Text shortenedChild = new Text(this.ellipseString(((Text)lastChildAsShown).getText()));
            super.getChildren().add((Object)shortenedChild);
            super.autosize();
        }
    }

    private String ellipseString(String s) {
        int spacePos = s.lastIndexOf(32);
        if (spacePos < 0) {
            return this.getEllipsisString();
        }
        return s.substring(0, spacePos) + this.getEllipsisString();
    }

    public final void setEllipsisString(String value) {
        this.ellipsisString.set((Object)(value == null ? "" : value));
    }

    public String getEllipsisString() {
        return this.ellipsisString == null ? DEFAULT_ELLIPSIS_STRING : (String)this.ellipsisString.get();
    }

    public final StringProperty ellipsisStringProperty() {
        return this.ellipsisString;
    }
}

