/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.contactslist;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.contactslist.IHideStage;
import net.sipsnet.client.views.contactslist.ScrolledContactInfosListWithServices;
import net.sipsnet.client.views.profiles.contactpane.IContactSelected;
import smile.cti.client.ContactInfo;

public class ContactsMultiColumnList
extends ScrolledContactInfosListWithServices
implements IContactSelected,
IHideStage {
    private IContactSelected iContactSelected;
    private EventHandler<MouseEvent> onCloseEvent = event -> this.hide();
    private boolean singleTouchSelection = false;
    private ICallPanesVisibility iCallPanesVisibility;
    private BorderPane rootPane;
    private final boolean isAddToOpenedPopupList;
    private boolean isAlwaysOnTop;
    private Pane header;
    private HBox footer;

    private ContactsMultiColumnList(List<ContactInfo> excludeContacts, boolean isAddToOpenedPopupList) {
        super(excludeContacts);
        super.setIChildContactSelected(this);
        super.setIHideStage(this);
        this.isAddToOpenedPopupList = isAddToOpenedPopupList;
    }

    private ContactsMultiColumnList(boolean isAddToOpenedPopupList) {
        super(new ArrayList<ContactInfo>());
        super.setIChildContactSelected(this);
        super.setIHideStage(this);
        this.isAddToOpenedPopupList = isAddToOpenedPopupList;
    }

    public static ContactsMultiColumnList getInstance(List<ContactInfo> excludeContacts) {
        return ContactsMultiColumnList.getInstance(excludeContacts, false);
    }

    public static ContactsMultiColumnList getInstance(List<ContactInfo> excludeContacts, boolean isAddToOpenedPopupList) {
        return new ContactsMultiColumnList(excludeContacts, isAddToOpenedPopupList);
    }

    public static ContactsMultiColumnList getInstance(boolean isAddToOpenedPopupList) {
        return new ContactsMultiColumnList(isAddToOpenedPopupList);
    }

    public ContactsMultiColumnList setListTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public ContactsMultiColumnList setMustBeSelectedList(List<ContactInfo> list) {
        super.setSelectedList(list);
        return this;
    }

    public ContactsMultiColumnList setFooter(HBox footer) {
        this.footer = footer;
        return this;
    }

    public void setIContactSelected(IContactSelected iContactSelected) {
        this.iContactSelected = iContactSelected;
    }

    public void setOnCloseEvent(EventHandler<MouseEvent> onCloseEvent) {
        this.onCloseEvent = onCloseEvent;
    }

    public void setICallPanesVisibility(ICallPanesVisibility iCallPanesVisibility) {
        this.iCallPanesVisibility = iCallPanesVisibility;
    }

    public ContactsMultiColumnList build() {
        this.header = this.getHeaderLine(this.onCloseEvent);
        this.populateLists();
        this.rootPane = this.getRootPane();
        this.header.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        StackPane mainBox = this.initComponents();
        mainBox.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        super.bindPane((Pane)this.rootPane);
        this.rootPane.setTop((Node)this.header);
        this.rootPane.setCenter((Node)mainBox);
        this.footer = this.getFooter();
        if (this.footer != null) {
            this.footer.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
            this.rootPane.setBottom((Node)this.footer);
        }
        mainBox.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "mainBox.heightProperty() " + newValue);
            }
        });
        return this;
    }

    public void show() {
        this.show(null);
    }

    public void show(Stage parent) {
        ClientSingleton.getInstance().runLater(() -> this.onShow(parent));
    }

    private void onShow(Stage parent) {
        Stage primaryStage = null;
        if (this.isAddToOpenedPopupList) {
            primaryStage = ClientSingleton.getInstance().getParentWindow();
        } else if (parent != null) {
            primaryStage = parent;
        } else {
            primaryStage = new Stage();
            primaryStage.initModality(Modality.NONE);
            primaryStage.initStyle(StageStyle.UTILITY);
            primaryStage.setOpacity(0.0);
            primaryStage.setHeight(0.0);
            primaryStage.setWidth(0.0);
            if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
                primaryStage.show();
            }
        }
        super.setOwner((Window)primaryStage);
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.rootPane, (Window)primaryStage).initMotionListeners((Node)this.header);
        this.rootPane.setMaxWidth((double)(this.getMaxPaneWidth() + (this.isSelectWithArrow() ? 25 : 0)));
        if (this.isAddToOpenedPopupList) {
            ClientSingleton.getInstance().addToOpenedPopupsList(this.myPopupWindow);
        }
        if (this.isAlwaysOnTop) {
            this.myPopupWindow.setAlwaysOnTop(true);
        }
        this.myPopupWindow.showAndWait();
    }

    public void hide() {
        if (super.hideWindow()) {
            if (this.iCallPanesVisibility != null) {
                this.iCallPanesVisibility.setCallPanesUnVisible();
            }
            super.onClose();
            ClientSingleton.getInstance().releaseViewResources((Pane)this.rootPane);
        }
    }

    public Pane getView() {
        return this.rootPane;
    }

    private BorderPane getRootPane() {
        BorderPane vBox = new BorderPane();
        vBox.setPadding(new Insets(20.0, 15.0, 20.0, 15.0));
        vBox.setStyle("-fx-background-color: white;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);");
        return vBox;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.isAlwaysOnTop = alwaysOnTop;
    }

    public void setSingleTouchSelection(boolean singleTouchSelection) {
        this.singleTouchSelection = singleTouchSelection;
    }

    @Override
    public void contactSelected(ContactInfo contactInfo, boolean isSelected) {
        if (this.singleTouchSelection && isSelected) {
            this.setUnSelectContacts(contactInfo);
        }
        if (this.iContactSelected != null) {
            this.iContactSelected.contactSelected(contactInfo, isSelected);
        }
        if (this.isWithButtonSelection()) {
            boolean hasSelection = !this.getSelectedIds().isEmpty();
            for (MyLabelButton button : this.getButtons()) {
                button.setSelectedBackground(hasSelection);
            }
        }
    }

    public MyLabelButton addButton(String buttonTitle, EventHandler<MouseEvent> event) {
        return this.addButton(buttonTitle, event, true);
    }

    public MyLabelButton addButton(String buttonTitle, EventHandler<MouseEvent> event, boolean withHide) {
        MyLabelButton myLabelButton = this.addButtonToFooter(buttonTitle, event);
        if (withHide) {
            myLabelButton.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> this.hide());
        }
        return myLabelButton;
    }

    @Override
    public void hideStage() {
        this.hide();
    }

    @Override
    public void setWithServices(boolean withServices) {
        super.setWithServices(withServices);
    }
}

