/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.contactslist;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.MyAlert;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.utils.viewers.mylistview.interfaces.ScrollingState;
import net.sipsnet.client.utils.viewers.scrollbar.IScrollBar;
import net.sipsnet.client.utils.viewers.scrollbar.MyScrollBar;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.contactslist.IContactListChanged;
import net.sipsnet.client.views.contactslist.IHideStage;
import net.sipsnet.client.views.profiles.contactpane.ContactInfoPane;
import net.sipsnet.client.views.profiles.contactpane.IContactSelected;
import net.sipsnet.client.views.profiles.contactpane.IOnLoad;
import net.sipsnet.client.views.tabs.UpdateLists;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;

public class ScrolledContactInfosList
implements IGUIObservable,
IScrollBar {
    private MyScrollBar myScrollBar;
    private ScrollingState currentScrollingState;
    private final List<ContactInfo> excludeContacts;
    private int itemOnList = 10;
    private int columnCount = 3;
    public static final int HEADER_HEIGHT = 40;
    private IContactSelected iChildContactSelected;
    private IOnLoad iOnLoad;
    private IHideStage iHideStage;
    private final List<ObservableList<Pane>> columns = new ArrayList<ObservableList<Pane>>(this.columnCount);
    private final List<VBox> columnsView = new ArrayList<VBox>(this.columnCount);
    private final SimpleIntegerProperty firstVisibleIndex = new SimpleIntegerProperty(0);
    private final SimpleIntegerProperty lastVisibleIndex = new SimpleIntegerProperty(0);
    private final List<ContactInfoPane> contactsList = new ArrayList<ContactInfoPane>();
    protected String title = "contact_share";
    private final int SHOW_ALL = 0;
    protected final int SHOW_USERS = 1;
    protected final int SHOW_EXTERNALS = 2;
    private int showMode = 0;
    private boolean showSelectLabels = false;
    private boolean isTransferMode = false;
    private boolean isTitleOfTheTopLine = false;
    private final int itemPaneHeight = 32;
    private final SimpleIntegerProperty maxPaneHeight = new SimpleIntegerProperty(32 * this.itemOnList + 40 + 80);
    private final SimpleIntegerProperty maxPaneWidth = new SimpleIntegerProperty();
    private VBox headerLine;
    private Pane extraPane = null;
    private final List<MyLabelButton> buttons = new ArrayList<MyLabelButton>();
    private boolean isWithMouseSelection;
    private boolean isSelectWithArrow;
    private boolean isWithMinusImage;
    private boolean isWithSearch;
    private HBox mainPane;
    private IContactListChanged iContactListChanged;
    private HBox footer;
    private boolean isWithoutUsers = false;
    private boolean isSpeedDialMode = false;
    private boolean withButtonSelection = false;
    private MyAlert myAlert;
    private Window owner;
    private List<ContactInfo> currentContactList = null;
    private List<ContactInfo> selectedList = new ArrayList<ContactInfo>();
    private StackPane mainBackgroundPane = null;
    protected MyPopupWindow myPopupWindow;
    private MyLabel showAll;
    private MyLabel showUsers;
    private MyLabel showNotUsers;
    private PublishSubject<String> searchObserver;
    private CompositeDisposable disposables;
    private final ChangeListener<Number> changeListener = (observableValue, oldValue, newValue) -> ClientSingleton.getInstance().runLater(() -> this.scrollItems(oldValue.intValue(), newValue.intValue()));
    private TextFieldWithSearch textFieldWithSearch;
    private final HBox containerPane = new HBox();

    public boolean isWithoutUsers() {
        return this.isWithoutUsers;
    }

    public void setWithoutUsers(boolean withoutUsers) {
        this.isWithoutUsers = withoutUsers;
    }

    public void setOwner(Window owner) {
        this.owner = owner;
    }

    public Window getOwner() {
        return this.owner;
    }

    public void bindPane(Pane pane) {
        this.setMaxPaneHeight(this.getMaxPaneHeight() + (int)(pane.getPadding().getTop() + pane.getPadding().getBottom()) + 5);
        pane.maxHeightProperty().bind((ObservableValue)this.maxPaneHeight);
        pane.minHeightProperty().bind((ObservableValue)this.maxPaneHeight);
        pane.minWidthProperty().bind((ObservableValue)this.maxPaneWidth);
    }

    public void setCurrentContactList(List<ContactInfo> currentContactList) {
        this.currentContactList = currentContactList;
    }

    public int getMaxPaneHeight() {
        return this.maxPaneHeight.get();
    }

    public SimpleIntegerProperty maxPaneHeightProperty() {
        return this.maxPaneHeight;
    }

    public void setMaxPaneHeight(int maxPaneHeight) {
        this.maxPaneHeight.set(maxPaneHeight);
    }

    public int getMaxPaneWidth() {
        return this.maxPaneWidth.get();
    }

    public void setMaxPaneWidth(int maxPaneWidth) {
        this.maxPaneWidth.set(maxPaneWidth);
    }

    public ScrolledContactInfosList(List<ContactInfo> excludeContacts) {
        this.excludeContacts = excludeContacts;
        if (!ClientSingleton.getInstance().getClientConnector().get().canSeeUsers()) {
            this.isWithoutUsers = true;
        }
    }

    public void setIHideStage(IHideStage iHideStage) {
        this.iHideStage = iHideStage;
    }

    public void setIChildContactSelected(IContactSelected iChildContactSelected) {
        this.iChildContactSelected = iChildContactSelected;
    }

    public ScrolledContactInfosList setWithMinusImage(boolean withMinusImage) {
        this.isWithMinusImage = withMinusImage;
        return this;
    }

    public void setItemOnList(int itemOnList) {
        this.itemOnList = itemOnList;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    private int getColumnCount() {
        return this.columnCount;
    }

    private boolean isTitleOfTheTopLine() {
        return this.isTitleOfTheTopLine;
    }

    public void setTitleOnTheTopLine(boolean titleOfTheTopLine) {
        this.isTitleOfTheTopLine = titleOfTheTopLine;
        if (this.isTitleOfTheTopLine) {
            this.setMaxPaneHeight(32 * this.itemOnList + 40 + 120);
        }
    }

    public void setIContactListChanged(IContactListChanged iContactListChanged) {
        this.iContactListChanged = iContactListChanged;
    }

    public void setIOnLoad(IOnLoad iOnLoad) {
        this.iOnLoad = iOnLoad;
    }

    public void setExtraPane(Pane extraPane) {
        this.extraPane = extraPane;
        this.extraPane.prefWidthProperty().bind((ObservableValue)this.containerPane.widthProperty().subtract(8));
        this.containerPane.setAlignment(Pos.CENTER);
    }

    public List<ContactInfo> getSelectedIds() {
        ArrayList<ContactInfo> list = new ArrayList<ContactInfo>();
        for (ContactInfoPane contactInfoPane : this.contactsList) {
            ContactInfo contactInfo;
            if (!contactInfoPane.isSelected() || (contactInfo = contactInfoPane.getContactInfo()) == null) continue;
            list.add(contactInfo);
        }
        return list;
    }

    public void setTextFieldWithSearchPrompt(String prompt) {
        this.textFieldWithSearch.setPromptText(prompt);
    }

    public void setTextFieldWithSearchBackground(String color) {
        this.textFieldWithSearch.setBackgroundColor(color);
    }

    public void setTextFieldPropertyListener(ChangeListener<? super String> changeListener) {
        this.textFieldWithSearch.addListener(changeListener);
    }

    public String getNumber() {
        return this.textFieldWithSearch.getText();
    }

    public void clearNumber() {
        this.textFieldWithSearch.setText("");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private boolean isTransferMode() {
        return this.isTransferMode;
    }

    public void setTransferMode(boolean transferMode) {
        this.isTransferMode = transferMode;
    }

    protected void setShowOnlyUsers(int mode) {
        this.showMode = mode;
    }

    public void setShowSelectLabels(boolean showSelectLabels) {
        this.showSelectLabels = showSelectLabels;
    }

    public boolean isShowSelectLabels() {
        return this.showSelectLabels;
    }

    public void addSpeedDialMode() {
        this.isSpeedDialMode = true;
    }

    protected void populateLists(List<ContactInfo> list) {
        if (list.isEmpty()) {
            this.populateLists();
        } else {
            this.populate(list.stream());
        }
    }

    protected void populateLists() {
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (!optionalClientConnector.isPresent()) {
            return;
        }
        Stream<ContactInfo> stream1 = (this.currentContactList != null ? this.currentContactList : optionalClientConnector.get().getContacts()).stream();
        this.populate(stream1);
        if (this.isTransferMode()) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                ClientSingleton.getInstance().getContactInfoStream().filter(ClientSingleton.getInstance().distinctByKey(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).filter(contactInfo -> contactInfo.isSlot() && contactInfo.getState() != 8).sorted(Collections.reverseOrder()).collect(Collectors.toList()).forEach(contactInfo -> {
                    if (!atomicBoolean.get()) {
                        atomicBoolean.set(true);
                    }
                    ContactInfoPane contactInfoPane = this.getContactInfoPane(contactInfo);
                    if (!this.selectedList.isEmpty()) {
                        contactInfoPane.setSelected(this.selectedList.contains(contactInfo));
                    }
                    contactInfoPane.addEventFilter((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
                        if (mouseEvent.getClickCount() > 1) {
                            return;
                        }
                        if (this.myAlert != null) {
                            return;
                        }
                        ClientSingleton.getInstance().runLater(() -> this.callAlert(this.owner, (ContactInfo)contactInfo, contactInfoPane));
                    }));
                    this.contactsList.add(0, contactInfoPane);
                });
                if (atomicBoolean.get()) {
                    this.contactsList.add(0, this.getContactInfoPane(ClientSingleton.getInstance().getString("contacts_parking")));
                }
            });
        }
    }

    public void unselectContactInfoPane(ContactInfo contactInfo) {
        this.contactsList.forEach(contactInfoPane -> {
            if (contactInfoPane.getContactInfo() != null && contactInfo.getUserID().equals(contactInfoPane.getContactInfo().getUserID())) {
                contactInfoPane.setSelectedPane(false);
            }
        });
    }

    public boolean selectContactInfoPane(ContactInfo contactInfo) {
        AtomicBoolean selected = new AtomicBoolean(false);
        this.contactsList.forEach(contactInfoPane -> {
            if (contactInfoPane.getContactInfo() != null && contactInfo.getUserID().equals(contactInfoPane.getContactInfo().getUserID())) {
                contactInfoPane.setSelected(true);
                contactInfoPane.setSelectedPane(true);
                selected.set(true);
            }
        });
        return selected.get();
    }

    public void contactSelected(ContactInfo contactInfo, boolean isSelected) {
    }

    public void selectAllContact(boolean mode) {
        this.contactsList.forEach(contactInfoPane -> {
            if (contactInfoPane.getContactInfo() != null) {
                contactInfoPane.setPaneStyle(mode);
                this.contactSelected(contactInfoPane.getContactInfo(), mode);
            }
        });
    }

    private void callAlert(Window owner, ContactInfo contactInfo, ContactInfoPane contactInfoPane) {
        this.addCover();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            this.myPopupWindow.setAlwaysOnTop(false);
            this.myAlert = new MyAlert(owner);
            this.myAlert.setMessage(ClientSingleton.getInstance().getString("park_this_call")).addPositiveButton(ClientSingleton.getInstance().getString("yes"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
                if (mouseEvent.getClickCount() > 1) {
                    return;
                }
                this.closeAlert();
                if (this.iHideStage != null) {
                    this.iHideStage.hideStage();
                }
                MyThreadPoolManager.getInstance().execute(() -> {
                    try {
                        clientConnector.transferCall(contactInfo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.removeCover();
                });
            })).addNegativeButton(ClientSingleton.getInstance().getString("cancel"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
                contactInfoPane.makeSelected(false);
                this.closeAlert();
                this.removeCover();
            })).moveToFront().setAlwaysOnTop(true).buildDialogAndShow();
        });
    }

    private void closeAlert() {
        this.myAlert.close();
        this.myAlert = null;
    }

    private void populate(Stream<ContactInfo> stream1) {
        Predicate<ContactInfo> predicate;
        this.contactsList.clear();
        if (!ClientSingleton.getInstance().getClientConnector().get().canSeeUsers()) {
            stream1 = stream1.filter(UpdateLists.getNotAutorizedContacts());
        }
        if (this.showMode == 1) {
            predicate = contactInfo -> contactInfo.isUser() && !this.excludeContacts.contains(contactInfo);
        } else if (this.showMode == 2) {
            stream1 = stream1.limit(1000L);
            predicate = AudioCaller.getWorkingLinesCount() != 0 ? contactInfo -> !contactInfo.isUser() && !contactInfo.isFeature() && !this.excludeContacts.contains(contactInfo) && contactInfo.getStatus() != 3 && contactInfo.canReceiveCalls() : UpdateLists::isContactNotAutirized;
        } else {
            stream1 = stream1.limit(1000L);
            predicate = contactInfo -> {
                if (this.isWithoutUsers) {
                    return !contactInfo.isUser();
                }
                return !this.excludeContacts.contains(contactInfo);
            };
        }
        List contactInfoList = stream1.distinct().filter(contactInfo -> {
            if ((contactInfo.getName() == null || contactInfo.getName().isEmpty()) && (contactInfo.toString() == null || contactInfo.toString().isEmpty())) {
                return false;
            }
            return !contactInfo.isFeature() && contactInfo.getStatus() != 3 && (!this.isSpeedDialMode || !contactInfo.isSpeedDial());
        }).filter(predicate).sorted().filter(ClientSingleton.getInstance().distinctByKey(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo) == null ? "" : ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
        Function<ContactInfo, String> classifier = contactInfo -> contactInfo.toString().substring(0, 1);
        Supplier<TreeMap> mapFactory = () -> new TreeMap(Comparator.naturalOrder());
        Collector downStream = Collectors.toList();
        Collector<ContactInfo, ?, TreeMap> collector = Collectors.groupingBy(classifier, mapFactory, downStream);
        TreeMap map = contactInfoList.stream().collect(collector);
        map.forEach((key, value) -> {
            this.contactsList.add(this.getContactInfoPane(key));
            for (ContactInfo contactInfo : value) {
                ContactInfoPane contactInfoPane = this.getContactInfoPane(contactInfo);
                if (this.iChildContactSelected != null) {
                    contactInfoPane.setIContactSelected(this.iChildContactSelected);
                }
                this.contactsList.add(contactInfoPane);
            }
        });
        if (this.iOnLoad != null) {
            this.iOnLoad.listUpdated();
        }
    }

    protected void scrollItems(int oldValue, int newValue) {
        block8: {
            ArrayList<ContactInfoPane> items;
            block7: {
                if (this.contactsList.isEmpty()) {
                    return;
                }
                if (this.getCurrentScrollState() != ScrollingState.SCROLLBAR_SCROLLING) {
                    this.myScrollBar.setValue(newValue - this.columnCount * this.itemOnList);
                }
                items = new ArrayList<ContactInfoPane>();
                if (oldValue >= newValue) break block7;
                this.firstVisibleIndex.set(this.firstVisibleIndex.get() + 1);
                ContactInfoPane cip = this.contactsList.get(newValue);
                for (VBox vBox : this.columnsView) {
                    ContactInfoPane contactInfoPane = (ContactInfoPane)((Object)vBox.getChildren().remove(0));
                    items.add(contactInfoPane);
                }
                items.add(cip);
                for (int index = 0; index < this.columnsView.size(); ++index) {
                    VBox vBox;
                    vBox = this.columnsView.get(index);
                    vBox.getChildren().add((Object)((Node)items.get(index + 1)));
                }
                break block8;
            }
            if (oldValue <= newValue) break block8;
            this.firstVisibleIndex.set(this.firstVisibleIndex.get() - 1);
            if (this.firstVisibleIndex.get() >= this.contactsList.size()) {
                this.firstVisibleIndex.set(this.contactsList.size() - 1);
            }
            ContactInfoPane cip = this.contactsList.get(this.firstVisibleIndex.get());
            for (VBox vBox : this.columnsView) {
                items.add((ContactInfoPane)((Object)vBox.getChildren().remove(vBox.getChildren().size() - 1)));
            }
            items.add(0, cip);
            for (int index = 0; index < this.columnsView.size(); ++index) {
                VBox vBox;
                vBox = this.columnsView.get(index);
                cip = (ContactInfoPane)((Object)items.get(index));
                if (vBox.getChildren().contains((Object)cip)) continue;
                vBox.getChildren().add(0, (Object)cip);
            }
        }
    }

    protected void searchContact(String prefix) {
        if (this.searchObserver == null) {
            this.initSearchObserver();
        }
        this.searchObserver.onNext((Object)prefix);
    }

    public List<ContactInfoPane> getContactsList() {
        return this.contactsList;
    }

    protected StackPane initComponents() {
        this.mainBackgroundPane = new StackPane();
        this.myScrollBar = new MyScrollBar(this);
        this.currentScrollingState = ScrollingState.NOT_SCROLLING;
        this.mainPane = new HBox();
        VBox.setMargin((Node)this.mainPane, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
        for (int i = 0; i < this.columnCount; ++i) {
            this.columns.add((ObservableList<Pane>)FXCollections.observableArrayList());
            VBox vBox = this.getColumnPane();
            this.columnsView.add(vBox);
            vBox.prefHeightProperty().bind((ObservableValue)this.mainPane.heightProperty());
            this.mainPane.getChildren().add((Object)vBox);
            vBox.addEventFilter(ScrollEvent.SCROLL, event -> {
                this.currentScrollingState = ScrollingState.FLING_SCROLLING;
                if (event.getDeltaY() < 0.0) {
                    this.scrollDown();
                } else {
                    this.scrollUp();
                }
                this.currentScrollingState = ScrollingState.NOT_SCROLLING;
            });
        }
        int height = this.getMaxPaneHeight() - 40 * (this.buttons.isEmpty() ? 2 : 3) - (this.isShowSelectLabels() ? 40 : 0);
        if (this.contactsList.size() > this.itemOnList * this.columnCount) {
            this.mainPane.getChildren().add((Object)this.myScrollBar);
            this.myScrollBar.setMinHeight(height);
        } else {
            this.mainPane.setMinHeight((double)height);
        }
        this.mainBackgroundPane.getChildren().add((Object)this.mainPane);
        this.mainPane.prefHeightProperty().bind((ObservableValue)this.maxPaneHeight);
        this.mainPane.prefWidthProperty().bind((ObservableValue)this.maxPaneWidth);
        this.mainBackgroundPane.prefHeightProperty().bind((ObservableValue)this.maxPaneHeight);
        this.mainBackgroundPane.minWidthProperty().bind((ObservableValue)this.maxPaneWidth);
        this.mainBackgroundPane.maxWidthProperty().bind((ObservableValue)this.maxPaneWidth);
        this.populateColumns();
        this.initObservable();
        return this.mainBackgroundPane;
    }

    public StackPane getMainPane() {
        return this.mainBackgroundPane;
    }

    public Pane getHeaderLine(EventHandler<MouseEvent> event) {
        return this.getHeaderLine(event, null);
    }

    public Pane getHeaderLine(EventHandler<MouseEvent> event, EventHandler<MouseEvent> backEvent) {
        VBox pane = null;
        this.headerLine = new VBox();
        HBox.setMargin((Node)this.headerLine, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        HBox.setHgrow((Node)this.headerLine, (Priority)Priority.ALWAYS);
        if (this.isShowSelectLabels()) {
            this.headerLine.setAlignment(Pos.CENTER);
            this.headerLine.setMinHeight(85.0);
            HBox.setMargin((Node)this.headerLine, (Insets)new Insets(0.0, 0.0, 10.0, 5.0));
            HBox labels = new HBox();
            labels.setMinHeight(40.0);
            labels.setMaxHeight(40.0);
            labels.setAlignment(Pos.CENTER_LEFT);
            this.headerLine.setMinHeight(this.headerLine.getMinHeight() + 15.0);
            String color = Theme.getInstance().isDarkTheme() ? ClientSingleton.getInstance().getStyleValue(Constants.TAB_CELL_TEXT_FILL) : "#969aae";
            MyLabel show = this.getLabel("call_transfer0_", color);
            show.setLabelMarginRight(5);
            show.setMaxWidth(70.0);
            show.setTextAlignment(Pos.CENTER_LEFT);
            this.showAll = this.getLabel("call_transfer0", "#969aae");
            this.showAll.setWithRightBorder(true);
            this.showAll.setLabelMarginRight(10);
            this.showUsers = this.getLabel("call_transfer1", "#242b42");
            this.showUsers.setWithRightBorder(true);
            this.showUsers.setLabelMarginRight(10);
            this.showNotUsers = this.getLabel("call_transfer2", "#969aae");
            this.showAll.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.switchLabel(0)));
            this.showUsers.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.switchLabel(1)));
            this.showNotUsers.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.switchLabel(2)));
            if (this.isWithoutUsers) {
                labels.getChildren().addAll((Object[])new Node[]{show, this.showAll});
            } else {
                labels.getChildren().addAll((Object[])new Node[]{show, this.showAll, this.showUsers, this.showNotUsers});
            }
            this.switchLabelView();
            if (this.isTitleOfTheTopLine()) {
                this.headerLine.getChildren().add((Object)this.getExtraHeader(event, backEvent));
            }
            this.headerLine.getChildren().add((Object)this.getHeader(event));
            this.headerLine.getChildren().add((Object)labels);
            if (this.extraPane != null) {
                this.headerLine.getChildren().add((Object)this.containerPane);
            }
            pane = this.headerLine;
            this.setMaxPaneHeight(this.getMaxPaneHeight() + 40);
            labels.prefWidthProperty().addListener((eventC, oldValue, newValue) -> {
                if (this.getColumnCount() == 1) {
                    String label = this.showUsers.getText() + this.showNotUsers.getText();
                    for (VBox column : this.columnsView) {
                        column.setMinWidth((double)(this.getMaxPaneWidth() - 5));
                        column.setMaxWidth((double)(this.getMaxPaneWidth() - 5));
                        column.setPrefWidth((double)(this.getMaxPaneWidth() - 5));
                    }
                }
            });
            labels.prefWidthProperty().bind((ObservableValue)this.headerLine.widthProperty());
        } else {
            if (this.isTitleOfTheTopLine()) {
                this.headerLine.getChildren().add((Object)this.getExtraHeader(event, backEvent));
            }
            this.headerLine.setMinHeight((double)(40 * (this.isTitleOfTheTopLine ? 2 : 1)));
            this.headerLine.getChildren().add((Object)this.getHeader(event));
            if (this.extraPane != null) {
                this.headerLine.getChildren().add((Object)this.containerPane);
            }
            pane = this.headerLine;
        }
        return pane;
    }

    private void switchLabel(int mode) {
        if (this.showMode == mode) {
            return;
        }
        this.showMode = mode;
        this.switchLabelView();
        this.setShowOnlyUsers(this.showMode);
        if (this.textFieldWithSearch.getText().isEmpty()) {
            this.searchContact("");
        } else {
            this.textFieldWithSearch.setText("");
        }
        if (this.iContactListChanged != null) {
            this.iContactListChanged.contactListChanged();
        }
    }

    private void switchLabelView() {
        String color;
        String string = color = Theme.getInstance().isDarkTheme() ? ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL) : "#242b42";
        if (this.showMode == 0) {
            this.showAll.setLabelFontColor(color);
            this.showUsers.setLabelFontColor("#969aae");
            this.showNotUsers.setLabelFontColor("#969aae");
        } else if (this.showMode == 1) {
            this.showAll.setLabelFontColor("#969aae");
            this.showUsers.setLabelFontColor(color);
            this.showNotUsers.setLabelFontColor("#969aae");
        } else {
            this.showAll.setLabelFontColor("#969aae");
            this.showUsers.setLabelFontColor("#969aae");
            this.showNotUsers.setLabelFontColor(color);
        }
    }

    private MyLabel getLabel(String title, String background) {
        MyLabel myLabel = new MyLabel();
        myLabel.setMaxHeight(15.0);
        myLabel.setIsUnderline(true);
        myLabel.setText(title);
        myLabel.setAlignment(Pos.CENTER);
        myLabel.setBackgroundColor("transparent");
        myLabel.setLabelFontSize(12);
        myLabel.setLabelFontColor(background);
        myLabel.setLabelFontFamily("Arial");
        myLabel.setLabelMarginLeft(10);
        ClientSingleton.getInstance().setMouseCursor((Node)myLabel);
        return myLabel;
    }

    public HBox getExtraHeader(EventHandler<MouseEvent> event, EventHandler<MouseEvent> backEvent) {
        HBox hBox = new HBox();
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setMinHeight(40.0);
        hBox.setMaxHeight(40.0);
        if (event != null) {
            hBox.getChildren().addAll((Object[])new Node[]{this.getTitleBox(), this.getCloseButton(event)});
        } else {
            hBox.getChildren().add((Object)this.getTitleBox());
        }
        if (backEvent != null) {
            hBox.getChildren().add(0, (Object)this.getBackButton(backEvent));
        }
        return hBox;
    }

    private HBox getHeader(EventHandler<MouseEvent> event) {
        HBox hBox = new HBox();
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)hBox, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        hBox.setMinHeight(40.0);
        hBox.setMaxHeight(40.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        if (event != null && !this.isTitleOfTheTopLine()) {
            hBox.getChildren().add((Object)this.getTitleBox());
        }
        this.textFieldWithSearch = new TextFieldWithSearch();
        this.textFieldWithSearch.setPromptText("contact_search_prompt");
        this.textFieldWithSearch.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR));
        this.textFieldWithSearch.setTextFontColor(ClientSingleton.getInstance().getStyleValue(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL));
        if (this.isWithSearch) {
            this.textFieldWithSearch.setWithSearch(true);
        }
        HBox.setHgrow((Node)this.textFieldWithSearch, (Priority)Priority.ALWAYS);
        if (this.getColumnCount() > 1) {
            this.textFieldWithSearch.setTextWidth(290);
        } else {
            this.textFieldWithSearch.prefWidthProperty().bind((ObservableValue)hBox.widthProperty().subtract(10));
        }
        hBox.getChildren().add((Object)this.textFieldWithSearch);
        if (this.extraPane != null) {
            for (Node pane : this.extraPane.getChildren()) {
                MyLabel myLabel = (MyLabel)pane;
                if (!"text".equals(myLabel.getId())) continue;
                this.textFieldWithSearch.addListener((ChangeListener<? super String>)((ChangeListener)(observable, oldValue, newValue) -> myLabel.setText((String)newValue)));
            }
        }
        this.textFieldWithSearch.addListener((ChangeListener<? super String>)((ChangeListener)(observable, oldValue, newValue) -> {
            if (oldValue.isEmpty() && newValue.isEmpty()) {
                return;
            }
            if (this.extraPane != null) {
                int height = (int)this.extraPane.getMaxHeight() + 15;
                if (!newValue.isEmpty()) {
                    if (!this.containerPane.getChildren().contains((Object)this.extraPane)) {
                        this.containerPane.getChildren().add((Object)this.extraPane);
                        this.headerLine.setMinHeight(this.headerLine.getMinHeight() + (double)height);
                        this.mainPane.setMinHeight(this.mainPane.getMinHeight() - this.headerLine.getMinHeight());
                        this.itemOnList = this.buttons.isEmpty() ? this.itemOnList - 1 : this.itemOnList - 2;
                        this.setItemOnList(this.itemOnList);
                    }
                } else if (this.containerPane.getChildren().contains((Object)this.extraPane)) {
                    this.containerPane.getChildren().remove((Object)this.extraPane);
                    this.mainPane.setMinHeight(this.mainPane.getMinHeight() + (double)height);
                    this.headerLine.setMinHeight(this.headerLine.getMinHeight() - this.headerLine.getMinHeight());
                    this.itemOnList = this.buttons.isEmpty() ? this.itemOnList + 1 : this.itemOnList + 2;
                    this.setItemOnList(this.itemOnList);
                }
            }
            this.searchContact((String)newValue);
            if (this.iContactListChanged != null) {
                TimerExecutor.getInstance().setMyAction(() -> this.iContactListChanged.contactListChanged()).startWithDelay(100L);
            }
        }));
        HBox.setHgrow((Node)this.textFieldWithSearch, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.textFieldWithSearch, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        if (event != null && !this.isTitleOfTheTopLine()) {
            hBox.getChildren().add((Object)this.getCloseButton(event));
        } else {
            this.textFieldWithSearch.minWidthProperty().bind((ObservableValue)hBox.minWidthProperty());
        }
        return hBox;
    }

    private HBox getTitleBox() {
        HBox labelBox = new HBox();
        Label titleLabel = new Label();
        labelBox.getChildren().add((Object)titleLabel);
        titleLabel.setAlignment(Pos.CENTER_LEFT);
        titleLabel.setText(ClientSingleton.getInstance().getString(this.title));
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)titleLabel);
        HBox.setHgrow((Node)titleLabel, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)titleLabel, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        return labelBox;
    }

    private HBox getCloseButton(EventHandler<MouseEvent> event) {
        HBox closeBox = new HBox();
        closeBox.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow((Node)closeBox, (Priority)Priority.ALWAYS);
        CloseImageButton closeImageButton = new CloseImageButton(true);
        closeImageButton.setBackgroundColor("transparent");
        closeImageButton.setSize(20, 20);
        closeImageButton.addMouseEventHandler(event);
        closeBox.getChildren().add((Object)closeImageButton);
        closeImageButton.requestFocus();
        return closeBox;
    }

    private HBox getBackButton(EventHandler<MouseEvent> event) {
        HBox backBox = new HBox();
        backBox.setAlignment(Pos.CENTER_RIGHT);
        ImageButton backImageButton = new ImageButton();
        backImageButton.setImagePath("other/arrow_back.png");
        backImageButton.setSize(20, 20);
        backImageButton.addMouseEventHandler(event);
        backBox.getChildren().add((Object)backImageButton);
        backImageButton.requestFocus();
        return backBox;
    }

    private void populateColumns() {
        int visibleIndex = 0;
        for (VBox vBox : this.columnsView) {
            vBox.getChildren().clear();
            for (int i = 0; i < this.itemOnList && this.contactsList.size() - 1 >= visibleIndex; ++visibleIndex, ++i) {
                ContactInfoPane contactInfoPane = this.contactsList.get(visibleIndex);
                vBox.getChildren().add((Object)contactInfoPane);
            }
        }
        this.lastVisibleIndex.removeListener(this.changeListener);
        this.lastVisibleIndex.setValue((Number)visibleIndex);
        this.lastVisibleIndex.addListener(this.changeListener);
        if (this.contactsList.size() > this.itemOnList * this.columnCount) {
            if (!this.myScrollBar.isVisible()) {
                this.myScrollBar.setVisible(true);
            }
            this.myScrollBar.setValue(0);
            this.myScrollBar.setMax(this.contactsList.size() - visibleIndex);
            this.myScrollBar.setOnValueChangedAction((ChangeListener<Number>)((ChangeListener)(observableValue, oldValue, newValue) -> {
                if (this.getCurrentScrollState() == ScrollingState.SCROLLBAR_SCROLLING) {
                    if ((double)(oldValue.intValue() - newValue.intValue()) < 0.0) {
                        this.scrollDown();
                    } else if ((double)(oldValue.intValue() - newValue.intValue()) > 0.0) {
                        this.scrollUp();
                    }
                }
            }));
        } else if (this.myScrollBar.isVisible()) {
            this.myScrollBar.setVisible(false);
        }
    }

    private void scrollUp() {
        if (this.firstVisibleIndex.get() - 1 >= 0) {
            this.lastVisibleIndex.set(this.lastVisibleIndex.get() - 1);
        }
    }

    private void scrollDown() {
        if (this.lastVisibleIndex.get() + 1 < this.contactsList.size()) {
            this.lastVisibleIndex.set(this.lastVisibleIndex.get() + 1);
        }
    }

    private VBox getColumnPane() {
        VBox vBox = new VBox();
        int COLUMN_WIDTH = this.columnCount == 1 ? 250 : 160;
        vBox.setMinWidth((double)COLUMN_WIDTH);
        vBox.setMaxWidth((double)COLUMN_WIDTH);
        vBox.setPrefWidth((double)COLUMN_WIDTH);
        vBox.setMinHeight((double)(this.itemOnList * 32));
        vBox.setMaxHeight((double)(this.itemOnList * 32));
        vBox.setPrefHeight((double)(this.itemOnList * 32));
        this.setMaxPaneWidth(this.getMaxPaneWidth() + (COLUMN_WIDTH + 5));
        return vBox;
    }

    @Override
    public void changeScrollState(ScrollingState scrollingState) {
        this.currentScrollingState = scrollingState;
    }

    @Override
    public ScrollingState getCurrentScrollState() {
        return this.currentScrollingState;
    }

    private ContactInfoPane getContactInfoPane(Object label) {
        return ContactInfoPane.getInstance().setLabel(label).setWithAvatar(false).setItemPaneHeight(32).setWithMouseSelection(this.isWithMouseSelection).setSelectWithArrow(this.isSelectWithArrow).setWithMinusImage(this.isWithMinusImage).build();
    }

    private void initObservable() {
        String[] actions = new String[]{IntentConstants.CONTACT_STATE_CHANGED};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        if (action.equals(IntentConstants.CONTACT_STATE_CHANGED)) {
            ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
            if (contactInfo == null) {
                return;
            }
            for (ContactInfoPane pane : this.contactsList) {
                if (pane.getId() == null || !pane.getId().equals(ClientSingleton.getInstance().getUserID(contactInfo))) continue;
                ClientSingleton.getInstance().runLater(pane::setState);
            }
        }
    }

    public void setUnSelectContacts(ContactInfo exContactInfo) {
        this.contactsList.forEach(contactInfoPane -> {
            if (contactInfoPane.getContactInfo() != null && !ClientSingleton.getInstance().getUserID(contactInfoPane.getContactInfo()).equals(ClientSingleton.getInstance().getUserID(exContactInfo)) && contactInfoPane.isSelected()) {
                contactInfoPane.makeSelected(false);
            }
        });
    }

    private boolean isExistsPhoneNumber(ContactInfo contactInfo, String prefix) {
        List phones = contactInfo.getPhoneDetails();
        for (ContactInfo.Detail detail : phones) {
            boolean eqvPhone;
            String number;
            if (detail.getValue() instanceof Map) {
                Map m = (Map)detail.getValue();
                number = (String)m.get("value");
            } else {
                number = detail.getValue().toString();
            }
            if (number == null || number.isEmpty() || !(eqvPhone = (number = number.replaceAll("\\s+|\\(|\\)", "")).toLowerCase().contains(prefix))) continue;
            return true;
        }
        Optional<String> ext = Optional.ofNullable(Optional.ofNullable((String)contactInfo.getProperty("extension")).orElse((String)contactInfo.getProperty("ext")));
        if (ext.isPresent()) {
            return ext.get().toLowerCase().contains(prefix);
        }
        return false;
    }

    public void setWithButtonSelection(boolean withButtonSelection) {
        this.withButtonSelection = withButtonSelection;
    }

    public boolean isWithButtonSelection() {
        return this.withButtonSelection;
    }

    protected HBox getFooter() {
        if (this.buttons.isEmpty()) {
            return null;
        }
        if (this.footer != null) {
            return this.footer;
        }
        this.footer = new HBox();
        HBox.setHgrow((Node)this.footer, (Priority)Priority.ALWAYS);
        this.footer.setMinHeight(40.0);
        this.footer.setMaxHeight(40.0);
        this.footer.setAlignment(this.buttons.size() == 1 ? Pos.BOTTOM_RIGHT : Pos.BOTTOM_CENTER);
        for (MyLabelButton myLabelButton : this.buttons) {
            HBox.setHgrow((Node)myLabelButton, (Priority)Priority.ALWAYS);
            this.footer.getChildren().add((Object)myLabelButton);
            myLabelButton.prefHeightProperty().bind((ObservableValue)this.footer.heightProperty());
        }
        this.footer.setStyle("-fx-background-color:transparent;");
        return this.footer;
    }

    protected MyLabelButton addButtonToFooter(String buttonTitle, EventHandler<MouseEvent> event) {
        MyLabelButton myLabelButton = new MyLabelButton(ClientSingleton.getInstance().getString(buttonTitle), 30, this.withButtonSelection);
        HBox.setMargin((Node)myLabelButton, (Insets)new Insets(0.0, 15.0, 0.0, 15.0));
        myLabelButton.addMouseEventHandler(event);
        this.buttons.add(myLabelButton);
        return myLabelButton;
    }

    public List<MyLabelButton> getButtons() {
        return this.buttons;
    }

    public void setWithMouseSelection(boolean withMouseSelection) {
        this.isWithMouseSelection = withMouseSelection;
    }

    public void setSelectWithArrow(boolean selectWithArrow) {
        this.isSelectWithArrow = selectWithArrow;
    }

    public boolean isSelectWithArrow() {
        return this.isSelectWithArrow;
    }

    public void setWithSearchImage(boolean withSearch) {
        this.isWithSearch = withSearch;
    }

    protected void setSelectedList(List<ContactInfo> list) {
        this.selectedList = list;
    }

    private void addCover() {
        if (this.mainBackgroundPane.getChildren().size() != 1) {
            return;
        }
        Pane pane = new Pane();
        HBox.setHgrow((Node)pane, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        pane.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> event.consume());
        pane.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> event.consume());
        pane.setStyle(" -fx-opacity: 0.7;-fx-background-color:" + ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR) + " ;");
        this.mainBackgroundPane.getChildren().add((Object)pane);
    }

    private void removeCover() {
        if (this.mainBackgroundPane.getChildren().size() == 1) {
            return;
        }
        Pane pane = (Pane)this.mainBackgroundPane.getChildren().remove(this.mainBackgroundPane.getChildren().size() - 1);
        if (pane != null) {
            pane.prefWidthProperty().unbind();
            pane.prefHeightProperty().unbind();
        }
    }

    protected boolean hideWindow() {
        if (this.myAlert != null) {
            this.myAlert.close();
            this.myAlert = null;
        }
        this.myPopupWindow.hide();
        return true;
    }

    protected void initMotionListener(Node node) {
        if (this.myPopupWindow != null) {
            this.myPopupWindow.initMotionListeners(node);
        }
    }

    private void initSearchObserver() {
        this.searchObserver = PublishSubject.create();
        this.disposables = new CompositeDisposable();
        this.disposables.add(this.searchObserver.debounce(200L, TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).switchMap(prefix -> {
            if (prefix.isEmpty()) {
                this.populateLists();
            } else {
                Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
                if (optionalClientConnector.isEmpty()) {
                    return Observable.empty();
                }
                Stream stream1 = (this.currentContactList != null ? this.currentContactList : optionalClientConnector.get().getContacts()).stream();
                this.populate(stream1.filter(contactInfo -> {
                    if (!this.excludeContacts.contains(contactInfo)) {
                        return contactInfo.toString().toLowerCase().contains(prefix.toLowerCase()) || this.isExistsPhoneNumber((ContactInfo)contactInfo, prefix.toLowerCase());
                    }
                    return false;
                }));
            }
            return Observable.just((Object)true);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(just -> {
            if (just.booleanValue()) {
                this.populateColumns();
            }
        }, Throwable::printStackTrace));
    }

    protected void onClose() {
        if (this.disposables != null) {
            this.disposables.dispose();
            this.disposables.clear();
            this.disposables = null;
        }
        this.searchObserver = null;
    }
}

