/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.emoji;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.views.emoji.EmojiButton;
import net.sipsnet.client.views.emoji.EmojisController;

public class EmojiBaseController {
    private PublishSubject<ScrollPane> updateObserver;
    private PublishSubject<Boolean> resizeObserver;
    private CompositeDisposable disposables = new CompositeDisposable();
    private CompositeDisposable disposablesResize = new CompositeDisposable();
    private boolean isResizing;

    public void dispose() {
        if (this.disposables != null) {
            this.disposables.dispose();
            this.disposables.clear();
            this.disposables = null;
        }
        if (this.disposablesResize != null) {
            this.disposablesResize.dispose();
            this.disposablesResize.clear();
            this.disposablesResize = null;
        }
        this.updateObserver = null;
        this.resizeObserver = null;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "on dispose ");
    }

    public void onResize(MyAction myAction) {
        if (this.resizeObserver == null) {
            this.initResizeObserver(myAction);
        }
        this.resizeObserver.onNext((Object)true);
    }

    public void onCheckVisible(ScrollPane scrollPane) {
        if (this.updateObserver == null) {
            this.initUpdateObserver();
        }
        this.updateObserver.onNext((Object)scrollPane);
    }

    private void initResizeObserver(MyAction myAction) {
        this.resizeObserver = PublishSubject.create();
        if (this.disposablesResize == null) {
            this.disposablesResize = new CompositeDisposable();
        }
        this.disposablesResize.add(this.resizeObserver.debounce(100L, TimeUnit.MILLISECONDS).doOnError(this::onError).switchMap(b -> {
            this.isResizing = true;
            return Observable.just((Object)0);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(integer -> {
            myAction.execute();
            this.isResizing = false;
        }, this::onError));
    }

    private void onError(Throwable throwable) {
        throwable.printStackTrace();
        this.isResizing = false;
    }

    private void initUpdateObserver() {
        this.updateObserver = PublishSubject.create();
        if (this.disposables == null) {
            this.disposables = new CompositeDisposable();
        }
        this.disposables.add(this.updateObserver.debounce(100L, TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).switchMap(pane -> {
            if (this.isResizing) {
                return Observable.empty();
            }
            return Observable.just((Object)pane);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(pane -> {
            ArrayList<Node> visibleNodes = new ArrayList<Node>();
            Bounds paneBounds = pane.localToScene(pane.getBoundsInParent());
            if (pane.getContent() instanceof GridPane) {
                for (Node n : ((GridPane)pane.getContent()).getChildrenUnmodifiable()) {
                    Bounds nodeBounds;
                    EmojiButton emojiButton = (EmojiButton)n;
                    if (emojiButton.isHasImage() || !paneBounds.intersects(nodeBounds = n.localToScene(n.getBoundsInLocal()))) continue;
                    visibleNodes.add(n);
                }
            }
            visibleNodes.forEach(node -> ((EmojiButton)node).setImagePath());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "iconsCount = " + EmojisController.iconsCount);
        }, Throwable::printStackTrace));
    }
}

