/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.emoji;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.views.emoji.EmojiActionEvent;
import net.sipsnet.client.views.emoji.EmojiBaseController;
import net.sipsnet.client.views.emoji.EmojiButton;
import net.sipsnet.client.views.emoji.EmojiTabHeader;
import net.sipsnet.client.views.emoji.IEmojiController;
import net.sipsnet.client.views.emoji.utils.EmojiClass;
import net.sipsnet.client.views.emoji.utils.EmojiUtils;

public class EmojisController
extends EmojiBaseController
implements IEmojiController {
    private final String TAB_EMOTIONS = "emotions";
    private final String TAB_FACES = "faces";
    private final String TAB_HANDS = "hands";
    private final String TAB_OBJECTS = "objects";
    private final List<EmojiTabHeader> tabHeaders = new ArrayList<EmojiTabHeader>();
    private EventHandler<EmojiActionEvent> onEmojiAction;
    private VBox fx_MainPane;
    private int currentWidth;
    private String currentTab = "emotions";
    public static int iconsCount = 0;
    @FXML
    private ScrollPane fx_spTitles;
    @FXML
    private ScrollPane fx_SmilesScrollPane;
    @FXML
    private ScrollPane fx_FacesScrollPane;
    @FXML
    private ScrollPane fx_HandsScrollPane;
    @FXML
    private ScrollPane fx_ObjectsScrollPane;
    @FXML
    private ImageButton fx_CloseStage;
    @FXML
    private HBox fx_spEmojis;
    @FXML
    private HBox fx_TabTitles;

    public static EmojisController getInstance() {
        return new EmojisController();
    }

    @Override
    public Pane getPane() {
        this.setSelectTab("emotions");
        return this.fx_MainPane;
    }

    @Override
    public Pane getPaneForDispose() {
        this.dispose();
        return this.fx_MainPane;
    }

    @Override
    public void setEmojiAction(EventHandler<EmojiActionEvent> event) {
        this.onEmojiAction = event;
        this.addEmojiTab("emotions");
        this.addEmojiTab("faces");
        this.addEmojiTab("hands");
        this.addEmojiTab("objects");
    }

    @Override
    public void setCloseAction(EventHandler<MouseEvent> mouseEvent) {
        this.fx_CloseStage.addMouseEventHandler(mouseEvent);
        this.fx_CloseStage.setImagePath("buttons/arrow_down.png");
    }

    @Override
    public void setWidth(int width) {
        this.currentWidth = width;
    }

    private EmojisController() {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/emoji/emoji.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        try {
            this.fx_MainPane = (VBox)loader.load();
            Theme.getInstance().applyTo(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND, (Pane)this.fx_MainPane);
            String color = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)this.fx_spTitles, color);
            loader.setController((Object)this);
            this.initComponent();
            this.fx_MainPane.widthProperty().addListener((event, oldValue, newValue) -> {
                this.currentWidth = newValue.intValue() - 5;
                if (this.fx_SmilesScrollPane != null) {
                    ((GridPane)this.fx_SmilesScrollPane.getContent()).getChildren().clear();
                    ((GridPane)this.fx_HandsScrollPane.getContent()).getChildren().clear();
                    ((GridPane)this.fx_FacesScrollPane.getContent()).getChildren().clear();
                    ((GridPane)this.fx_ObjectsScrollPane.getContent()).getChildren().clear();
                }
                this.onResize(() -> this.addGridPaneRows(this.currentTab));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponent() {
        this.setSelectTab("emotions");
        BorderPane.setMargin((Node)this.fx_spTitles, (Insets)new Insets(10.0, 10.0, 5.0, 10.0));
    }

    private void setSelectTab(String category) {
        this.tabHeaders.forEach(emojiTabHeader -> {
            if (!emojiTabHeader.getCategory().equals(category) && emojiTabHeader.isSelected()) {
                emojiTabHeader.unselectedButton();
            }
        });
        this.currentTab = category;
        this.addGridPaneRows(category);
    }

    private void addGridPaneRows(String category) {
        if (this.fx_SmilesScrollPane == null) {
            this.fx_SmilesScrollPane = this.getScrollPane();
            this.fx_HandsScrollPane = this.getScrollPane();
            this.fx_FacesScrollPane = this.getScrollPane();
            this.fx_ObjectsScrollPane = this.getScrollPane();
        }
        AtomicReference<ScrollPane> scrollPane = new AtomicReference<ScrollPane>();
        if (category.equals("emotions")) {
            scrollPane.set(this.fx_SmilesScrollPane);
        } else if (category.equals("hands")) {
            scrollPane.set(this.fx_HandsScrollPane);
        } else if (category.equals("faces")) {
            scrollPane.set(this.fx_FacesScrollPane);
        } else {
            scrollPane.set(this.fx_ObjectsScrollPane);
        }
        GridPane gridPane = (GridPane)((ScrollPane)scrollPane.get()).getContent();
        this.fx_spEmojis.getChildren().clear();
        if (gridPane.getChildren().isEmpty() && this.currentWidth != 0) {
            int columnIndex = 0;
            int rowIndex = 0;
            EmojiButton button = null;
            List<EmojiClass> emojisList = EmojiUtils.getEmojisList(category);
            if (emojisList != null) {
                int EMOJIS_PER_LINE = this.currentWidth / EmojiButton.BUTTON_WIDTH - 1;
                for (EmojiClass emojiClass : emojisList) {
                    if (columnIndex > EMOJIS_PER_LINE) {
                        ++rowIndex;
                        columnIndex = 0;
                    }
                    button = new EmojiButton(emojiClass);
                    button.setBackgroundColor("transparent");
                    button.setOnEmojiAction((EventHandler<EmojiActionEvent>)((EventHandler)arg_0 -> this.onEmojiAction.handle(arg_0)));
                    GridPane.setColumnIndex((Node)button, (Integer)columnIndex);
                    GridPane.setRowIndex((Node)button, (Integer)rowIndex);
                    gridPane.getChildren().add((Object)button);
                    ++columnIndex;
                }
                TimerExecutor.getInstance().setMyAction(() -> this.checkVisible((ScrollPane)scrollPane.get())).startWithDelayInGUIThread(500L);
            }
        }
        this.fx_spEmojis.getChildren().add((Object)((Node)scrollPane.get()));
    }

    private void checkVisible(ScrollPane scrollPane) {
        this.onCheckVisible(scrollPane);
    }

    private ScrollPane getScrollPane() {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        GridPane gridPane = new GridPane();
        gridPane.prefWidthProperty().bind((ObservableValue)scrollPane.widthProperty());
        scrollPane.setContent((Node)gridPane);
        scrollPane.setFitToHeight(true);
        scrollPane.setPannable(true);
        scrollPane.prefWidthProperty().bind((ObservableValue)this.fx_MainPane.widthProperty().subtract(5));
        String color = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND);
        Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)scrollPane, color);
        scrollPane.vvalueProperty().addListener(obs -> this.checkVisible(scrollPane));
        scrollPane.hvalueProperty().addListener(obs -> this.checkVisible(scrollPane));
        HBox.setHgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        return scrollPane;
    }

    private void addEmojiTab(String title) {
        String[] images;
        switch (title) {
            case "emotions": {
                images = new String[]{"emojis_people_off.png", "emojis_people_on.png"};
                break;
            }
            case "faces": {
                images = new String[]{"emojis_faces_off.png", "emojis_faces_on.png"};
                break;
            }
            case "hands": {
                images = new String[]{"emojis_hands_off.png", "emojis_hands_on.png"};
                break;
            }
            default: {
                images = new String[]{"emojis_objects_off.png", "emojis_objects_on.png"};
            }
        }
        String prefix = "emojis_tabs/";
        images[0] = prefix + images[0];
        images[1] = prefix + images[1];
        EmojiTabHeader emojiTabHeader = new EmojiTabHeader(title, images);
        emojiTabHeader.setSize(24, 24);
        HBox hBox = new HBox();
        hBox.setMinWidth(50.0);
        hBox.setMaxWidth(50.0);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().add((Object)emojiTabHeader);
        if (title.equals("emotions")) {
            emojiTabHeader.setSelectedButton();
        }
        this.tabHeaders.add(emojiTabHeader);
        this.fx_TabTitles.getChildren().add((Object)hBox);
        emojiTabHeader.setOnMouseClicked(event -> this.setSelectTab(emojiTabHeader.getCategory()));
    }
}

