/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.group.createeditgroup;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.mylistview.MyListView;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.contactslist.IContactListChanged;
import net.sipsnet.client.views.contactslist.ScrolledContactInfosList;
import net.sipsnet.client.views.profiles.contactpane.ContactInfoPane;
import net.sipsnet.client.views.profiles.contactpane.IContactSelected;
import net.sipsnet.client.views.profiles.contactpane.IOnLoad;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class GroupCreatorEditor
extends ScrolledContactInfosList
implements IContactSelected,
IOnLoad,
IContactListChanged {
    private final HBox rootPane;
    private MyLabelButton myLabelButton;
    private MyPopupWindow myPopupWindow;
    private VBox participateBox;
    private Label participantCount;
    private MyListView myListView;
    private File pictureImagePath;
    private final int imageWidth = 111;
    private TextFieldWithSearch groupNameTextField;
    private MyTextArea fx_taComment;
    private SessionInfo sessionInfo;
    private Label myLabel;
    private boolean isAddParticipant = false;
    private int panelsWidth = 530;
    private final int leftPanelWidth = 240;
    private boolean isUpdated = false;
    private HBox closeBox;
    private final ContactInfo contactInfo;
    private ImageView myImageView;

    private void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
        if (!this.isAddParticipant) {
            this.myLabel.setText(ClientSingleton.getInstance().getString("group_edit_group"));
            this.groupNameTextField.setText(sessionInfo.toString());
            this.fx_taComment.setText(sessionInfo.getDescription());
            this.pictureImagePath = ClientSingleton.getInstance().getClientConnector().get().getAvatar(sessionInfo);
            if (this.pictureImagePath != null && this.pictureImagePath.exists()) {
                ClientSingleton.getInstance().removeAvatar("id");
                ClientSingleton.getInstance().getImageFromFile(this.pictureImagePath, 111, 111).ifPresent(image -> {
                    this.myImageView.setFitHeight(111.0);
                    this.myImageView.setFitWidth(111.0);
                    this.myImageView.setImage(this.makeRoundedImage((Image)image));
                });
            }
        }
        this.myLabelButton.setButtonLabelText(ClientSingleton.getInstance().getString("save"));
        List administrator = sessionInfo.getAdmins();
        String uId = ClientSingleton.getInstance().getUserId();
        List members = sessionInfo.getParties();
        for (ContactInfo contactInfo : members) {
            this.addContactToList(contactInfo);
        }
        for (ContactInfoPane contactInfoPane : super.getContactsList()) {
            String userId = contactInfoPane.getId();
            if (!members.stream().map(ContactInfo::getUserID).anyMatch(userId::equals)) continue;
            contactInfoPane.makeSelected();
        }
        this.participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_participants"));
    }

    public GroupCreatorEditor() {
        this(null, false, null);
    }

    public GroupCreatorEditor(ContactInfo contactInfo) {
        this(null, false, contactInfo);
        try {
            this.participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_participants"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GroupCreatorEditor(SessionInfo sessionInfo, boolean isAddParticipant) {
        this(sessionInfo, isAddParticipant, null);
    }

    private ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public GroupCreatorEditor(SessionInfo sessionInfo, boolean isAddParticipant, ContactInfo contactInfo) {
        super(new ArrayList<ContactInfo>());
        this.isAddParticipant = isAddParticipant;
        this.contactInfo = contactInfo;
        if (isAddParticipant) {
            this.panelsWidth -= 240;
        }
        this.setWithMinusImage(false);
        this.setColumnCount(2);
        this.setItemOnList(12);
        this.setWithSearchImage(true);
        this.rootPane = this.getRootPane();
        this.bindPane((Pane)this.rootPane);
        this.setMaxPaneHeight(545);
        super.setIChildContactSelected(this);
        super.setIContactListChanged(this);
        super.setIOnLoad(this);
        super.setShowOnlyUsers(1);
        super.populateLists();
        if (!isAddParticipant) {
            this.rootPane.getChildren().add((Object)this.getLeftPane());
        }
        VBox vBox = new VBox();
        Pane searchBox = this.getHeaderLine(null);
        VBox.setMargin((Node)searchBox, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        if (!isAddParticipant) {
            vBox.setStyle("-fx-border-width: 0 1 0 1; -fx-border-insets: 0 1 0 1;-fx-border-color:  #d9e0ef");
            vBox.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        } else {
            vBox.setStyle("-fx-border-width: 0 1 0 0; -fx-border-insets: 0 1 0 0;-fx-border-color:  #d9e0ef");
        }
        vBox.getChildren().addAll((Object[])new Node[]{searchBox, this.initComponents()});
        this.rootPane.getChildren().add((Object)vBox);
        this.rootPane.getChildren().add((Object)this.getRightPane());
        searchBox.setMinWidth((double)this.getMaxPaneWidth());
        if (sessionInfo != null) {
            this.setSessionInfo(sessionInfo);
        }
        if (contactInfo != null) {
            if (this.groupNameTextField != null) {
                this.groupNameTextField.setText(contactInfo.toString());
            }
            if (!super.selectContactInfoPane(contactInfo)) {
                this.addContactToList(contactInfo);
            }
        }
    }

    private void addContactToList(ContactInfo contactInfo) {
        ParticipateContact participateContact = new ParticipateContact(contactInfo, ClientSingleton.getInstance().isGroupAdmin(this.sessionInfo, contactInfo));
        VBox.setMargin((Node)participateContact, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        this.myListView.add((Pane)participateContact);
    }

    private void createGroup() {
        String name = this.groupNameTextField.getText();
        if (name.length() == 0) {
            ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_warning"));
            return;
        }
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("creating") + " " + name);
        MyThreadPoolManager.getInstance().execute(() -> {
            ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>();
            ArrayList<String> admins = new ArrayList<String>();
            for (Node node : this.participateBox.getChildren()) {
                ParticipateContact participateContact = (ParticipateContact)node;
                ContactInfo contactInfo = participateContact.getContactInfo();
                parties.add(contactInfo);
                if (!participateContact.isAdmin()) continue;
                admins.add(ClientSingleton.getInstance().getUserID(contactInfo));
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Session parties  " + parties);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    ClientSingleton.getInstance().setLastAction(IntentConstants.SESSION_CREATED);
                    SessionInfo sessionInfo = clientConnector.createSession((Collection)parties, name, 3);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "Session created  " + sessionInfo);
                    sessionInfo.setAdmins(admins);
                    sessionInfo.setName(name);
                    sessionInfo.setProperty("isFavorite", (Object)false);
                    sessionInfo.setDescription(this.fx_taComment.getText());
                    if (this.pictureImagePath != null && this.pictureImagePath.exists()) {
                        clientConnector.setAvatar(sessionInfo, this.pictureImagePath);
                    }
                    clientConnector.updateSession(sessionInfo, -1, new HashSet(), this.pictureImagePath != null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
        this.hide();
    }

    private void updateMembers() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "updateSessionMembers getSelectedIds()=" + this.participateBox.getChildren());
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("updating_chat"));
        MyThreadPoolManager.getInstance().execute(() -> {
            ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>();
            ArrayList<String> admins = new ArrayList<String>();
            for (Node node : this.participateBox.getChildren()) {
                ParticipateContact participateContact = (ParticipateContact)node;
                ContactInfo contactInfo2 = participateContact.getContactInfo();
                parties.add(contactInfo2);
                if (!participateContact.isAdmin()) continue;
                admins.add(ClientSingleton.getInstance().getUserID(contactInfo2));
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "sessionInfo.getParties()=" + this.sessionInfo.getParties());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "parties=" + parties);
            this.sessionInfo.setAdmins(admins);
            List partiesIds = this.sessionInfo.getParties().stream().map(ContactInfo::getUserID).collect(Collectors.toList());
            List add = parties.stream().filter(contactInfo -> !partiesIds.contains(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "add members=" + add);
            if (!add.isEmpty()) {
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    try {
                        clientConnector.updateSession(this.sessionInfo, 1, new HashSet(add), this.sessionInfo.hasAvatar());
                    }
                    catch (Exception exception) {
                        ClientSingleton.getInstance().removeLoadingPane();
                        exception.printStackTrace();
                    }
                });
            }
            List partsIds = parties.stream().map(ContactInfo::getUserID).collect(Collectors.toList());
            List remove = this.sessionInfo.getParties().stream().filter(contactInfo -> !partsIds.contains(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "remove members=" + remove);
            if (!remove.isEmpty()) {
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    try {
                        clientConnector.updateSession(this.sessionInfo, 2, new HashSet(remove), this.sessionInfo.hasAvatar());
                    }
                    catch (Exception exception) {
                        ClientSingleton.getInstance().removeLoadingPane();
                        exception.printStackTrace();
                    }
                });
            }
            this.sessionInfo.setAdmins(admins);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "sessionInfo=" + this.sessionInfo);
        });
        this.isUpdated = true;
    }

    private void updateGroup() {
        String name = this.groupNameTextField.getText();
        if (name.length() == 0) {
            ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_warning"));
            return;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Updating session sessionInfo=" + this.sessionInfo + " getDialogType()=" + this.sessionInfo.getDialogType());
        MyThreadPoolManager.getInstance().execute(() -> {
            ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>();
            ArrayList<String> admins = new ArrayList<String>();
            for (Node node : this.participateBox.getChildren()) {
                ParticipateContact participateContact = (ParticipateContact)node;
                ContactInfo contactInfo = participateContact.getContactInfo();
                parties.add(contactInfo);
                if (!participateContact.isAdmin()) continue;
                admins.add(ClientSingleton.getInstance().getUserID(contactInfo));
            }
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "updateGroup hash:" + this.sessionInfo.hashCode() + " sessionInfo=" + this.sessionInfo + " sessionInfo.getName()=" + this.sessionInfo.getName() + " new name=" + name + " parties=" + parties + " admin=" + admins);
                    if (this.pictureImagePath != null && this.pictureImagePath.exists()) {
                        clientConnector.setAvatar(this.sessionInfo, this.pictureImagePath);
                    }
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "pictureImagePath=" + this.pictureImagePath);
                    if (!name.equals(this.sessionInfo.getName())) {
                        this.sessionInfo.setName(name);
                    }
                    this.sessionInfo.setDescription(this.fx_taComment.getText());
                    this.sessionInfo.setAdmins(admins);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "after hash:" + this.sessionInfo.hashCode() + " sessionInfo=" + this.sessionInfo + " sessionInfo.getName()=" + this.sessionInfo.getName());
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "done");
                    clientConnector.updateSession(this.sessionInfo, 0, new HashSet(parties), this.pictureImagePath != null);
                }
                catch (Exception e) {
                    ClientSingleton.getInstance().removeLoadingPane();
                    e.printStackTrace();
                }
            });
        });
        this.isUpdated = true;
        this.hide();
    }

    public VBox getLeftPane() {
        VBox vBox = new VBox();
        HBox.setMargin((Node)vBox, (Insets)new Insets(0.0, 20.0, 0.0, 20.0));
        this.myLabel = new Label();
        this.myLabel.prefWidthProperty().bind((ObservableValue)vBox.prefWidthProperty());
        this.myLabel.setAlignment(Pos.CENTER_LEFT);
        this.myLabel.setText(ClientSingleton.getInstance().getString("group_new_group"));
        VBox.setMargin((Node)this.myLabel, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        vBox.getChildren().add((Object)this.myLabel);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        hBox.prefWidthProperty().bind((ObservableValue)vBox.prefWidthProperty());
        VBox.setMargin((Node)hBox, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        vBox.getChildren().add((Object)hBox);
        this.myImageView = new ImageView();
        ClientSingleton.getInstance().setMouseCursor((Node)this.myImageView);
        ClientSingleton.getInstance().setImageToImageView(this.myImageView, "group/info_ava_default.png");
        this.myImageView.setFitHeight(111.0);
        this.myImageView.setFitWidth(111.0);
        hBox.getChildren().add((Object)this.myImageView);
        Label uploadLabel = new Label();
        uploadLabel.prefWidthProperty().bind((ObservableValue)vBox.prefWidthProperty());
        uploadLabel.setAlignment(Pos.CENTER);
        uploadLabel.setText(ClientSingleton.getInstance().getString("group_upload_image"));
        VBox.setMargin((Node)uploadLabel, (Insets)new Insets(6.0, 0.0, 20.0, 0.0));
        vBox.getChildren().add((Object)uploadLabel);
        ClientSingleton.getInstance().setMouseCursor((Node)uploadLabel);
        uploadLabel.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            Image writableImage = this.getFile();
            if (writableImage != null) {
                this.myImageView.setFitHeight(111.0);
                this.myImageView.setFitWidth(111.0);
                this.myImageView.setImage(writableImage);
            }
        });
        this.groupNameTextField = new TextFieldWithSearch();
        this.groupNameTextField.setTextWidth(240);
        this.groupNameTextField.setPromptText("group_group_name");
        this.groupNameTextField.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR));
        this.groupNameTextField.setTextFontColor(ClientSingleton.getInstance().getStyleValue(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL));
        this.groupNameTextField.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        VBox.setMargin((Node)this.groupNameTextField, (Insets)new Insets(0.0, 0.0, 15.0, 0.0));
        vBox.getChildren().add((Object)this.groupNameTextField);
        HBox taBox = new HBox();
        taBox.setMinHeight(200.0);
        taBox.setPrefWidth(240.0);
        taBox.setMinWidth(240.0);
        taBox.prefWidthProperty().bind((ObservableValue)vBox.prefWidthProperty());
        this.fx_taComment = new MyTextArea("", (Pane)taBox, false);
        HBox.setMargin((Node)this.fx_taComment, (Insets)new Insets(10.0, 10.0, 20.0, 10.0));
        taBox.getChildren().add((Object)this.fx_taComment);
        this.fx_taComment.prefWidthProperty().bind((ObservableValue)vBox.prefWidthProperty());
        this.fx_taComment.setPromptText(ClientSingleton.getInstance().getString("group_group_description"));
        this.fx_taComment.setMinHeight(180.0);
        this.fx_taComment.setWhiteBackground();
        this.fx_taComment.setEditable(true);
        String style = " -fx-background-color: %s;-fx-padding:  5;\n-fx-border-insets:  0;\n-fx-background-insets: 0;\n -fx-control-inner-background: #f1f2f5;    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
        String color = ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR);
        taBox.setStyle(Theme.getInstance().formatedString(style, color));
        vBox.getChildren().add((Object)taBox);
        vBox.setPrefWidth(240.0);
        vBox.setMinWidth(240.0);
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.myLabel);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)uploadLabel);
        return vBox;
    }

    private VBox getRightPane() {
        int width = 215;
        VBox vBox = new VBox();
        this.closeBox = new HBox();
        VBox.setVgrow((Node)this.closeBox, (Priority)Priority.ALWAYS);
        VBox.setMargin((Node)this.closeBox, (Insets)new Insets(0.0, 0.0, 15.0, 0.0));
        this.closeBox.setMinHeight(40.0);
        this.closeBox.setMaxHeight(40.0);
        vBox.getChildren().add((Object)this.closeBox);
        this.closeBox.setAlignment(Pos.CENTER_LEFT);
        HBox countBox = new HBox();
        HBox.setHgrow((Node)countBox, (Priority)Priority.ALWAYS);
        countBox.setAlignment(Pos.CENTER_LEFT);
        this.participantCount = new Label();
        HBox.setMargin((Node)this.participantCount, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        HBox.setHgrow((Node)countBox, (Priority)Priority.ALWAYS);
        countBox.getChildren().add((Object)this.participantCount);
        this.closeBox.getChildren().add((Object)countBox);
        CloseImageButton closeImageButton = new CloseImageButton();
        closeImageButton.setBackgroundColor("transparent");
        closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.hide()));
        this.closeBox.getChildren().add((Object)closeImageButton);
        closeImageButton.requestFocus();
        this.myListView = new MyListView();
        this.participateBox = new VBox();
        this.myListView.setContent(this.participateBox, null);
        VBox.setMargin((Node)this.myListView, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        vBox.getChildren().add((Object)this.myListView);
        vBox.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.myListView, (Priority)Priority.ALWAYS);
        this.myLabelButton = new MyLabelButton(ClientSingleton.getInstance().getString("group_create_group"), 32);
        this.myLabelButton.prefWidthProperty().bind((ObservableValue)vBox.prefWidthProperty());
        vBox.getChildren().add((Object)this.myLabelButton);
        this.myLabelButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "isAddParticipant=" + this.isAddParticipant + " sessionInfo=" + this.sessionInfo);
            if (this.sessionInfo != null) {
                if (this.isAddParticipant) {
                    this.updateMembers();
                    this.hide();
                } else {
                    this.updateGroup();
                }
            } else {
                this.createGroup();
            }
        }));
        VBox.setMargin((Node)this.myLabelButton, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        vBox.setPrefWidth((double)width);
        vBox.setMinWidth((double)width);
        this.closeBox.setPrefWidth((double)width);
        this.closeBox.setMinWidth((double)width);
        this.participateBox.setPrefWidth((double)width);
        this.participateBox.setMinWidth((double)width);
        this.myListView.setPrefWidth(width + 10);
        this.myListView.setMinWidth(width + 10);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.participantCount);
        return vBox;
    }

    public boolean show() {
        ClientSingleton.getInstance().runLater(this::onShow);
        return this.isUpdated;
    }

    private void onShow() {
        this.rootPane.setMaxWidth((double)(this.getMaxPaneWidth() + this.panelsWidth - (this.isAddParticipant ? 60 : 0)));
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.rootPane).initMotionListeners((Node)this.closeBox);
        if (this.myLabel != null) {
            this.myPopupWindow.initMotionListeners((Node)this.myLabel);
        }
        this.myPopupWindow.showAndWait();
    }

    public void hide() {
        ClientSingleton.getInstance().runLater(() -> {
            this.myPopupWindow.hide();
            long st = System.currentTimeMillis();
            super.onClose();
            ClientSingleton.getInstance().releaseViewResources((Pane)this.rootPane);
        });
    }

    private HBox getRootPane() {
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(20.0, 10.0, 20.0, 10.0));
        hBox.setStyle("-fx-background-color: white;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.23), 4, 0, 0, 0);");
        hBox.setSpacing(2.0);
        return hBox;
    }

    @Override
    public void contactSelected(ContactInfo contactInfo, boolean isSelected) {
        if (isSelected) {
            this.addContactToList(contactInfo);
        } else {
            this.myListView.removeItem(ClientSingleton.getInstance().getUserID(contactInfo));
        }
        this.participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_participants"));
    }

    @Override
    public void listUpdated() {
        if (this.sessionInfo != null) {
            List members = this.sessionInfo.getParties();
            for (ContactInfoPane contactInfoPane : super.getContactsList()) {
                String userId = contactInfoPane.getId();
                if (!members.stream().map(ContactInfo::getUserID).anyMatch(userId::equals)) continue;
                contactInfoPane.makeSelected();
            }
        }
    }

    @Override
    public void contactListChanged() {
        ObservableList<Node> list = this.myListView.getChildrenPanes();
        for (int i = 0; i < list.size(); ++i) {
            ParticipateContact participateContact = (ParticipateContact)((Object)list.get(i));
            ContactInfo contactInfo = participateContact.getContactInfo();
            this.getContactsList().stream().filter(contactInfoPane1 -> contactInfoPane1.getId().equals(ClientSingleton.getInstance().getUserID(contactInfo) == null ? String.valueOf(contactInfo.hashCode()) : ClientSingleton.getInstance().getUserID(contactInfo)) && !contactInfoPane1.isSelected()).findAny().ifPresent(ContactInfoPane::makeSelected);
        }
    }

    private Image getFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        Stage stage = (Stage)ClientSingleton.getInstance().getMainViewModel().getParentWindow().getScene().getWindow();
        File file = fileChooser.showOpenDialog((Window)stage);
        Optional<Image> writableImage = ClientSingleton.getInstance().getImageFromFile(file, 111, 111);
        if (writableImage.isPresent()) {
            this.pictureImagePath = file;
        }
        return writableImage.map(this::makeRoundedImage).orElse(null);
    }

    private Image makeRoundedImage(Image writableImage) {
        ImageView fx_ivImageViewer = new ImageView();
        fx_ivImageViewer.setFitWidth(111.0);
        fx_ivImageViewer.setFitHeight(111.0);
        fx_ivImageViewer.setImage(writableImage);
        Rectangle clip = new Rectangle(fx_ivImageViewer.getFitWidth(), fx_ivImageViewer.getFitHeight());
        int ARC_WIDTH = 111;
        clip.setArcWidth((double)ARC_WIDTH);
        int ARC_HEIGHT = 111;
        clip.setArcHeight((double)ARC_HEIGHT);
        fx_ivImageViewer.setClip((Node)clip);
        SnapshotParameters parameters = new SnapshotParameters();
        parameters.setFill((Paint)Color.TRANSPARENT);
        return fx_ivImageViewer.snapshot(parameters, null);
    }

    private class ParticipateContact
    extends HBox {
        private boolean isAdmin = false;
        private ContactInfo contactInfo;

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public void setAdmin(boolean admin) {
            this.isAdmin = admin;
        }

        private void setContactInfo(ContactInfo contactInfo) {
            this.contactInfo = contactInfo;
        }

        public ContactInfo getContactInfo() {
            return this.contactInfo;
        }

        private ParticipateContact(ContactInfo contactInfo) {
            this(contactInfo, false);
        }

        private ParticipateContact(ContactInfo contactInfo, boolean isAdmin) {
            this.setContactInfo(contactInfo);
            this.setAdmin(isAdmin);
            ContactInfoPane contactInfoPane = ContactInfoPane.getInstance().setDefaultTextFontColor("#646a7e").setDefaultSelectColor("#f1f2f5").setLabel(contactInfo).setWithAvatar(false).setSelected(true).setWithState(false).setPreventSelection(false).build();
            contactInfoPane.maxWidthProperty().bind((ObservableValue)GroupCreatorEditor.this.participateBox.widthProperty().subtract(10));
            contactInfoPane.minWidthProperty().bind((ObservableValue)GroupCreatorEditor.this.participateBox.widthProperty().subtract(10));
            this.setAlignment(Pos.CENTER);
            this.setStyle(" -fx-background-color:" + ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR) + ";-fx-border-radius: 15 15 15 15;-fx-background-radius: 15 15 15 15;");
            this.getChildren().add((Object)contactInfoPane);
            HBox hBox = new HBox();
            HBox.setMargin((Node)hBox, (Insets)new Insets(2.0, 2.0, 2.0, 2.0));
            hBox.setAlignment(Pos.CENTER);
            HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
            if (contactInfo.getName() != null && !contactInfo.getName().isEmpty() && contactInfo.getState() != -1) {
                Text text = new Text("admin");
                this.setAdminTextColor(text);
                hBox.getChildren().add((Object)text);
                hBox.setStyle(this.getSelectionStyle(this.isAdmin()));
                contactInfoPane.getChildren().add((Object)hBox);
                VBox.setMargin((Node)this, (Insets)new Insets(3.0, 0.0, 3.0, 0.0));
                hBox.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                this.setId(ClientSingleton.getInstance().getUserID(contactInfo));
                ClientSingleton.getInstance().setMouseCursor((Node)text);
                if (!ClientSingleton.getInstance().isGroupWithAllAdmins(GroupCreatorEditor.this.sessionInfo)) {
                    text.addEventFilter(MouseEvent.MOUSE_PRESSED, eventEventHandler -> {
                        this.setAdmin(!this.isAdmin());
                        this.setAdminTextColor(text);
                        hBox.setStyle(this.getSelectionStyle(this.isAdmin()));
                    });
                }
            }
            if (!(GroupCreatorEditor.this.isAddParticipant && this.getContactInfo() != null && ClientSingleton.getInstance().getUserID(this.getContactInfo()).equals(ClientSingleton.getInstance().getUserID(contactInfo)) || ClientSingleton.getInstance().isGroupWithAllAdmins(GroupCreatorEditor.this.sessionInfo) && ClientSingleton.getInstance().isExternalContact(contactInfo))) {
                ImageButton myImageView = new ImageButton();
                ClientSingleton.getInstance().setMouseCursor((Node)myImageView);
                myImageView.setSize(15, 15);
                myImageView.setImagePath("profiles/profile_minus.png");
                myImageView.setBackgroundColor("transparent");
                myImageView.setOnMouseClickedEvent((EventHandler<MouseEvent>)((EventHandler)event -> {
                    GroupCreatorEditor.this.unselectContactInfoPane(contactInfo);
                    GroupCreatorEditor.this.myListView.removeItemByHash(((Object)((Object)this)).hashCode());
                }));
                HBox.setMargin((Node)myImageView, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
                contactInfoPane.getChildren().add((Object)myImageView);
            }
        }

        private void setAdminTextColor(Text text) {
            try {
                ClientSingleton.getInstance().setStyledTextFont(text, false, this.isAdmin ? "#ffffff" : "#969aae", 8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private String getSelectionStyle(boolean isAdmin) {
            return " -fx-background-color:" + (String)(isAdmin ? WhiteLabels.getCustomBlueColor() + ";" : ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR)) + "    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
        }

        public boolean equals(ContactInfo contactInfo_) {
            return ClientSingleton.getInstance().getUserID(this.contactInfo).equals(ClientSingleton.getInstance().getUserID(contactInfo_));
        }
    }
}

