/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.group.createfromconference;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.buttoncombobox.MenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.mylistview.MyListView;
import net.sipsnet.client.utils.viewers.mylistview.internal.IOnScrollAction;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.profiles.contactpane.ContactInfoPane;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;

public class CreateGroupFromConferenceController
implements IOnScrollAction {
    private final double HEADER_HEIGHT = 40.0;
    private Image arrow_up;
    private Image arrow_down;
    private final IOnCloseViewer iOnCloseViewer;
    private final Map<String, List<Node>> mapDetails = new HashMap<String, List<Node>>();
    private MyListView myListView;
    private VBox participateBox;
    private final List<String> admins = new ArrayList<String>();
    private TextArea fx_taComment;
    @FXML
    private HBox fx_MainAvatarPane;
    @FXML
    private HBox fx_TopAvatarBox;
    @FXML
    private VBox fx_vbMainPane;
    @FXML
    private HBox fx_AvatarImage;
    @FXML
    private VBox fx_GroupInfo;
    @FXML
    private TextField fx_GroupName;
    @FXML
    private VBox fx_AvatarViewPane;
    @FXML
    private HBox fx_hbForCloseButton;
    @FXML
    private VBox fx_MembersViewPane;
    @FXML
    private HBox fx_ButtonBox;

    public CreateGroupFromConferenceController(ResourceBundle resourceBundle, IOnCloseViewer iOnCloseViewer) {
        this.iOnCloseViewer = iOnCloseViewer;
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/profiles/creategroupfromconference.fxml"));
        loader.setResources(resourceBundle);
        loader.setController((Object)this);
        try {
            this.fx_vbMainPane = (VBox)loader.load();
            loader.setController((Object)this);
            this.myListView = new MyListView();
            this.myListView.setId(this.getClass().getSimpleName());
            this.myListView.setContent(this.fx_vbMainPane, this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MyLabelButton myLabelButton = new MyLabelButton(ClientSingleton.getInstance().getString("group_create_group"), 30);
        HBox.setMargin((Node)myLabelButton, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        myLabelButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {}));
        this.fx_ButtonBox.getChildren().add((Object)myLabelButton);
        HBox closeBox = new HBox();
        closeBox.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)closeBox, (Priority)Priority.ALWAYS);
        this.fx_hbForCloseButton.getChildren().add((Object)closeBox);
        closeBox.setMinWidth(20.0);
        closeBox.setAlignment(Pos.CENTER_RIGHT);
        CloseImageButton closeImageButton = new CloseImageButton();
        closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> iOnCloseViewer.onCloseViewer()));
        closeBox.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        closeBox.getChildren().add((Object)closeImageButton);
        String style = "-fx-text-fill:#969aae;\n-fx-font-size: 14 px;\n    -fx-font-weight: bold;\n-fx-font-family: \"Roboto\";\n    -fx-line-height: 1.19;\n    -fx-border-color: #dce0ec;\n    -fx-border-insets: 0 0 1 0; \n    -fx-border-width: 0 0 1 0; \n    -fx-padding: 0.333333em 0 0.333333em 0;-fx-background-color: transparent;\n";
        this.fx_GroupName.setStyle(style);
        this.fx_GroupName.prefWidthProperty().bind((ObservableValue)this.fx_hbForCloseButton.widthProperty().subtract(30));
    }

    private Label getAvatarLabel() {
        int size = 65;
        String chars = "C";
        Label labelAvatar = new Label();
        labelAvatar.setMinHeight((double)size);
        labelAvatar.setMinWidth((double)size);
        labelAvatar.setAlignment(Pos.CENTER);
        int radius = size / 2;
        String stRadius = " " + radius + " " + radius + " " + radius + " " + radius + ";";
        labelAvatar.setStyle("-fx-text-fill: #252b40;-fx-font-size: 36 ;-fx-border-radius:" + stRadius + "-fx-background-radius:" + stRadius + "-fx-background-color:#f3f4f7;");
        labelAvatar.setText(chars);
        return labelAvatar;
    }

    public Pane getNode() {
        return this.myListView;
    }

    private void createGroup() {
        String name = this.fx_GroupName.getText();
        if (name.length() == 0) {
            ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_warning"));
            return;
        }
        if (this.participateBox.getChildren().isEmpty()) {
            ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_warning1"));
            return;
        }
        if (this.participateBox.getChildren().size() < 2) {
            ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_warning2"));
            return;
        }
        MyThreadPoolManager.getInstance().execute(() -> {
            try {
                ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>();
                ArrayList<String> admins = new ArrayList<String>();
                for (Node node : this.participateBox.getChildren()) {
                    ParticipateContact participateContact = (ParticipateContact)node;
                    ContactInfo contactInfo = participateContact.getContactInfo();
                    parties.add(contactInfo);
                    if (!participateContact.isAdmin()) continue;
                    admins.add(ClientSingleton.getInstance().getUserID(contactInfo));
                }
                SessionInfo sessionInfo = ClientSingleton.getInstance().getClientConnector().get().createSession(parties, name);
                sessionInfo.setAdmins(admins);
                sessionInfo.setName(name);
                sessionInfo.setProperty("isFavorite", (Object)false);
                sessionInfo.setDescription(this.fx_taComment.getText());
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("sessionInfo", sessionInfo);
                ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.iOnCloseViewer != null) {
                this.iOnCloseViewer.onCloseViewer();
            }
        });
    }

    private void getParticipatePane(LineInfo lineInfo) {
        this.fx_MembersViewPane.getChildren().clear();
        HBox countBox = new HBox();
        VBox.setMargin((Node)countBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        countBox.setMinHeight(40.0);
        countBox.setMaxHeight(40.0);
        this.fx_MembersViewPane.getChildren().add((Object)countBox);
        countBox.setAlignment(Pos.CENTER_LEFT);
        Text participantCount = new Text();
        try {
            ClientSingleton.getInstance().setStyledTextFont(participantCount, false, "#969aae", 10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HBox.setHgrow((Node)countBox, (Priority)Priority.ALWAYS);
        countBox.getChildren().add((Object)participantCount);
        this.participateBox = new VBox();
        VBox.setVgrow((Node)this.participateBox, (Priority)Priority.ALWAYS);
        this.fx_MembersViewPane.setAlignment(Pos.CENTER);
        this.participateBox.prefWidthProperty().bind((ObservableValue)this.fx_MembersViewPane.prefWidthProperty());
        VBox.setMargin((Node)this.participateBox, (Insets)new Insets(0.0, 10.0, 10.0, 10.0));
        TextFieldWithSearch textFieldWithSearch = new TextFieldWithSearch();
        VBox.setMargin((Node)textFieldWithSearch, (Insets)new Insets(0.0, 10.0, 10.0, 10.0));
        textFieldWithSearch.setPromptText("group_search_participants");
        textFieldWithSearch.setTextWidth(230);
        textFieldWithSearch.setWithSearch(true);
        textFieldWithSearch.addListener((ChangeListener<? super String>)((ChangeListener)(observable, oldValue, newValue) -> {
            if (oldValue.isEmpty() && newValue.isEmpty()) {
                return;
            }
            this.makeParticipateList(lineInfo, this.participateBox, (String)newValue);
        }));
        this.makeParticipateList(lineInfo, this.participateBox, "");
        participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_members"));
        this.fx_MembersViewPane.getChildren().addAll((Object[])new Node[]{textFieldWithSearch, this.participateBox});
    }

    private void makeParticipateList(LineInfo lineInfo, VBox participateBox, String prefix) {
        participateBox.getChildren().clear();
        ParticipateContact participateContact = new ParticipateContact("Me", true);
        participateBox.getChildren().add((Object)participateContact);
        participateContact.minWidthProperty().bind((ObservableValue)participateBox.widthProperty());
        for (ContactInfo contactInfo : lineInfo.getContacts()) {
            if (!prefix.isEmpty() && !contactInfo.toString().toLowerCase().contains(prefix.toLowerCase())) continue;
            participateContact = new ParticipateContact(contactInfo, false);
            participateBox.getChildren().add((Object)participateContact);
            participateContact.minWidthProperty().bind((ObservableValue)participateBox.widthProperty());
        }
    }

    public void removeParticipantPane(ParticipateContact participateContact) {
        this.participateBox.getChildren().remove((Object)participateContact);
    }

    private void onCloseViewer() {
        this.iOnCloseViewer.onCloseViewer();
    }

    @Override
    public void scrolling() {
    }

    public void setMaxWidth(int defaultPanelWidth) {
        this.fx_vbMainPane.setMaxWidth((double)(defaultPanelWidth + 5));
        this.fx_vbMainPane.setMinWidth((double)(defaultPanelWidth + 5));
        this.myListView.setMaxWidth(defaultPanelWidth);
        this.myListView.setMinWidth(defaultPanelWidth);
    }

    private class ParticipateContact
    extends HBox
    implements ICallPanesVisibility {
        private final ContactInfoPane contactInfoPane;
        private ContactInfo contactInfo = null;
        HBox hbAdmin = null;
        private boolean isAdmin = false;
        private MenuImageButton menuImageButton;
        private final EventHandler<MouseEvent> enteredEvent = event -> {
            this.setCursor(Cursor.HAND);
            if (this.menuImageButton != null) {
                this.menuImageButton.setVisible(true);
            }
            this.setStyle(this.getSelectionStyle());
        };
        private final EventHandler<MouseEvent> exitedEvent = event -> {
            if (this.menuImageButton.isShowing()) {
                return;
            }
            this.unChecked();
        };

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public void setAdmin(boolean admin) {
            this.isAdmin = admin;
        }

        private ParticipateContact(Object ci, boolean isAdmin) {
            VBox.setMargin((Node)this, (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.isAdmin = isAdmin;
            if (ci instanceof ContactInfo) {
                this.contactInfo = (ContactInfo)ci;
            }
            this.addEventFilter(MouseEvent.MOUSE_ENTERED, this.enteredEvent);
            this.addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedEvent);
            this.setAdmin(isAdmin);
            this.menuImageButton = new MenuImageButton();
            this.menuImageButton.setSize(20, 32);
            this.menuImageButton.setImagePath("buttons/dot_menu.png");
            this.menuImageButton.setBackgroundColor("#d9e0ef");
            this.menuImageButton.setVisible(false);
            this.menuImageButton.setICallPanesVisibility(this);
            HBox.setMargin((Node)this.menuImageButton, (Insets)new Insets(0.0, 10.0, 0.0, 5.0));
            this.menuImageButton.addMenuItem((Object)ClientSingleton.getInstance().getString("group_menu1_"), (EventHandler<MouseEvent>)((EventHandler)action -> {
                if (this.isAdmin()) {
                    this.removeParticipant(this.contactInfo, false);
                } else {
                    this.addAdmin(this.contactInfo);
                }
                this.menuImageButton.hideMenu();
            }));
            this.menuImageButton.addMenuItem((Object)ClientSingleton.getInstance().getString("group_menu2"), (EventHandler<MouseEvent>)((EventHandler)action -> {
                ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_menu4"), ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> this.removeParticipant(this.contactInfo, true))));
                this.menuImageButton.hideMenu();
            }));
            this.contactInfoPane = ContactInfoPane.getInstance().setLabel(ci).setWithAvatar(false).setSelected(false).setWithState(true).setItemPaneHeight(32).setPreventSelection(false);
            if (this.isAdmin()) {
                if (this.hbAdmin == null) {
                    this.hbAdmin = this.getAdminPane();
                }
                this.contactInfoPane.setAddAfterText((Pane)this.hbAdmin);
            }
            this.contactInfoPane.build();
            HBox.setHgrow((Node)this.contactInfoPane, (Priority)Priority.ALWAYS);
            this.getChildren().add((Object)this.contactInfoPane);
            if (this.contactInfo != null) {
                this.getChildren().add((Object)this.menuImageButton);
            }
        }

        private HBox getAdminPane() {
            HBox hbAdmin = new HBox();
            hbAdmin.setMaxHeight(15.0);
            hbAdmin.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
            hbAdmin.setAlignment(Pos.CENTER);
            Label text = new Label("admin");
            text.setTextAlignment(TextAlignment.CENTER);
            String style = "-fx-text-fill:#ffffff;-fx-font-family: \"Arial\";-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-background-color: transparent;";
            text.setStyle(style);
            hbAdmin.getChildren().add((Object)text);
            HBox.setMargin((Node)text, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
            hbAdmin.setStyle(" -fx-background-color:" + WhiteLabels.getCustomBlueColor() + ";    -fx-border-radius: 8;    -fx-background-radius: 8;");
            return hbAdmin;
        }

        private void addAdmin(ContactInfo contactInfo) {
            if (!CreateGroupFromConferenceController.this.admins.contains(ClientSingleton.getInstance().getUserID(contactInfo))) {
                if (this.hbAdmin == null) {
                    this.hbAdmin = this.getAdminPane();
                }
                this.contactInfoPane.addAfterText((Pane)this.hbAdmin);
                this.isAdmin = true;
                CreateGroupFromConferenceController.this.admins.add(ClientSingleton.getInstance().getUserID(contactInfo));
            }
        }

        private void removeParticipant(ContactInfo contactInfo, boolean withRemove) {
            if (withRemove) {
                List<ContactInfo> remove = Collections.singletonList(contactInfo);
                CreateGroupFromConferenceController.this.removeParticipantPane(this);
            }
            if (CreateGroupFromConferenceController.this.admins.contains(ClientSingleton.getInstance().getUserID(contactInfo))) {
                this.contactInfoPane.removeAddAfterText();
                this.isAdmin = false;
                CreateGroupFromConferenceController.this.admins.remove(ClientSingleton.getInstance().getUserID(contactInfo));
            }
        }

        private String getEmptyStyle() {
            return "-fx-background-color: white;    -fx-border-radius: 0;    -fx-background-radius: 0;";
        }

        private String getSelectionStyle() {
            return " -fx-background-color: #d9e0ef;    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
        }

        @Override
        public void setCallPanesVisible() {
        }

        @Override
        public void setCallPanesUnVisible() {
            this.unChecked();
        }

        @Override
        public void switchToFilter() {
        }

        private void unChecked() {
            this.setCursor(Cursor.DEFAULT);
            if (this.menuImageButton != null) {
                this.menuImageButton.setVisible(false);
            }
            this.setStyle(this.getEmptyStyle());
        }

        public ContactInfo getContactInfo() {
            return this.contactInfo;
        }
    }
}

