/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.mainview.model;

import java.awt.Desktop;
import java.awt.desktop.SystemSleepEvent;
import java.awt.desktop.SystemSleepListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import net.sipsnet.client.UserClient;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.ClientSingletonUtil;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.image.ImageUtil;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.taskbar.TaskBarList3;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.views.calls.audiocontrolls.ILineListener;
import net.sipsnet.client.views.calls.audiocontrolls.LineInfoPane;
import net.sipsnet.client.views.calls.videocall.VideoProcessor;
import net.sipsnet.client.views.group.createeditgroup.GroupCreatorEditor;
import net.sipsnet.client.views.login.LoginSceneControllerNew;
import net.sipsnet.client.views.mainview.MainViewSceneController;
import net.sipsnet.client.views.profiles.createcontact.CreateContactProfileController;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;
import smile.cti.phone.PhoneDevice;

public class MainViewModel
implements IGUIObservable,
ILineListener {
    public static final int TAB_MENU = 0;
    public static final int TAB_CONTACT = 1;
    public static final int TAB_CONTACT_NA = 2;
    public static final int TAB_SESSION = 3;
    public static final int TAB_CALLS = 4;
    public static final int TAB_SPEED_CALL = 5;
    public static final int TAB_NUMPAD = 6;
    public static final int TAB_SEARCH = 7;
    private final Stage parentWindow;
    private MainViewSceneController mainViewSceneController;
    private boolean isLastSplashPaneVisible = false;
    private final Duration opacityDuration = Duration.millis((double)300.0);
    private MyPopupWindow myPopupWindow;
    private MyPopupWindow loginPopupWindow;
    private LoginSceneControllerNew loginSceneControllerNew;
    private boolean isFocused;
    private boolean isSystemSleep;
    private final NotificationState currentNotificationState = NotificationState.OFF;

    public boolean isFocused() {
        return this.isFocused;
    }

    public boolean isSystemSleep() {
        return this.isSystemSleep;
    }

    public void removeLoadingPane() {
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.removeLoadingPane();
        }
    }

    public void addLoadingPane(String text, boolean isWithDelay) {
        if (this.mainViewSceneController != null) {
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "addLoadingPane=" + text);
            this.mainViewSceneController.addLoadingPane(text);
            if (isWithDelay) {
                TimerExecutor.getInstance().setMyAction(this::removeLoadingPane).startWithDelay(2000L);
            }
        }
    }

    public void onRegistrationApp() {
        ClientSingleton.getInstance().runLater(() -> {
            try {
                this.loadMainScene();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void onNotRegistrationApp(Map<String, Object> data) throws IOException {
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "onNotRegistrationApp: " + data);
        ClientSingleton.getInstance().runLater(() -> this.onNRAAction(data));
    }

    private void onNRAAction(Map<String, Object> data) {
        try {
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "onNRAAction: loginSceneControllerNew=" + this.loginSceneControllerNew);
            if (this.loginSceneControllerNew != null) {
                this.loginSceneControllerNew.hideSplashPane();
                this.loginSceneControllerNew.showLoginPane();
            } else {
                this.loadRegistrationScene();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (data != null && data.containsKey(Constants.THROW_MESSAGE)) {
            String message = data.get(Constants.THROW_MESSAGE).toString();
            if (message.contains("Untrusted certificate")) {
                ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("untrusted_connection_title"), ClientSingleton.getInstance().getString("untrusted_connection_message"), ClientSingleton.getInstance().getString("continue"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                    System.setProperty("noverifycert", "true");
                    this.loginSceneControllerNew.login();
                }));
            } else {
                ClientSingleton.getInstance().showAlert(message);
            }
        }
    }

    public void switchTab(int tab) {
        if (this.mainViewSceneController.getCurrentTab() != tab) {
            this.mainViewSceneController.initImagesAndCreateMenu(tab);
        }
    }

    public void sessionUpdated(SessionInfo sessionInfo) {
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.sessionUpdated(sessionInfo);
        }
    }

    public VideoProcessor getVideoProcessor() {
        return this.mainViewSceneController.getVideoProcessor();
    }

    public void switchViewMode() {
        this.mainViewSceneController.switchViewMode();
    }

    public boolean isShareDesktopPaneShowing() {
        return this.mainViewSceneController.isShareDesktopPaneShowing();
    }

    public SessionInfo getCurrentSessionInfo() {
        if (this.mainViewSceneController == null) {
            return null;
        }
        return this.mainViewSceneController.getCurrentSessionInfo();
    }

    public void chatFireScrollEvent(ScrollEvent scrollEvent) {
        this.mainViewSceneController.chatFireScrollEvent(scrollEvent);
    }

    public void invalidateViews() {
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "invalidateTabView mainViewSceneController " + this.mainViewSceneController);
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.invalidateViews();
        }
    }

    public void clientStateChanged(int state) {
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.clientStateChanged(state);
        }
    }

    public void clearChatMessagePane() {
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.clearChatMessagePane();
        }
    }

    public void searchUpdated() {
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.searchUpdated();
        }
    }

    public void reloadMenuTab() {
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.reloadMenuTab();
        }
    }

    public void contactGroupsListChanged() {
        ClientSingleton.toLog("ClientListener", "contactGroupsListChanged mainViewSceneController");
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.contactGroupsListChanged();
        }
    }

    public void setServiceContacts(String serviceId, List<ContactInfo> list) {
        if (this.mainViewSceneController != null) {
            this.mainViewSceneController.setServiceContacts(serviceId, list);
        }
    }

    public boolean isRegistrationPaneShow() {
        return this.loginPopupWindow != null;
    }

    public MainViewModel(Stage parentWindow) {
        this.parentWindow = parentWindow;
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "initObservable start");
        this.initObservable();
        ClientSingleton.getInstance().initResizeHelper(parentWindow);
        Optional<ClientConnector> clientConnector = ClientSingleton.getInstance().getClientConnector();
        if (clientConnector.isEmpty()) {
            ClientSingleton.getInstance().initClientConnector();
        } else {
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "clientConnector is not null");
        }
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "initObservable done");
    }

    public void setStatusBarIcon(int count) {
        Platform.runLater(() -> {
            try {
                ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "setStatusBarIcon currentNotificationState=" + this.currentNotificationState + " count=" + count);
                if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
                    UserClient.setTaskBarImage_Mac(count > 0);
                } else if (ClientUtil.getOS() == ClientUtil.OS.LINUX) {
                    UserClient.setTaskBarImage_Linux(count > 0);
                } else {
                    UserClient.setTrayIconImage(count > 0);
                    TaskBarList3.getInstance().SetOverlayIcon(this.parentWindow, count > 0 ? ImageUtil.getPngBufferedImage("other/notification_badge.png") : null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public Stage getParentWindow() {
        return this.parentWindow;
    }

    private void loadMainScene() {
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "SCREEN loadMainScene " + ClientSingleton.getInstance().isRegistered());
        if (this.mainViewSceneController == null) {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/mainview/mainview.fxml"));
            loader.setResources(ClientSingleton.getInstance().getResourceBundle());
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "SCREEN loadMainScene 1_0");
            try {
                Desktop desktop;
                Pane mainPane = (Pane)loader.load();
                ObservableMap fxmlNamespace = loader.getNamespace();
                mainPane.prefWidthProperty().bind((ObservableValue)this.parentWindow.widthProperty());
                mainPane.prefHeightProperty().bind((ObservableValue)this.parentWindow.heightProperty());
                this.mainViewSceneController = (MainViewSceneController)loader.getController();
                Scene newScene = new Scene((Parent)mainPane, 1200.0, 728.0);
                mainPane.setStyle("-fx-background-color: transparent;");
                newScene.setFill((Paint)Color.TRANSPARENT);
                HBox fx_IconsPane = (HBox)fxmlNamespace.get("fx_IconsPane");
                ClientSingleton.getInstance().initDragListener((Pane)fx_IconsPane);
                this.parentWindow.focusedProperty().addListener((observable, oldValue, newValue) -> {
                    this.isFocused = newValue;
                    ClientSingleton.memoryReport();
                    double newWidth = this.parentWindow.getWidth() + 1.0E-6;
                    double newHeight = this.parentWindow.getHeight() + 1.0E-6;
                    if (newValue.booleanValue()) {
                        if (this.loginPopupWindow == null) {
                            if (this.parentWindow.getWidth() < ClientSingleton.getInstance().getCurrentWidth()) {
                                newWidth = ClientSingleton.getInstance().getCurrentWidth();
                            }
                            if (this.parentWindow.getHeight() < 728.0) {
                                newHeight = 728.0;
                            }
                        }
                        this.parentWindow.setWidth(newWidth);
                        this.parentWindow.setHeight(newHeight);
                        this.parentWindow.setOpacity(1.0);
                        mainPane.setOpacity(1.0);
                        mainPane.resize(newWidth, newHeight);
                        mainPane.applyCss();
                        mainPane.requestLayout();
                        ClientSingleton.getInstance().getParentWindow().toFront();
                        this.mainViewSceneController.onFocusGained();
                    }
                    if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
                        this.mainViewSceneController.setTopButtonsImages((boolean)newValue);
                    }
                    this.mainViewSceneController.switchCallNotificationVisibility();
                });
                this.parentWindow.setScene(newScene);
                ClientSingleton.getInstance().setStagePosition(true);
                mainPane.requestFocus();
                this.isLastSplashPaneVisible = false;
                if (this.myPopupWindow != null) {
                    this.myPopupWindow.hide();
                }
                this.initHotKey();
                this.parentWindow.setOnShown(event -> TimerExecutor.getInstance().setMyAction(() -> {
                    this.parentWindow.requestFocus();
                    this.parentWindow.toFront();
                    this.mainViewSceneController.setFocus();
                }).startWithDelayInGUIThread(100L));
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.APP_EVENT_SYSTEM_SLEEP)) {
                    desktop.addAppEventListener(new SystemSleepListener(){

                        @Override
                        public void systemAboutToSleep(SystemSleepEvent event) {
                            MainViewModel.this.isSystemSleep = true;
                            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "System is going to sleep.isFocused " + MainViewModel.this.isFocused);
                        }

                        @Override
                        public void systemAwoke(SystemSleepEvent event) {
                            MainViewModel.this.isSystemSleep = false;
                            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "System is exiting sleep mode.isFocused " + MainViewModel.this.isFocused);
                            MainViewModel.this.invalidateViews();
                            ClientSingleton.getInstance().onWakeUp();
                        }
                    });
                }
                if (this.parentWindow.getWidth() < ClientSingleton.getInstance().getCurrentWidth() || this.parentWindow.getHeight() < 550.0) {
                    ClientSingleton.getInstance().restoreStageBounds();
                }
                if (!this.parentWindow.isShowing()) {
                    this.parentWindow.show();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(UserClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.mainViewSceneController.setCurrentTab();
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "SCREEN loadMainScene done  size =" + this.parentWindow.getWidth() + "x" + this.parentWindow.getHeight());
        } else if (!this.parentWindow.isShowing() || this.parentWindow.getWidth() < ClientSingleton.getInstance().getCurrentWidth() - 10.0 || this.parentWindow.getHeight() < 540.0) {
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "SCREEN loadMainScene reload getCurrentViewMode = " + this.mainViewSceneController.getCurrentViewMode());
            this.invalidateViews();
            this.reloadMenuTab();
            this.mainViewSceneController.initParkLines();
            this.mainViewSceneController.initImagesAndCreateMenu(this.mainViewSceneController.getCurrentTab());
            this.mainViewSceneController.reloadChatPane();
            this.mainViewSceneController.initFxBrowser();
            try {
                ClientSingleton.getInstance().restoreStageBounds();
            }
            catch (Throwable ex) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Error: restoreStageBounds ");
            }
            if (!this.parentWindow.isShowing()) {
                this.parentWindow.show();
            }
            MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    PhoneDevice device = clientConnector.getPhoneDevice();
                    Map localProperties = clientConnector.getProperties();
                    String oldSpeakerDevice = device.getAudioSourceLine();
                    String speakerDevice = (String)localProperties.get("Speaker device");
                    if (oldSpeakerDevice != null && speakerDevice == null) {
                        clientConnector.setProperty("Speaker device", (Object)oldSpeakerDevice);
                    }
                    String oldMicrophoneDevice = device.getAudioTargetLine();
                    String microphoneDevice = (String)localProperties.get("Microphone device");
                    if (oldMicrophoneDevice != null && microphoneDevice == null) {
                        clientConnector.setProperty("Microphone device", (Object)oldMicrophoneDevice);
                    }
                    String oldRingDevice = device.getAudioSourceLine();
                    String ringDevice = (String)localProperties.get("Ring device");
                    if (oldRingDevice != null && ringDevice == null) {
                        clientConnector.setProperty("Ring device", (Object)oldRingDevice);
                    }
                    clientConnector.setProperties(localProperties);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
        }
        if (this.loginPopupWindow != null) {
            this.parentWindow.setOnHiding(null);
            this.loginPopupWindow.hide();
            this.loginPopupWindow.release();
            this.loginPopupWindow = null;
            this.loginSceneControllerNew = null;
        }
    }

    private void initHotKey() {
        boolean isMac = ClientUtil.getOS() == ClientUtil.OS.MAC;
        KeyCombination.Modifier currentModifier = isMac ? KeyCombination.SHORTCUT_DOWN : KeyCombination.CONTROL_DOWN;
        KeyCodeCombination switchNumpad = new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)switchNumpad, () -> this.mainViewSceneController.switchNumpadTab());
        KeyCodeCombination switchSearch = new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)switchSearch, () -> this.mainViewSceneController.switchSearchTab());
        KeyCodeCombination searchInChat = new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)searchInChat, () -> this.mainViewSceneController.searchInChat());
        KeyCodeCombination kcAnswerCall = new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)kcAnswerCall, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                AudioCaller.answerCall(lineInfo, false);
            }
        });
        KeyCodeCombination kcDropCall = new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)kcDropCall, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                AudioCaller.dropCall(lineInfo);
            }
        });
        KeyCodeCombination switchMode = new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)switchMode, () -> this.mainViewSceneController.switchViewMode());
        KeyCodeCombination createNewChat = new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)createNewChat, () -> ClientSingleton.getInstance().createChat());
        KeyCodeCombination createNewGroup = new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)createNewGroup, () -> {
            GroupCreatorEditor groupCreatorEditor = new GroupCreatorEditor();
            groupCreatorEditor.show();
        });
        KeyCodeCombination createNewContact = new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)createNewContact, () -> {
            CreateContactProfileController createContactProfileController = new CreateContactProfileController();
            createContactProfileController.show();
        });
        KeyCodeCombination showProfile = new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{currentModifier});
        this.parentWindow.getScene().getAccelerators().put((Object)showProfile, () -> this.mainViewSceneController.openProfile());
        KeyCodeCombination transferHotKey = new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.parentWindow.getScene().getAccelerators().put((Object)transferHotKey, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                ClientSingleton.getInstance().transferCallTo(lineInfo, true, true);
            }
        });
        KeyCodeCombination muteHotKey = new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.parentWindow.getScene().getAccelerators().put((Object)muteHotKey, AudioCaller::setMute);
        KeyCodeCombination holdHotKey = new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.parentWindow.getScene().getAccelerators().put((Object)holdHotKey, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                TimerExecutor.getInstance().start(() -> {
                    if (lineInfo.getState() == 4) {
                        AudioCaller.setActiveLine(lineInfo);
                    } else {
                        AudioCaller.setHoldLine(lineInfo);
                    }
                });
            }
        });
        KeyCodeCombination addToCallHotKey = new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.parentWindow.getScene().getAccelerators().put((Object)addToCallHotKey, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                ClientSingleton.getInstance().addParticipantToCall(lineInfo, true, true);
            }
        });
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            List list = clientConnector.getCustomPages();
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    HashMap pair = (HashMap)list.get(i);
                    this.addHotKey(pair, i + 1);
                }
            }
        });
    }

    private void addHotKey(HashMap<String, String> pair, int index) {
        KeyCode digit;
        switch (index) {
            case 1: {
                digit = KeyCode.DIGIT1;
                break;
            }
            case 2: {
                digit = KeyCode.DIGIT2;
                break;
            }
            case 3: {
                digit = KeyCode.DIGIT3;
                break;
            }
            case 4: {
                digit = KeyCode.DIGIT4;
                break;
            }
            case 5: {
                digit = KeyCode.DIGIT5;
                break;
            }
            case 6: {
                digit = KeyCode.DIGIT6;
                break;
            }
            case 7: {
                digit = KeyCode.DIGIT7;
                break;
            }
            case 8: {
                digit = KeyCode.DIGIT8;
                break;
            }
            case 9: {
                digit = KeyCode.DIGIT9;
                break;
            }
            default: {
                digit = KeyCode.DIGIT0;
            }
        }
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "addHotKey digit=" + digit);
        boolean isMac = ClientUtil.getOS() == ClientUtil.OS.MAC;
        KeyCombination.Modifier currentModifier = KeyCombination.CONTROL_DOWN;
        KeyCodeCombination addToCallHotKey = new KeyCodeCombination(digit, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.parentWindow.getScene().getAccelerators().put((Object)addToCallHotKey, () -> {
            String url = (String)pair.get("url");
            String title = (String)pair.get("title");
            ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "addHotKey url=" + url);
            Map localProperties = ClientSingleton.getInstance().getClientConnector().get().getProperties();
            boolean isOpenUrlInExternalBrowser = false;
            if (localProperties.get(Constants.OPEN_URL_IN_EB) != null) {
                isOpenUrlInExternalBrowser = (Boolean)localProperties.get(Constants.OPEN_URL_IN_EB);
            }
            if (!isOpenUrlInExternalBrowser && this.mainViewSceneController != null) {
                this.mainViewSceneController.loadUrl(url, false);
            } else {
                ClientSingleton.getInstance().openWebBrowser(url);
            }
        });
    }

    public void loadRegistrationScene() throws IOException {
        ClientSingleton.getInstance().hideStageOnExit();
        if (ClientUtil.getOS() != ClientUtil.OS.LINUX) {
            this.parentWindow.show();
        } else {
            this.parentWindow.hide();
        }
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "loadSplashScene start");
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/login/login.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        try {
            Pane fx_MainPane = (Pane)loader.load();
            if (this.loginSceneControllerNew != null) {
                this.loginSceneControllerNew.hideSplashPane();
            } else {
                this.loginSceneControllerNew = (LoginSceneControllerNew)loader.getController();
            }
            fx_MainPane.setMaxWidth(330.0);
            fx_MainPane.setMaxHeight(625.0);
            Theme.getInstance().applyTo(Constants.BASE_COLOR, fx_MainPane);
            this.loginPopupWindow = MyPopupWindow.getNewInstance(fx_MainPane, (Window)this.parentWindow).setNoneModality().setAlwaysOnTop(false).initMotionListeners((Node)fx_MainPane);
            Theme.getInstance().applyTo(Constants.LOGIN_BACKGROUND_STYLE, fx_MainPane);
            this.loginPopupWindow.showInCenter();
            Stage.getWindows().stream().filter(Window::isShowing).forEach(window -> ClientSingleton.toLog(this.getClass().getSimpleName(), "Showing windows : " + window.getClass()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initObservable() {
        String[] actions = new String[]{IntentConstants.SHOW_SPLASH};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "showView action=" + action + " data=" + data);
        if (!IntentConstants.ON_FOCUSED.equals(action) && IntentConstants.SHOW_SPLASH.equals(action)) {
            if (this.isLastSplashPaneVisible && data != null) {
                ClientSingletonUtil.toLog(this.getClass().getSimpleName(), "loginData=" + data);
                MyThreadPoolManager.getInstance().execute(() -> {
                    String password = (String)data.get("password");
                    String login = (String)data.get("login");
                    Boolean isSave = (Boolean)data.get("isSave");
                    ClientSingleton.getInstance().signIn(login, password, isSave);
                });
            } else {
                ClientSingleton.getInstance().runLater(() -> {
                    try {
                        this.loadRegistrationScene();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    public String getString(String name) {
        return this.mainViewSceneController.getString(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToActiveLine(LineInfoPane lineInfoPane) {
        if (this.mainViewSceneController != null) {
            MainViewModel mainViewModel = this;
            synchronized (mainViewModel) {
                ClientSingleton.getInstance().runLater(() -> this.mainViewSceneController.addToActiveLines(lineInfoPane));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromActiveLine(LineInfoPane lineInfoPane) {
        if (this.mainViewSceneController != null) {
            MainViewModel mainViewModel = this;
            synchronized (mainViewModel) {
                ClientSingleton.getInstance().runLater(() -> {
                    this.mainViewSceneController.removeFromActiveLines(lineInfoPane);
                    if (AudioCaller.getWorkingLinesCount() == 1) {
                        ClientSingleton.getInstance().getLineInfoPanes().forEach(LineInfoPane::invalidateLinePane);
                    }
                });
            }
        }
    }

    @Override
    public void connectedLineState() {
        ClientSingleton.getInstance().runLater(() -> {
            if (AudioCaller.getWorkingLinesCount() > 1) {
                ClientSingleton.getInstance().getLineInfoPanes().forEach(lineInfoPane -> {
                    if (lineInfoPane.getLineInfo() != null && lineInfoPane.getLineInfo().getState() == 4) {
                        lineInfoPane.invalidateCallLineView();
                    }
                });
            }
        });
    }

    private void setInCenter() {
        ClientSingleton.getInstance().toCenterInScreen(this.parentWindow);
    }

    public void onMessageReceived(SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (this.mainViewSceneController != null && !this.isSystemSleep()) {
            this.mainViewSceneController.onMessageReceived(sessionInfo, messageInfo);
        }
    }

    public void onMessageUpdated(SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (this.mainViewSceneController != null && !this.isSystemSleep()) {
            this.mainViewSceneController.onMessageUpdated(sessionInfo, messageInfo);
        }
    }

    public void onMessageRemoved(SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (this.mainViewSceneController != null && !this.isSystemSleep()) {
            this.mainViewSceneController.onMessageRemoved(sessionInfo, messageInfo);
        }
    }

    public void onMessagesLoaded(List<MessageInfo> list, SessionInfo sessionInfo) {
        if (this.mainViewSceneController != null && !this.isSystemSleep()) {
            this.mainViewSceneController.onMessagesLoaded(list, sessionInfo);
        }
    }

    public void onMessagesLoaded(List<MessageInfo> list, SessionInfo sessionInfo, String lastAction) {
        if (this.mainViewSceneController != null && !this.isSystemSleep()) {
            this.mainViewSceneController.onMessagesLoaded(list, sessionInfo, lastAction);
        }
    }

    public void onContactInfoStateChanged(ContactInfo contactInfo) {
        if (this.mainViewSceneController != null && !this.isSystemSleep()) {
            this.mainViewSceneController.contactInfoStateChanged(contactInfo);
        }
    }

    public void onSessionInfoEventReceived(SessionInfo sessionInfo, int event) {
        if (this.mainViewSceneController != null && !this.isSystemSleep()) {
            this.mainViewSceneController.onSessionEventReceived(sessionInfo, event);
        }
    }

    public void onUsersAvatarUpdated() {
        if (this.mainViewSceneController != null && !this.isSystemSleep()) {
            this.mainViewSceneController.onUsersAvatarUpdated();
        }
    }

    static enum NotificationState {
        ON,
        OFF;

    }
}

