/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.notification;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sipsnet.client.UserClient;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.RichTextViwer.InnerTextArea;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttoncombobox.ContextMenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ArrowImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.callStateArrow.CallStateArrowPane;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.audiomessage.AudioMessagePane;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import net.sipsnet.client.views.notification.Notification;
import net.sipsnet.client.views.tabs.UpdateLists;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.EmailInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class NotificationPane
extends HBox
implements IInnerMessageTextArea {
    private AnchorPane textPane;
    private MessageInfo messageInfo;
    private ImageButton fx_ivStar;
    private MyImageView imageViewer;
    private MyLabel messageTypeLabel;
    private MyLabel fx_lbContactName;
    private MyLabel fx_lbMessageTime;
    private BorderPane rightBox;
    private HBox avatarBox;
    private final int lineHeight = 30;
    private final int EXPANDED_WIDTH = 400;
    private final int CONTENT_WIDTH = 320;
    private final int CONTENT_PADDING = 7;
    public static final int HARDWARE_INSERTED = 0;
    public static final int HARDWARE_REMOVED = 1;
    private boolean canHide = true;
    private ContextMenuImageButton fx_ivMenu;
    private final int GO_TO_CHAT = 0;
    private final int COPY = 1;
    private final int FORWARD = 2;
    private final int MARK_AS_READ = 3;
    private final int CALL_BACK = 4;
    private final MenuItem[] menuItems = new MenuItem[5];
    private MyStyledTextArea replySyledTextArea;
    private KeyCode lastPressedKey;
    private HBox replyPane;
    private HBox replyArrowBox;
    private Notification notification;
    private VBox menuBox;
    private HBox headerPane;
    private HBox fx_hbIvStarContainer;
    private CallStateArrowPane fx_hbIvCallArrowContainer;
    private final ChangeListener<Number> scrollChangeListener = (event, oldValue, newValue) -> {
        if (newValue != null && oldValue != null && (newValue.intValue() - oldValue.intValue() < -5 || newValue.intValue() - oldValue.intValue() > 5)) {
            this.canHide = false;
        }
    };
    private final EventHandler<? super MouseEvent> eventHandler = event -> {
        event.consume();
        if (ClientSingleton.getInstance().getCurrentViewMode() == 1) {
            if (event.getClickCount() == 2) {
                this.openSession();
            } else {
                ClientSingleton.getInstance().showWindow();
            }
        } else {
            this.openSession();
        }
    };
    private final ChangeListener<Number> changeListener = (event, oldValue, newValue) -> ClientSingleton.getInstance().runLater(() -> {
        this.replyPane.setMinHeight((double)newValue.intValue());
        int delta = newValue.intValue() - oldValue.intValue();
        double paneHeight = this.getMinHeight() + (double)delta + (double)(this.messageInfo.getType() == 23 ? 40 : 10);
        this.setMinHeight(paneHeight);
        this.notification.resizeNotificationsPane();
    });

    private void openSession() {
        if (this.messageInfo == null) {
            return;
        }
        Optional<SessionInfo> sessionInfo = ClientSingleton.getInstance().getSessionInfo(this.messageInfo.getSessionId());
        if (sessionInfo.isPresent()) {
            this.openSession(sessionInfo.get());
        } else {
            MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                SessionInfo sessionInfo1 = clientConnector.getSession(ClientSingleton.getInstance().getSessionInfoByMessageId(this.messageInfo.getId()).getSessionId());
                if (sessionInfo1 != null) {
                    ClientSingleton.getInstance().runLater(() -> this.openSession(sessionInfo1));
                }
            }));
        }
    }

    public NotificationPane(Notification notification) {
        this.notification = notification;
        this.initComponents();
    }

    public void buildAndShow(MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
        Optional<SessionInfo> oSessionInfo = ClientSingleton.getInstance().getSessionInfo(messageInfo.getSessionId());
        if (oSessionInfo.isPresent() && (oSessionInfo.get().isGroup() || oSessionInfo.get().isChannel() || oSessionInfo.get().getParties().size() > 1)) {
            this.messageTypeLabel.setText(oSessionInfo.get().toString());
            this.imageViewer.setImage("notification/group_emblem.png");
        } else {
            boolean isLost;
            boolean bl = isLost = messageInfo.getType() == 8 && MessageInfoCellLabels.isLostCall(messageInfo);
            if (isLost) {
                this.messageTypeLabel.setText(ClientSingleton.getInstance().getPackageName());
            } else {
                this.messageTypeLabel.setText("personal_message");
            }
            this.imageViewer.setImage("notify_emblem.png");
        }
        String name = MessageInfoCellLabels.getSender(messageInfo);
        this.fx_lbContactName.setText(name);
        String cur = ClientSingleton.getInstance().getDateTimeString(messageInfo.getTime());
        this.fx_lbMessageTime.setText(cur);
        this.fx_lbMessageTime.setMinWidth(this.fx_lbMessageTime.getContentWidth() + 10);
        this.avatarBox.getChildren().clear();
        oSessionInfo.ifPresent(sessionInfo -> this.avatarBox.getChildren().add((Object)this.getAvatar((SessionInfo)sessionInfo)));
        this.canHide = true;
        this.removeReplyPane();
        TimerExecutor.getInstance().setMyAction(() -> {
            if (this.canHide) {
                this.closeNotificationPane();
            }
        }).startWithDelayInGUIThread(8000L);
        this.playMessageNotification();
        this.layoutChildren();
        this.layout();
        if (this.headerPane != null) {
            if (this.fx_hbIvCallArrowContainer.setLostArrowImageView(messageInfo)) {
                if (!this.headerPane.getChildren().contains((Object)this.fx_hbIvCallArrowContainer)) {
                    this.headerPane.getChildren().add(0, (Object)this.fx_hbIvCallArrowContainer);
                }
            } else {
                this.headerPane.getChildren().remove((Object)this.fx_hbIvCallArrowContainer);
            }
        }
        String content = this.getTextContent();
        if (messageInfo.getType() == 23) {
            content = ClientSingleton.getInstance().getString("create_meeting_message");
        }
        double textHeight = Math.min(100.0, this.getTextHeight(content));
        double height = textHeight + (double)(30 * (this.rightBox.getBottom() != null ? 3 : 2)) + 15.0;
        this.addStyledTextArea(content);
        if (messageInfo.getType() == 23) {
            height = 30 + 30 * (this.rightBox.getBottom() != null ? 3 : 2) + 15;
            MyLabelButton myLabelButton = new MyLabelButton(ClientSingleton.getInstance().getString("join_meeting"), 30);
            ClientSingleton.getInstance().setMouseCursor((Node)myLabelButton);
            VBox.setMargin((Node)myLabelButton, (Insets)new Insets(10.0, 5.0, 10.0, 25.0));
            myLabelButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                ClientSingleton.getInstance().openWebBrowser(messageInfo.getContent());
                this.closeNotificationPane();
            }));
            height += myLabelButton.getHeight() + 30.0;
            if (((VBox)this.rightBox.getCenter()).getChildren().size() == 2) {
                ((VBox)this.rightBox.getCenter()).getChildren().remove(1);
            }
            ((VBox)this.rightBox.getCenter()).getChildren().add((Object)myLabelButton);
        }
        if (!this.textPane.getChildren().isEmpty()) {
            this.setMinHeight(height);
            this.notification.addNotificationPane(this);
        }
    }

    public void buildAndShow(String name, String content, boolean isWithTimer, String imageName) {
        this.buildAndShow(name, content, isWithTimer, imageName, -1);
    }

    public void buildAndShow(String name, String content, boolean isWithTimer, String imageName, int mode) {
        this.messageTypeLabel.setText(ClientSingleton.getInstance().getPackageName());
        this.imageViewer.setImage("notify_emblem.png");
        this.fx_lbContactName.setText(name);
        String cur = ClientSingleton.getInstance().getDateTimeString(System.currentTimeMillis());
        this.fx_lbMessageTime.setText(cur);
        this.fx_lbMessageTime.setMinWidth(this.fx_lbMessageTime.getContentWidth() + 10);
        this.avatarBox.setAlignment(Pos.CENTER);
        if (imageName != null) {
            ClientSingleton.getInstance().getImageFromResources(imageName).ifPresent(image -> {
                ImageView fx_ivImageViewer = new ImageView();
                fx_ivImageViewer.setFitWidth(image.getWidth());
                fx_ivImageViewer.setFitHeight(image.getHeight());
                fx_ivImageViewer.setImage(image);
                fx_ivImageViewer.setPreserveRatio(true);
                fx_ivImageViewer.setPickOnBounds(true);
                this.avatarBox.getChildren().add((Object)fx_ivImageViewer);
            });
        }
        if (this.replyArrowBox != null) {
            this.replyArrowBox.setVisible(false);
        }
        this.headerPane.getChildren().remove((Object)this.menuBox);
        this.fx_hbIvStarContainer.getChildren().remove((Object)this.fx_ivStar);
        if (isWithTimer) {
            TimerExecutor.getInstance().setMyAction(this::closeNotificationPane).startWithDelayInGUIThread(8000L);
        }
        if (mode < 0) {
            this.playMessageNotification();
        } else {
            this.playHardwareConnected(mode == 0);
        }
        this.layoutChildren();
        this.layout();
        double textHeight = Math.min(100.0, this.getTextHeight(content));
        double height = textHeight + (double)(30 * (this.rightBox.getBottom() != null ? 3 : 2)) + 15.0;
        this.addStyledTextArea(content);
        if (!this.textPane.getChildren().isEmpty()) {
            this.setMinHeight(height);
            this.notification.addNotificationPane(this);
        }
    }

    private void replyAction() {
        if (this.rightBox.getBottom() == null) {
            ClientSingleton.getInstance().runLater(() -> {
                this.replyPane = this.getReplyPane();
                this.replyPane.prefHeightProperty().addListener(this.changeListener);
                this.replyPane.prefHeightProperty().set(35.0);
                this.replyPane.prefWidthProperty().bind((ObservableValue)this.rightBox.widthProperty());
                this.rightBox.setBottom((Node)this.replyPane);
                this.fx_ivMenu.hideMenu();
                if (this.replyArrowBox != null) {
                    this.replyArrowBox.setVisible(false);
                }
                this.canHide = false;
                this.rightBox.requestFocus();
            });
        }
    }

    private void removeReplyPane() {
        if (this.rightBox.getBottom() != null && this.replyPane != null) {
            this.replyPane.prefWidthProperty().unbind();
            this.replyPane.prefHeightProperty().removeListener(this.changeListener);
            this.rightBox.setBottom(null);
            this.replyPane = null;
            if (this.replyArrowBox != null) {
                this.replyArrowBox.setVisible(true);
            }
        }
    }

    private void initComponents() {
        VBox.setMargin((Node)this, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
        this.getStylesheets().clear();
        this.getStylesheets().add((Object)MyUtils.getResourceUrl(NotificationPane.class, "/extracss/mynotifycontextmenu.css"));
        this.applyCss();
        this.setMaxWidth(400.0);
        this.setMinWidth(400.0);
        this.setPrefHeight(105.0);
        this.setMaxHeight(105.0);
        HBox leftBox = new HBox();
        leftBox.setPrefWidth(20.0);
        leftBox.setAlignment(Pos.TOP_CENTER);
        leftBox.setPadding(new Insets(5.0, 10.0, 0.0, 0.0));
        VBox.setVgrow((Node)leftBox, (Priority)Priority.ALWAYS);
        leftBox.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        ImageButton closeImageButton = new ImageButton(false);
        leftBox.getChildren().add((Object)closeImageButton);
        closeImageButton.setImagePath("profiles/close.png");
        closeImageButton.setSize(24, 24);
        closeImageButton.setIsRounded(true);
        closeImageButton.setStyle(null);
        closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.closeNotificationPane()));
        VBox superMain = new VBox();
        superMain.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        superMain.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(30));
        HBox mainBox = new HBox();
        mainBox.prefWidthProperty().bind((ObservableValue)superMain.prefWidthProperty());
        mainBox.prefHeightProperty().bind((ObservableValue)superMain.heightProperty());
        this.getChildren().addAll((Object[])new Node[]{leftBox, superMain});
        this.avatarBox = new HBox();
        this.avatarBox.setMaxWidth(35.0);
        this.avatarBox.setMinWidth(35.0);
        this.avatarBox.setPrefWidth(35.0);
        this.avatarBox.prefHeightProperty().bind((ObservableValue)this.heightProperty().subtract(10));
        HBox.setMargin((Node)this.avatarBox, (Insets)new Insets(5.0, 5.0, 0.0, 10.0));
        this.avatarBox.setAlignment(Pos.TOP_CENTER);
        this.rightBox = new BorderPane();
        this.rightBox.prefWidthProperty().bind((ObservableValue)superMain.prefWidthProperty());
        mainBox.getChildren().addAll((Object[])new Node[]{this.avatarBox, this.rightBox});
        this.setContentWithHeader();
        HBox footer = this.getFooter();
        footer.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(30));
        superMain.getChildren().addAll((Object[])new Node[]{mainBox, footer});
        this.setMaxHeight(Double.MAX_VALUE);
        this.fx_hbIvCallArrowContainer = CallStateArrowPane.getInstance();
        HBox.setMargin((Node)this.fx_hbIvCallArrowContainer, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        Theme.getInstance().applyNotificationPaneTo((Pane)closeImageButton);
        Theme.getInstance().applyNotificationPaneTo((Pane)superMain);
    }

    private void setContentWithHeader() {
        this.headerPane = new HBox();
        this.headerPane.prefWidthProperty().bind((ObservableValue)this.rightBox.prefWidthProperty());
        this.headerPane.setMinHeight(30.0);
        this.headerPane.setMaxHeight(30.0);
        this.headerPane.setAlignment(Pos.CENTER_LEFT);
        this.fx_lbContactName = new MyLabel();
        HBox.setHgrow((Node)this.fx_lbContactName, (Priority)Priority.ALWAYS);
        this.fx_lbContactName.prefHeightProperty().bind((ObservableValue)this.headerPane.heightProperty());
        this.fx_lbContactName.setLabelFontFamily("Helvetica");
        this.fx_lbContactName.setLabelFontColor("#ffffff");
        this.fx_lbContactName.setLabelFontSize(12);
        VBox.setVgrow((Node)this.fx_lbContactName, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.fx_lbContactName, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.headerPane.getChildren().add((Object)this.fx_lbContactName);
        this.fx_lbMessageTime = new MyLabel();
        this.fx_lbMessageTime.setLabelFontFamily("Helvetica");
        this.fx_lbMessageTime.setLabelFontColor("#d0d2d7");
        this.fx_lbMessageTime.setLabelFontSize(12);
        this.fx_lbMessageTime.setTextAlignment(Pos.CENTER);
        this.fx_lbMessageTime.setAlignment(Pos.CENTER_LEFT);
        this.fx_lbMessageTime.prefHeightProperty().bind((ObservableValue)this.headerPane.heightProperty());
        HBox.setMargin((Node)this.fx_lbMessageTime, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        this.headerPane.getChildren().add((Object)this.fx_lbMessageTime);
        this.fx_hbIvStarContainer = new HBox();
        this.fx_hbIvStarContainer.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.fx_hbIvStarContainer, (Priority)Priority.ALWAYS);
        this.fx_ivStar = new ImageButton();
        this.fx_ivStar.setSize(14, 14);
        this.fx_ivStar.setIsRounded(true);
        this.fx_ivStar.setImagePath("chat/messagecell/star_grey.png");
        this.fx_ivStar.setBackgroundColor("transparent");
        this.fx_ivStar.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.makeStarMessage()));
        HBox.setMargin((Node)this.fx_ivStar, (Insets)new Insets(0.0, 17.0, 0.0, 0.0));
        this.fx_hbIvStarContainer.getChildren().add((Object)this.fx_ivStar);
        this.headerPane.getChildren().add((Object)this.fx_hbIvStarContainer);
        this.rightBox.setTop((Node)this.headerPane);
        VBox vBox = new VBox();
        this.textPane = new AnchorPane();
        vBox.getChildren().add((Object)this.textPane);
        this.textPane.setStyle("-fx-background-color: transparent;");
        this.textPane.setMinHeight(25.0);
        this.textPane.setMaxHeight(Double.MAX_VALUE);
        this.textPane.setPrefWidth(320.0);
        this.textPane.setMaxWidth(320.0);
        this.textPane.setMinWidth(320.0);
        this.textPane.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.rightBox.setCenter((Node)vBox);
        this.menuBox = new VBox();
        this.menuBox.setMinWidth(24.0);
        this.menuBox.setMaxWidth(24.0);
        this.menuBox.getChildren().add((Object)this.getMenu());
        Pane pane = new Pane();
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        this.menuBox.getChildren().add((Object)pane);
        this.headerPane.getChildren().add((Object)this.menuBox);
    }

    private String getTextContent() {
        Object text;
        if (this.messageInfo.getType() == 5) {
            EmailInfo emailInfo = (EmailInfo)this.messageInfo;
            text = emailInfo.getFrom();
            if (emailInfo.getSubject() != null && emailInfo.getSubject().length() > 0 && !"null".equals(emailInfo.getSubject())) {
                text = (String)text + emailInfo.getSubject();
            } else if (emailInfo.getText() != null) {
                text = (String)text + emailInfo.getText();
            }
        } else {
            FileInfo fileInfo;
            text = this.messageInfo.getContent().contains("https://www.google.com/maps/search/") ? ClientSingleton.getInstance().getString("notify_message4") : (this.messageInfo instanceof FileInfo ? ((fileInfo = (FileInfo)this.messageInfo).isImage() ? ClientSingleton.getInstance().getString("notify_message3") : (ClientSingleton.getInstance().isSound(fileInfo) ? ClientSingleton.getInstance().getString("notify_message1") : ClientSingleton.getInstance().getString("notify_message2"))) : MessageInfoCellLabels.setContentLabel(this.messageInfo, true));
        }
        return text;
    }

    private HBox getFooter() {
        HBox hBox = new HBox();
        hBox.setMinHeight(30.0);
        hBox.setMaxHeight(30.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        this.imageViewer = new MyImageView(12, 12);
        this.imageViewer.setImage("notify_emblem.png");
        HBox.setMargin((Node)this.imageViewer, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        this.messageTypeLabel = new MyLabel();
        this.messageTypeLabel.setText("personal_message");
        this.messageTypeLabel.setPrefHeight(30.0);
        this.messageTypeLabel.setLabelFontColor("white");
        this.messageTypeLabel.setLabelFontSize(11);
        this.messageTypeLabel.setLabelFontFamily("HelveticaNeue");
        HBox.setHgrow((Node)this.messageTypeLabel, (Priority)Priority.ALWAYS);
        MyLabel replyLabel = new MyLabel();
        replyLabel.setText("reply");
        replyLabel.setPrefHeight(30.0);
        replyLabel.setLabelFontColor("white");
        replyLabel.setLabelFontSize(11);
        replyLabel.setLabelFontFamily("HelveticaNeue");
        HBox.setMargin((Node)replyLabel, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        ArrowImageButton arrowImageButton = new ArrowImageButton();
        arrowImageButton.setBackgroundColor("transparent");
        arrowImageButton.setSize(15, 15);
        arrowImageButton.setIsRounded(true);
        arrowImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.replyAction()));
        ClientSingleton.getInstance().setMouseCursor((Node)replyLabel);
        replyLabel.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.replyAction());
        hBox.getChildren().addAll((Object[])new Node[]{this.imageViewer, this.messageTypeLabel});
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (clientConnector.canChat()) {
                this.replyArrowBox = new HBox();
                this.replyArrowBox.setAlignment(Pos.CENTER_RIGHT);
                this.replyArrowBox.setMinWidth(150.0);
                this.replyArrowBox.getChildren().addAll((Object[])new Node[]{replyLabel, arrowImageButton});
                ClientSingleton.getInstance().setMouseCursor((Node)this.replyArrowBox);
                this.replyArrowBox.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.replyAction());
                hBox.getChildren().addAll((Object[])new Node[]{this.replyArrowBox});
            }
        });
        VBox.setMargin((Node)hBox, (Insets)new Insets(0.0, 10.0, 0.0, 15.0));
        return hBox;
    }

    private HBox getReplyPane() {
        HBox mainReply = new HBox();
        mainReply.setMinHeight(30.0);
        mainReply.setAlignment(Pos.CENTER_LEFT);
        HBox withButtons = new HBox();
        withButtons.setAlignment(Pos.CENTER);
        withButtons.prefWidthProperty().bind((ObservableValue)mainReply.widthProperty());
        AnchorPane replyTextPane = new AnchorPane();
        HBox.setHgrow((Node)replyTextPane, (Priority)Priority.ALWAYS);
        replyTextPane.setMinWidth(200.0);
        replyTextPane.prefHeightProperty().bind((ObservableValue)mainReply.heightProperty());
        String style = " -fx-control-inner-background:%s;    -fx-border-radius: 8 8 8 8;    -fx-background-radius: 8 8 8 8;-fx-background-color: -fx-control-inner-background;";
        String color = ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR);
        withButtons.setStyle(Theme.getInstance().formatedString(style, color));
        ImageButton audioMessage = new ImageButton();
        audioMessage.setImagePath("chat/bottompane/audio_message.png");
        audioMessage.setSize(16, 16);
        audioMessage.setBackgroundColor("transparent");
        audioMessage.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.action(this::callAudioMessagePane)));
        ImageButton sendFile = new ImageButton();
        sendFile.setImagePath("chat/bottompane/file.png");
        sendFile.setSize(20, 20);
        sendFile.setBackgroundColor("transparent");
        sendFile.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.action(this::sendChatFile)));
        HBox.setMargin((Node)sendFile, (Insets)new Insets(0.0, 8.0, 0.0, 10.0));
        ImageButton sendMessage = new ImageButton(false);
        sendMessage.setImagePath("notification/send_message.png");
        sendMessage.setSize(16, 16);
        sendMessage.setBackgroundColor("transparent");
        sendMessage.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.action(this::sendMessage)));
        HBox.setMargin((Node)sendMessage, (Insets)new Insets(5.0, 10.0, 0.0, 10.0));
        ClientSingleton.getInstance().runLater(() -> this.initStiledTextArea(withButtons, replyTextPane, audioMessage, sendFile));
        HBox sendMessageBox = new HBox();
        sendMessageBox.setAlignment(Pos.TOP_CENTER);
        sendMessageBox.getChildren().add((Object)sendMessage);
        sendMessageBox.prefHeightProperty().bind((ObservableValue)mainReply.heightProperty());
        withButtons.getChildren().addAll((Object[])new Node[]{replyTextPane, audioMessage, sendFile});
        mainReply.getChildren().addAll((Object[])new Node[]{withButtons, sendMessageBox});
        replyTextPane.prefHeightProperty().bind((ObservableValue)replyTextPane.heightProperty());
        return mainReply;
    }

    private void initStiledTextArea(HBox withButtons, AnchorPane replyTextPane, ImageButton audioMessage, ImageButton sendFile) {
        this.replySyledTextArea = new MyStyledTextArea((IInnerMessageTextArea)this, (ChangeListener<Boolean>)((ChangeListener)(observable, oldValue, newValue) -> {
            String text = this.replySyledTextArea.getText();
            Nodes.addInputMap((Node)this.replySyledTextArea, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY})), event -> this.sendMessage()));
            Nodes.addInputMap((Node)this.replySyledTextArea, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), event -> {
                this.lastPressedKey = event.getCode();
                this.replySyledTextArea.insertNewLineInText();
            }));
            if (newValue.booleanValue() || text != null && !text.isEmpty()) {
                withButtons.getChildren().remove((Object)audioMessage);
                withButtons.getChildren().remove((Object)sendFile);
            } else if (!withButtons.getChildren().contains((Object)audioMessage)) {
                withButtons.getChildren().addAll((Object[])new Node[]{audioMessage, sendFile});
            }
        }));
        this.replySyledTextArea.prefWidthProperty().bind((ObservableValue)replyTextPane.widthProperty());
        this.replySyledTextArea.setAutoHeight(true);
        this.replySyledTextArea.createPalaceHolder(1025);
        AnchorPane.setTopAnchor((Node)this.replySyledTextArea, (Double)4.0);
        AnchorPane.setBottomAnchor((Node)this.replySyledTextArea, (Double)4.0);
        AnchorPane.setRightAnchor((Node)this.replySyledTextArea, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.replySyledTextArea, (Double)0.0);
        this.resizeParent(0, 1);
        replyTextPane.getChildren().add((Object)this.replySyledTextArea);
    }

    private double getTextHeight(String content) {
        Text text = new Text(content);
        text.setWrappingWidth(250.0);
        double height = text.getBoundsInLocal().getHeight();
        return Math.max(30.0, height + (double)(7 * (height > 50.0 ? 4 : 2)));
    }

    private Pane getAvatar(SessionInfo sessionInfo) {
        int avatarWidth = 32;
        AvatarPane avatarPane = AvatarPane.getInstance().setSize(avatarWidth);
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        if (this.messageInfo.getSenderId().equals(clientConnector.getUserId())) {
            avatarPane.setObjectInfo(clientConnector.getUserInfo(false));
        } else {
            Optional<ContactInfo> optionalContactInfo = ClientSingleton.getInstance().getContactInfoByUserIdOrExt(this.messageInfo.getSenderId());
            if (optionalContactInfo.isEmpty()) {
                optionalContactInfo = ClientSingleton.getInstance().getContactInfoByNumber(this.messageInfo.getSenderId());
            }
            if (optionalContactInfo.isPresent()) {
                avatarPane.setObjectInfo(optionalContactInfo.get());
            } else {
                try {
                    avatarPane.setObjectInfo(sessionInfo);
                }
                catch (Exception var6) {
                    var6.printStackTrace();
                }
            }
        }
        AvatarPane pane = avatarPane.setDefaultBackgroundColor().build();
        pane.setMaxHeight(avatarWidth);
        return pane;
    }

    private ContextMenuImageButton getMenu() {
        this.fx_ivMenu = new ContextMenuImageButton(() -> {
            if (this.messageInfo != null) {
                this.fx_ivMenu.clear();
                if (this.messageInfo.getType() == 8) {
                    this.fx_ivMenu.addMenuItem(this.menuItems[0]);
                    this.fx_ivMenu.addMenuItem(this.menuItems[1]);
                    this.fx_ivMenu.addMenuItem(this.menuItems[4]);
                } else {
                    this.fx_ivMenu.addMenuItem(this.menuItems[0]);
                    this.fx_ivMenu.addMenuItem(this.menuItems[1]);
                    this.fx_ivMenu.addMenuItem(this.menuItems[2]);
                    this.fx_ivMenu.addMenuItem(this.menuItems[3]);
                }
            }
            return null;
        });
        this.fx_ivMenu.setBackgroundColor("transparent");
        this.fx_ivMenu.setSize(14, 14);
        this.fx_ivMenu.setOnMousePressed(event -> {
            this.canHide = false;
        });
        this.fx_ivMenu.setMenuWidth(100);
        MenuItem menuItem = new MenuItem(ClientSingleton.getInstance().getString("notification_menu1"));
        menuItem.setOnAction(event -> this.action(this::openSession));
        this.menuItems[0] = menuItem;
        menuItem = new MenuItem(ClientSingleton.getInstance().getString("notification_menu2"));
        menuItem.setOnAction(event -> {
            String text = this.messageInfo.getContent();
            ClientSingleton.getInstance().toClipBoard(this.messageInfo, text.contains("http:") || text.contains("https:") || text.contains("www."));
            this.fx_ivMenu.hideMenu();
            this.closeNotificationPane();
        });
        this.menuItems[1] = menuItem;
        menuItem = new MenuItem(ClientSingleton.getInstance().getString("notification_menu3"));
        menuItem.setOnAction(event -> {
            ClientSingleton.getInstance().shareMessage(this.messageInfo);
            this.fx_ivMenu.hideMenu();
            this.closeNotificationPane();
        });
        this.menuItems[2] = menuItem;
        menuItem = new MenuItem(ClientSingleton.getInstance().getString("notification_menu4"));
        menuItem.setOnAction(event -> this.action(this::sendRead));
        this.menuItems[3] = menuItem;
        menuItem = new MenuItem(ClientSingleton.getInstance().getString("notification_menu5"));
        menuItem.setOnAction(event -> this.action(this::callBack));
        this.menuItems[4] = menuItem;
        this.fx_ivMenu.setImagePath("buttons/notify_menu.png");
        HBox.setMargin((Node)this.fx_ivMenu, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        this.fx_ivMenu.setMinHeight(30.0);
        this.fx_ivMenu.setMaxHeight(30.0);
        return this.fx_ivMenu;
    }

    private void action(Consumer<SessionInfo> consumer) {
        Optional<SessionInfo> oSessionInfo = ClientSingleton.getInstance().getSessionInfo(this.messageInfo.getSessionId());
        if (oSessionInfo.isPresent()) {
            consumer.accept(oSessionInfo.get());
        } else {
            ClientSingleton.getInstance().runLater(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                SessionInfo sessionInfo1 = clientConnector.getSession(ClientSingleton.getInstance().getSessionInfoByMessageId(this.messageInfo.getId()).getSessionId());
                if (sessionInfo1 != null) {
                    consumer.accept(sessionInfo1);
                }
            }));
        }
        this.closeNotificationPane();
    }

    private void makeStarMessage() {
        Observable.just((Object)this.messageInfo).observeOn(UpdateLists.scheduler).doOnError(Throwable::printStackTrace).doOnNext(messageInfo1 -> {
            Optional<ClientConnector> optionalClientConnector;
            int code = (this.messageInfo.getCode() & 1) == 1 ? 0 : 1;
            Optional<SessionInfo> optionalSessionInfo = ClientSingleton.getInstance().getSessionInfo(this.messageInfo.getSessionId());
            if (optionalSessionInfo.isPresent() && (optionalClientConnector = ClientSingleton.getInstance().getClientConnector()).isPresent()) {
                optionalClientConnector.get().markMessages(optionalSessionInfo.get(), Collections.singletonList(this.messageInfo), code);
            }
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(messageInfo1 -> {
            this.fx_ivStar.setImagePath("chat/messagecell/star_yellow.png");
            if (this.canHide) {
                this.closeNotificationPane();
            }
        });
    }

    private void sendRead(SessionInfo sessionInfo) {
        Observable.just((Object)sessionInfo).observeOn(UpdateLists.scheduler).doOnError(Throwable::printStackTrace).doOnNext(sessionInfo1 -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.sendRead(sessionInfo))).subscribe(sessionInfo1 -> {
            this.fx_ivMenu.hideMenu();
            this.closeNotificationPane();
        });
    }

    private void openSession(SessionInfo sessionInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", sessionInfo);
        data.put("tab", 3);
        ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        if (this.fx_ivMenu.isShowing()) {
            this.fx_ivMenu.hideMenu();
        }
        this.closeNotificationPane();
        TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().showWindow()).startWithDelay(500L);
    }

    private void callBack(SessionInfo sessionInfo) {
        if (sessionInfo != null) {
            AudioCaller.makeCall(sessionInfo, false);
        }
        this.fx_ivMenu.hideMenu();
        this.closeNotificationPane();
    }

    private void callAudioMessagePane(SessionInfo sessionInfo) {
        new AudioMessagePane(sessionInfo, 0);
    }

    private void sendMessage(SessionInfo sessionInfo) {
        this.sendMessage();
    }

    private void sendMessage() {
        if (!this.replySyledTextArea.getText().isEmpty()) {
            this.sendMessage(this.replySyledTextArea.getTextString());
            this.replySyledTextArea.setTAText();
        }
    }

    public void closeNotificationPane() {
        if (this.notification != null) {
            ClientSingleton.getInstance().runLater(() -> {
                this.notification.removeNotification(this);
                this.removeReplyPane();
                ClientSingleton.getInstance().releaseViewResources((Pane)this);
                this.notification = null;
                if (((VBox)this.rightBox.getCenter()).getChildren().size() == 2) {
                    ((VBox)this.rightBox.getCenter()).getChildren().remove(1);
                }
            });
        }
    }

    private void sendChatFile(SessionInfo sessionInfo) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        Stage stage = (Stage)this.getScene().getWindow();
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            String filename = file.getName();
            byte[] data = new byte[(int)file.length()];
            try {
                FileInputStream fis = new FileInputStream(file);
                fis.read(data);
                fis.close();
                if (sessionInfo.canChat()) {
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.sendFile(file, sessionInfo, 0));
                } else if (ClientSingleton.getInstance().canMMS(sessionInfo)) {
                    AudioCaller.sendSmsMms(sessionInfo, file, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MyUtils.showAlert(e.getMessage());
            }
        }
    }

    private void playHardwareConnected(boolean isHardwareInserted) {
        TimerExecutor.getInstance().setMyAction(() -> {
            try {
                String path = "/sounds/" + (isHardwareInserted ? "hardware_insert.mp3" : "hardware_remove.mp3");
                Media media = new Media(UserClient.class.getResource(path).toURI().toString());
                MediaPlayer mediaPlayer = new MediaPlayer(media);
                Optional<ClientConnector> clientConnector = ClientSingleton.getInstance().getClientConnector();
                if (clientConnector.isPresent()) {
                    Number playbackLevel = (Number)clientConnector.get().getProperty("Playback level");
                    if (playbackLevel == null) {
                        playbackLevel = Float.valueOf(clientConnector.get().getPhoneDevice().getPlaybackLevel());
                    }
                    mediaPlayer.setVolume(playbackLevel.doubleValue());
                    mediaPlayer.setAutoPlay(true);
                    Thread.sleep(1500L);
                    mediaPlayer.dispose();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).startWithDelay(200L);
    }

    private void playMessageNotification() {
        if (AudioCaller.getWorkingLinesCount() > 0) {
            return;
        }
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (!clientConnector.hasActiveCalls()) {
                TimerExecutor.getInstance().setMyAction(() -> {
                    Object filename = (String)clientConnector.getProperty("Message notification prompt");
                    if (filename == null || !new File((String)filename).exists()) {
                        filename = System.getProperty("user.dir") + "/sounds/notify.wav";
                    }
                    try {
                        clientConnector.playFile(new File((String)filename), 0, -1, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).startWithDelay(1000L);
            }
        });
    }

    @Override
    public void resizeParent(int height, int linesCount) {
        if (this.rightBox.getBottom() == null) {
            return;
        }
        ClientSingleton.getInstance().runLater(() -> {
            int heightPane = height + 8;
            double delta = (double)(heightPane + 8) - this.replyPane.prefHeightProperty().get();
            if (delta == 0.0) {
                return;
            }
            if (this.lastPressedKey == null || this.lastPressedKey != KeyCode.DELETE && this.lastPressedKey != KeyCode.BACK_SPACE && (double)heightPane < this.replySyledTextArea.getLayoutBounds().getHeight()) {
                return;
            }
            this.replyPane.prefHeightProperty().set((double)heightPane);
            this.replyPane.layout();
        });
    }

    @Override
    public void sendMessage(String message) {
        ClientSingleton.getInstance().getSessionInfo(this.messageInfo.getSessionId()).ifPresent(sessionInfo -> {
            if (sessionInfo.isChannel() && (this.messageInfo.getCode() & 0x20) != 0 && (this.messageInfo.getCode() & 0x10) == 0) {
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    try {
                        SessionInfo sessionInfo1 = clientConnector.acceptChatRequest(this.messageInfo);
                        if (sessionInfo1 != null) {
                            clientConnector.sendMessage(message, sessionInfo1);
                            ClientSingleton.getInstance().doNotify(Constants.UPDATE_SESSIONS_LIST);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            } else {
                if (!sessionInfo.canChat() && (ClientSingleton.getInstance().canSMS((SessionInfo)sessionInfo) || ClientSingleton.getInstance().canMMS((SessionInfo)sessionInfo))) {
                    AudioCaller.sendSmsMms(sessionInfo, message, false);
                } else {
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.sendMessage(message, sessionInfo));
                }
                this.closeNotificationPane();
                this.sendRead((SessionInfo)sessionInfo);
            }
        });
    }

    @Override
    public void clearEditedMessage() {
    }

    @Override
    public void clearMessagePane(int height) {
    }

    private void addStyledTextArea(String text) {
        if (!this.textPane.getChildren().isEmpty()) {
            VirtualizedScrollPane virtualizedScrollPane = (VirtualizedScrollPane)this.textPane.getChildren().get(0);
            virtualizedScrollPane.getStylesheets().clear();
            virtualizedScrollPane.estimatedScrollYProperty().removeListener(this.scrollChangeListener);
            MyStyledTextArea myStyledTextArea = (MyStyledTextArea)virtualizedScrollPane.removeContent();
            myStyledTextArea.dispose();
        }
        this.textPane.getChildren().clear();
        MyStyledTextArea myStyledTextArea = this.getMyStyledTextArea(text);
        VirtualizedScrollPane virtualizedScrollPane = new VirtualizedScrollPane((Node)myStyledTextArea);
        virtualizedScrollPane.getStylesheets().clear();
        virtualizedScrollPane.getStylesheets().add((Object)MyUtils.getResourceUrl(InnerTextArea.class, "/extracss/myvnotifyscrollpane.css"));
        virtualizedScrollPane.applyCss();
        AnchorPane.setTopAnchor((Node)virtualizedScrollPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)virtualizedScrollPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)virtualizedScrollPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)virtualizedScrollPane, (Double)0.0);
        ClientSingleton.getInstance().setMouseCursor((Node)myStyledTextArea);
        myStyledTextArea.addEventHandler(MouseEvent.MOUSE_PRESSED, this.eventHandler);
        this.textPane.getChildren().add((Object)virtualizedScrollPane);
        virtualizedScrollPane.estimatedScrollYProperty().addListener(this.scrollChangeListener);
    }

    private MyStyledTextArea getMyStyledTextArea(String text) {
        MyStyledTextArea myStyledTextArea = new MyStyledTextArea(new IInnerMessageTextArea(){

            @Override
            public void resizeParent(int height, int linesCount) {
                NotificationPane.this.textPane.setPrefHeight((double)Math.min(100, 25 * linesCount));
                NotificationPane.this.textPane.setMinHeight((double)Math.min(100, 25 * linesCount));
                NotificationPane.this.textPane.setMaxHeight((double)Math.min(100, 25 * linesCount));
                NotificationPane.this.textPane.setVisible(false);
                int paneHeight = (int)NotificationPane.this.textPane.getMaxHeight() + 30 * (NotificationPane.this.rightBox.getBottom() != null ? 3 : 2) + 20;
                NotificationPane.this.setMinHeight(paneHeight);
                NotificationPane.this.layout();
                NotificationPane.this.notification.resizeNotificationsPane();
                if (!NotificationPane.this.textPane.isVisible()) {
                    NotificationPane.this.textPane.setVisible(true);
                }
            }

            @Override
            public void sendMessage(String message) {
            }

            @Override
            public void clearEditedMessage() {
            }

            @Override
            public void clearMessagePane(int height) {
            }
        }, "#dce0ec");
        myStyledTextArea.setContentToStyledTextArea(text);
        myStyledTextArea.setEditable(false);
        return myStyledTextArea;
    }

    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }
}

