/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.profiles.contactpane;

import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.statespane.StatesPane;
import net.sipsnet.client.views.profiles.contactpane.IContactSelected;
import smile.cti.client.ContactInfo;

public class ContactInfoPane
extends HBox {
    public int itemPaneHeight = 25;
    private Label fx_lbDndTitle;
    private String defaultSelectColor = "transparent";
    private boolean preventSelection = true;
    private boolean isWithMouseSelection = false;
    private boolean isSelectWithArrow = false;
    private boolean isWithMinusImage = false;
    private int paneWidth;
    private ImageButton myImageView;
    private Pane addAfterText;
    private Label textLabel;
    private final SimpleStringProperty defaultTextFontColor = new SimpleStringProperty("#646a7e");
    private final SimpleBooleanProperty textFontStyle = new SimpleBooleanProperty(false);
    private final EventHandler<MouseEvent> enteredEvent = event -> {
        this.setCursor(Cursor.HAND);
        if (this.isWithMouseSelection && this.myImageView != null) {
            this.myImageView.setVisible(true);
        }
        this.setPaneStyle(true);
    };
    private final EventHandler<MouseEvent> exitedEvent = event -> {
        this.setCursor(Cursor.DEFAULT);
        if (this.isWithMouseSelection && this.myImageView != null) {
            this.myImageView.setVisible(false);
        }
        this.setPaneStyle(false);
    };
    private HBox contactNamePane;
    private StatesPane statesPane;
    private IContactSelected iContactSelected;
    private ContactInfo contactInfo;
    private String label = "";
    private boolean withState = true;
    private boolean withAvatar = false;
    private boolean isSelected = false;

    public ContactInfoPane setIContactSelected(IContactSelected iContactSelected) {
        this.iContactSelected = iContactSelected;
        return this;
    }

    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public ContactInfoPane setLabel(Object label) {
        if (label instanceof ContactInfo) {
            this.contactInfo = (ContactInfo)label;
            this.setId(ClientSingleton.getInstance().getUserID(this.contactInfo) == null ? String.valueOf(this.contactInfo.hashCode()) : ClientSingleton.getInstance().getUserID(this.contactInfo));
        } else {
            this.label = (String)label;
            this.setId(label.toString());
        }
        return this;
    }

    public ContactInfoPane setWithState(boolean withState) {
        this.withState = withState;
        return this;
    }

    public ContactInfoPane setDefaultTextFontColor(String color) {
        this.defaultTextFontColor.set(color);
        return this;
    }

    public void setTextFontStyle(boolean textFontStyle) {
        this.textFontStyle.set(textFontStyle);
    }

    public ContactInfoPane setItemPaneHeight(int itemPaneHeight) {
        this.itemPaneHeight = itemPaneHeight;
        return this;
    }

    public void setAddAfterText(Pane addAfterText) {
        this.addAfterText = addAfterText;
    }

    public void removeAddAfterText() {
        if (this.addAfterText != null) {
            this.contactNamePane.getChildren().remove((Object)this.addAfterText);
            this.addAfterText = null;
        }
    }

    public void addAfterText(Pane addAfterText) {
        if (this.addAfterText == null) {
            this.addAfterText = addAfterText;
            this.contactNamePane.getChildren().add(1, (Object)this.addAfterText);
        }
    }

    private int getPaneWidth() {
        return this.paneWidth;
    }

    public void setPaneWidth(int paneWidth) {
        this.paneWidth = paneWidth;
    }

    public void makeSelected() {
        this.makeSelected(true);
    }

    public void makeSelected(boolean selected) {
        this.isSelected = selected;
        this.setPaneStyle(this.isSelected);
    }

    public ContactInfoPane setWithAvatar(boolean withAvatar) {
        this.withAvatar = withAvatar;
        return this;
    }

    public ContactInfoPane setPreventSelection(boolean preventSelection) {
        this.preventSelection = preventSelection;
        return this;
    }

    private ContactInfoPane() {
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            if (this.contactInfo != null && this.preventSelection) {
                this.isSelected = !this.isSelected;
                this.setSelectedPane(this.isSelected);
            }
        });
    }

    private void setLabelStyle() {
        if (this.textLabel != null) {
            if (this.contactInfo != null && this.label != null && this.label.contains("You")) {
                this.textLabel.setStyle("-fx-text-fill: " + this.defaultTextFontColor.get() + ";    -fx-font-family: \"HelveticaNeue\";    -fx-font-size: 12px;" + (!this.textFontStyle.get() ? "" : "    -fx-font-weight: bold;") + "    -fx-line-height: 1.19;");
            } else {
                this.textLabel.setStyle("-fx-text-fill: " + this.defaultTextFontColor.get() + ";    -fx-font-family: \"HelveticaNeue\";    -fx-font-size: 14px;" + (this.label != null && this.label.length() > 1 ? "" : "    -fx-font-weight: bold;") + "    -fx-line-height: 1.19;");
            }
        }
    }

    public void setSelectedPane(boolean isSelected) {
        this.setPaneStyle(isSelected);
        if (this.iContactSelected != null) {
            this.iContactSelected.contactSelected(this.contactInfo, isSelected);
        }
    }

    public ContactInfoPane addEventFilter(EventHandler<MouseEvent> event) {
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, event);
        return this;
    }

    public static ContactInfoPane getInstance() {
        return new ContactInfoPane();
    }

    public static ContactInfoPane getInstance(ContactInfo contactInfo, boolean withCheckBox) {
        return new ContactInfoPane();
    }

    public ContactInfoPane build() {
        this.setAlignment(Pos.CENTER_LEFT);
        this.setMinHeight(this.itemPaneHeight);
        StackPane contactAvatarPane = new StackPane();
        contactAvatarPane.setAlignment(Pos.CENTER);
        contactAvatarPane.setMaxWidth(40.0);
        contactAvatarPane.setMinHeight((double)this.itemPaneHeight);
        if (this.withAvatar) {
            AvatarPane avatarPane = AvatarPane.getInstance(this.contactInfo, 32, 16, false);
            HBox.setMargin((Node)contactAvatarPane, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
            contactAvatarPane.getChildren().add((Object)avatarPane);
        }
        if (this.contactInfo != null) {
            this.textLabel = new Label();
            if (this.withState) {
                HBox labelPane = new HBox();
                labelPane.setMaxWidth(40.0);
                labelPane.setMinHeight((double)this.itemPaneHeight);
                labelPane.setStyle("-fx_background-color:transparent;");
                this.statesPane = StatesPane.getInstance(StatesPane.VIEW_MODE.HANDLER_MODE);
                if (this.withAvatar) {
                    HBox.setMargin((Node)this.statesPane, (Insets)new Insets(0.0, 20.0, 20.0, 25.0));
                } else {
                    labelPane.setMinWidth(26.0);
                    labelPane.setAlignment(Pos.CENTER);
                }
                labelPane.getChildren().add((Object)this.statesPane);
                contactAvatarPane.getChildren().add((Object)labelPane);
                this.getChildren().add((Object)contactAvatarPane);
            } else {
                HBox.setMargin((Node)this.textLabel, (Insets)new Insets(0.0, 20.0, 0.0, 20.0));
            }
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.textLabel);
        } else {
            this.textLabel = new Label();
            HBox.setMargin((Node)this.textLabel, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.textLabel);
            this.textLabel.setStyle("-fx-font-weight: bold;");
        }
        AtomicReference strLabel = new AtomicReference();
        if (this.contactInfo != null) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (clientConnector.getUserId().equals(this.contactInfo.getUserID())) {
                    strLabel.set(ClientSingleton.getInstance().getString("you_message") + " (" + this.contactInfo + ")");
                } else {
                    strLabel.set(this.contactInfo.toString());
                }
            });
        }
        Object stringLabel = this.contactInfo != null ? (String)strLabel.get() : this.label + "  ";
        this.textLabel.setText((String)stringLabel);
        this.contactNamePane = new HBox();
        HBox.setHgrow((Node)this.contactNamePane, (Priority)Priority.ALWAYS);
        this.contactNamePane.setAlignment(Pos.CENTER_LEFT);
        this.contactNamePane.setMinHeight((double)this.itemPaneHeight);
        this.contactNamePane.getChildren().add((Object)this.textLabel);
        if (this.contactInfo != null) {
            this.fx_lbDndTitle = new Label();
            this.fx_lbDndTitle.setAlignment(Pos.CENTER);
            HBox.setMargin((Node)this.fx_lbDndTitle, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
            int radius = 7;
            this.fx_lbDndTitle.setStyle("-fx-font-size:9pt;-fx-text-fill: white;-fx-font-family: \"Arial\";-fx-background-color: #e65d5d;-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + "; -fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + "; ");
            this.contactNamePane.getChildren().add((Object)this.fx_lbDndTitle);
            this.setState();
        }
        if (this.addAfterText != null) {
            this.contactNamePane.getChildren().add((Object)this.addAfterText);
        }
        this.contactNamePane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.contactNamePane.maxWidthProperty().bind((ObservableValue)this.widthProperty());
        HBox.setHgrow((Node)this.textLabel, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.contactNamePane);
        if (this.contactInfo != null) {
            if (this.isSelectWithArrow) {
                this.myImageView = new ImageButton();
                this.myImageView.setSize(20, 20);
                this.myImageView.setImagePath("other/dark_chevron_right.png");
                this.myImageView.setBackgroundColor(this.defaultSelectColor);
                HBox.setMargin((Node)this.myImageView, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
                this.myImageView.setVisible(false);
                this.getChildren().add((Object)this.myImageView);
            } else if (this.isWithMinusImage) {
                this.myImageView = new ImageButton();
                this.myImageView.setSize(15, 15);
                this.myImageView.setImagePath("profiles/profile_minus.png");
                this.myImageView.setBackgroundColor(this.defaultSelectColor);
                HBox.setMargin((Node)this.myImageView, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
                this.myImageView.setVisible(false);
                this.getChildren().add((Object)this.myImageView);
            }
        }
        VBox.setMargin((Node)this, (Insets)new Insets(3.0, 0.0, 3.0, 0.0));
        this.setPaneStyle(this.isSelected);
        return this;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public ContactInfoPane setSelected(boolean selected) {
        this.isSelected = selected;
        return this;
    }

    public ContactInfoPane setSelectionListener(EventHandler<MouseEvent> eventEventHandler) {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, eventEventHandler);
        return this;
    }

    public ContactInfoPane setWithMouseSelection(boolean withMouseSelection) {
        this.isWithMouseSelection = withMouseSelection;
        if (this.isWithMouseSelection && this.contactInfo != null) {
            this.addEventFilter(MouseEvent.MOUSE_ENTERED, this.enteredEvent);
            this.addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedEvent);
        }
        return this;
    }

    public ContactInfoPane setSelectWithArrow(boolean selectWithArrow) {
        this.isSelectWithArrow = selectWithArrow;
        return this;
    }

    public ContactInfoPane setWithMinusImage(boolean withMinusImage) {
        this.isWithMinusImage = withMinusImage;
        return this;
    }

    public void setState() {
        if (!ClientSingleton.getInstance().isContactInfoApproved(this.contactInfo)) {
            if (this.statesPane != null) {
                this.statesPane.setPaneVisibility(false);
            }
            this.fx_lbDndTitle.setVisible(false);
        } else {
            this.setDnDState(this.contactInfo.getState() == 3);
            if (this.statesPane != null) {
                this.statesPane.setState(this.contactInfo.getState());
            }
        }
    }

    private void setDnDState(boolean visible) {
        if (this.fx_lbDndTitle == null) {
            return;
        }
        if (!visible) {
            this.fx_lbDndTitle.setText("");
            this.fx_lbDndTitle.setMaxWidth(0.0);
            this.fx_lbDndTitle.setPrefWidth(0.0);
        } else {
            double width = new Text("DnD").getLayoutBounds().getWidth() + 8.0;
            this.fx_lbDndTitle.setText("DnD");
            this.fx_lbDndTitle.setMaxWidth(width);
            this.fx_lbDndTitle.setPrefWidth(width);
        }
    }

    public ContactInfoPane setDefaultSelectColor(String defaultSelectColor) {
        this.defaultSelectColor = defaultSelectColor;
        return this;
    }

    public void setPaneStyle(boolean mode) {
        Theme.getInstance().applyTabCellTo((Pane)this, mode, false);
        if (this.isWithMinusImage && this.myImageView != null) {
            this.myImageView.setVisible(mode);
        }
    }
}

