/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.profiles.createcontact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.AddImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.views.profiles.ProfileUtils;
import net.sipsnet.client.views.profiles.profileedit.EditDataPaneV;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.util.RedirectionException;

public class CreateContactProfileController
extends ProfileUtils {
    private MyPopupWindow myPopupWindow;
    public HBox fx_AvatarImage;
    public HBox fx_MainPane;
    private File pictureImagePath;
    private ContactInfo contactInfo;
    private ImageView myImageView;
    private final String inputName;
    private boolean isCreating = false;
    private WebView browser;
    private ProgressIndicator fx_pbLoadIndicator;
    @FXML
    public EditDataPaneV fx_edpUserName;
    @FXML
    public EditDataPaneV fx_edTags;
    @FXML
    private AddImageButton fx_AddData;
    @FXML
    private CloseImageButton fx_CloseStage;
    @FXML
    private VBox fx_LeftPane;
    @FXML
    private MyLabelButton fx_SaveButton;
    @FXML
    public MyLabel fx_lbUploadImage;
    @FXML
    public MyLabel fx_lbTitle;
    @FXML
    public HBox fx_RightPaneTitle;
    @FXML
    public EditDataPaneV fx_edJobTitle;
    @FXML
    public EditDataPaneV fx_edCompanyTitle;
    @FXML
    public VBox fx_vbExtension;
    @FXML
    public StackPane fx_StackPane;
    @FXML
    public HBox fx_hbViewPane;
    @FXML
    public ScrollPane fx_DataScrollPane;
    @FXML
    public MyLabel fx_myAddDetails;

    public CreateContactProfileController() {
        this("");
    }

    public CreateContactProfileController(String name) {
        this.inputName = name;
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/profiles/clientprofileeditor.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        try {
            this.fx_MainPane = (HBox)loader.load();
            loader.setController((Object)this);
            String style = "-fx-background-color: #dae0ee;-fx-border-radius: 8 0 0 8;-fx-background-radius: 8 0 0 8;";
            this.fx_LeftPane.setStyle(style);
            this.fx_edpUserName.setTextToEditField(name);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)this.fx_DataScrollPane);
            this.fx_DataPane.minWidthProperty().bind((ObservableValue)this.fx_RightPane.widthProperty().subtract(10));
            ClientSingleton.getInstance().getStyle(Constants.BLUE_ALTERNATIVE_COLOR).ifPresent(color -> this.fx_myAddDetails.setLabelFontColor((String)color));
            this.initProfileViewer();
            this.addEmailDetailPane();
            this.addPhoneDetailPane();
            this.addAboutPane();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void show() {
        ClientSingleton.getInstance().runLater(() -> {
            this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.fx_MainPane).initMotionListeners((Node)this.fx_lbTitle).initMotionListeners((Node)this.fx_RightPaneTitle);
            this.myPopupWindow.showAndWait();
            this.fx_edpUserName.setFocusToEditField();
        });
    }

    private void initProfileViewer() {
        this.fx_StackPane.setAlignment(Pos.CENTER);
        this.fx_StackPane.prefWidthProperty().bind((ObservableValue)this.fx_MainPane.widthProperty());
        this.fx_StackPane.prefHeightProperty().bind((ObservableValue)this.fx_MainPane.heightProperty());
        this.fx_hbViewPane.prefWidthProperty().bind((ObservableValue)this.fx_StackPane.widthProperty());
        this.fx_hbViewPane.prefHeightProperty().bind((ObservableValue)this.fx_StackPane.heightProperty());
        this.fx_LeftPane.prefHeightProperty().bind((ObservableValue)this.fx_StackPane.heightProperty());
        this.fx_RightPane.prefHeightProperty().bind((ObservableValue)this.fx_StackPane.heightProperty());
        this.fx_lbTitle.setText(ClientSingleton.getInstance().getString("new_contact"));
        this.fx_SaveButton.setButtonLabelText(ClientSingleton.getInstance().getString(this.inputName.isEmpty() ? "create_contact" : "create_contact_and_chat"));
        this.fx_edpUserName.maxWidthProperty().bind((ObservableValue)this.fx_LeftPane.prefWidthProperty().subtract(10));
        this.fx_edpUserName.setFocusToEditField();
        this.fx_edpUserName.setPromptToEditField(ClientSingleton.getInstance().getString("contacts_name"));
        this.fx_edTags.maxWidthProperty().bind((ObservableValue)this.fx_LeftPane.prefWidthProperty().subtract(10));
        this.fx_edJobTitle.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_job_title"));
        this.fx_edCompanyTitle.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_company_name"));
        this.fx_edTags.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_tags"));
        this.fx_DataPane.prefWidthProperty().bind((ObservableValue)this.fx_RightPane.prefWidthProperty().subtract(10));
        this.myImageView = new ImageView();
        ClientSingleton.getInstance().setMouseCursor((Node)this.myImageView);
        ClientSingleton.getInstance().setImageToImageView(this.myImageView, "group/info_ava_default.png");
        this.myImageView.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            Image writableImage = this.getFile();
            if (writableImage != null) {
                this.showImage(writableImage);
            }
        });
        this.myImageView.setFitHeight(111.0);
        this.myImageView.setFitWidth(111.0);
        this.fx_AvatarImage.getChildren().add((Object)this.myImageView);
        this.fx_AddData.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.addDetailPane()));
        this.fx_CloseStage.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.close()));
        this.fx_CloseStage.setBackgroundColor("transparent");
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbUploadImage);
        this.fx_lbUploadImage.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            Image writableImage = this.getFile();
            if (writableImage != null) {
                this.showImage(writableImage);
            }
        });
        this.fx_SaveButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.update()));
    }

    private void close() {
        this.myPopupWindow.hide();
        this.fx_StackPane.prefWidthProperty().unbind();
        this.fx_StackPane.prefHeightProperty().unbind();
        this.fx_hbViewPane.prefWidthProperty().unbind();
        this.fx_hbViewPane.prefHeightProperty().unbind();
        this.fx_LeftPane.prefHeightProperty().unbind();
        this.fx_RightPane.prefHeightProperty().unbind();
        ClientSingleton.getInstance().releaseViewResources((Pane)this.fx_MainPane);
    }

    private void addDetailPane() {
        this.addDetailPaneParameters(true, 1);
    }

    private EditDataPaneV addDetailPane(int valueIndex) {
        return this.addDetailPaneParameters(false, valueIndex);
    }

    private void addPhoneDetailPane() {
        EditDataPaneV editDataPaneV = this.addDetailPane(4);
        editDataPaneV.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_enter_phone"));
    }

    private void addEmailDetailPane() {
        EditDataPaneV editDataPaneV = this.addDetailPane(10);
        editDataPaneV.setPromptToEditField(ClientSingleton.getInstance().getString("prompt_enter_email"));
    }

    private Image getFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        Stage stage = (Stage)ClientSingleton.getInstance().getMainViewModel().getParentWindow().getScene().getWindow();
        File file = fileChooser.showOpenDialog((Window)stage);
        Optional<Image> writableImage = ClientSingleton.getInstance().getImageFromFile(file, 135, 135);
        if (writableImage.isPresent()) {
            this.pictureImagePath = file;
        }
        return writableImage.orElse(null);
    }

    private void update() {
        if (this.fx_edpUserName.getText().isEmpty()) {
            ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("profile_warning"));
            return;
        }
        if (this.isCreating) {
            return;
        }
        this.isCreating = true;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "saveContactInfo = " + this.contactInfo);
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("creating") + " " + this.fx_edpUserName.getText());
        TimerExecutor.getInstance().start(() -> {
            String text;
            this.contactInfo = ContactInfo.createContact(null);
            this.addDetailToContact((Pane)this.fx_DataPane);
            ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
            if (!this.fx_edTags.getText().isEmpty()) {
                String[] str;
                ArrayList<String> tags = new ArrayList<String>();
                for (String s : str = this.fx_edTags.getText().split("#")) {
                    String tag = s.trim();
                    if (tag.length() <= 0) continue;
                    tags.add(tag);
                }
                this.contactInfo.setCustomTags(tags);
            }
            if (!(text = this.fx_edJobTitle.getText()).isEmpty()) {
                this.contactInfo.addCustomDetail("Position", (Object)text);
            }
            if (!(text = this.fx_edCompanyTitle.getText()).isEmpty()) {
                this.contactInfo.addCustomDetail("Company", (Object)text);
            }
            String about = this.aboutDataPane.getText();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "createContact about =" + about);
            if (!about.isEmpty()) {
                this.contactInfo.addCustomDetail("About", (Object)about);
            }
            String name = this.fx_edpUserName.getText();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "contactInfo name=" + name + " pictureImagePath=" + this.pictureImagePath);
            this.contactInfo.setName(name);
            try {
                if (this.pictureImagePath != null) {
                    clientConnector.setAvatar(this.contactInfo, this.pictureImagePath);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "contactInfo setAvatar=" + this.pictureImagePath);
                }
                ClientSingleton.getInstance().setLastAction(IntentConstants.CONTACT_ADDED);
                clientConnector.setContactInfo(this.contactInfo, this.pictureImagePath != null);
            }
            catch (RedirectionException redirectionException) {
                ClientSingleton.getInstance().removeLoadingPane();
                redirectionException.printStackTrace();
                ClientSingleton.getInstance().openWebBrowser(redirectionException.getLocation());
            }
            catch (Exception ex) {
                ClientSingleton.getInstance().removeLoadingPane();
                ex.printStackTrace();
                ClientSingleton.getInstance().showAlert(ex.getLocalizedMessage());
            }
            this.isCreating = false;
        });
        ClientSingleton.toLog(this.getClass().getSimpleName(), "saveContactInfo  close = " + this.contactInfo);
        this.close();
    }

    private void addDetailToContact(Pane pane) {
        for (int i = 0; i < pane.getChildren().size(); ++i) {
            EditDataPaneV editDataPaneV = (EditDataPaneV)pane.getChildren().get(i);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "saveContactInfo  (aboutDataPane.equals(editDataPaneV))" + this.aboutDataPane.equals(editDataPaneV));
            if (this.aboutDataPane.equals(editDataPaneV)) continue;
            this.contactInfo.addCustomDetail(editDataPaneV.getKey(), (Object)editDataPaneV.getText());
        }
    }

    public void showImage(Image writableImage) {
        ClientSingleton.getInstance().runLater(() -> this.onShowImage(writableImage));
    }

    private void onShowImage(Image writableImage) {
        this.myImageView.setImage(writableImage);
        Rectangle clip = new Rectangle(this.myImageView.getFitWidth(), this.myImageView.getFitHeight());
        int ARC_WIDTH = 111;
        clip.setArcWidth((double)ARC_WIDTH);
        int ARC_HEIGHT = 111;
        clip.setArcHeight((double)ARC_HEIGHT);
        this.myImageView.setClip((Node)clip);
    }
}

