/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.profiles.listener;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import net.sipsnet.client.views.profiles.listener.IArrowClickedAction;

public class ArrowClickedListener
implements EventHandler<MouseEvent> {
    private final IArrowClickedAction iArrowClickedAction;
    private final Pane parentPane;

    public ArrowClickedListener(IArrowClickedAction iArrowClickedAction, Pane parentPane) {
        this.iArrowClickedAction = iArrowClickedAction;
        this.parentPane = parentPane;
    }

    public void handle(MouseEvent mouseEvent) {
        try {
            if (this.parentPane.getChildren().isEmpty()) {
                List<Pane> details = this.iArrowClickedAction.getNodesListFromCache(this.parentPane.getId());
                if (details != null) {
                    for (Pane pane : details) {
                        pane.maxWidthProperty().bind((ObservableValue)this.parentPane.widthProperty().subtract(10));
                        this.parentPane.getChildren().add((Object)pane);
                    }
                }
                this.parentPane.applyCss();
                this.parentPane.layout();
            } else {
                ArrayList<Pane> details = new ArrayList<Pane>();
                for (int i = 0; i <= this.parentPane.getChildren().size() - 1; ++i) {
                    Pane pane = (Pane)this.parentPane.getChildren().get(i);
                    pane.maxWidthProperty().unbind();
                    details.add(pane);
                }
                this.iArrowClickedAction.addNodesListToCache(this.parentPane.getId(), new ArrayList<Pane>(details));
                this.parentPane.getChildren().clear();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

