/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.profiles.profileedit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.AddImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ArrowImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.SwitchImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import net.sipsnet.client.views.profiles.listener.AddDataListener;
import net.sipsnet.client.views.profiles.listener.ArrowClickedListener;
import net.sipsnet.client.views.profiles.listener.IArrowClickedAction;
import net.sipsnet.client.views.profiles.profileedit.EditDataPane;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.util.RedirectionException;

public class ProfileEditController
implements IArrowClickedAction {
    private final IOnCloseViewer iOnCloseViewer;
    private final Map<String, List<Pane>> mapDetails = new HashMap<String, List<Pane>>();
    private final ResourceBundle resourceBundle;
    @FXML
    private Pane fx_AvatarViewPane;
    @FXML
    private Pane fx_PhoneViewPane;
    @FXML
    private Pane fx_EmailViewPane;
    @FXML
    private Pane fx_TagViewPane;
    @FXML
    private Pane fx_OtherViewPane;
    @FXML
    private Pane fx_NoteViewPane;
    private ContactInfo contactInfo;
    private File pictureImagePath;
    private MyTextArea tagsTextArea;
    private MyTextArea descriptionTextArea;
    private boolean wasFavorite;
    @FXML
    private VBox fx_scrollMainPane;
    @FXML
    private HBox fx_AvatarImage;
    @FXML
    private SwitchImageButton fx_ivFavorite;
    @FXML
    private Label fx_ContactName;
    @FXML
    private TextField fx_tfContactName;
    @FXML
    private Label fx_GroupName;
    @FXML
    private Label fx_Company;
    @FXML
    private TextField fx_tfCompany;
    @FXML
    private TextField fx_tfGroupName;
    @FXML
    private ImageView fx_PhoneImage;
    @FXML
    private ArrowImageButton fx_PhoneArrowImage;
    @FXML
    private Label fx_PhoneTitle;
    @FXML
    private Label fx_AddPhone;
    @FXML
    private AddImageButton fx_AddPhoneImage;
    @FXML
    private VBox fx_PhoneData;
    @FXML
    private ImageView fx_EmailImage;
    @FXML
    private ArrowImageButton fx_EmailArrowImage;
    @FXML
    private Label fx_EmailTitle;
    @FXML
    private Label fx_AddEmail;
    @FXML
    private AddImageButton fx_AddEmailImage;
    @FXML
    private VBox fx_EmailData;
    @FXML
    private ImageView fx_OtherImage;
    @FXML
    private ArrowImageButton fx_OtherArrowImage;
    @FXML
    private Label fx_OtherTitle;
    @FXML
    private Label fx_AddOther;
    @FXML
    private AddImageButton fx_AddOtherImage;
    @FXML
    private VBox fx_OtherData;
    @FXML
    private ImageView fx_TagImage;
    @FXML
    private ArrowImageButton fx_TagArrowImage;
    @FXML
    private Label fx_TagTitle;
    @FXML
    private VBox fx_TagData;
    @FXML
    private ImageView fx_NoteImage;
    @FXML
    private ArrowImageButton fx_NoteArrowImage;
    @FXML
    private Label fx_NoteTitle;
    @FXML
    private VBox fx_NoteData;
    @FXML
    private VBox fx_vbProfilePane;
    @FXML
    private StackPane fx_StackPane;
    @FXML
    private ScrollPane fx_ScrollPane;

    public ProfileEditController(ResourceBundle resourceBundle, IOnCloseViewer iOnCloseViewer) {
        this.iOnCloseViewer = iOnCloseViewer;
        this.resourceBundle = resourceBundle;
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/profiles/profileeditor.fxml"));
        loader.setResources(resourceBundle);
        loader.setController((Object)this);
        try {
            this.fx_scrollMainPane = (VBox)loader.load();
            loader.setController((Object)this);
            this.initComponents();
            HBox hBox = new HBox();
            hBox.prefWidthProperty().bind((ObservableValue)this.fx_scrollMainPane.widthProperty());
            hBox.setAlignment(Pos.CENTER);
            String style = "-fx-background-color: %s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;";
            hBox.setStyle(Theme.getInstance().formatedString(style, ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR)));
            MyLabelButton myLabelButton = new MyLabelButton(ClientSingleton.getInstance().getString("save"), 30);
            myLabelButton.setButtonWidth(-1);
            myLabelButton.prefWidthProperty().bind((ObservableValue)this.fx_scrollMainPane.widthProperty());
            HBox.setMargin((Node)myLabelButton, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
            myLabelButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                if (this.fx_tfContactName.getText().isEmpty()) {
                    ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("enter_contact_name"));
                } else {
                    this.update();
                }
            }));
            hBox.getChildren().add((Object)myLabelButton);
            this.fx_scrollMainPane.getChildren().add((Object)hBox);
            this.fx_StackPane.setAlignment(Pos.CENTER);
            this.fx_StackPane.prefWidthProperty().bind((ObservableValue)this.fx_scrollMainPane.widthProperty());
            this.fx_StackPane.prefHeightProperty().bind((ObservableValue)this.fx_scrollMainPane.heightProperty());
            this.fx_ScrollPane.prefWidthProperty().bind((ObservableValue)this.fx_StackPane.widthProperty());
            this.fx_ScrollPane.prefHeightProperty().bind((ObservableValue)this.fx_StackPane.heightProperty());
            Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this.fx_scrollMainPane, true);
            Theme.getInstance().applyProfilesPaneTo(this.fx_AvatarViewPane);
            Theme.getInstance().applyProfilesPaneTo(this.fx_PhoneViewPane);
            Theme.getInstance().applyProfilesPaneTo(this.fx_EmailViewPane);
            Theme.getInstance().applyProfilesPaneTo(this.fx_TagViewPane);
            Theme.getInstance().applyProfilesPaneTo(this.fx_OtherViewPane);
            Theme.getInstance().applyProfilesPaneTo(this.fx_NoteViewPane);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_ContactName);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_GroupName);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_Company);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)this.fx_ScrollPane);
            this.setTextFiledStyle(this.fx_tfContactName);
            this.setTextFiledStyle(this.fx_tfGroupName);
            this.setTextFiledStyle(this.fx_tfCompany);
            this.fx_ScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setTextFieldFocus() {
        TimerExecutor.getInstance().setMyAction(() -> this.fx_tfContactName.requestFocus()).startWithDelayInGUIThread(500L);
    }

    public void initProfileViewer(ContactInfo contactInfo, boolean isNotShowContactName) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initProfileViewer contactInfo=" + contactInfo);
        this.contactInfo = contactInfo;
        this.fx_ContactName.setText(ClientSingleton.getInstance().getString("contacts_name"));
        if (!isNotShowContactName) {
            this.fx_tfContactName.setText(contactInfo.toString());
        }
        this.fx_AddPhone.setText(ClientSingleton.getInstance().getString("profile_add_phone"));
        this.fx_AddEmail.setText(ClientSingleton.getInstance().getString("profile_add_email"));
        this.fx_AddOther.setText(ClientSingleton.getInstance().getString("profile_add_other"));
        ClientSingleton.getInstance().getStyle(Constants.BLUE_ALTERNATIVE_COLOR).ifPresent(color -> {
            this.fx_AddPhone.setTextFill((Paint)Color.web((String)color));
            this.fx_AddEmail.setTextFill((Paint)Color.web((String)color));
            this.fx_AddOther.setTextFill((Paint)Color.web((String)color));
        });
        this.setContactInfoTitles(contactInfo);
        List detailLists = contactInfo.getUserDetails();
        List<DetailValue> detailValues = TypeConstantsRT.getDetails(detailLists, contactInfo);
        this.fx_PhoneData.getChildren().clear();
        this.fx_EmailData.getChildren().clear();
        this.fx_OtherData.getChildren().clear();
        this.fx_NoteData.getChildren().clear();
        this.fx_TagData.getChildren().clear();
        this.fx_AvatarImage.getChildren().clear();
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        boolean isUser = ClientSingleton.getInstance().getUserID(contactInfo).equals(clientConnector.getUserId());
        for (DetailValue detailValue : detailValues) {
            if (detailValue.getDetailViewType() == 0) {
                this.addDetailPane((Pane)this.fx_PhoneData, detailValue, 0, isUser);
                continue;
            }
            if (detailValue.getDetailViewType() == 1) {
                this.addDetailPane((Pane)this.fx_EmailData, detailValue, 1, isUser);
                continue;
            }
            if (!isUser && (detailValue.getLabel().equals("Company") || detailValue.getLabel().equals("Organization") || detailValue.getLabel().equals("JobTitle") || detailValue.getLabel().equals("Position"))) continue;
            this.addDetailPane((Pane)this.fx_OtherData, detailValue, 3, isUser);
        }
        detailLists = contactInfo.getCustomDetails();
        List<DetailValue> customDetailValues = TypeConstantsRT.getDetails(detailLists, contactInfo, true);
        for (DetailValue detailValue : customDetailValues) {
            if (detailValue.getDetailViewType() == 0) {
                this.addDetailPane((Pane)this.fx_PhoneData, detailValue, 0);
                continue;
            }
            if (detailValue.getDetailViewType() == 1) {
                this.addDetailPane((Pane)this.fx_EmailData, detailValue, 1);
                continue;
            }
            if (this.hasInEditorDetail(detailValue)) continue;
            this.addDetailPane((Pane)this.fx_OtherData, detailValue, 3);
        }
        List<String> list = this.getTags();
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (String tag : list) {
                stringBuilder.append("#");
                stringBuilder.append(tag);
                stringBuilder.append(" ");
            }
        }
        this.tagsTextArea = new MyTextArea(stringBuilder.toString(), (Pane)this.fx_NoteData);
        this.tagsTextArea.setWhiteBackground();
        this.tagsTextArea.setMinHeight(30.0);
        this.tagsTextArea.setEditable(true);
        this.fx_TagData.getChildren().add((Object)this.tagsTextArea);
        AvatarPane avatarPane = AvatarPane.getInstance(contactInfo, 65, 36, true);
        avatarPane.setMouseListeners((EventHandler<MouseEvent>)((EventHandler)event -> {
            Image writableImage = this.getFile();
            if (writableImage != null) {
                avatarPane.setImageView(writableImage);
            }
        }));
        this.fx_AvatarImage.getChildren().add((Object)avatarPane);
        this.wasFavorite = contactInfo.isFavorite();
        if (this.wasFavorite) {
            this.fx_ivFavorite.setImages("profiles/star_yellow.png", "profiles/star_grey.png", true);
        } else {
            this.fx_ivFavorite.setImages("profiles/star_grey.png", "profiles/star_yellow.png", true);
        }
        ContactInfo.Detail detail = contactInfo.getCustomDetail("About");
        String text = "";
        if (detail != null) {
            text = detail.getValue().toString();
        }
        this.descriptionTextArea = new MyTextArea(text, (Pane)this.fx_NoteData);
        this.descriptionTextArea.setWhiteBackground();
        this.descriptionTextArea.setEditable(true);
        this.fx_NoteData.getChildren().clear();
        this.descriptionTextArea.setMinHeight(30.0);
        this.fx_NoteData.getChildren().add((Object)this.descriptionTextArea);
        this.fx_tfContactName.requestFocus();
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_PhoneTitle);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_EmailTitle);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_TagTitle);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_NoteTitle);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_OtherTitle);
    }

    private void setContactInfoTitles(ContactInfo contactInfo) {
        ContactInfo.Detail detail = TypeConstantsRT.getUserContactDetail(contactInfo, "JobTitle");
        if (detail != null) {
            this.setPosition(false, detail);
        } else {
            detail = TypeConstantsRT.getUserContactDetail(contactInfo, "Position");
            if (detail != null) {
                this.setPosition(false, detail);
            } else {
                detail = TypeConstantsRT.getCustomContactDetail(contactInfo, "JobTitle");
                if (detail != null) {
                    this.setPosition(true, detail);
                } else {
                    detail = TypeConstantsRT.getCustomContactDetail(contactInfo, "Position");
                    if (detail != null) {
                        this.setPosition(true, detail);
                    } else {
                        this.fx_tfGroupName.setEditable(true);
                    }
                }
            }
        }
        detail = TypeConstantsRT.getUserContactDetail(contactInfo, "Company");
        if (detail != null) {
            this.setOrganization(false, detail);
        } else {
            detail = TypeConstantsRT.getUserContactDetail(contactInfo, "Organization");
            if (detail != null) {
                this.setOrganization(false, detail);
            } else {
                detail = TypeConstantsRT.getCustomContactDetail(contactInfo, "Company");
                if (detail != null) {
                    this.setOrganization(true, detail);
                } else {
                    detail = TypeConstantsRT.getCustomContactDetail(contactInfo, "Organization");
                    if (detail != null) {
                        this.setOrganization(true, detail);
                    } else {
                        this.fx_tfCompany.setEditable(true);
                    }
                }
            }
        }
    }

    private boolean hasInEditorDetail(DetailValue detailValue) {
        return (detailValue.getLabel().equals("Company") || detailValue.getLabel().equals("Organization")) && this.fx_tfCompany.isEditable() && this.fx_tfCompany.getText().contains(detailValue.getValue()) || (detailValue.getLabel().equals("JobTitle") || detailValue.getLabel().equals("Position")) && this.fx_tfGroupName.isEditable() && this.fx_tfGroupName.getText().contains(detailValue.getValue());
    }

    private void setOrganization(boolean value, ContactInfo.Detail detail) {
        this.fx_tfCompany.setEditable(value);
        this.fx_tfCompany.setText(detail.getValue().toString());
    }

    private void setPosition(boolean value, ContactInfo.Detail detail) {
        this.fx_tfGroupName.setEditable(value);
        this.fx_tfGroupName.setText(detail.getValue().toString());
    }

    public Pane getNode() {
        return this.fx_scrollMainPane;
    }

    @Override
    public void addNodesListToCache(String key, List<Pane> node) {
        this.mapDetails.put(key, node);
    }

    @Override
    public List<Pane> getNodesListFromCache(String key) {
        return this.mapDetails.get(key);
    }

    private void addDetailPane(Pane pane, DetailValue detailValue, int mode) {
        this.addDetailPane(pane, detailValue, mode, true);
    }

    private void addDetailPane(Pane pane, DetailValue detailValue, int mode, boolean editable) {
        EditDataPane editDataPane = new EditDataPane(true, pane, editable);
        List<DetailValue> items = TypeConstantsRT.getContactDetailList(mode);
        editDataPane.addItemsList(items);
        editDataPane.setSelectedValue(detailValue.getKey(), detailValue.getValue());
        editDataPane.setWithRemoveButton(true);
        editDataPane.setTextFieldEditable(detailValue.isEditable());
        pane.getChildren().add((Object)editDataPane);
    }

    private void initComponents() {
        this.fx_PhoneData.setId("fx_PhoneData");
        this.fx_EmailData.setId("fx_EmailData");
        this.fx_OtherData.setId("fx_OtherData");
        this.fx_NoteData.setId("fx_NoteData");
        this.fx_TagData.setId("fx_TagData");
        this.fx_vbProfilePane.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.fx_vbProfilePane.prefWidthProperty().bind((ObservableValue)this.fx_scrollMainPane.widthProperty().subtract(8));
        this.fx_PhoneData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_EmailData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_OtherData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_NoteData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        this.fx_TagData.prefWidthProperty().bind((ObservableValue)this.fx_vbProfilePane.widthProperty().subtract(8));
        ClientSingleton.getInstance().setImageToImageView(this.fx_PhoneImage, "profiles/phone.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_EmailImage, "profiles/email.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_TagImage, "profiles/tags.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_NoteImage, "profiles/notes.png");
        ClientSingleton.getInstance().setImageToImageView(this.fx_OtherImage, "profiles/notes.png");
        AddDataListener addDataListener = new AddDataListener((Pane)this.fx_PhoneData, 0);
        this.fx_AddPhoneImage.addMouseEventHandler(addDataListener);
        addDataListener = new AddDataListener((Pane)this.fx_EmailData, 1);
        this.fx_AddEmailImage.addMouseEventHandler(addDataListener);
        addDataListener = new AddDataListener((Pane)this.fx_OtherData, 3);
        this.fx_AddOtherImage.addMouseEventHandler(addDataListener);
        this.fx_PhoneArrowImage.setId(String.valueOf(0));
        ArrowClickedListener arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_PhoneData);
        this.fx_PhoneArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_TagArrowImage.setId(String.valueOf(2));
        arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_TagData);
        this.fx_TagArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_EmailArrowImage.setId(String.valueOf(1));
        arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_EmailData);
        this.fx_EmailArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_NoteArrowImage.setId("NOTE_TYPE");
        arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_NoteData);
        this.fx_EmailArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_OtherArrowImage.setId(String.valueOf(3));
        arrowClickedListener = new ArrowClickedListener(this, (Pane)this.fx_OtherData);
        this.fx_OtherArrowImage.addMouseEventHandler(arrowClickedListener);
        this.fx_PhoneTitle.setText(ClientSingleton.getInstance().getString("profile_phones"));
        this.fx_EmailTitle.setText(ClientSingleton.getInstance().getString("profile_emails"));
        this.fx_TagTitle.setText(ClientSingleton.getInstance().getString("profile_tags"));
        this.fx_NoteTitle.setText(ClientSingleton.getInstance().getString("profile_note"));
        this.fx_OtherTitle.setText(ClientSingleton.getInstance().getString("profile_other"));
    }

    private Image getFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        Stage stage = (Stage)ClientSingleton.getInstance().getMainViewModel().getParentWindow().getScene().getWindow();
        File file = fileChooser.showOpenDialog((Window)stage);
        Optional<Image> writableImage = ClientSingleton.getInstance().getImageFromFile(file, 65, 65);
        if (writableImage.isPresent()) {
            this.pictureImagePath = file;
        }
        return writableImage.orElse(null);
    }

    private void update() {
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("saving_contact_info"));
        MyThreadPoolManager.getInstance().execute(() -> {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (ClientSingleton.getInstance().getUserID(this.contactInfo).equals(clientConnector.getUserId())) {
                    ArrayList list = new ArrayList(this.contactInfo.getUserDetails());
                    for (ContactInfo.Detail detail : list) {
                        this.removeDetail(detail);
                    }
                } else {
                    ArrayList list = new ArrayList(this.contactInfo.getCustomDetails());
                    for (ContactInfo.Detail detail : list) {
                        this.removeDetail(detail);
                    }
                }
            });
            try {
                this.addDetail(this.descriptionTextArea.getText(), "About");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addDetailToPane((Pane)this.fx_PhoneData);
            this.addDetailToPane((Pane)this.fx_EmailData);
            this.addDetailToPane((Pane)this.fx_OtherData);
            ClientConnector clientConnector2 = ClientSingleton.getInstance().getClientConnector().get();
            if (this.pictureImagePath != null) {
                try {
                    clientConnector2.setAvatar(this.contactInfo, this.pictureImagePath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.tagsTextArea.getText().isEmpty()) {
                String[] str;
                ArrayList<String> tags = new ArrayList<String>();
                for (String s : str = this.tagsTextArea.getText().split("#")) {
                    String tag = s.trim();
                    if (tag.isEmpty()) continue;
                    tags.add(tag);
                }
                this.setTags(tags);
            }
            if (this.fx_tfGroupName.isEditable() && !this.fx_tfGroupName.getText().isEmpty()) {
                this.setDetail("Position", this.fx_tfGroupName.getText());
            }
            if (this.fx_tfCompany.isEditable() && !this.fx_tfCompany.getText().isEmpty()) {
                this.setDetail("Organization", this.fx_tfCompany.getText());
            }
            String name = this.fx_tfContactName.getText();
            this.contactInfo.setName(name);
            if (this.contactInfo.getStatus() != 4) {
                try {
                    this.contactInfo.setStatus(4);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (ClientSingleton.getInstance().getUserID(this.contactInfo).equals(clientConnector2.getUserId())) {
                try {
                    clientConnector2.setUserInfo(this.contactInfo, this.pictureImagePath != null);
                    this.setContactInfo();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    clientConnector2.setContactInfo(this.contactInfo, this.pictureImagePath != null);
                    this.setContactInfo();
                }
                catch (RedirectionException redirectionException) {
                    redirectionException.printStackTrace();
                    ClientSingleton.getInstance().openWebBrowser(redirectionException.getLocation());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ClientSingleton.getInstance().removeLoadingPane();
        });
    }

    private void setContactInfo() {
        ClientSingleton.getInstance().removeLoadingPane();
        this.iOnCloseViewer.reopenProfileEditor(this.contactInfo);
        int index = this.fx_ivFavorite.getSelectedImage();
        if (this.wasFavorite) {
            this.contactInfo.setFavorite(index == 0);
        } else {
            this.contactInfo.setFavorite(index == 1);
        }
        ClientSingleton.getInstance().releaseViewResources((Pane)this.fx_scrollMainPane);
    }

    private void addDetailToPane(Pane pane) {
        for (int i = 0; i < pane.getChildren().size(); ++i) {
            EditDataPane editDataPane = (EditDataPane)pane.getChildren().get(i);
            if (editDataPane.getText().isEmpty()) continue;
            try {
                this.addDetail(editDataPane);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<String> getTags() {
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        if (ClientSingleton.getInstance().getUserID(this.contactInfo).equals(clientConnector.getUserId())) {
            return this.contactInfo.getUserTags();
        }
        return this.contactInfo.getCustomTags();
    }

    private void setTags(List<String> tags) {
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        if (ClientSingleton.getInstance().getUserID(this.contactInfo).equals(clientConnector.getUserId())) {
            this.contactInfo.setUserTags(tags);
        } else {
            this.contactInfo.setCustomTags(tags);
        }
    }

    private void addDetail(EditDataPane editDataPane) throws Exception {
        if (!editDataPane.isIsEditable()) {
            return;
        }
        String key = editDataPane.getKey();
        String value = editDataPane.getText();
        this.addDetail(value, key);
    }

    private void addDetail(String value, String key) {
        if (value.equals(this.contactInfo.getNumber())) {
            return;
        }
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        if (ClientSingleton.getInstance().getUserID(this.contactInfo).equals(clientConnector.getUserId())) {
            this.contactInfo.addUserDetail(key, (Object)value);
        } else {
            this.contactInfo.addCustomDetail(key, (Object)value);
        }
    }

    private void setDetail(String key, String value) {
        if (value.equals(this.contactInfo.getNumber())) {
            return;
        }
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        if (ClientSingleton.getInstance().getUserID(this.contactInfo).equals(clientConnector.getUserId())) {
            this.contactInfo.setUserDetail(key, (Object)value);
        } else {
            this.contactInfo.setCustomDetail(key, (Object)value);
        }
    }

    private ContactInfo.Detail getDetail(String key) {
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        ContactInfo.Detail fn = ClientSingleton.getInstance().getUserID(this.contactInfo).equals(clientConnector.getUserId()) ? this.contactInfo.getUserDetail(key) : this.contactInfo.getCustomDetail(key);
        return fn;
    }

    private void removeDetail(ContactInfo.Detail fn) {
        ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        if (ClientSingleton.getInstance().getUserID(this.contactInfo).equals(clientConnector.getUserId())) {
            this.contactInfo.removeUserDetail(fn);
        } else {
            this.contactInfo.removeCustomDetail(fn);
        }
    }

    private void setTextFiledStyle(TextField textField) {
        String style = "-fx-text-fill:%s;\n-fx-font-size: 11pt;\n-fx-font-family: Arial;\n-fx-line-height: 1.19;\n-fx-border-color:#dce0ec;\n-fx-border-insets: 0 0 1 0; \n-fx-border-width: 0 0 1 0; \n-fx-padding: 0.333333em 0 0.333333em 0;-fx-background-color: transparent;\n";
        textField.setStyle(Theme.getInstance().formatedString(style, ClientSingleton.getInstance().getStyleValue(Constants.TAB_CELL_TEXT_FILL)));
    }
}

