/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.settings.exportcontacts;

import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import net.sipsnet.client.views.tabs.UpdateLists;
import smile.cti.client.ContactInfo;

public class ExportToCVS {
    public static void processExport(StackPane spSettingsPane, HBox fx_progressBarPane, MyAction onClose, File selectedFile) {
        Observable.just((Object)selectedFile).observeOn(Schedulers.from((Executor)MyThreadPoolManager.getInstance().getThreadPoolExecutor())).doOnError(ExportToCVS.onError()).flatMap(file -> {
            List<ContactInfo> contacts = ClientSingleton.getInstance().getContactInfoStream().filter(UpdateLists::isContactNotAutirized).collect(Collectors.toList());
            if (contacts.isEmpty()) {
                return Observable.empty();
            }
            String lineSeparator = System.getProperty("line.separator");
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(selectedFile.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                ArrayList userHeaderList = new ArrayList();
                ArrayList customHeaderList = new ArrayList();
                contacts.forEach(contactInfo -> ExportToCVS.addDetailHeaders(contactInfo, userHeaderList));
                List<String> headerList = Stream.concat(userHeaderList.stream(), customHeaderList.stream()).collect(Collectors.toList());
                headerList.add("link_title");
                headerList.add("link_url");
                StringBuilder headersLine = new StringBuilder("Name");
                headersLine.append(",");
                headerList.forEach(header -> headersLine.append((String)header).append(","));
                headersLine.append(lineSeparator);
                writer.write(headersLine.toString());
                contacts.forEach(contactInfo -> {
                    StringBuilder detailsLine = new StringBuilder(contactInfo.toString());
                    detailsLine.append(",");
                    ExportToCVS.getDetailsLine(headerList, contactInfo, detailsLine);
                    List links = ClientSingleton.getInstance().getClientConnector().get().getContactLinks(contactInfo);
                    if (!links.isEmpty()) {
                        StringBuilder titlesStringBuilder = new StringBuilder();
                        StringBuilder urlsStringBuilder = new StringBuilder();
                        for (int i = 0; i < links.size(); ++i) {
                            HashMap map = (HashMap)links.get(i);
                            titlesStringBuilder.append(map.get("title")).append(";");
                            urlsStringBuilder.append(map.get("url")).append(";");
                        }
                        if (titlesStringBuilder.length() - 1 >= 0 && String.valueOf(titlesStringBuilder.charAt(titlesStringBuilder.length() - 1)).equals(";")) {
                            titlesStringBuilder.deleteCharAt(titlesStringBuilder.length() - 1);
                        }
                        if (urlsStringBuilder.length() - 1 >= 0 && String.valueOf(urlsStringBuilder.charAt(urlsStringBuilder.length() - 1)).equals(";")) {
                            urlsStringBuilder.deleteCharAt(urlsStringBuilder.length() - 1);
                        }
                        detailsLine.append((CharSequence)titlesStringBuilder).append(",").append((CharSequence)urlsStringBuilder).append(",");
                    } else {
                        detailsLine.append(",").append(",");
                    }
                    detailsLine.append(lineSeparator);
                    try {
                        writer.write(detailsLine.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            return Observable.just(contacts);
        }).subscribe(contacts -> ClientSingleton.getInstance().runLater(() -> {
            spSettingsPane.getChildren().remove((Object)fx_progressBarPane);
            fx_progressBarPane.getChildren().clear();
            onClose.execute();
        }), ExportToCVS.onError());
    }

    private static Consumer<? super Throwable> onError() {
        return throwable -> {
            ClientSingleton.toLog("ExportToCVS", "error import contacts : " + throwable.getMessage());
            ClientSingleton.getInstance().removeLoadingPane();
        };
    }

    private static void getDetailsLine(List<String> headerList, ContactInfo contactInfo, StringBuilder detailsLine) {
        ArrayList<ContactInfo.Detail> details = new ArrayList<ContactInfo.Detail>(contactInfo.getUserDetails());
        details.addAll(contactInfo.getCustomDetails());
        List<DetailValue> userDetails = TypeConstantsRT.getDetails(details, contactInfo, true);
        Function<DetailValue, String> classifier = DetailValue::getLabel;
        Supplier<TreeMap> mapFactory = () -> new TreeMap(Collections.reverseOrder());
        Collector downStream = Collectors.toList();
        Collector<DetailValue, ?, TreeMap> collector = Collectors.groupingBy(classifier, mapFactory, downStream);
        TreeMap treeMap = userDetails.stream().collect(collector);
        for (String header : headerList) {
            List values = (List)treeMap.get(header);
            if (header.equals("link_title") || header.equals("link_url")) continue;
            if (header.equals("About")) {
                Object about = "";
                ContactInfo.Detail detail = contactInfo.getUserDetail("About");
                if (detail != null) {
                    about = detail.getValue().toString();
                }
                if ((detail = contactInfo.getCustomDetail("About")) != null) {
                    if (((String)about).isEmpty()) {
                        about = (String)about + "\n";
                    }
                    about = (String)about + detail.getValue().toString();
                }
                if (!((String)about).isEmpty()) {
                    detailsLine.append((String)about);
                    continue;
                }
            }
            if (values != null) {
                values.forEach(detailValue -> {
                    String detail;
                    try {
                        BigDecimal x = new BigDecimal(detailValue.getValue());
                        detail = x.toPlainString();
                    }
                    catch (Exception ex) {
                        detail = detailValue.getValue();
                    }
                    detailsLine.append(detail);
                    detailsLine.append(";");
                });
                if (detailsLine.length() - 1 >= 0 && String.valueOf(detailsLine.charAt(detailsLine.length() - 1)).equals(";")) {
                    detailsLine.deleteCharAt(detailsLine.length() - 1);
                }
            }
            detailsLine.append(",");
        }
    }

    private static void addDetailHeaders(ContactInfo contactInfo, List<String> headerList) {
        ArrayList<ContactInfo.Detail> details = new ArrayList<ContactInfo.Detail>(contactInfo.getUserDetails());
        details.addAll(contactInfo.getCustomDetails());
        List<DetailValue> userDetails = TypeConstantsRT.getDetails(details, contactInfo, true);
        userDetails.forEach(detailValue -> {
            String header = detailValue.getCode();
            if (!headerList.contains(header)) {
                headerList.add(header);
            }
        });
    }
}

