/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.settings.importcontacts.csv_google;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import net.sipsnet.client.views.settings.importcontacts.csv_google.GoogleTag;
import smile.cti.client.ContactInfo;

public class GoogleContactsImport {
    private final GoogleTag[] googleTypes = new GoogleTag[]{new GoogleTag(0, "", "Phone"), new GoogleTag(0, "*", "Phone"), new GoogleTag(0, "Home", "PrivatePhone"), new GoogleTag(0, "Work", "BusinessPhone"), new GoogleTag(0, "Other", "BusinessPhone"), new GoogleTag(0, "Mobile", "Mobile"), new GoogleTag(0, "Main", "Phone"), new GoogleTag(0, "Home(fax)", "PrivateFax"), new GoogleTag(0, "Work(fax)", "BusinessFax"), new GoogleTag(0, "", "Fax"), new GoogleTag(0, "*", "Fax"), new GoogleTag(0, "Home", "PrivateFax"), new GoogleTag(0, "Work", "BusinessFax"), new GoogleTag(0, "Other", "Fax"), new GoogleTag(1, "", "Email"), new GoogleTag(1, "*", "Email"), new GoogleTag(1, "Home", "PrivateEmail"), new GoogleTag(1, "Work", "BusinessEmail"), new GoogleTag(1, "Other", "Email"), new GoogleTag(3, "", "Web"), new GoogleTag(3, "*", "Web"), new GoogleTag(3, "Profile", "Web"), new GoogleTag(3, "Blog", "Web"), new GoogleTag(3, "Homepage", "BusinessWeb"), new GoogleTag(3, "Work", "PrivateWeb"), new GoogleTag(4, "", "Address"), new GoogleTag(4, "Home", "PrivateAddress"), new GoogleTag(4, "Work", "BusinessAddress"), new GoogleTag(4, "Other", "Address")};

    public GoogleTag getGoogleTag(String columnName, String value) {
        if (!columnName.toLowerCase().contains("type")) {
            return null;
        }
        GoogleTag googleTag = null;
        if (columnName.startsWith("Phone")) {
            googleTag = this.getGoogleTag(0, value);
        } else if (columnName.contains("Website")) {
            googleTag = this.getGoogleTag(3, value);
        } else if (columnName.contains("E-mail")) {
            googleTag = this.getGoogleTag(1, value);
        }
        return googleTag;
    }

    private GoogleTag getGoogleTag(int type, String value) {
        return Arrays.stream(this.googleTypes).filter(googleTag -> type == googleTag.getType() && value.equalsIgnoreCase(googleTag.getGoogleTag())).findFirst().orElse(null);
    }

    public ContactInfo convertToContactInfo(String line, String[] keys) {
        AtomicReference<String[]> values = new AtomicReference<String[]>(line.split(","));
        AtomicReference googleTagAtomicReference = new AtomicReference();
        ContactInfo contactInfo = ContactInfo.createContact(null);
        IntStream.range(0, keys.length).forEach(index -> {
            String value;
            String key = keys[index].trim();
            String string = value = index < ((String[])values.get()).length ? ((String[])values.get())[index].trim() : "";
            if (!value.isEmpty() || key.contains("type")) {
                if (key.equalsIgnoreCase("Name")) {
                    contactInfo.setName(value);
                } else if (key.equalsIgnoreCase("notes")) {
                    contactInfo.addCustomDetail("About", (Object)value);
                } else if (key.contains("organization")) {
                    if (key.contains("name")) {
                        contactInfo.addCustomDetail("Organization", (Object)value);
                    } else if (key.contains("department")) {
                        contactInfo.addCustomDetail("Department", (Object)value);
                    } else if (key.contains("title")) {
                        contactInfo.addCustomDetail("Position", (Object)value);
                    }
                } else if (key.startsWith("phone") || key.startsWith("e-mail") || key.startsWith("website")) {
                    int type;
                    int n = key.startsWith("phone") ? 0 : (type = key.startsWith("e-mail") ? 1 : 3);
                    if (key.contains("type")) {
                        googleTagAtomicReference.set(this.getGoogleTag(type, value));
                    } else if (googleTagAtomicReference.get() != null) {
                        if (value.contains(" ::: ")) {
                            String[] tagValues;
                            for (String val : tagValues = value.split(" ::: ")) {
                                contactInfo.addCustomDetail(((GoogleTag)googleTagAtomicReference.get()).getRingotelTag(), (Object)val);
                            }
                        } else {
                            contactInfo.addCustomDetail(((GoogleTag)googleTagAtomicReference.get()).getRingotelTag(), (Object)value);
                        }
                        googleTagAtomicReference.set(null);
                    }
                }
            }
        });
        if ("Unknown".equals(contactInfo.toString()) && contactInfo.getPhoneDetails().isEmpty() && contactInfo.getEmailDetails().isEmpty()) {
            return null;
        }
        return contactInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsContactDetail(String header) {
        List<String> headers = List.of("Name", "Given Name", "Additional Name", "Family Name", "Yomi Name", "Given Name Yomi", "Additional Name Yomi", "Family Name Yomi", "Name Prefix", "Name Suffix", "Initials", "Nickname", "Short Name", "Maiden Name", "Birthday", "Gender", "Location", "Billing Information", "Directory Server", "Mileage", "Occupation", "Hobby", "Sensitivity", "Priority", "Subject", "Notes", "Language", "Photo", "Group Membership");
        List<String> headersOrganization = List.of("Name", "Yomi Name", "Department", "Symbol", "Location", "Job Description", "Title");
        List<String> headersTags = List.of("Type", "Value");
        if (headers.contains(header)) return true;
        if (header.startsWith("Address")) return true;
        if (header.contains("Phone")) {
            if (headersTags.stream().anyMatch(header::contains)) return true;
        }
        if (header.contains("E-mail")) {
            if (headersTags.stream().anyMatch(header::contains)) return true;
        }
        if (header.contains("Website")) {
            if (headersTags.stream().anyMatch(header::contains)) return true;
        }
        if (!header.startsWith("Organization")) return false;
        return true;
    }
}

