/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.settings.importcontacts.vcf_converter;

import ezvcard.VCard;
import ezvcard.parameter.EmailType;
import ezvcard.parameter.TelephoneType;
import ezvcard.property.FormattedName;
import ezvcard.property.Organization;
import ezvcard.property.StructuredName;
import ezvcard.property.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.sipsnet.client.connector.ClientSingleton;
import smile.cti.client.ContactInfo;

public class CVFImport {
    public static List<ContactInfo> convertToContactInfo(List<VCard> vCards) throws Exception {
        ArrayList<ContactInfo> contactInfoList = new ArrayList<ContactInfo>();
        vCards.forEach(vCard -> {
            ContactInfo contactInfo = ContactInfo.createContact(null);
            FormattedName formattedName = vCard.getFormattedName();
            StructuredName structuredName = vCard.getStructuredName();
            if (structuredName != null) {
                if (structuredName.getFamily() != null && !structuredName.getFamily().isEmpty()) {
                    contactInfo.setCustomDetail("LastName", (Object)structuredName.getFamily());
                }
                if (structuredName.getGiven() != null && !structuredName.getGiven().isEmpty()) {
                    contactInfo.setCustomDetail("FirstName", (Object)structuredName.getFamily());
                }
            }
            if (formattedName != null) {
                contactInfo.setName((String)formattedName.getValue());
            }
            CVFImport.addNumbers(vCard, contactInfo);
            CVFImport.addEmails(vCard, contactInfo);
            CVFImport.addWeb(vCard, contactInfo);
            CVFImport.addOrganization(vCard, contactInfo);
            CVFImport.addPosition(vCard, contactInfo);
            CVFImport.getNotes(vCard, contactInfo);
            if (!("Unknown".equals(contactInfo.toString()) && contactInfo.getPhoneDetails().isEmpty() && contactInfo.getEmailDetails().isEmpty())) {
                contactInfoList.add(contactInfo);
            } else {
                ClientSingleton.toLog("CVFImport", "convertToContactInfo error vCard : " + vCard + "\ncontactInfo = " + contactInfo + ", CustomDetails = " + contactInfo.getCustomDetails());
            }
        });
        return contactInfoList;
    }

    private static void addPosition(VCard vCard, ContactInfo contactInfo) {
        if (vCard.getTitles() == null || vCard.getTitles().isEmpty()) {
            return;
        }
        List<Title> list = vCard.getTitles();
        Title title = list.get(0);
        String position = (String)title.getValue();
        contactInfo.addCustomDetail("Position", (Object)position);
    }

    private static void addOrganization(VCard vCard, ContactInfo contactInfo) {
        if (vCard.getOrganization() == null) {
            return;
        }
        Organization organization = vCard.getOrganization();
        List list = organization.getValues();
        if (list.size() == 1) {
            contactInfo.addCustomDetail("Organization", list.get(0));
        } else if (list.size() > 1) {
            contactInfo.addCustomDetail("Organization", list.get(0));
            contactInfo.addCustomDetail("Department", list.get(1));
        }
    }

    private static void getNotes(VCard vCard, ContactInfo contactInfo) {
        if (vCard.getNotes() == null && vCard.getNotes().isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        vCard.getNotes().forEach(note -> stringBuilder.append((String)note.getValue()).append("\n"));
        contactInfo.addCustomDetail("About", (Object)stringBuilder.toString());
    }

    private static void addWeb(VCard vCard, ContactInfo contactInfo) {
        if (vCard.getUrls() == null && vCard.getUrls().isEmpty()) {
            return;
        }
        vCard.getUrls().forEach(url -> {
            String value = (String)url.getValue();
            String type = url.getType();
            String tag = "Web";
            if (type != null) {
                if (type.equalsIgnoreCase("home")) {
                    tag = "PrivateWeb";
                } else if (type.equalsIgnoreCase("work")) {
                    tag = "BusinessWeb";
                }
            }
            contactInfo.addCustomDetail(tag, (Object)value);
        });
    }

    private static void addEmails(VCard vCard, ContactInfo contactInfo) {
        if (vCard.getEmails() == null && vCard.getEmails().isEmpty()) {
            return;
        }
        vCard.getEmails().forEach(email -> {
            String value = (String)email.getValue();
            Optional<EmailType> homeType = email.getTypes().stream().filter(type -> type == EmailType.HOME).findAny();
            Optional<EmailType> workType = email.getTypes().stream().filter(type -> type == EmailType.WORK).findAny();
            Optional<EmailType> otherType = email.getTypes().stream().filter(type -> "other".equals(type.getValue())).findAny();
            String tag = homeType.isPresent() ? "PrivateEmail" : (workType.isPresent() ? "BusinessEmail" : "Email");
            contactInfo.addCustomDetail(tag, (Object)value);
        });
    }

    private static void addNumbers(VCard vCard, ContactInfo contactInfo) {
        if (vCard.getTelephoneNumbers() == null && vCard.getTelephoneNumbers().isEmpty()) {
            return;
        }
        vCard.getTelephoneNumbers().forEach(telephone -> {
            String value = telephone.getText();
            Optional<TelephoneType> cellType = telephone.getTypes().stream().filter(type -> type == TelephoneType.CELL).findAny();
            Optional<TelephoneType> faxType = telephone.getTypes().stream().filter(type -> type == TelephoneType.FAX).findAny();
            Optional<TelephoneType> homeType = telephone.getTypes().stream().filter(type -> type == TelephoneType.HOME).findAny();
            Optional<TelephoneType> workType = telephone.getTypes().stream().filter(type -> type == TelephoneType.WORK).findAny();
            String tag = cellType.isPresent() ? (homeType.isPresent() ? "PrivateMobile" : (workType.isPresent() ? "BusinessMobile" : "Mobile")) : (faxType.isPresent() ? (homeType.isPresent() ? "PrivateFax" : (workType.isPresent() ? "BusinessFax" : "Fax")) : (homeType.isPresent() ? "PrivatePhone" : (workType.isPresent() ? "BusinessPhone" : "Phone")));
            contactInfo.addCustomDetail(tag, (Object)value);
        });
    }
}

