/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.speeddial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.contactslist.IHideStage;
import net.sipsnet.client.views.contactslist.ScrolledContactInfosList;
import net.sipsnet.client.views.profiles.contactpane.IContactSelected;
import net.sipsnet.client.views.profiles.profileedit.EditDataPaneV;
import net.sipsnet.client.views.settings.MyRadioButton;
import smile.cti.client.ContactInfo;

public class AddToSpeedDial
extends ScrolledContactInfosList
implements IContactSelected,
IHideStage {
    private final EventHandler<MouseEvent> onCloseEvent = event -> this.hide();
    private final EventHandler<MouseEvent> onBackEvent = event -> {
        this.editDataPaneVName = null;
        this.editDataPaneVNumber = null;
        this.contactName = null;
        this.buildList();
    };
    private final List<MyRadioButton> myRadioButtons = new ArrayList<MyRadioButton>();
    private EditDataPaneV editDataPaneVName;
    private EditDataPaneV editDataPaneVNumber;
    private MyLabel contactName;
    private final EventHandler<MouseEvent> onConfirmEvent = event -> {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "myRadioButtons=" + this.myRadioButtons);
        if (this.editDataPaneVName != null && this.editDataPaneVNumber != null) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                String number = this.editDataPaneVNumber.getText();
                ContactInfo contactInfo = clientConnector.findContactByPhoneNumber(number);
                this.setSpeedDialContact(contactInfo != null && contactInfo.isValid() ? contactInfo.toString() : this.editDataPaneVName.getText(), this.editDataPaneVNumber.getText());
            });
        } else if (!this.myRadioButtons.isEmpty()) {
            AtomicReference<String> atomicReference = new AtomicReference<String>("");
            this.myRadioButtons.forEach(myRadioButton -> {
                if (myRadioButton.isSelected()) {
                    atomicReference.set(myRadioButton.getId());
                }
            });
            ClientSingleton.toLog(this.getClass().getSimpleName(), "atomicReference=" + atomicReference);
            if (!atomicReference.get().isEmpty()) {
                this.setSpeedDialContact(this.contactName.getText(), atomicReference.get());
            }
        }
    };
    private boolean singleTouchSelection = false;
    private ICallPanesVisibility iCallPanesVisibility;
    private final BorderPane rootPane;
    private MyPopupWindow myPopupWindow;
    private final boolean isAddToOpenedPopupList;
    private boolean isAlwaysOnTop;
    private Pane header;
    private StackPane mainBox;

    public AddToSpeedDial() {
        super(new ArrayList<ContactInfo>());
        super.setIChildContactSelected(this);
        super.setIHideStage(this);
        this.isAddToOpenedPopupList = true;
        this.singleTouchSelection = true;
        this.setShowSelectLabels(true);
        this.setItemOnList(!ClientSingleton.getInstance().getClientConnector().get().getSIPTrunksForSMS().isEmpty() ? 11 : 10);
        this.addSpeedDialMode();
        this.setShowSelectLabels(true);
        this.setTitle("speed_dial_name_header");
        this.setColumnCount(1);
        this.setTitleOnTheTopLine(true);
        this.setWithMouseSelection(true);
        this.setSelectWithArrow(true);
        this.setWithSearchImage(true);
        this.rootPane = this.getRootPane();
        this.setExtraPane(this.getExtraPane());
        this.buildList();
        this.show();
    }

    private void buildList() {
        this.populateLists();
        if (this.header != null) {
            this.header.prefWidthProperty().unbind();
        }
        this.header = this.getHeaderLine(this.onCloseEvent);
        this.header.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        if (this.mainBox != null) {
            this.mainBox.prefWidthProperty().unbind();
        }
        this.mainBox = this.initComponents();
        this.mainBox.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        super.bindPane((Pane)this.rootPane);
        this.rootPane.setTop((Node)this.header);
        this.rootPane.setCenter((Node)this.mainBox);
        HBox footer = this.getFooter();
        if (footer != null) {
            footer.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
            this.rootPane.setBottom((Node)footer);
        }
        this.setTextFieldWithSearchPrompt("speed_dial_number");
    }

    private void buildPhoneNumbers(ContactInfo contactInfo) {
        this.header = this.getExtraHeader(this.onCloseEvent, null);
        this.header.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        HBox mainBox = new HBox();
        VBox editVBox = new VBox();
        editVBox.setAlignment(Pos.TOP_LEFT);
        editVBox.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
        mainBox.getChildren().add((Object)editVBox);
        editVBox.prefWidthProperty().bind((ObservableValue)mainBox.widthProperty().subtract(10));
        MyLabel myLabelName = new MyLabel();
        myLabelName.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        myLabelName.setText("profile_name");
        myLabelName.setLabelFontColor("#646a7e");
        myLabelName.setLabelFontSize(12);
        myLabelName.setLabelFontFamily("HelveticaNeue-Medium");
        MyLabel myContactInfoName = new MyLabel();
        myContactInfoName.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        myContactInfoName.setText(contactInfo.toString());
        myContactInfoName.setLabelFontColor("#252b40");
        myContactInfoName.setLabelFontSize(16);
        myContactInfoName.setLabelFontFamily("HelveticaNeue-Medium");
        this.contactName = new MyLabel();
        this.contactName.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.contactName.setText(contactInfo.toString());
        this.contactName.setLabelFontColor("#646a7e");
        this.contactName.setLabelFontSize(12);
        this.contactName.setLabelFontFamily("HelveticaNeue-Medium");
        MyLabel myLabelNumber = new MyLabel();
        VBox.setMargin((Node)myLabelNumber, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
        myLabelNumber.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        myLabelNumber.setText("speed_dial_phone_numbers");
        myLabelNumber.setLabelFontColor("#646a7e");
        myLabelNumber.setLabelFontSize(12);
        myLabelNumber.setLabelFontFamily("HelveticaNeue-Medium");
        editVBox.getChildren().addAll((Object[])new Node[]{myLabelName, this.contactName, myLabelNumber});
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.getStylesheets().add((Object)"extracss/myscrollpane2.css");
        scrollPane.applyCss();
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        VBox details = new VBox();
        scrollPane.setContent((Node)details);
        details.prefWidthProperty().bind((ObservableValue)scrollPane.widthProperty().subtract(5));
        this.myRadioButtons.clear();
        Optional<String> ext = Optional.ofNullable(Optional.ofNullable((String)contactInfo.getProperty("extension")).orElse((String)contactInfo.getProperty("ext")));
        ext.ifPresent(s -> {
            HBox hBox = this.getNumberHBox((String)s, ClientSingleton.getInstance().getString("speed_dial_internal_number"));
            hBox.prefWidthProperty().bind((ObservableValue)scrollPane.widthProperty().subtract(10));
            details.getChildren().add((Object)hBox);
        });
        for (ContactInfo.Detail detail : contactInfo.getPhoneDetails()) {
            HBox hBox = this.getNumberHBox(detail.getValue().toString(), detail.getLabel());
            hBox.prefWidthProperty().bind((ObservableValue)scrollPane.widthProperty().subtract(10));
            details.getChildren().add((Object)hBox);
        }
        editVBox.getChildren().add((Object)scrollPane);
        mainBox.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        VBox.setVgrow((Node)mainBox, (Priority)Priority.ALWAYS);
        MyLabelButton myLabelButton = this.addButtonToFooter("alert_dialog_title3", this.onConfirmEvent);
        myLabelButton.setButtonWidth(-1);
        this.rootPane.setTop((Node)this.header);
        this.rootPane.setCenter((Node)mainBox);
        HBox footer = this.getFooter();
        if (footer != null) {
            footer.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
            this.rootPane.setBottom((Node)footer);
            VBox.setMargin((Node)footer, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
            this.setMaxPaneHeight(this.getMaxPaneWidth() - 40);
        }
        super.bindPane((Pane)this.rootPane);
    }

    private HBox getNumberHBox(String contactType, String number) {
        HBox hBox = new HBox();
        hBox.setStyle("-fx-background-color: white;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);");
        hBox.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        HBox radioButtonHBox = new HBox();
        HBox.setMargin((Node)radioButtonHBox, (Insets)new Insets(0.0, 15.0, 0.0, 15.0));
        hBox.prefHeightProperty().bind((ObservableValue)hBox.heightProperty());
        MyRadioButton myRadioButton = new MyRadioButton();
        this.myRadioButtons.add(myRadioButton);
        myRadioButton.setSelected(this.myRadioButtons.size() == 1);
        radioButtonHBox.setAlignment(Pos.CENTER);
        radioButtonHBox.getChildren().add((Object)myRadioButton);
        myRadioButton.setOnMouseClicked(event -> {
            this.myRadioButtons.forEach(myRadioButton1 -> myRadioButton1.setSelected(false));
            myRadioButton.setSelected(true);
        });
        myRadioButton.setId(contactType);
        VBox vBox = new VBox();
        MyLabel myLabelName = new MyLabel();
        VBox.setMargin((Node)myLabelName, (Insets)new Insets(9.0, 0.0, 0.0, 0.0));
        myLabelName.setText(number);
        myLabelName.setLabelFontColor("#646a7e");
        myLabelName.setLabelFontSize(11);
        myLabelName.setLabelFontFamily("HelveticaNeue");
        MyLabel myLabelNumber = new MyLabel();
        VBox.setMargin((Node)myLabelName, (Insets)new Insets(0.0, 0.0, 9.0, 0.0));
        myLabelNumber.setText(contactType);
        myLabelNumber.setLabelFontColor("#252b40");
        myLabelNumber.setLabelFontSize(14);
        myLabelNumber.setLabelFontFamily("HelveticaNeue");
        vBox.getChildren().addAll((Object[])new Node[]{myLabelName, myLabelNumber});
        hBox.getChildren().addAll((Object[])new Node[]{radioButtonHBox, vBox});
        return hBox;
    }

    private void buildCustomNumber(String number) {
        this.header = this.getExtraHeader(this.onCloseEvent, null);
        this.header.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        HBox mainBox = new HBox();
        VBox editVBox = new VBox();
        editVBox.setAlignment(Pos.CENTER_LEFT);
        editVBox.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
        mainBox.getChildren().add((Object)editVBox);
        editVBox.prefWidthProperty().bind((ObservableValue)mainBox.widthProperty().subtract(50));
        MyLabel myLabelName = new MyLabel();
        myLabelName.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        myLabelName.setText("profile_name");
        myLabelName.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.SUBJECT_TEXT_FILL));
        myLabelName.setLabelFontSize(12);
        myLabelName.setLabelFontFamily("HelveticaNeue-Medium");
        this.editDataPaneVName = new EditDataPaneV();
        this.editDataPaneVName.setUnderlineColor("#dce0ec");
        this.editDataPaneVName.setPromptToEditField(ClientSingleton.getInstance().getString("speed_dial_name"));
        this.editDataPaneVName.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TAB_CELL_TEXT_FILL));
        this.editDataPaneVName.setLabelFontSize(16);
        this.editDataPaneVName.setLabelFontFamily("Arial");
        MyLabel myLabelNumber = new MyLabel();
        VBox.setMargin((Node)myLabelNumber, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
        myLabelNumber.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        myLabelNumber.setText("speed_dial_phone_number");
        myLabelNumber.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.SUBJECT_TEXT_FILL));
        myLabelNumber.setLabelFontSize(12);
        myLabelNumber.setLabelFontFamily("HelveticaNeue-Medium");
        this.editDataPaneVNumber = new EditDataPaneV();
        this.editDataPaneVNumber.setUnderlineColor("#dce0ec");
        this.editDataPaneVNumber.setPromptToEditField("speed_dial_name");
        this.editDataPaneVNumber.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TAB_CELL_TEXT_FILL));
        this.editDataPaneVNumber.setLabelFontFamily("Arial");
        this.editDataPaneVNumber.setPromptToEditField(ClientSingleton.getInstance().getString("speed_dial_number"));
        this.editDataPaneVNumber.setLabelFontSize(16);
        this.editDataPaneVNumber.setTextToEditField(number);
        editVBox.getChildren().addAll((Object[])new Node[]{myLabelName, this.editDataPaneVName, myLabelNumber, this.editDataPaneVNumber});
        VBox.setMargin((Node)editVBox, (Insets)new Insets(0.0, 0.0, 15.0, 0.0));
        mainBox.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        VBox.setVgrow((Node)mainBox, (Priority)Priority.ALWAYS);
        this.rootPane.setTop((Node)this.header);
        this.rootPane.setCenter((Node)mainBox);
        MyLabelButton myLabelButton = this.addButtonToFooter("alert_dialog_title3", this.onConfirmEvent);
        myLabelButton.setButtonWidth(-1);
        HBox footer = this.getFooter();
        if (footer != null) {
            footer.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
            this.rootPane.setBottom((Node)footer);
            VBox.setMargin((Node)footer, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
            this.setMaxPaneHeight(this.getMaxPaneWidth() - 40);
        }
        super.bindPane((Pane)this.rootPane);
    }

    private void show() {
        ClientSingleton.getInstance().runLater(this::onShow);
    }

    private void onShow() {
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.rootPane, (Window)(this.isAddToOpenedPopupList ? ClientSingleton.getInstance().getParentWindow() : new Stage())).initMotionListeners((Node)this.header);
        this.rootPane.setMaxWidth((double)(this.getMaxPaneWidth() + (this.isSelectWithArrow() ? 25 : 0)));
        this.setMaxPaneHeight(this.getMaxPaneHeight() + 15);
        if (this.isAddToOpenedPopupList) {
            ClientSingleton.getInstance().addToOpenedPopupsList(this.myPopupWindow);
        }
        if (this.isAlwaysOnTop) {
            this.myPopupWindow.setAlwaysOnTop(true);
        }
        this.myPopupWindow.showAndWait();
    }

    public void hide() {
        if (this.iCallPanesVisibility != null) {
            this.iCallPanesVisibility.setCallPanesUnVisible();
        }
        this.myPopupWindow.hide();
        super.onClose();
    }

    private Pane getExtraPane() {
        VBox extraPane = new VBox();
        MyLabel labelBox = new MyLabel();
        VBox.setVgrow((Node)labelBox, (Priority)Priority.ALWAYS);
        labelBox.setText(ClientSingleton.getInstance().getString("speed_dial_new_number"));
        labelBox.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL));
        labelBox.setLabelFontSize(14);
        labelBox.setLabelFontFamily("Arial");
        labelBox.setTextAlignment(Pos.CENTER_LEFT);
        labelBox.prefWidthProperty().bind((ObservableValue)extraPane.widthProperty());
        labelBox.setLabelMarginLeft(10);
        extraPane.getChildren().add((Object)labelBox);
        MyLabel nameBox = new MyLabel();
        VBox.setVgrow((Node)nameBox, (Priority)Priority.ALWAYS);
        nameBox.setId("text");
        nameBox.setLabelMarginLeft(10);
        nameBox.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL));
        nameBox.setLabelFontSize(14);
        nameBox.setLabelFontFamily("Arial");
        nameBox.setTextAlignment(Pos.BOTTOM_LEFT);
        nameBox.setAlignment(Pos.CENTER);
        nameBox.setMinHeight(30.0);
        nameBox.prefWidthProperty().bind((ObservableValue)extraPane.widthProperty());
        ImageButton imageButton = new ImageButton();
        imageButton.setBackgroundColor("transparent");
        nameBox.setOnMouseEntered(event -> {
            Theme.getInstance().applyTabCellTo((Pane)nameBox, true, false);
            ((Node)event.getSource()).setCursor(Cursor.HAND);
        });
        nameBox.setOnMouseExited(event -> {
            Theme.getInstance().applyTabCellTo((Pane)nameBox, false, false);
            ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
        });
        HBox.setMargin((Node)imageButton, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        imageButton.setSize(20, 20);
        imageButton.setImagePath("other/dark_chevron_right.png");
        nameBox.getChildren().add((Object)imageButton);
        extraPane.getChildren().add((Object)nameBox);
        extraPane.setAlignment(Pos.CENTER_LEFT);
        extraPane.setMaxHeight(50.0);
        extraPane.setMinHeight(50.0);
        nameBox.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            String number = this.getNumber();
            this.clearNumber();
            this.buildCustomNumber(number);
        });
        return extraPane;
    }

    private BorderPane getRootPane() {
        BorderPane vBox = new BorderPane();
        vBox.setPadding(new Insets(20.0, 15.0, 20.0, 15.0));
        vBox.setStyle("-fx-background-color: white;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);");
        return vBox;
    }

    @Override
    public void contactSelected(ContactInfo contactInfo, boolean isSelected) {
        if (isSelected) {
            List<String> numbers = ClientSingleton.getInstance().getPhonesListForMenu(contactInfo);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "contactSelected contactInfo=" + contactInfo + " numbers=" + numbers);
            if (numbers.size() > 1) {
                this.buildPhoneNumbers(contactInfo);
            } else {
                this.setSpeedDialContact(contactInfo.toString(), numbers.get(0));
            }
        }
    }

    private void setSpeedDialContact(String name, String number) {
        ClientSingleton.getInstance().runLater(() -> {
            this.hide();
            ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("creating") + " " + name);
        });
        MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                ContactInfo contactInfo = clientConnector.setSpeedDialContact(name, number);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("contactInfo", contactInfo);
                data.put("tab", 5);
                ClientSingleton.getInstance().doNotify(IntentConstants.CONTACT_ADDED, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    public void addButton(String buttonTitle, EventHandler<MouseEvent> event) {
        this.addButtonToFooter(buttonTitle, event).addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> this.hide());
    }

    @Override
    public void hideStage() {
        this.hide();
    }
}

