/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.animation.FadeTransition;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import javafx.util.Pair;
import net.sipsnet.client.click2dial.GetSelectedText;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.views.group.createeditgroup.GroupCreatorEditor;
import net.sipsnet.client.views.tabs.calls.flow.CallDateCellView;
import net.sipsnet.client.views.tabs.contacts.flow.ContactCellView;
import net.sipsnet.client.views.tabs.contacts.flow.ContactHeaderCellView;
import net.sipsnet.client.views.tabs.sessions.flow.SessionHeaderCellView;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.ICellSelection;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.reactfx.util.Lists;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;
import smile.util.RedirectionException;

public abstract class TabBaseView<T>
extends AnchorPane
implements ICellSelection {
    protected final int currentTab;
    protected INewMessagesNotification iNewMessagesNotification = null;
    protected VirtualFlow<T, ?> virtualFlow;
    protected VirtualizedScrollPane<VirtualFlow<T, ?>> scrollPane;
    protected Function<T, Cell<T, Node>> cellFactory;
    public static int SCROLL_TO_TOP = 0;
    public static int CLEAR_CALLS = 1;
    public static int WITHOUT_OPACITY = -1;
    public static int WITHOUT_COMPARE = 10;
    private final SimpleIntegerProperty lastScrollMode = new SimpleIntegerProperty(-1);
    protected ObservableList<T> dataInfoList = FXCollections.observableArrayList();
    private TimerExecutor timerExecutor;
    protected PublishSubject<Pair<BaseCell, MouseEvent>> selectObserver;
    private PublishSubject<Integer> updateObserver;
    private PublishSubject<Integer> goToPosition;
    protected PublishSubject<Integer> switchObserver;
    private CompositeDisposable disposables = new CompositeDisposable();
    private CompositeDisposable disposablesSelection = new CompositeDisposable();
    private Function<Integer, List<T>> updateFunction;
    private final SimpleBooleanProperty isItemListUpdating = new SimpleBooleanProperty(false);
    private Supplier<Integer> startPositionSupplier = null;
    private MaxSizedContextMenu myContextMenu;
    protected final SimpleBooleanProperty isMultiSelectionMode = new SimpleBooleanProperty(false);

    public void setStartPositionSupplier(Supplier<Integer> startPositionSupplier) {
        this.startPositionSupplier = startPositionSupplier;
    }

    public TabBaseView(int currentTab, INewMessagesNotification iNewMessagesNotification) {
        this.currentTab = currentTab;
        this.iNewMessagesNotification = iNewMessagesNotification;
        this.isItemListUpdating.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "isItemListUpdating current state : " + newValue);
            }
        });
        this.initSelectBaseCellObserver();
        if (this.currentTab == 4 || this.currentTab == 2) {
            this.isMultiSelectionMode.addListener((observableValue, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.addDeleteHeader();
                } else {
                    this.removeDeleteHeader();
                    this.clearSelections();
                }
                this.updateList(SCROLL_TO_TOP);
            });
        }
    }

    public boolean compare(List<T> members) {
        boolean isEquals = true;
        if (this.dataInfoList.size() == members.size()) {
            int j = this.dataInfoList.size() - 1;
            for (int i = 0; i <= this.dataInfoList.size() - 1; ++i) {
                Object object1 = this.dataInfoList.get(i);
                T object2 = members.get(i);
                if (object1 instanceof ContactInfo && object2 instanceof ContactInfo) {
                    if (ClientSingleton.getInstance().getUserID((ContactInfo)object1).equals(ClientSingleton.getInstance().getUserID((ContactInfo)object2))) continue;
                    isEquals = false;
                } else {
                    if (!(object1 instanceof SessionInfo) || !(object2 instanceof SessionInfo) || ClientSingleton.getInstance().getSessionId((SessionInfo)object1).equals(ClientSingleton.getInstance().getSessionId((SessionInfo)object2))) continue;
                    isEquals = false;
                }
                break;
            }
        } else {
            isEquals = false;
        }
        return isEquals;
    }

    public void setCellFactory(Function<T, Cell<T, Node>> cellFactory, Function<Integer, List<T>> updateFunction) {
        this.dataInfoList = FXCollections.observableArrayList();
        this.cellFactory = cellFactory;
        this.updateFunction = updateFunction;
    }

    private void initUpdateObserver() {
        this.updateObserver = PublishSubject.create();
        ObservableList tmpList = FXCollections.observableArrayList();
        this.disposables.add(this.updateObserver.debounce(200L, TimeUnit.MILLISECONDS).doOnError(this.getThrowableConsumer()).switchMap(integer -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "updateList isItemListUpdating.get()=" + this.isItemListUpdating.get() + " integer=" + integer + " dataInfoList.size() = " + this.dataInfoList.size());
            if (this.isItemListUpdating.get()) {
                return Observable.empty();
            }
            this.isItemListUpdating.set(true);
            List<T> list = this.updateFunction.apply((Integer)integer);
            if (integer != WITHOUT_COMPARE) {
                boolean isEqual = this.compare(list);
                ClientSingleton.toLog(this.getClass().getSimpleName(), "updateList isEqual list=" + isEqual + " list=" + list.size() + " getVisibleCellsCount()=" + this.getVisibleCellsCount());
                if (isEqual) {
                    integer = this.getVisibleCellsCount() > 0 ? Integer.valueOf(-20) : Integer.valueOf(-10);
                } else if (list.isEmpty()) {
                    integer = -10;
                }
            }
            return Observable.just((Object)new Pair(integer, list));
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(arg_0 -> this.lambda$initUpdateObserver$2((List)tmpList, arg_0), this.getThrowableConsumer((List<T>)tmpList)));
    }

    public void resetUpdate() {
        this.isItemListUpdating.set(false);
    }

    public void updateListItems(int mode) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "updateList start base");
        if (this.updateObserver == null || this.disposables.size() == 0) {
            this.initUpdateObserver();
        }
        this.updateObserver.onNext((Object)mode);
    }

    public void setLastScrollMode(int lastScrollMode) {
        if (this.timerExecutor != null && lastScrollMode == -1) {
            try {
                this.timerExecutor.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.timerExecutor = null;
        }
        this.lastScrollMode.set(lastScrollMode);
    }

    private void addItemsToList(List<T> members) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "uaddItemsToList list=" + members.size());
        if (this.lastScrollMode.get() != WITHOUT_OPACITY) {
            this.setOpacity(0.0);
            if (this.lastScrollMode.get() != SCROLL_TO_TOP) {
                this.setLastScrollMode(SCROLL_TO_TOP);
            }
        }
        ArrayList<T> tmpList = new ArrayList<T>();
        for (int i = members.size() - 1; i >= 0; --i) {
            tmpList.add(0, members.get(i));
        }
        ClientSingleton.getInstance().runLater(() -> {
            this.dataInfoList.setAll((Collection)tmpList);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "uaddItemsToList dataInfoList=" + this.dataInfoList.size());
            if (!this.dataInfoList.isEmpty()) {
                this.goToStartPosition();
            }
            members.clear();
            tmpList.clear();
            if (!this.dataInfoList.isEmpty()) {
                if (this.getOpacity() != 1.0) {
                    FadeTransition ft = new FadeTransition(Duration.millis((double)50.0), (Node)this);
                    ft.setOnFinished(actionEvent -> {
                        this.isItemListUpdating.set(false);
                        this.setLastScrollMode(SCROLL_TO_TOP);
                    });
                    ft.setFromValue(0.0);
                    ft.setToValue(1.0);
                    ft.play();
                } else {
                    this.setLastScrollMode(SCROLL_TO_TOP);
                    this.isItemListUpdating.set(false);
                }
            } else {
                this.setLastScrollMode(SCROLL_TO_TOP);
                this.isItemListUpdating.set(false);
            }
        });
    }

    public Consumer<? super Throwable> getThrowableConsumer() {
        return throwable -> {
            if (this.getOpacity() != 1.0) {
                this.setOpacity(1.0);
            }
            throwable.printStackTrace();
        };
    }

    public Consumer<? super Throwable> getThrowableConsumer(List<T> members) {
        return throwable -> {
            throwable.printStackTrace();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Error : getThrowableConsumer members=" + members.size());
            if (!members.isEmpty()) {
                this.dataInfoList = FXCollections.observableArrayList((Collection)members);
                this.addScrollPane();
                members.clear();
            }
            if (this.getOpacity() != 1.0) {
                this.setOpacity(1.0);
            }
            this.isItemListUpdating.set(false);
        };
    }

    @Override
    public void showContextMenu(BaseCell selectedCell, MouseEvent mouseEvent) {
        MenuItem menuItem;
        SessionInfo sessionInfo;
        boolean dismissDial;
        boolean hasNotActiveLine;
        this.hideContextMenu(selectedCell);
        if (this.myContextMenu == null) {
            this.myContextMenu = new MaxSizedContextMenu();
            this.myContextMenu.setMaxHeight(300.0);
            this.myContextMenu.setMinWidth(150.0);
            this.myContextMenu.setPrefWidth(150.0);
            this.myContextMenu.setMaxWidth(150.0);
            Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this);
        }
        ContactInfo contactInfo = selectedCell.getContactInfo();
        LineInfo lineInfo = AudioCaller.getActiveLine();
        boolean bl = hasNotActiveLine = lineInfo != null && (lineInfo.getState() == 2 || lineInfo.getState() == 1 || lineInfo.getState() == 15);
        if (lineInfo != null && lineInfo.getContacts() != null) {
            ContactInfo calledContactInfo = (ContactInfo)lineInfo.getContacts().iterator().next();
            if (ClientSingleton.getInstance().getUserID(contactInfo).equals(ClientSingleton.getInstance().getUserID(calledContactInfo))) {
                return;
            }
        }
        boolean bl2 = dismissDial = (sessionInfo = selectedCell.getSessionInfo()) != null && sessionInfo.getStatus() == 2;
        if (!(sessionInfo == null || dismissDial || AudioCaller.getWorkingLinesCount() != 0 && lineInfo == null)) {
            if (sessionInfo.getDialogType() != 3) {
                menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_dial"));
                menuItem.setOnAction(event -> {
                    this.hideContextMenu(selectedCell);
                    if (this.currentTab != 1 && this.currentTab != 2) {
                        if (sessionInfo != null) {
                            if (sessionInfo.isGroup()) {
                                ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_start_conference"), ClientSingleton.getInstance().getString("alert_dialog_title3"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent1 -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                                    ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCall sessionInfo=" + sessionInfo);
                                    AudioCaller.makeCall(sessionInfo, false);
                                })));
                            } else if (sessionInfo.getStatus() < -1) {
                                AudioCaller.makeAudioCallToExternal(sessionInfo, false);
                            } else {
                                AudioCaller.makeCall(sessionInfo, false);
                            }
                        }
                    } else {
                        AudioCaller.makeCall(contactInfo);
                    }
                });
                this.myContextMenu.getItems().add((Object)menuItem);
            }
            if (!sessionInfo.isGroup()) {
                List trunks = ClientSingleton.getInstance().getClientConnector().get().getTrunks(null);
                List<String> numbers = ClientSingleton.getInstance().getPhonesListForMenu(contactInfo);
                if (trunks != null && trunks.size() > 1 || numbers != null && numbers.size() > 1) {
                    MenuItem menuItem2 = new MenuItem(ClientSingleton.getInstance().getString("call_menu_dial_as"));
                    menuItem2.setOnAction(event1 -> {
                        this.hideContextMenu(selectedCell);
                        SessionInfo si = sessionInfo;
                        if (this.currentTab == 2 || this.currentTab == 1 || sessionInfo == null) {
                            try {
                                si = ClientSingleton.getInstance().getExistSessionInfoByUserId(ClientSingleton.getInstance().getUserID(contactInfo));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        AudioCaller.makeAudioCallToExternal(si != null ? si.toString() : contactInfo.toString(), numbers, trunks);
                    });
                    this.myContextMenu.getItems().add((Object)menuItem2);
                }
            }
        }
        if (this.currentTab == 2) {
            if (!(contactInfo.getUserID() == null || "".equals(contactInfo.getName()) && contactInfo.getStatus() != 0)) {
                menuItem = new MenuItem(ClientSingleton.getInstance().getString("edit_contact"));
                menuItem.setOnAction(event -> {
                    this.hideContextMenu(selectedCell);
                    if (ClientSingleton.getInstance().getCurrentViewMode() == 1) {
                        selectedCell.setSelectedCellStyle(false);
                        if (this.iNewMessagesNotification != null) {
                            this.iNewMessagesNotification.openSessionEditor(selectedCell);
                        }
                    } else {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("contactInfo", contactInfo);
                        ClientSingleton.getInstance().doNotify(Constants.OPEN_PROFILE_EDITOR, data);
                    }
                });
                this.myContextMenu.getItems().add((Object)menuItem);
            }
            this.addShareItem(selectedCell, contactInfo);
        }
        if (lineInfo != null && !hasNotActiveLine) {
            if (sessionInfo != null && sessionInfo.isGroup()) {
                return;
            }
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_blind_tr"));
            menuItem.setOnAction(event -> {
                this.hideContextMenu(selectedCell);
                if (lineInfo.getState() != 4) {
                    AudioCaller.setHoldLine(lineInfo);
                }
                TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.transferCall(contactInfo))).startWithDelay(300L);
            });
            this.myContextMenu.getItems().add((Object)menuItem);
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_attended_tr"));
            menuItem.setOnAction(event -> {
                this.hideContextMenu(selectedCell);
                if (lineInfo.getState() != 4) {
                    AudioCaller.setHoldLine(lineInfo);
                }
                TimerExecutor.getInstance().setMyAction(() -> AudioCaller.makeCall(contactInfo)).startWithDelay(300L);
            });
            this.myContextMenu.getItems().add((Object)menuItem);
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_conference"));
            menuItem.setOnAction(event -> {
                this.hideContextMenu(selectedCell);
                AudioCaller.makeCall(contactInfo);
            });
            this.myContextMenu.getItems().add((Object)menuItem);
        } else if ("".equals(contactInfo.getName()) || this.isNotMember(contactInfo)) {
            menuItem = new MenuItem(ClientSingleton.getInstance().getString("call_menu_copy"));
            menuItem.setOnAction(event -> {
                this.hideContextMenu(selectedCell);
                try {
                    GetSelectedText.setClipboardText(contactInfo.getNumber());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            this.myContextMenu.getItems().add((Object)menuItem);
        }
        if (AudioCaller.getWorkingLinesCount() == 0 || hasNotActiveLine) {
            MenuItem menuItem3;
            String title;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "currentTab=" + this.currentTab + " isMultiSelectionMode()=" + this.isMultiSelectionMode());
            if (this.currentTab == 4) {
                this.addShareItem(selectedCell, contactInfo);
                if (!this.isMultiSelectionMode() && WhiteLabels.isRemoveCallLogEnabled()) {
                    menuItem = new MenuItem(ClientSingleton.getInstance().getString("cell_menu_multiple"));
                    menuItem.setOnAction(event -> {
                        this.hideContextMenu(selectedCell);
                        this.setIsMultiselectMode();
                    });
                    this.myContextMenu.getItems().add((Object)menuItem);
                }
            }
            if (sessionInfo != null && sessionInfo.canGroup()) {
                menuItem = new MenuItem(ClientSingleton.getInstance().getString("action_add_participant"));
                menuItem.setOnAction(action -> {
                    this.hideContextMenu(selectedCell);
                    GroupCreatorEditor groupCreatorEditor = sessionInfo.isGroup() ? new GroupCreatorEditor(sessionInfo, true) : new GroupCreatorEditor((ContactInfo)sessionInfo.getParties().get(0));
                    groupCreatorEditor.show();
                });
                this.myContextMenu.getItems().add((Object)menuItem);
            }
            if (this.currentTab == 4) {
                title = ClientSingleton.getInstance().getString("cell_menu_delete_call");
            } else if (this.currentTab == 3) {
                if (sessionInfo != null) {
                    boolean check = false;
                    if (sessionInfo.getProperty("PinChat") != null) {
                        check = (Boolean)sessionInfo.getProperty("PinChat");
                    }
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "pinChat sessionInfo.getProperty(Constants.PIN_CHAT)=" + check);
                    String pinChat = ClientSingleton.getInstance().getString(check ? "chat_unpin" : "chat_pin");
                    MenuItem menuItem4 = new MenuItem(pinChat);
                    menuItem4.setOnAction(event -> ClientSingleton.getInstance().pinChat(sessionInfo));
                    this.myContextMenu.getItems().add((Object)menuItem4);
                }
                title = ClientSingleton.getInstance().getString("session_menu_delete");
            } else {
                title = ClientSingleton.getInstance().getString("contact_menu_delete");
            }
            if (this.currentTab == 2) {
                if (this.isNotMember(contactInfo) && (contactInfo.getStatus() != -1 || contactInfo.getState() != -1)) {
                    menuItem3 = new MenuItem(title);
                    menuItem3.setStyle("-fx-text-fill:#e65d5d");
                    menuItem3.setOnAction(event -> {
                        this.hideContextMenu(selectedCell);
                        this.removeContact(selectedCell);
                    });
                    this.myContextMenu.getItems().add((Object)menuItem3);
                }
            } else if (this.currentTab != 1 && WhiteLabels.isRemoveCallLogEnabled()) {
                menuItem3 = new MenuItem(title);
                menuItem3.setStyle("-fx-text-fill:#e65d5d");
                menuItem3.setOnAction(event -> {
                    this.hideContextMenu(selectedCell);
                    if (sessionInfo != null) {
                        if (this.currentTab == 4) {
                            this.removeCallHistory(sessionInfo);
                        } else {
                            this.removeSession(sessionInfo);
                        }
                    }
                });
                this.myContextMenu.getItems().add((Object)menuItem3);
            }
        }
        this.myContextMenu.show((Node)selectedCell, mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    private void addShareItem(BaseCell selectedCell, ContactInfo contactInfo) {
        if (!contactInfo.isUser() && !contactInfo.isPhone() && ClientSingleton.getInstance().canShareContact(contactInfo)) {
            MenuItem menuItem = new MenuItem(ClientSingleton.getInstance().getString("cell_menu_share"));
            menuItem.setOnAction(event -> {
                this.hideContextMenu(selectedCell);
                ClientSingleton.getInstance().shareContact(contactInfo);
            });
            this.myContextMenu.getItems().add((Object)menuItem);
        }
    }

    private boolean isNotMember(ContactInfo contactInfo) {
        return ClientSingleton.getInstance().isNotMember(contactInfo);
    }

    public void setIsMultiselectMode() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setIsMultiselectMode");
        this.isMultiSelectionMode.set(true);
    }

    public void removeMultiSelectionMode() {
        if (this.currentTab == 4 || this.currentTab == 2) {
            this.isMultiSelectionMode.set(false);
        }
    }

    public boolean isMultiSelectionMode() {
        return this.isMultiSelectionMode.get();
    }

    private void removeSession(SessionInfo sessionInfo) {
        ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("remove_chat_dialog"), ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> TimerExecutor.getInstance().start(() -> {
            ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("removing_chat_dialog"));
            try {
                clientConnector.deleteSession(sessionInfo);
            }
            catch (Exception e) {
                ClientSingleton.getInstance().removeLoadingPane();
                e.printStackTrace();
            }
        }))));
    }

    private void removeContact(BaseCell selectedCell) {
        ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("remove_contact_dialog"), ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            ContactInfo contactInfo = selectedCell.getContactInfo();
            if (contactInfo != null) {
                MyThreadPoolManager.getInstance().execute(() -> {
                    try {
                        ClientSingleton.getInstance().getClientConnector().get().deleteContact(contactInfo);
                        selectedCell.setSelectedCellStyle(false);
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "removeContact removed " + contactInfo);
                    }
                    catch (RedirectionException redirectionException) {
                        redirectionException.printStackTrace();
                        ClientSingleton.getInstance().openWebBrowser(redirectionException.getLocation());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }));
    }

    private void removeCallHistory(SessionInfo sessionInfo) {
        ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("remove_call_dialog"), ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                clientConnector.removeCallHistory(sessionInfo.getSessionId());
                this.iNewMessagesNotification.getSelectedItemId().ifPresent(sessionInfoId -> {
                    if (Objects.equals(sessionInfoId, sessionInfo.getSessionId())) {
                        this.iNewMessagesNotification.sessionRemoved();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        })));
    }

    @Override
    public void hideContextMenu(BaseCell selectedCell) {
        if (this.myContextMenu != null) {
            if (this.myContextMenu.isMenuShowing()) {
                this.myContextMenu.hide();
            }
            this.myContextMenu.getItems().forEach(menuItem -> menuItem.setOnAction(null));
            this.myContextMenu.getItems().clear();
        }
        if (ClientSingleton.getInstance().getCurrentViewMode() == 1) {
            selectedCell.setSelectedCellStyle(false);
        }
    }

    @Override
    public boolean isContextMenuShowing() {
        return this.myContextMenu != null && this.myContextMenu.isShowing();
    }

    protected void updateList(int mode) {
    }

    protected void clearSelections() {
    }

    protected void removeDeleteHeader() {
    }

    protected void addDeleteHeader() {
    }

    public void updateList() {
    }

    public void clearSelection() {
        this.actionWithItem((Consumer<BaseCell>)((Consumer)baseCell -> baseCell.setSelectedCellStyle(false)));
    }

    public void setTabSelectedItem() {
        this.setTabSelectedItem(true);
    }

    public void setTabSelectedItem(boolean mode) {
        this.iNewMessagesNotification.getSelectedItemId().ifPresent(itemId -> {
            BaseCell baseCell = this.getItemCell((String)itemId);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setTabSelectedItem baseCell=" + baseCell + " mode = " + mode);
            if (baseCell != null) {
                baseCell.setSelectedCellStyle(mode);
            }
        });
    }

    public BaseCell getItemCell(String id) {
        AtomicReference aSessionCell = new AtomicReference();
        AtomicReference<String> itemId = new AtomicReference<String>(id);
        if (this.currentTab == 1 || this.currentTab == 2) {
            Optional<SessionInfo> oSessionInfo = ClientSingleton.getInstance().getSessionInfo(id);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setTabSelectedItem oSessionInfo=" + oSessionInfo);
            if (oSessionInfo.isPresent() && oSessionInfo.get().getParties().size() == 1) {
                itemId.set(((ContactInfo)oSessionInfo.get().getParties().get(0)).getUserID());
            }
        }
        this.actionWithItem((Consumer<BaseCell>)((Consumer)baseCell -> {
            if (baseCell.getCellId().equals(itemId.get())) {
                aSessionCell.set(baseCell);
            }
        }));
        return (BaseCell)((Object)aSessionCell.get());
    }

    public boolean getItem(String id) {
        AtomicBoolean hasSession = new AtomicBoolean();
        if (this.currentTab == 4 || this.currentTab == 3) {
            this.dataInfoList.stream().filter(value -> id.equals(((SessionInfo)value).getSessionId())).findAny().ifPresent(value -> hasSession.set(true));
        }
        return hasSession.get();
    }

    @Override
    public void setSelectedTabCell(BaseCell cell, MouseEvent mouseEvent) {
        if (!this.isItemListUpdating.get()) {
            if (this.selectObserver == null) {
                this.initSelectBaseCellObserver();
            }
            this.selectObserver.onNext((Object)new Pair((Object)cell, (Object)mouseEvent));
        }
    }

    public String getId(BaseCell cell) {
        return this.getId(cell.getCellId());
    }

    private String getId(String cellId) {
        AtomicReference<String> id = new AtomicReference<String>(cellId);
        if (this.currentTab == 1 || this.currentTab == 2) {
            ClientSingleton.getInstance().getSessionInfo(id.get()).ifPresent(sessionInfo -> {
                if (!sessionInfo.isGroup()) {
                    id.set(ClientSingleton.getInstance().getUserID((ContactInfo)sessionInfo.getParties().get(0)));
                }
            });
        }
        return id.get();
    }

    public void setNewName(SessionInfo sessionInfo) {
        BaseCell callCell = this.getItemCell(sessionInfo.getSessionId());
        if (callCell != null) {
            ClientSingleton.getInstance().runLater(callCell::setName);
        }
    }

    public void setNewName(ContactInfo contactInfo) {
        this.actionWithItem((Consumer<BaseCell>)((Consumer)baseCell -> {
            SessionInfo sessionInfo = baseCell.getSessionInfo();
            if (sessionInfo != null && sessionInfo.getParties() != null && sessionInfo.getParties().size() == 1 && ClientSingleton.getInstance().getUserID((ContactInfo)sessionInfo.getParties().get(0)).equals(ClientSingleton.getInstance().getUserID(contactInfo))) {
                baseCell.setName();
            }
        }));
    }

    public void addScrollPane() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addScrollPane start ");
        this.addScrollPane(null);
    }

    public void addScrollPane(Pane pane) {
        if (pane == null) {
            this.getChildren().clear();
        } else {
            pane.getChildren().clear();
        }
        this.resetUpdate();
        this.virtualFlow = VirtualFlow.createVertical(this.dataInfoList, this.cellFactory);
        this.scrollPane = new VirtualizedScrollPane(this.virtualFlow, ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.AS_NEEDED);
        if (pane == null) {
            this.getChildren().add(this.scrollPane);
        } else {
            pane.getChildren().add(this.scrollPane);
        }
        AnchorPane.setTopAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setLeftAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setBottomAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setRightAnchor(this.scrollPane, (Double)0.0);
        this.setLastScrollMode(-1);
        this.lastScrollMode.addListener((observableValue, oldValue, newValue) -> {
            if (newValue.intValue() != -1 && this.timerExecutor == null) {
                this.timerExecutor = TimerExecutor.getInstance();
                this.timerExecutor.setMyAction(() -> this.setLastScrollMode(-1)).startWithDelay(1000L);
            }
        });
        this.virtualFlow.totalHeightEstimateProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.lastScrollMode.get() == SCROLL_TO_TOP && !this.dataInfoList.isEmpty()) {
                this.goToStartPosition();
            }
        });
        this.disposeDisposables();
        this.initUpdateObserver();
        this.initSelectBaseCellObserver();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addScrollPane pane=" + pane + " done");
    }

    private void goToStartPosition() {
        try {
            int position = 0;
            if (this.startPositionSupplier != null) {
                position = this.startPositionSupplier.get();
            }
            if (!Lists.isValidIndex((int)position, (int)this.dataInfoList.size())) {
                position = 0;
            }
            this.virtualFlow.getCell(position);
            this.virtualFlow.showAsFirst(position);
        }
        catch (Throwable throwable) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Error : throwable = " + throwable.getMessage());
        }
    }

    public void updateVisibleHandles() {
        ClientSingleton.getInstance().runLater(this::updateVisibleHandles_);
    }

    private void updateVisibleHandles_() {
        if (this.isItemListUpdating.get()) {
            return;
        }
        AtomicReference<String> selectedSessionId = new AtomicReference<String>("");
        this.iNewMessagesNotification.getSelectedItemId().ifPresent(selectedSessionId::set);
        for (int index = this.virtualFlow.getFirstVisibleIndex(); index <= this.virtualFlow.getLastVisibleIndex(); ++index) {
            HBox baseCell;
            Optional optional = this.virtualFlow.getCellIfVisible(index);
            if (!optional.isPresent()) continue;
            Cell visibleCell = (Cell)optional.get();
            if (visibleCell.getNode() instanceof ContactHeaderCellView) {
                ContactHeaderCellView contactHeaderCellView = (ContactHeaderCellView)visibleCell.getNode();
                if (contactHeaderCellView.getContactInfoHeader() == null || contactHeaderCellView.getContactInfoHeader().getType() != 4) continue;
                contactHeaderCellView.setTitle();
                continue;
            }
            if (visibleCell.getNode() instanceof BaseCell) {
                baseCell = (BaseCell)visibleCell.getNode();
                baseCell.updateNewMessages();
                if (this.currentTab == 1 || this.currentTab == 2) {
                    selectedSessionId.set(this.getId(selectedSessionId.get()));
                }
                baseCell.setSelectedCellStyle(selectedSessionId.get().equals(baseCell.getCellId()));
                if (!(visibleCell.getNode() instanceof ContactCellView)) continue;
                ContactCellView contactCellView = (ContactCellView)visibleCell.getNode();
                contactCellView.update();
                continue;
            }
            if (visibleCell.getNode() instanceof CallDateCellView) {
                baseCell = (CallDateCellView)visibleCell.getNode();
                baseCell.updateNode(this.isMultiSelectionMode());
                continue;
            }
            if (!(visibleCell.getNode() instanceof SessionHeaderCellView)) continue;
            baseCell = (SessionHeaderCellView)visibleCell.getNode();
            baseCell.setNewMessagesLabel();
        }
    }

    protected int getCurrentTab() {
        return this.currentTab;
    }

    public void disposeTab() {
        this.disposeDisposables();
        try {
            this.dataInfoList.clear();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "disposeTab");
    }

    private void disposeDisposables() {
        this.disposables.dispose();
        this.disposables.clear();
        this.disposables = new CompositeDisposable();
        this.disposablesSelection.dispose();
        this.disposablesSelection.clear();
        this.disposablesSelection = new CompositeDisposable();
        this.updateObserver = null;
        this.selectObserver = null;
    }

    public void dispose() {
        this.resetUpdate();
        this.disposeTab();
        this.virtualFlow.dispose();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "dispose done");
    }

    public abstract List<T> getListOnSearch(String var1);

    public void setListOnSearch(List<T> members) throws Exception {
        ArrayList<T> tmpList = new ArrayList<T>();
        for (int i = members.size() - 1; i >= 0; --i) {
            tmpList.add(0, members.get(i));
        }
        this.dataInfoList.setAll(tmpList);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getListOnSearch dataInfoList=" + this.dataInfoList.size());
    }

    protected void onUpdateItemsList(Pair<Integer, List<T>> pair) {
        this.setLastScrollMode((Integer)pair.getKey());
        List items = (List)pair.getValue();
        this.iNewMessagesNotification.getSelectedItemId().ifPresent(sessionInfoId -> items.stream().filter(item -> {
            if (item instanceof SessionInfo) {
                SessionInfo sessionInfo = (SessionInfo)item;
                return sessionInfo.getSessionId() != null && Objects.equals(sessionInfo.getSessionId(), sessionInfoId);
            }
            if (item instanceof ContactInfo) {
                ContactInfo contactInfo = (ContactInfo)item;
                return ClientSingleton.getInstance().getUserID(contactInfo) != null && ClientSingleton.getInstance().getUserID(contactInfo).equals(sessionInfoId);
            }
            return false;
        }).findAny().ifPresent(item -> {
            BaseCell callCell = this.getItemCell((String)sessionInfoId);
            if (callCell != null) {
                ClientSingleton.getInstance().runLater(() -> callCell.setSelectedCellStyle(true));
            }
        }));
    }

    protected int getVisibleCellsCount() {
        try {
            if (this.virtualFlow.getFirstVisibleIndex() >= 0 && this.virtualFlow.getLastVisibleIndex() == this.virtualFlow.getFirstVisibleIndex()) {
                return 1;
            }
            return this.virtualFlow.getLastVisibleIndex() - this.virtualFlow.getFirstVisibleIndex();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    private void initSelectBaseCellObserver() {
        this.selectObserver = PublishSubject.create();
        this.selectObserver.debounce(100L, TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).switchMap(pair -> {
            BaseCell cell = (BaseCell)((Object)((Object)pair.getKey()));
            this.setSelectedCell(cell);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setSelection 1 iNewMessagesNotification.getSelectedItemId()=" + this.iNewMessagesNotification.getSelectedItemId());
            return Observable.just((Object)pair);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(pair -> {
            BaseCell cell = (BaseCell)((Object)((Object)pair.getKey()));
            MouseEvent mouseEvent = (MouseEvent)pair.getValue();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setSelection 2 iNewMessagesNotification.getSelectedItemId()=" + this.iNewMessagesNotification.getSelectedItemId());
            if (mouseEvent != null) {
                this.iNewMessagesNotification.getSelectedItemId().ifPresent(itemId -> {
                    if (!itemId.equals(this.getId(cell))) {
                        this.iNewMessagesNotification.openSession(cell);
                    }
                });
                mouseEvent.consume();
            } else {
                this.iNewMessagesNotification.openSession(cell);
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setSelection done");
        }, Throwable::printStackTrace);
    }

    private void setSelectedCell(BaseCell cell) {
        ClientSingleton.getInstance().runLater(() -> {
            for (int index = this.virtualFlow.getFirstVisibleIndex(); index <= this.virtualFlow.getLastVisibleIndex(); ++index) {
                BaseCell baseCell;
                Cell visibleCell;
                Optional optional = this.virtualFlow.getCellIfVisible(index);
                if (!optional.isPresent() || !((visibleCell = (Cell)optional.get()).getNode() instanceof BaseCell) || !(baseCell = (BaseCell)visibleCell.getNode()).isSelectedCell()) continue;
                baseCell.setSelectedCellStyle(false);
            }
            cell.setSelectedCellStyle(true);
        });
    }

    private void actionWithItem(Consumer<BaseCell> consumer) {
        ClientSingleton.getInstance().runLater(() -> {
            for (int index = this.virtualFlow.getFirstVisibleIndex(); index <= this.virtualFlow.getLastVisibleIndex(); ++index) {
                Cell visibleCell;
                Optional optional = this.virtualFlow.getCellIfVisible(index);
                if (!optional.isPresent() || !((visibleCell = (Cell)optional.get()).getNode() instanceof BaseCell)) continue;
                BaseCell baseCell = (BaseCell)visibleCell.getNode();
                try {
                    consumer.accept((Object)baseCell);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Optional<T> getItemObject(String name) {
        return this.dataInfoList.stream().filter(item -> item.toString().equals(name)).findAny();
    }

    public String getInputTextFromSearch() {
        return this.iNewMessagesNotification.getInputTextFromSearch();
    }

    public void onRemoveSession(SessionInfo sessionInfo) {
        this.dataInfoList.stream().filter(item -> {
            if (item instanceof SessionInfo) {
                SessionInfo si = (SessionInfo)item;
                return si.getSessionId().equals(sessionInfo.getSessionId());
            }
            return false;
        }).findAny().ifPresent(si -> this.updateList());
    }

    private /* synthetic */ void lambda$initUpdateObserver$2(List tmpList, Pair pair) throws Exception {
        if ((Integer)pair.getKey() == -10) {
            if (!this.dataInfoList.isEmpty()) {
                this.dataInfoList.clear();
            }
            this.isItemListUpdating.set(false);
        } else if ((Integer)pair.getKey() == -20) {
            this.isItemListUpdating.set(false);
            this.updateVisibleHandles();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "updateList isItemListUpdating =" + this.isItemListUpdating);
        } else {
            this.onUpdateItemsList(pair);
            tmpList.addAll((Collection)pair.getValue());
            this.addItemsToList(tmpList);
        }
    }
}

