/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.calls.flow;

import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.views.settings.MyRadioButton;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallDateHandler;
import net.sipsnet.client.views.tabs.utils.IRemovebleCellInterface;

public class CallDateCellView
extends HBox {
    private final HBox hBox;
    private String title;
    private final Label fx_lbDateTitle = new Label();
    private CallDateHandler callDateHandler;
    private MyRadioButton myRadioButton;
    private boolean isMultiSelectionMode;
    private IRemovebleCellInterface iCallCellInterface;
    private final double PREF_WIDTH = 205.0;
    private String selectedColor = "#c2c5d2";
    private final EventHandler<MouseEvent> mouseEventEventHandler = mouseEvent -> {
        if (this.iCallCellInterface.isMultiSelectionMode()) {
            boolean isSelected = !this.myRadioButton.isSelected();
            this.myRadioButton.setSelected(isSelected);
            this.iCallCellInterface.selectDateCell(isSelected, this.callDateHandler.getSessionId());
            this.setSelectedDateCell(isSelected);
        }
    };

    public CallDateCellView(IRemovebleCellInterface iCallCellInterface, CallDateHandler callDateHandler) {
        this.callDateHandler = callDateHandler;
        this.iCallCellInterface = iCallCellInterface;
        this.setPrefWidth(205.0);
        this.setPrefHeight(22.0);
        this.setAlignment(Pos.CENTER);
        this.hBox = new HBox();
        this.hBox.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.hBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)this.hBox, (Priority)Priority.ALWAYS);
        this.hBox.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        HBox.setMargin((Node)this.fx_lbDateTitle, (Insets)new Insets(2.0, 2.0, 2.0, 2.0));
        this.fx_lbDateTitle.setAlignment(Pos.CENTER);
        this.fx_lbDateTitle.setPrefWidth(100.0);
        this.fx_lbDateTitle.setPrefHeight(12.0);
        this.title = ClientSingleton.getInstance().getDateMarker(callDateHandler.toString());
        this.setDefaultStyle();
        this.hBox.getChildren().add((Object)this.fx_lbDateTitle);
        this.getChildren().add((Object)this.hBox);
        this.setCallsCount(callDateHandler.getCallsCount());
        if (iCallCellInterface.isMultiSelectionMode()) {
            this.addMyRadioButton();
            this.setSelectedDateCell(iCallCellInterface.isSelectedDateForDelete(callDateHandler.getSessionId()));
        }
        if (Theme.getInstance().isDarkTheme()) {
            this.selectedColor = "#909091";
        }
    }

    public double computeMinWidth(double height) {
        return 205.0;
    }

    public double computePrefWidth(double height) {
        return 205.0;
    }

    public double computePrefHeight(double height) {
        return 22.0;
    }

    private void addMyRadioButton() {
        if (this.myRadioButton == null) {
            this.myRadioButton = new MyRadioButton();
            HBox.setMargin((Node)this.myRadioButton, (Insets)new Insets(0.0, 0.0, 0.0, 7.0));
            this.myRadioButton.setRadioRadius(13);
            this.myRadioButton.setDotRadius(7);
            this.myRadioButton.setSelected(false);
            this.myRadioButton.setOnMouseClicked(this.mouseEventEventHandler);
        }
        if (!this.getChildren().contains((Object)this.myRadioButton)) {
            this.getChildren().add(0, (Object)this.myRadioButton);
        }
    }

    public void updateNode(boolean isMultiSelectionMode) {
        if (isMultiSelectionMode) {
            this.addMyRadioButton();
            this.setDefaultStyle();
        } else {
            if (this.myRadioButton != null) {
                this.getChildren().remove((Object)this.myRadioButton);
                this.myRadioButton.setSelected(false);
            }
            this.fx_lbDateTitle.getStyleClass().clear();
            this.setDefaultStyle();
        }
    }

    private void setDefaultStyle() {
        Theme.getInstance().applyTo(Constants.CHAT_DATE_LABEL_STYLE, (Labeled)this.fx_lbDateTitle);
    }

    public void setSelectedDateCell(boolean mode) {
        if (mode) {
            Theme.getInstance().applyTo(Constants.CHAT_DATE_LABEL_STYLE, (Labeled)this.fx_lbDateTitle, this.selectedColor);
            if (this.myRadioButton != null) {
                this.myRadioButton.setBorderColor("#c2c5d2");
                this.myRadioButton.setSelected(true);
            }
        } else {
            this.setDefaultStyle();
            if (this.myRadioButton != null) {
                this.myRadioButton.setBorderColor("#646a7e");
                this.myRadioButton.setSelected(false);
            }
        }
    }

    public void setCallsCount(int callsCount) {
        this.callDateHandler.setCallsCount(callsCount);
        this.fx_lbDateTitle.setText(this.title + " (" + callsCount + ")");
    }

    public String getSessionId() {
        return this.callDateHandler.getSessionId();
    }

    public boolean isSelected() {
        return this.myRadioButton != null && this.myRadioButton.isSelected();
    }

    public void bind(CallDateHandler callDateHandler) {
        this.callDateHandler = callDateHandler;
        this.title = ClientSingleton.getInstance().getDateMarker(callDateHandler.toString());
        this.fx_lbDateTitle.setText(this.title + " (" + callDateHandler.getCallsCount() + ")");
    }

    public void dispose() {
        if (this.myRadioButton != null) {
            this.myRadioButton.setOnMouseClicked(null);
        }
        ClientSingleton.getInstance().releaseViewResources((Pane)this);
    }
}

