/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.calls.flow;

import java.util.Optional;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ArrowImageButton;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallSessionHeader;
import net.sipsnet.client.views.tabs.utils.ICallsTabActions;

public class CallHeaderCellView
extends HBox {
    private Label fx_lbTitle;
    private ArrowImageButton fx_ivArrow;
    private final ICallsTabActions iCallsTabActions;
    private CallSessionHeader callSessionHeader;

    public CallHeaderCellView(ICallsTabActions iCallsTabActions, CallSessionHeader callSessionHeader) {
        this.iCallsTabActions = iCallsTabActions;
        this.callSessionHeader = callSessionHeader;
        this.setStyle("-fx-background-color: transparent;");
        this.setPadding(new Insets(0.0, 0.0, 0.0, 12.0));
        this.initComponents();
        Optional<Boolean> isCollapsed = ClientSingleton.getInstance().getBooleanProperty("calls_collapsed");
        this.setCollapse(isCollapsed.orElse(false));
        this.setAlignment(Pos.CENTER_LEFT);
    }

    public double computeMinWidth(double height) {
        return 280.0;
    }

    public double computePrefWidth(double height) {
        return 280.0;
    }

    public double computePrefHeight(double height) {
        return 32.0;
    }

    public void setCollapse(boolean isCollapse) {
        if (this.fx_ivArrow == null) {
            HBox hBox = new HBox();
            hBox.setAlignment(Pos.CENTER);
            hBox.setPrefWidth(32.0);
            hBox.setMinWidth(32.0);
            this.fx_ivArrow = new ArrowImageButton(!isCollapse);
            this.fx_ivArrow.setSize(14, 14);
            this.fx_ivArrow.setBackgroundColor("transparent");
            this.fx_ivArrow.setReleaseFocusAfterClick(true);
            hBox.getChildren().add((Object)this.fx_ivArrow);
            this.getChildren().add((Object)hBox);
            ClientSingleton.getInstance().setMouseCursor((Node)hBox);
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbTitle);
            this.fx_ivArrow.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.fx_ivArrow.makeClick()));
            this.updateArrowTitle(isCollapse);
            hBox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                this.collapse();
                this.fx_ivArrow.makeClick();
            });
            this.fx_lbTitle.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                this.collapse();
                this.fx_ivArrow.makeClick();
            });
        }
        ClientSingleton.getInstance().setProperty("calls_collapsed", isCollapse);
    }

    private void collapse() {
        boolean isCollapse = !this.callSessionHeader.isCollapse();
        this.callSessionHeader.setCollapse(isCollapse);
        this.updateArrowTitle(isCollapse);
        this.iCallsTabActions.refreshCallList();
    }

    private void updateArrowTitle(boolean isCollapse) {
        String title = "";
        title = !isCollapse ? ClientSingleton.getInstance().getString("call_show_all") : ClientSingleton.getInstance().getString("call_show_missed");
        this.fx_lbTitle.setText(title);
    }

    private void initComponents() {
        this.prefHeight(32.0);
        this.minHeight(32.0);
        this.fx_lbTitle = new Label();
        this.fx_lbTitle.prefHeight(40.0);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbTitle);
        this.fx_lbTitle.setStyle("-fx-font-size: 13px;");
        this.getChildren().add((Object)this.fx_lbTitle);
        VBox.setMargin((Node)this, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
    }

    public void bind(CallSessionHeader sessionInfo) {
        this.callSessionHeader = this.callSessionHeader;
    }
}

