/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.contacts.flow;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjavafx.observables.JavaFxObservable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.buttoncombobox.MenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ArrowImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.views.contactsgroup.createeditgroup.ContactsGroupCreatorEditor;
import net.sipsnet.client.views.settings.SettingUtil;
import net.sipsnet.client.views.tabs.contacts.flow.util.ContactInfoHeader;
import net.sipsnet.client.views.tabs.utils.IContactsTabActions;
import smile.cti.client.ContactInfo;

public class ContactHeaderCellView
extends HBox {
    private Label fx_lbTitle;
    private final IContactsTabActions iTabActions;
    private ContactInfoHeader contactInfoHeader;
    private Disposable disposableSpellMouseHandler;
    private ImageButton imageButton;
    private HBox hBox;

    public double computeMinWidth(double height) {
        return 280.0;
    }

    public double computePrefWidth(double height) {
        return 280.0;
    }

    public double computePrefHeight(double height) {
        return 32.0;
    }

    public ContactHeaderCellView(IContactsTabActions iTabActions, ContactInfoHeader contactInfoHeader) {
        this.contactInfoHeader = contactInfoHeader;
        this.iTabActions = iTabActions;
        this.setStyle("-fx-background-color: transparent;");
        this.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.initComponents();
        this.setTitle();
    }

    public void bind(ContactInfoHeader contactInfoHeader) {
        this.contactInfoHeader = contactInfoHeader;
        this.setTitle();
    }

    public void setTitle() {
        this.fx_lbTitle.setText(this.contactInfoHeader.toString());
    }

    public ContactInfoHeader getContactInfoHeader() {
        return this.contactInfoHeader;
    }

    private void initComponents() {
        this.setAlignment(Pos.CENTER_LEFT);
        this.hBox = new HBox();
        this.hBox.prefHeight(22.0);
        HBox.setMargin((Node)this.hBox, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        this.hBox.setAlignment(Pos.CENTER_LEFT);
        this.fx_lbTitle = new Label();
        this.fx_lbTitle.prefHeight(40.0);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbTitle);
        this.fx_lbTitle.setStyle("-fx-font-size: 13px;");
        HBox.setHgrow((Node)this.hBox, (Priority)Priority.ALWAYS);
        this.hBox.getChildren().add((Object)this.fx_lbTitle);
        this.getChildren().add((Object)this.hBox);
        PublishSubject mouseEventPublishSubject = PublishSubject.create();
        if (this.contactInfoHeader.getType() == 4 || this.contactInfoHeader.getType() == 5 || this.contactInfoHeader.getType() == 6) {
            if (!this.contactInfoHeader.isCollapse()) {
                this.getBackImageButton("other/arrow_back.png", this.getHideGroupMouseEventEventHandler());
                this.fx_lbTitle.setOnMousePressed(this.getHideGroupMouseEventEventHandler());
                this.hBox.setOnMousePressed(this.getHideGroupMouseEventEventHandler());
                this.getChildren().add(0, (Object)this.imageButton);
                this.addMenuButton();
            } else {
                this.getBackImageButton("other/dark_chevron_right.png", this.getShowGroupMouseEventHandler());
                this.fx_lbTitle.setOnMousePressed(this.getShowGroupMouseEventHandler());
                this.hBox.setOnMousePressed(this.getShowGroupMouseEventHandler());
                this.getChildren().add((Object)this.imageButton);
            }
        } else if (this.contactInfoHeader.getType() == 3) {
            if (!this.contactInfoHeader.isCollapse()) {
                this.getBackImageButton("other/arrow_back.png", this.getHideGroupMouseEventEventHandler());
                this.getChildren().add(0, (Object)this.imageButton);
                this.addMenuButton();
            } else {
                this.addMenuButton();
            }
        } else {
            ArrowImageButton fx_ivArrow = new ArrowImageButton(!this.contactInfoHeader.isCollapse());
            fx_ivArrow.setSize(22, 22);
            fx_ivArrow.setBackgroundColor("transparent");
            this.getChildren().add((Object)fx_ivArrow);
            this.disposableSpellMouseHandler = mouseEventPublishSubject.debounce(200L, TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).observeOn((Scheduler)JavaFxScheduler.platform()).flatMap(mouseEvent -> {
                this.contactInfoHeader.setCollapse();
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "contactInfoHeader 1 " + this.contactInfoHeader + " contactInfoHeader.isCollapse()=" + this.contactInfoHeader.isCollapse());
                if (this.contactInfoHeader.isCollapse()) {
                    this.iTabActions.removeCells(this.contactInfoHeader);
                } else {
                    this.iTabActions.addCells(this.contactInfoHeader);
                }
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "contactInfoHeader 2 " + this.contactInfoHeader + " contactInfoHeader.isCollapse()=" + this.contactInfoHeader.isCollapse());
                return Observable.just((Object)this.contactInfoHeader.isCollapse());
            }).subscribe(isCollapsed -> fx_ivArrow.makeClick(isCollapsed != false ? 1 : 0));
            ClientSingleton.getInstance().setMouseCursor((Node)fx_ivArrow);
            JavaFxObservable.eventsOf((Node)fx_ivArrow, (EventType)MouseEvent.MOUSE_CLICKED).subscribe((Observer)mouseEventPublishSubject);
            JavaFxObservable.eventsOf((Node)this.fx_lbTitle, (EventType)MouseEvent.MOUSE_CLICKED).subscribe((Observer)mouseEventPublishSubject);
            JavaFxObservable.eventsOf((Node)this.hBox, (EventType)MouseEvent.MOUSE_CLICKED).subscribe((Observer)mouseEventPublishSubject);
        }
        ClientSingleton.getInstance().setMouseCursor((Node)this.hBox);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbTitle);
    }

    private void addMenuButton() {
        MenuImageButton fx_ivMenu = new MenuImageButton();
        fx_ivMenu.setBackgroundColor("transparent");
        fx_ivMenu.setSize(14, 22);
        ClientSingleton.getInstance().setImageToImageView(fx_ivMenu, "buttons/dot_menu.png");
        this.makeMenu(fx_ivMenu);
        HBox.setMargin((Node)fx_ivMenu, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.getChildren().add((Object)fx_ivMenu);
    }

    private void getBackImageButton(String imagePath, EventHandler<MouseEvent> HideGroupMouseEventEventHandler) {
        this.imageButton = new ImageButton();
        this.imageButton.setBackgroundColor("transparent");
        this.imageButton.setSize(20, 22);
        this.imageButton.setImagePath(imagePath);
        ClientSingleton.getInstance().setMouseCursor((Node)this.imageButton);
        this.imageButton.setOnMousePressed(HideGroupMouseEventEventHandler);
    }

    private void makeMenu(MenuImageButton fx_ivMenu) {
        if (this.contactInfoHeader.getType() == 3) {
            if (this.contactInfoHeader.isCollapse()) {
                fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("group_create_group"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                    ContactsGroupCreatorEditor createContactProfileController = new ContactsGroupCreatorEditor();
                    createContactProfileController.show();
                    fx_ivMenu.hideMenu();
                }));
            }
            fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("group_select_contacts"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                this.contactInfoHeader.setCollapse(false);
                this.iTabActions.addCells(this.contactInfoHeader);
                fx_ivMenu.hideMenu();
                TimerExecutor.getInstance().setMyAction(this.iTabActions::setMultiselectMode).startWithDelayInGUIThread(500L);
            }));
            if (this.contactInfoHeader.isCollapse()) {
                fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("contacts_import"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                    fx_ivMenu.hideMenu();
                    SettingUtil.getInstance().importContacts(() -> {}, allContacts -> {
                        ContactsGroupCreatorEditor createContactProfileController = new ContactsGroupCreatorEditor((List<ContactInfo>)allContacts);
                        createContactProfileController.show();
                    });
                }));
            }
        } else {
            fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("group_edit_group"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                ContactsGroupCreatorEditor createContactProfileController = new ContactsGroupCreatorEditor(this.contactInfoHeader.toString());
                createContactProfileController.show();
                fx_ivMenu.hideMenu();
            }));
            fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("group_select_contacts"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                this.iTabActions.setMultiselectMode();
                fx_ivMenu.hideMenu();
            }));
            if (this.contactInfoHeader.getType() == 5) {
                fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("contacts_import"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                    fx_ivMenu.hideMenu();
                    SettingUtil.getInstance().importContacts(() -> {}, allContacts -> {
                        ContactsGroupCreatorEditor createContactProfileController = new ContactsGroupCreatorEditor(this.contactInfoHeader.toString(), (List<ContactInfo>)allContacts);
                        createContactProfileController.show();
                    });
                }));
                fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("contacts_delete_group"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("chat_delete_group"), ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> MyThreadPoolManager.getInstance().execute(() -> {
                        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("call_delete_message"));
                        try {
                            String groupName = this.contactInfoHeader.toString();
                            String groupId = clientConnector.getContactListId(groupName);
                            clientConnector.deleteContactList(groupId);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ClientSingleton.getInstance().removeLoadingPane();
                        this.hideGroup();
                    }))));
                    fx_ivMenu.hideMenu();
                }), "#e65d5d");
            }
        }
    }

    private EventHandler<MouseEvent> getHideGroupMouseEventEventHandler() {
        return event -> this.hideGroup();
    }

    private void hideGroup() {
        this.iTabActions.removeMultiSelectionMode();
        this.contactInfoHeader.setCollapse(this.contactInfoHeader.getType() != 3);
        this.iTabActions.removeCells(this.contactInfoHeader);
    }

    private EventHandler<MouseEvent> getShowGroupMouseEventHandler() {
        return event -> {
            this.contactInfoHeader.setCollapse(false);
            this.iTabActions.addCells(this.contactInfoHeader);
        };
    }

    public void dispose() {
        if (this.imageButton != null) {
            this.imageButton.setOnMousePressed(null);
        }
        if (this.fx_lbTitle != null) {
            this.fx_lbTitle.setOnMousePressed(null);
        }
        if (this.hBox != null) {
            this.hBox.setOnMousePressed(null);
        }
        if (this.disposableSpellMouseHandler != null) {
            this.disposableSpellMouseHandler.dispose();
        }
    }
}

