/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.contacts.flow;

import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.tabs.contacts.flow.ContactCellView;
import net.sipsnet.client.views.tabs.contacts.flow.ContactHeaderCellView;
import net.sipsnet.client.views.tabs.contacts.flow.TabContactsWithGroupController;
import net.sipsnet.client.views.tabs.contacts.flow.util.ContactInfoHeader;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.IContactsTabActions;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import org.fxmisc.flowless.Cell;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class ContactInfoCell
implements Cell<ContactInfo, Node> {
    private final INewMessagesNotification iNewMessagesNotification;
    private final IContactsTabActions iContactsTabActions;
    private Pane contactCell;
    private final BaseCell.ITEM_MODE item_mode;

    public ContactInfoCell(BaseCell.ITEM_MODE item_mode, ContactInfo contactInfo, IContactsTabActions iContactsTabActions, INewMessagesNotification iNewMessagesNotification) {
        this.iContactsTabActions = iContactsTabActions;
        this.iNewMessagesNotification = iNewMessagesNotification;
        this.item_mode = item_mode;
        this.initCell(contactInfo);
    }

    private void initCell(ContactInfo contactInfo) {
        if (contactInfo instanceof ContactInfoHeader) {
            this.dispose();
            ContactInfoHeader contactInfoHeader = (ContactInfoHeader)contactInfo;
            this.contactCell = new ContactHeaderCellView(this.iContactsTabActions, contactInfoHeader);
            ClientSingleton.getInstance().setFocusNotTraversable(this.contactCell);
            this.contactCell.prefWidthProperty().bind((ObservableValue)((TabContactsWithGroupController)this.iContactsTabActions).widthProperty().subtract(10));
        } else {
            this.createContactInfoCell(contactInfo);
        }
    }

    private void createContactInfoCell(ContactInfo contactInfo) {
        if (this.contactCell instanceof ContactCellView) {
            ((ContactCellView)this.contactCell).bind(contactInfo);
        } else {
            this.dispose();
            this.contactCell = new ContactCellView(this.item_mode, this.iContactsTabActions, contactInfo, this.iNewMessagesNotification);
            ClientSingleton.getInstance().setFocusNotTraversable(this.contactCell);
            this.contactCell.prefWidthProperty().bind((ObservableValue)((TabContactsWithGroupController)this.iContactsTabActions).widthProperty().subtract(10));
        }
        if (this.iNewMessagesNotification != null) {
            this.iNewMessagesNotification.getSelectedItemId().ifPresent(selectedId -> {
                Optional<SessionInfo> optional = ClientSingleton.getInstance().getSessionInfo((String)selectedId);
                if (optional.isPresent()) {
                    SessionInfo sessionInfo = optional.get();
                    if (sessionInfo.getParties().size() == 1) {
                        ((ContactCellView)this.contactCell).setSelectedCellStyle(ClientSingleton.getInstance().isEqualsContacts(sessionInfo, contactInfo));
                    } else {
                        ((ContactCellView)this.contactCell).setSelectedCellStyle(false);
                    }
                } else {
                    ((ContactCellView)this.contactCell).setSelectedCellStyle(Objects.equals(ClientSingleton.getInstance().getUserID(contactInfo), selectedId));
                }
            });
        }
    }

    public Pane getNode() {
        return this.contactCell;
    }

    public boolean isReusable() {
        return false;
    }

    public void updateItem(ContactInfo contactInfo) {
        this.initCell(contactInfo);
    }

    public void dispose() {
        if (this.contactCell != null) {
            this.contactCell.prefWidthProperty().unbind();
            if (this.contactCell instanceof ContactCellView) {
                ((ContactCellView)this.contactCell).dispose();
            } else {
                ClientSingleton.getInstance().releaseViewResources(this.contactCell);
            }
            this.contactCell = null;
        }
    }
}

