/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.contacts.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.MyPair;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.contacts.flow.ContactCellView;
import net.sipsnet.client.views.tabs.contacts.flow.ContactHeaderCellView;
import net.sipsnet.client.views.tabs.contacts.flow.ContactInfoCell;
import net.sipsnet.client.views.tabs.contacts.flow.util.ContactInfoHeader;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.ICellSelection;
import net.sipsnet.client.views.tabs.utils.IContactsTabActions;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import net.sipsnet.client.views.tabs.utils.TabBaseViewWithRemoveCells;
import org.fxmisc.flowless.Cell;
import smile.cti.client.ContactInfo;
import smile.util.RedirectionException;

public class TabContactsWithGroupController
extends TabBaseViewWithRemoveCells<ContactInfo>
implements IGUIObservable,
IContactsTabActions,
ICellSelection {
    private final List<ContactInfoHeader> headers = new ArrayList<ContactInfoHeader>();
    private int savedScrollPosition;
    private AnchorPane anchorScrollPane;
    private final boolean isNewUnselect = false;

    public TabContactsWithGroupController(INewMessagesNotification iNewMessagesNotification, int currentTab) {
        super(currentTab, iNewMessagesNotification);
        this.collapseServices();
        AnchorPane.setTopAnchor((Node)this.fx_bvMainBox, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.fx_bvMainBox, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.fx_bvMainBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.fx_bvMainBox, (Double)0.0);
        this.getChildren().add((Object)this.fx_bvMainBox);
        this.initObservable();
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this);
        BaseCell.ITEM_MODE item_mode = currentTab == 1 ? BaseCell.ITEM_MODE.AUTORIZED_CONTACT_ITEM : BaseCell.ITEM_MODE.NOT_AUTORIZED_CONTACT_ITEM;
        this.setCellFactory(contactInfo -> new ContactInfoCell(item_mode, (ContactInfo)contactInfo, this, this.iNewMessagesNotification), integer -> {
            if (this.groupContactInfoHeader != null) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "REFRESH getInputTextFromSearch " + iNewMessagesNotification.getInputTextFromSearch() + " size=" + this.groupContactInfoHeader.getMemberLists().size() + " groupContactInfoHeader.getType()" + this.groupContactInfoHeader.getType());
                if (iNewMessagesNotification.getInputTextFromSearch().isEmpty()) {
                    if (this.groupContactInfoHeader.getType() == 5 && this.groupContactInfoHeader.getMemberLists().isEmpty()) {
                        ArrayList<ContactInfo> members = new ArrayList<ContactInfo>();
                        List ids = ClientSingleton.getInstance().getClientConnector().get().getContactList(this.groupContactInfoHeader.toString());
                        for (String id : ids) {
                            ClientSingleton.getInstance().getContactInfoByUserId(id).ifPresent(members::add);
                        }
                        this.groupContactInfoHeader.setMemberLists(members);
                    } else if (this.groupContactInfoHeader.getType() == 4 && this.groupContactInfoHeader.getMemberLists().isEmpty()) {
                        return this.getListOfGroupOnSearch("");
                    }
                    return new ArrayList<ContactInfo>(this.groupContactInfoHeader.getMemberLists());
                }
                return this.getListOfGroupOnSearch(iNewMessagesNotification.getInputTextFromSearch());
            }
            if (iNewMessagesNotification.getInputTextFromSearch().isEmpty()) {
                return UpdateLists.updateContactsList(this.headers, this.getCurrentTab() == 1);
            }
            return this.getListOnSearch(iNewMessagesNotification.getInputTextFromSearch());
        });
        this.addScrollPane();
        this.setStartPositionSupplier(() -> this.savedScrollPosition);
    }

    @Override
    public void setGroupHeader(ContactInfoHeader groupContactInfoHeader) {
        this.groupContactInfoHeader = groupContactInfoHeader;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setGroupHeader = " + groupContactInfoHeader);
        this.setOpacity(0.0);
        if (groupContactInfoHeader != null) {
            MyPair<Long, List<ContactInfo>> myPair;
            this.headers.clear();
            this.iNewMessagesNotification.setContactsGroupView(new ContactHeaderCellView(this, groupContactInfoHeader));
            if (groupContactInfoHeader.getType() == 4 && !(myPair = ClientSingleton.getInstance().getServiceContacts(groupContactInfoHeader.getServiceId(), "")).hasLastException() && myPair.getSecond() != null) {
                groupContactInfoHeader.setMemberLists(myPair.getSecond());
            }
            this.updateList();
        } else {
            this.savedScrollPosition = 0;
            this.iNewMessagesNotification.setContactsGroupView(null);
            this.setContactsList();
        }
    }

    public void clearServiceList() {
        if (this.groupContactInfoHeader != null && this.groupContactInfoHeader.getType() == 4) {
            this.groupContactInfoHeader.clearMembers();
        }
    }

    public void setContactsList() {
        for (ContactInfoHeader contactInfoHeader : this.headers) {
            contactInfoHeader.clearMembers();
        }
        this.headers.clear();
        if (this.getCurrentTab() == 1) {
            this.headers.add(new ContactInfoHeader(true, 0, this.getTitle(0)));
            this.headers.add(new ContactInfoHeader(true, 1, this.getTitle(1)));
            this.headers.add(new ContactInfoHeader(true, 2, this.getTitle(2)));
        } else {
            this.addServices();
            this.addContactsGroups();
            Collections.sort(this.headers, Comparator.comparing(ContactInfoHeader::toString));
            ContactInfoHeader favorites = new ContactInfoHeader(false, 0, this.getTitle(0));
            this.headers.add(favorites);
            this.headers.add(new ContactInfoHeader(false, 3, this.getTitle(3)));
        }
        if (this.groupContactInfoHeader != null) {
            this.iNewMessagesNotification.setContactsGroupView(new ContactHeaderCellView(this, this.groupContactInfoHeader));
        }
        this.updateList();
    }

    private void addServices() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                List list = clientConnector.getServices();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "addServices list=" + list);
                if (list != null && !list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        HashMap pair = (HashMap)list.get(i);
                        String title = (String)pair.get("name");
                        String serviceId = (String)pair.get("serviceid");
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "addServices title=" + title + " serviceId=" + serviceId);
                        ContactInfoHeader contactInfoHeader = new ContactInfoHeader(false, 4, title);
                        this.addHeader(contactInfoHeader, serviceId);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private void addHeader(ContactInfoHeader contactInfoHeader, String serviceId) {
        Optional<ContactInfoHeader> optionalContactInfoHeader = this.headers.stream().filter(contactInfoHeader1 -> {
            try {
                return contactInfoHeader1.equalsHeader((Object)contactInfoHeader);
            }
            catch (Exception ex) {
                return false;
            }
        }).findAny();
        if (optionalContactInfoHeader.isEmpty()) {
            if (serviceId != null) {
                contactInfoHeader.setServiceId(serviceId);
            }
            this.headers.add(contactInfoHeader);
        }
    }

    private void addContactsGroups() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                HashSet hashSet = (HashSet)clientConnector.getContactListNames();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "getContactListNames()=" + hashSet);
                if (hashSet != null && !hashSet.isEmpty()) {
                    ArrayList list = new ArrayList(hashSet);
                    for (String title : list) {
                        ContactInfoHeader contactInfoHeader = new ContactInfoHeader(false, 5, title);
                        this.addHeader(contactInfoHeader, null);
                        List ids = clientConnector.getContactList(title);
                        ArrayList<ContactInfo> contacts = new ArrayList<ContactInfo>();
                        ids.forEach(id -> ClientSingleton.getInstance().getContactInfoByUserId((String)id).ifPresent(contacts::add));
                        contactInfoHeader.setMemberLists(contacts);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private void collapseServices() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                List list = clientConnector.getServices();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "addServices list=" + list);
                if (list != null && !list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        HashMap pair = (HashMap)list.get(i);
                        String title = (String)pair.get("name");
                        ClientSingleton.getInstance().setProperty(title, true);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public void updateList() {
        this.updateList(SCROLL_TO_TOP);
    }

    @Override
    public void updateList(int mode) {
        super.updateListItems(mode);
    }

    @Override
    public List<ContactInfo> getListOnSearch(String prefix) {
        if (this.groupContactInfoHeader != null) {
            return this.getListOfGroupOnSearch(prefix);
        }
        ArrayList<? extends ContactInfo> members = new ArrayList<ContactInfo>();
        this.headers.forEach(contactInfoHeader -> members.addAll(contactInfoHeader.getMemberAllItems()));
        if (this.getCurrentTab() == 2) {
            this.headers.forEach(contactInfoHeader -> {
                MyPair<Long, List<ContactInfo>> myPair;
                if (contactInfoHeader.getType() == 4 && !(myPair = ClientSingleton.getInstance().getServiceContacts(contactInfoHeader.getServiceId(), prefix)).hasLastException() && myPair.getSecond() != null) {
                    members.addAll(myPair.getSecond().stream().filter(contactInfo -> contactInfo.toString().toLowerCase().contains(prefix.toLowerCase())).collect(Collectors.toList()));
                }
            });
            members.addAll(ClientSingleton.getInstance().getContactFromGroupsList(prefix));
        }
        return members.stream().filter(contactInfo -> {
            if (this.getCurrentTab() == 2) {
                return ClientSingleton.getInstance().isContactInfoInTheList((ContactInfo)contactInfo, prefix.toLowerCase());
            }
            return contactInfo.toString().toLowerCase().contains(prefix.toLowerCase());
        }).filter(ClientSingleton.getInstance().distinctByKey(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo) == null ? String.valueOf(contactInfo.hashCode()) : ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
    }

    private List<ContactInfo> getListOfGroupOnSearch(String prefix) {
        List<ContactInfo> members = new ArrayList<ContactInfo>();
        if (this.groupContactInfoHeader.getType() != 4) {
            members = this.findInMembers(prefix, members);
        } else {
            MyPair<Long, List<ContactInfo>> myPair = ClientSingleton.getInstance().getServiceContacts(this.groupContactInfoHeader.getServiceId(), prefix);
            if (!myPair.hasLastException() && myPair.getSecond() != null) {
                members.addAll(myPair.getSecond().stream().filter(contactInfo -> contactInfo.toString().toLowerCase().contains(prefix.toLowerCase())).collect(Collectors.toList()));
            } else {
                members = this.findInMembers(prefix, members);
            }
        }
        return members;
    }

    private List<ContactInfo> findInMembers(String prefix, List<ContactInfo> members) {
        members.addAll(this.groupContactInfoHeader.getMemberLists());
        members = members.stream().filter(contactInfo -> contactInfo.toString().toLowerCase().contains(prefix.toLowerCase())).filter(ClientSingleton.getInstance().distinctByKey(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo) == null ? String.valueOf(contactInfo.hashCode()) : ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
        return members;
    }

    private void initObservable() {
        String[] actions = new String[]{IntentConstants.CONTACT_ADDED, IntentConstants.CONTACT_STATUS_CHANGED};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
        for (ContactInfoHeader contactInfoHeader : this.headers) {
            if (contactInfoHeader.getType() != 4 || contactInfo == null) continue;
            contactInfoHeader.removeMember(contactInfo);
        }
        this.updateList();
    }

    public void updateHandler(String userId) {
        ContactCellView ContactCellView2 = this.getContactCell_New(userId);
        if (ContactCellView2 != null) {
            ContactCellView2.update();
        }
    }

    private ContactCellView getContactCell_New(String userId) {
        AtomicReference aContactCell_New = new AtomicReference();
        IntStream.range(0, this.dataInfoList.size()).forEach(index -> {
            Optional optional;
            ContactInfo contactInfo = (ContactInfo)this.dataInfoList.get(index);
            if (userId.equals(ClientSingleton.getInstance().getUserID(contactInfo) == null ? String.valueOf(contactInfo.hashCode()) : ClientSingleton.getInstance().getUserID(contactInfo)) && (optional = this.virtualFlow.getCellIfVisible(index)).isPresent()) {
                Cell visibleCell = (Cell)optional.get();
                aContactCell_New.set((ContactCellView)visibleCell.getNode());
            }
        });
        return (ContactCellView)aContactCell_New.get();
    }

    private String getTitle(int type) {
        String title = "";
        switch (type) {
            case 0: 
            case 6: {
                title = ClientSingleton.getInstance().getString("contacts_favorites");
                break;
            }
            case 1: {
                title = ClientSingleton.getInstance().getString("contacts_users");
                break;
            }
            case 3: {
                title = ClientSingleton.getInstance().getString("contacts_contacts");
                break;
            }
            case 2: {
                title = ClientSingleton.getInstance().getString("contacts_extensions");
            }
        }
        return title;
    }

    @Override
    public void removeCells(ContactInfoHeader contactInfoHeader) {
        if (contactInfoHeader.getType() == 4 || contactInfoHeader.getType() == 5 || contactInfoHeader.getType() == 6 || contactInfoHeader.getType() == 3) {
            this.setGroupHeader(null);
        } else {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "removeCells contactInfoHeader = " + contactInfoHeader + " type = " + contactInfoHeader.getType() + " getMemberLists=" + contactInfoHeader.getMemberLists());
            int i = Collections.indexOfSubList(this.dataInfoList, contactInfoHeader.getMemberLists());
            if (i != -1) {
                this.dataInfoList.subList(i, i + contactInfoHeader.getMemberLists().size()).clear();
            }
        }
    }

    public void removeGroupHeader() {
        this.setGroupHeader(null);
    }

    @Override
    public void addCells(ContactInfoHeader contactInfoHeader) {
        if (contactInfoHeader.getType() == 4) {
            this.addServicesContactsToList(contactInfoHeader);
        } else if (contactInfoHeader.getType() == 5 || contactInfoHeader.getType() == 6 || contactInfoHeader.getType() == 3) {
            this.setGroupHeader(contactInfoHeader);
        } else {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "addCells contactInfoHeader = " + contactInfoHeader + " type = " + contactInfoHeader.getType() + " getMemberLists=" + contactInfoHeader.getMemberLists());
            int i = Collections.indexOfSubList(this.dataInfoList, Collections.singletonList(contactInfoHeader));
            if (i != -1) {
                this.dataInfoList.addAll(i + 1, contactInfoHeader.getMemberLists());
            }
        }
    }

    private void test(ContactInfoHeader contactInfoHeader) {
        String relocate = "https://alexandco.zendesk.com/oauth/authorizations/new?response_type=code&client_id=ringotel-test&redirect_uri=https://shell.ringotel.co/services/Zendesk&scope=read%20write&state=16469200264754867928@16469197204683222026";
        ClientSingleton.getInstance().openWebBrowser(relocate);
    }

    public void addServicesContactsToList(ContactInfoHeader contactInfoHeader) {
        Exception exception;
        contactInfoHeader.clearMembers();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addServicesContactsToList = " + contactInfoHeader);
        MyPair<Long, List<ContactInfo>> myPair = ClientSingleton.getInstance().getServiceContacts(contactInfoHeader.getServiceId(), "");
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addServicesContactsToList myPair = " + myPair.hasLastException());
        if (myPair.hasLastException() && (exception = myPair.getLastException()) instanceof RedirectionException) {
            ClientSingleton.getInstance().removeLoadingPane();
            ClientSingleton.getInstance().openWebBrowser(((RedirectionException)((Object)exception)).getLocation());
            return;
        }
        List<ContactInfo> contactInfoList = myPair.getSecond();
        if (contactInfoList != null) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "loadedServiceContacts list count= " + contactInfoList.size());
            contactInfoHeader.setMemberLists(contactInfoList);
        }
        this.updateServiceList(contactInfoHeader, false, contactInfoHeader.getServiceId());
    }

    private void updateServiceList(ContactInfoHeader contactInfoHeader, boolean isMemberListEmpty, String serviceId) {
        ClientSingleton.getInstance().runLater(() -> {
            if (contactInfoHeader.isLargeMemberList()) {
                if (isMemberListEmpty) {
                    String message = ClientSingleton.getInstance().getString("downloaded_service_contacts_warning");
                    message = message.replace("@", String.valueOf(1000));
                    message = message.replace("#", serviceId);
                    ClientSingleton.getInstance().showAlert(message);
                }
                this.updateHeader();
            }
            this.setGroupHeader(contactInfoHeader);
            ClientSingleton.getInstance().removeLoadingPane();
        });
    }

    private void updateHeader() {
        this.updateVisibleHandles();
    }

    @Override
    public void addScrollPane() {
        this.releaseScrollPane();
        this.anchorScrollPane = new AnchorPane();
        this.anchorScrollPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        super.addScrollPane((Pane)this.anchorScrollPane);
        VBox.setVgrow((Node)this.anchorScrollPane, (Priority)Priority.ALWAYS);
        this.fx_bvMainBox.getChildren().add((Object)this.anchorScrollPane);
    }

    private void releaseScrollPane() {
        if (!this.fx_bvMainBox.getChildren().isEmpty()) {
            this.fx_bvMainBox.getChildren().remove((Object)this.anchorScrollPane);
            if (this.anchorScrollPane != null) {
                this.anchorScrollPane.prefWidthProperty().unbind();
            }
        }
    }

    public void contactInfoRemoved(ContactInfo contactInfo) {
        this.dataInfoList.removeIf(contactInfo1 -> ClientSingleton.getInstance().getUserID(contactInfo).equals(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo1)));
        this.dataInfoList.stream().filter(contactInfo1 -> contactInfo1 instanceof ContactInfoHeader).collect(Collectors.toList()).forEach(contactInfo1 -> ((ContactInfoHeader)((Object)contactInfo1)).removeMember(contactInfo));
    }

    @Override
    public void setMultiselectMode() {
        this.isMultiSelectionMode.set(true);
    }

    @Override
    public void removeMultiSelectionMode() {
        this.isMultiSelectionMode.set(false);
    }

    public void setServiceContacts(String serviceId, List<ContactInfo> list) {
        if (this.groupContactInfoHeader != null && this.groupContactInfoHeader.getServiceId().equals(serviceId)) {
            this.groupContactInfoHeader.setMemberLists(list);
            this.updateList();
        }
    }

    public void contactGroupsListChanged() {
        this.setGroupHeader(null);
        this.setContactsList();
    }

    public void saveScrollPosition() {
        this.savedScrollPosition = this.virtualFlow.getFirstVisibleIndex();
        if (this.savedScrollPosition < 0) {
            this.savedScrollPosition = 0;
        }
    }
}

