/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.base;

import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;

public class SearchBaseViewWithTextFlow
extends AnchorPane {
    protected SearchObject searchObject;
    protected final int LEFT_PADDING = 10;
    private final String unSelectedColor;
    private String selectedColor = ClientSingleton.getInstance().getStyleValue(Constants.TABS_SELECTED_CELL);
    protected final ISearchSelectionItem iSearchSelectionItem;
    private final VBox vbContent = new VBox();
    private boolean isMouseEntered = false;
    private EventHandler<MouseEvent> mouseEnteredEvent;
    private EventHandler<MouseEvent> mouseExitedEvent;
    private EventHandler<MouseEvent> mousePressedEvent;

    public ISearchSelectionItem getiSearchSelectionItem() {
        return this.iSearchSelectionItem;
    }

    public double computeMinWidth(double height) {
        return 280.0;
    }

    public double computePrefWidth(double height) {
        return 280.0;
    }

    public SearchBaseViewWithTextFlow(final SearchObject searchObject, ISearchSelectionItem iSearchSelectionItem, String color) {
        this.searchObject = searchObject;
        this.iSearchSelectionItem = iSearchSelectionItem;
        this.unSelectedColor = color;
        EventHandler scrollEvent = iSearchSelectionItem::chatFireScrollEvent;
        this.addEventFilter(ScrollEvent.ANY, scrollEvent);
        this.setPadding(new Insets(0.0, 0.0, 0.0, 18.0));
        this.getChildren().add((Object)this.vbContent);
        this.addMouseExitedEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            this.setItemStyle(this.unSelectedColor);
            this.isMouseEntered = false;
        }));
        this.addMouseEnteredEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            this.isMouseEntered = true;
            this.setItemStyle(this.selectedColor);
        }));
        if ((searchObject.getType() == SearchObject.ITEM_MODE.CONTACT_ITEM || searchObject.getType() == SearchObject.ITEM_MODE.SESSION_ITEM) && Theme.getInstance().isDarkTheme()) {
            this.selectedColor = ClientSingleton.getInstance().getStyleValue(Constants.TABS_SELECTED_CELL);
        }
        AnchorPane.setTopAnchor((Node)this.vbContent, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.vbContent, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.vbContent, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.vbContent, (Double)0.0);
        this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                searchObject.setViewHeight(newValue.intValue());
            }
        });
    }

    public void checkSelected() {
        if (this.isMouseEntered) {
            this.setItemStyle(this.selectedColor);
        }
    }

    protected void addChild(Pane pane) {
        if (!this.vbContent.getChildren().contains((Object)pane)) {
            this.vbContent.getChildren().add((Object)pane);
        }
    }

    protected void addChild(int index, Pane pane) {
        if (!this.vbContent.getChildren().contains((Object)pane)) {
            this.vbContent.getChildren().add(index, (Object)pane);
        }
    }

    protected void removeChild(Pane pane) {
        this.vbContent.getChildren().remove((Object)pane);
    }

    protected boolean hasChild(Pane pane) {
        return this.vbContent.getChildren().contains((Object)pane);
    }

    protected void bindWidth(Pane pane) {
        pane.prefWidthProperty().bind((ObservableValue)this.vbContent.widthProperty().subtract(10));
    }

    public void addMousePressedEvent(EventHandler<MouseEvent> mousePressedEvent) {
        this.mousePressedEvent = mousePressedEvent;
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, mousePressedEvent);
    }

    public void addMouseExitedEvent(EventHandler<MouseEvent> mouseExitedEvent) {
        if (mouseExitedEvent == null) {
            if (this.mouseExitedEvent != null) {
                this.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedEvent);
            }
        } else {
            this.addEventHandler(MouseEvent.MOUSE_EXITED, mouseExitedEvent);
        }
        this.mouseExitedEvent = mouseExitedEvent;
    }

    public void addMouseEnteredEvent(EventHandler<MouseEvent> mouseEnteredEvent) {
        if (mouseEnteredEvent == null) {
            if (this.mouseEnteredEvent != null) {
                this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEvent);
            }
        } else {
            this.addEventHandler(MouseEvent.MOUSE_ENTERED, mouseEnteredEvent);
        }
        this.mouseEnteredEvent = mouseEnteredEvent;
    }

    protected TextFlow addStyledTextArea(Pane pane, String content, String text) {
        return this.addStyledTextArea(pane, content, text, MyStyledTextArea.getFontColor(), 10);
    }

    protected TextFlow addStyledTextArea(Pane pane, String content, String text, int size) {
        return this.addStyledTextArea(pane, content, text, MyStyledTextArea.getFontColor(), size);
    }

    protected TextFlow addStyledTextArea(Pane pane, String content, String text, String color, int size) {
        if (content == null) {
            content = "";
        }
        TextFlow myStyledTextArea = ClientSingleton.getInstance().addStyledTextArea(content, text, color, size);
        AnchorPane.setTopAnchor((Node)myStyledTextArea, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)myStyledTextArea, (Double)0.0);
        AnchorPane.setRightAnchor((Node)myStyledTextArea, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)myStyledTextArea, (Double)0.0);
        pane.getChildren().add((Object)myStyledTextArea);
        myStyledTextArea.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedEvent);
        return myStyledTextArea;
    }

    public void setContentToStyledTextArea(TextFlow myStyledTextArea, String content) {
        this.setContentToStyledTextArea(myStyledTextArea, content, MyStyledTextArea.getFontColor(), 10);
    }

    public void setContentToStyledTextArea(TextFlow myStyledTextArea, String content, int size) {
        this.setContentToStyledTextArea(myStyledTextArea, content, MyStyledTextArea.getFontColor(), size);
    }

    public void setContentToStyledTextArea(TextFlow myStyledTextArea, String content, String color, int size) {
        try {
            List<Text> indexRanges = ClientSingleton.getInstance().getIndexRanges(content, this.iSearchSelectionItem.getInputText(), color, size);
            myStyledTextArea.getChildren().clear();
            for (Text str : indexRanges) {
                myStyledTextArea.getChildren().add((Object)str);
            }
        }
        catch (Exception e) {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Error setContentToStyledTextArea : " + content + " e: " + e.getMessage());
            myStyledTextArea.getChildren().add((Object)new Text(content));
        }
    }

    public void dispose() {
        ObservableList list = this.getChildren();
        for (Node node : list) {
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedEvent);
            if (this.mouseEnteredEvent != null) {
                node.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEvent);
            }
            if (this.mouseExitedEvent == null) continue;
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedEvent);
        }
    }

    private String getColor() {
        return Theme.getInstance().isDarkTheme() ? ClientSingleton.getInstance().getStyleValue(Constants.SUBJECT_TEXT_FILL) : "#646a7e";
    }

    public void setItemStyle(String color) {
    }

    public void update(SearchObject searchObject) {
    }

    protected String getStyle(String color) {
        return "-fx-background-color:" + color + "; -fx-cursor: hand;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;";
    }
}

