/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.views;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchBaseViewWithTextFlow;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;
import smile.cti.client.Activity;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class SearchCallInfoCellView
extends SearchBaseViewWithTextFlow
implements Comparable<SearchObject> {
    private TextFlow sessionNameTextArea;
    private final HBox headerLine;
    private HBox zeroBox;
    private VBox secondLine;
    private final int LEFT_PADDING = 15;
    private TextFlow activityTextArea;
    private TextFlow titleTextArea;
    private Label fx_lbMessageTime;

    public SearchCallInfoCellView(ISearchSelectionItem iSearchSelectionItem, SearchObject searchObject) {
        super(searchObject, iSearchSelectionItem, "transparent");
        this.addMousePressedEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            MessageInfo messageInfo = (MessageInfo)this.searchObject.getItem();
            SessionInfo sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSessionInfo(messageInfo.getSessionId());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", sessionInfo);
            data.put("messageInfo", messageInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        }));
        this.setItemStyle("transparent");
        if (searchObject.getSessionName() != null) {
            this.addSessionNameLine(iSearchSelectionItem.getInputText());
        }
        this.headerLine = new HBox();
        this.headerLine.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.addChild((Pane)this.headerLine);
        this.setPadding(new Insets(10.0, 0.0, 5.0, 0.0));
        this.headerLine.setPadding(new Insets(5.0, 0.0, 5.0, 30.0));
        this.headerLine.setAlignment(Pos.CENTER_LEFT);
        this.getTitleBox(iSearchSelectionItem);
        this.setCallActivityData();
    }

    private void addSessionNameLine(String text) {
        this.zeroBox = new HBox();
        this.zeroBox.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.zeroBox.setAlignment(Pos.CENTER_LEFT);
        this.zeroBox.setPadding(new Insets(0.0, 0.0, 0.0, 30.0));
        ImageView imageView = this.getArrowPane();
        HBox.setMargin((Node)imageView, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        this.zeroBox.getChildren().add(0, (Object)imageView);
        this.sessionNameTextArea = this.addStyledTextArea((Pane)this.zeroBox, this.searchObject.getSessionName(), text, 11);
        HBox.setHgrow((Node)this.sessionNameTextArea, (Priority)Priority.ALWAYS);
        this.zeroBox.getChildren().add((Object)this.getMessageTimeLabel());
        this.addChild((Pane)this.zeroBox);
    }

    private void getTitleBox(ISearchSelectionItem iSearchSelectionItem) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.prefWidthProperty().bind((ObservableValue)this.headerLine.widthProperty());
        StackPane.setAlignment((Node)hBox, (Pos)Pos.CENTER_LEFT);
        this.titleTextArea = this.addStyledTextArea((Pane)hBox, this.searchObject.getTitle(), iSearchSelectionItem.getInputText(), Constants.colorForSmallFont, 10);
        HBox.setHgrow((Node)this.titleTextArea, (Priority)Priority.ALWAYS);
        this.headerLine.getChildren().add((Object)hBox);
    }

    private Label getMessageTimeLabel() {
        this.fx_lbMessageTime = new Label(this.searchObject.getMessageTime());
        this.fx_lbMessageTime.setStyle("-fx-font-size: 8pt;-fx-line-height: 1.19;-fx-text-fill: " + MyStyledTextArea.getFontColor() + ";-fx-font-family: \"Arial\";");
        this.fx_lbMessageTime.setMinWidth((double)(this.searchObject.getMessageTime().length() * 5));
        this.fx_lbMessageTime.setAlignment(Pos.CENTER_RIGHT);
        HBox.setMargin((Node)this.fx_lbMessageTime, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        return this.fx_lbMessageTime;
    }

    private ImageView getArrowPane() {
        ImageView imageView = new ImageView();
        imageView.setFitWidth(13.0);
        imageView.setFitWidth(10.0);
        imageView.setPickOnBounds(true);
        imageView.setPreserveRatio(true);
        ClientSingleton.getInstance().setArrowPngName(imageView, (MessageInfo)this.searchObject.getItem());
        return imageView;
    }

    private void setCallActivityData() {
        MessageInfo messageInfo = (MessageInfo)this.searchObject.getItem();
        String inputText = this.iSearchSelectionItem.getInputText();
        Activity activity = messageInfo.getActivity();
        if (activity != null) {
            String comment;
            String subject = activity.getSubject() == null ? "" : activity.getSubject().toLowerCase();
            String string = comment = activity.getComment() == null ? "" : activity.getComment().toLowerCase();
            if (!subject.isEmpty() || !comment.isEmpty()) {
                String text = (String)(subject.isEmpty() ? "" : ClientSingleton.getInstance().getString("call_subject_label2") + " " + subject) + "\n" + (String)(comment.isEmpty() ? "" : ClientSingleton.getInstance().getString("call_subject_label1") + " " + comment);
                if (this.activityTextArea == null) {
                    this.activityTextArea = this.addStyledTextArea((Pane)this.getSecondLine(), text, inputText, Constants.colorForSmallFont, 10);
                } else {
                    this.setContentToStyledTextArea(this.activityTextArea, text, Constants.colorForSmallFont, 10);
                    if (!this.getSecondLine().getChildren().contains((Object)this.activityTextArea)) {
                        this.getSecondLine().getChildren().add((Object)this.activityTextArea);
                    }
                }
            }
        } else if (this.activityTextArea != null) {
            this.getSecondLine().getChildren().remove((Object)this.activityTextArea);
        }
    }

    private VBox getSecondLine() {
        if (this.secondLine == null) {
            this.secondLine = new VBox();
            this.secondLine.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
            this.addChild((Pane)this.secondLine);
            this.secondLine.setPadding(new Insets(0.0, 0.0, 5.0, 30.0));
        }
        return this.secondLine;
    }

    @Override
    public void setItemStyle(String color) {
        this.setStyle(this.getStyle(color));
    }

    @Override
    public int compareTo(SearchObject searchObject2) {
        MessageInfo messageInfo = (MessageInfo)this.searchObject.getItem();
        MessageInfo messageInfo2 = (MessageInfo)searchObject2.getItem();
        return (int)(messageInfo.getTime() - messageInfo2.getTime());
    }

    @Override
    public void dispose() {
        this.headerLine.prefWidthProperty().unbind();
        if (this.secondLine != null) {
            this.secondLine.prefWidthProperty().unbind();
        }
        if (this.zeroBox != null) {
            this.zeroBox.prefWidthProperty().unbind();
        }
        super.dispose();
    }

    @Override
    public void update(SearchObject searchObject) {
        this.searchObject = searchObject;
        this.setCallActivityData();
        this.setContentToStyledTextArea(this.titleTextArea, searchObject.getTitle(), Constants.colorForSmallFont, 10);
        this.fx_lbMessageTime.setText(searchObject.getMessageTime());
        this.fx_lbMessageTime.setMinWidth((double)(searchObject.getMessageTime().length() * 6));
        if (searchObject.getSessionName() != null) {
            if (this.zeroBox == null) {
                this.addSessionNameLine(this.iSearchSelectionItem.getInputText());
            } else {
                this.setContentToStyledTextArea(this.sessionNameTextArea, searchObject.getSessionName(), 11);
                if (!this.hasChild((Pane)this.zeroBox)) {
                    this.addChild(0, (Pane)this.zeroBox);
                }
            }
        } else if (this.zeroBox != null) {
            this.removeChild((Pane)this.zeroBox);
        }
        this.setItemStyle("transparent");
    }
}

