/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.views;

import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.utils.viewers.statespane.StatesPane;
import net.sipsnet.client.views.profiles.utils.DetailValue;
import net.sipsnet.client.views.profiles.utils.TypeConstantsRT;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchBaseViewWithTextFlow;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;
import smile.cti.client.ContactInfo;

public class SearchContactInfoCellView
extends SearchBaseViewWithTextFlow
implements Comparable<SearchObject> {
    private final HBox mainPane = new HBox();
    private final HBox headerLine = new HBox();
    private final TextFlow titleTextArea;
    private final StatesPane statesPane;
    private VBox secondLine;
    private TextFlow extentionTextArea;
    private TextFlow phoneTextArea;
    private final List<TextFlow> dataListTextArea = new ArrayList<TextFlow>();
    private CallViewButton videoCallImageButton;
    private CallViewButton audioCallImageButton;
    private final EventHandler<MouseEvent> mouseEnteredEvent = mouseEvent -> {
        ContactInfo contactInfo = (ContactInfo)this.searchObject.getItem();
        if (contactInfo.canReceiveVideoCalls()) {
            if (!this.mainPane.getChildren().contains((Object)this.videoCallImageButton)) {
                this.mainPane.getChildren().add((Object)this.videoCallImageButton);
            }
        } else {
            this.mainPane.getChildren().remove((Object)this.videoCallImageButton);
        }
        if (contactInfo.canMakeCalls()) {
            if (!this.mainPane.getChildren().contains((Object)this.audioCallImageButton)) {
                this.mainPane.getChildren().add((Object)this.audioCallImageButton);
            }
        } else {
            this.mainPane.getChildren().remove((Object)this.audioCallImageButton);
        }
    };
    private final EventHandler<MouseEvent> mouseExitedEvent = mouseEvent -> {
        this.mainPane.getChildren().remove((Object)this.videoCallImageButton);
        this.mainPane.getChildren().remove((Object)this.audioCallImageButton);
    };
    private final Collator usCollator = Collator.getInstance();

    public SearchContactInfoCellView(ISearchSelectionItem iSearchSelectionItem, SearchObject searchObject) {
        super(searchObject, iSearchSelectionItem, "transparent");
        this.addMousePressedEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            ContactInfo contactInfo = (ContactInfo)this.searchObject.getItem();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("contactInfo", contactInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        }));
        this.audioCallImageButton = new CallViewButton("tab/tab_audio_call.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            AudioCaller.makeCall((ContactInfo)searchObject.getItem());
            event.consume();
        }));
        this.videoCallImageButton = new CallViewButton("tab/tab_video_call.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            ContactInfo contactInfo = (ContactInfo)searchObject.getItem();
            ClientSingleton.getInstance().getClientConnector().get().makeVideoCall(contactInfo);
            event.consume();
        }));
        this.setItemStyle("transparent");
        ContactInfo contactInfo = (ContactInfo)searchObject.getItem();
        this.mainPane.setMinHeight(27.0);
        this.mainPane.setAlignment(Pos.CENTER_LEFT);
        this.addChild((Pane)this.mainPane);
        this.mainPane.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        this.mainPane.getChildren().add((Object)this.headerLine);
        this.headerLine.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)this.headerLine, (Priority)Priority.ALWAYS);
        this.headerLine.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.statesPane = StatesPane.getInstance(StatesPane.VIEW_MODE.HANDLER_MODE);
        this.statesPane.setState(contactInfo.getState());
        this.headerLine.getChildren().add((Object)this.statesPane);
        this.titleTextArea = this.addStyledTextArea((Pane)this.headerLine, searchObject.getItem().toString(), iSearchSelectionItem.getInputText(), 11);
        HBox.setMargin((Node)this.titleTextArea, (Insets)new Insets(5.0, 10.0, 0.0, 10.0));
        HBox.setHgrow((Node)this.headerLine, (Priority)Priority.ALWAYS);
        this.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.checkDetails((ContactInfo)searchObject.getItem());
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEvent);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedEvent);
    }

    private void checkDetails(ContactInfo contactInfo) {
        String inputText = this.iSearchSelectionItem.getInputText();
        Pair<String, String> pair = this.addExtension(contactInfo, inputText);
        ArrayList<ContactInfo.Detail> details = new ArrayList<ContactInfo.Detail>(contactInfo.getUserDetails());
        details.addAll(contactInfo.getCustomDetails());
        this.addDetailPane(contactInfo, details, inputText, pair);
    }

    private Pair<String, String> addExtension(ContactInfo contactInfo, String inputText) {
        String text;
        Optional<Object> prop = Optional.ofNullable(contactInfo.getProperty("extension"));
        String extension = "";
        String number = contactInfo.getNumber();
        if (number == null || ClientSingleton.getInstance().getUserID(contactInfo).equals(number) || !number.contains(inputText)) {
            number = "";
        }
        if (prop.isPresent()) {
            extension = (String)prop.get();
        }
        if (extension.isEmpty() && (prop = Optional.ofNullable(contactInfo.getProperty("ext"))).isPresent()) {
            extension = (String)prop.get();
        }
        if (!extension.isEmpty() && extension.contains(inputText)) {
            if (extension.contains(inputText)) {
                text = ClientSingleton.getInstance().getString("tab_menu_extension") + " : " + extension;
                if (this.extentionTextArea == null) {
                    this.extentionTextArea = this.addStyledTextArea((Pane)this.getSecondLine(), text, inputText, Constants.colorForSmallFont, 10);
                } else {
                    this.setContentToStyledTextArea(this.extentionTextArea, text, Constants.colorForSmallFont, 10);
                    if (!this.getSecondLine().getChildren().contains((Object)this.extentionTextArea)) {
                        this.getSecondLine().getChildren().add((Object)this.extentionTextArea);
                    }
                }
            } else {
                if (this.extentionTextArea != null) {
                    this.getSecondLine().getChildren().remove((Object)this.extentionTextArea);
                }
                extension = "";
            }
        }
        if (!(contactInfo.isUser() || number.isEmpty() || extension.isEmpty() || extension.equals(number))) {
            text = ClientSingleton.getInstance().getString("Phone") + " : " + number;
            if (this.phoneTextArea == null) {
                this.phoneTextArea = this.addStyledTextArea((Pane)this.getSecondLine(), text, inputText, Constants.colorForSmallFont, 10);
            } else {
                this.setContentToStyledTextArea(this.phoneTextArea, text, Constants.colorForSmallFont, 10);
                if (!this.getSecondLine().getChildren().contains((Object)this.phoneTextArea)) {
                    this.getSecondLine().getChildren().add((Object)this.phoneTextArea);
                }
            }
        } else if (this.phoneTextArea != null) {
            this.getSecondLine().getChildren().remove((Object)this.phoneTextArea);
        }
        return new Pair((Object)extension, (Object)number);
    }

    private void addDetailPane(ContactInfo contactInfo, List<ContactInfo.Detail> details, String inputText, Pair<String, String> pair) {
        for (TextFlow Label2 : this.dataListTextArea) {
            this.getSecondLine().getChildren().remove((Object)Label2);
        }
        this.dataListTextArea.clear();
        List<DetailValue> userDetails = TypeConstantsRT.getDetails(details, contactInfo);
        userDetails.forEach(detailValue -> {
            String value = detailValue.getValue();
            if (value != null && !value.isEmpty()) {
                String val = value.toLowerCase();
                boolean has = val.contains(inputText.toLowerCase());
                if (!((String)pair.getKey()).isEmpty() && !((String)pair.getValue()).isEmpty() && (val.equals(pair.getKey()) || val.equals(pair.getValue()))) {
                    has = false;
                }
                if (has) {
                    this.dataListTextArea.add(this.addStyledTextArea((Pane)this.getSecondLine(), detailValue.getLabel() + " : " + detailValue.getValue(), inputText, Constants.colorForSmallFont, 10));
                }
            }
        });
    }

    private VBox getSecondLine() {
        if (this.secondLine == null) {
            this.secondLine = new VBox();
            this.secondLine.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
            this.addChild((Pane)this.secondLine);
            this.secondLine.setPadding(new Insets(0.0, 0.0, 5.0, 30.0));
        }
        return this.secondLine;
    }

    @Override
    public void setItemStyle(String color) {
        String style = this.getStyle(color);
        this.setStyle(style);
    }

    private boolean isLatin(String str) {
        char c = str.charAt(0);
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '!' && c <= '9';
    }

    @Override
    public int compareTo(SearchObject searchObject2) {
        ContactInfo contactInfo = (ContactInfo)this.searchObject.getItem();
        ContactInfo contactInfo2 = (ContactInfo)searchObject2.getItem();
        this.usCollator.setStrength(0);
        if (this.isLatin(contactInfo.toString()) && !this.isLatin(contactInfo2.toString())) {
            return 1;
        }
        if (!this.isLatin(contactInfo.toString()) && this.isLatin(contactInfo2.toString())) {
            return -1;
        }
        return this.usCollator.compare(contactInfo.toString(), contactInfo2.toString());
    }

    @Override
    public void dispose() {
        this.headerLine.prefWidthProperty().unbind();
        if (this.secondLine != null) {
            this.secondLine.prefWidthProperty().unbind();
        }
        this.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEvent);
        this.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedEvent);
        super.dispose();
    }

    @Override
    public void update(SearchObject searchObject) {
        this.searchObject = searchObject;
        this.statesPane.setState(((ContactInfo)searchObject.getItem()).getState());
        this.setContentToStyledTextArea(this.titleTextArea, searchObject.getItem().toString(), 11);
        this.checkDetails((ContactInfo)searchObject.getItem());
        this.setItemStyle("transparent");
    }
}

