/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.views;

import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ArrowImageButton;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;

public class SearchHeaderCellView
extends HBox {
    private Label fx_lbTitle;
    private final ISearchSelectionItem iSearchSelectionItem;
    private SearchObject searchObject;
    private ArrowImageButton fx_ivArrow;

    public double computeMinWidth(double height) {
        return 280.0;
    }

    public double computePrefWidth(double height) {
        return 280.0;
    }

    public double computePrefHeight(double height) {
        return 32.0;
    }

    public SearchHeaderCellView(ISearchSelectionItem iSearchSelectionItem, SearchObject searchObject) {
        this.iSearchSelectionItem = iSearchSelectionItem;
        this.searchObject = searchObject;
        this.setStyle("-fx-background-color: transparent;");
        this.setPadding(new Insets(5.0, 0.0, 0.0, 12.0));
        this.initComponents();
        this.setTitle();
    }

    public SearchObject.ITEM_MODE getType() {
        return this.searchObject.getType();
    }

    private void setTitle() {
        String title = "";
        title = this.getType() == SearchObject.ITEM_MODE.CONTACTS_HEADER ? ClientSingleton.getInstance().getString("contacts_users") : (this.getType() == SearchObject.ITEM_MODE.EXT_CONTACTS_HEADER ? ClientSingleton.getInstance().getString("contacts_contacts") : (this.getType() == SearchObject.ITEM_MODE.SESSIONS_HEADER ? ClientSingleton.getInstance().getString("tab_sessions") : ClientSingleton.getInstance().getString("tab_calls")));
        this.fx_lbTitle.setText(title);
    }

    public String getTitle() {
        return ((Object)((Object)this)).hashCode() + " " + this.fx_lbTitle.getText();
    }

    public String toString() {
        return this.getSessionId();
    }

    public String getSessionId() {
        return this.getType().toString();
    }

    public void setMemberViewers(List<Object> items) {
        this.searchObject.setChildItems(items);
    }

    private void initComponents() {
        this.prefHeight(40.0);
        this.minHeight(40.0);
        this.maxHeight(40.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.fx_lbTitle = new Label();
        this.fx_lbTitle.prefHeight(40.0);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbTitle);
        this.fx_lbTitle.setStyle("-fx-font-size: 13px;");
        this.getChildren().add((Object)this.fx_lbTitle);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        hBox.setPrefWidth(30.0);
        hBox.setMinWidth(30.0);
        this.fx_ivArrow = new ArrowImageButton(!this.searchObject.isCollapse());
        HBox.setMargin((Node)this.fx_ivArrow, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.fx_ivArrow.setSize(14, 14);
        this.fx_ivArrow.setBackgroundColor("transparent");
        this.fx_ivArrow.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.fx_ivArrow.makeClick()));
        hBox.getChildren().add((Object)this.fx_ivArrow);
        this.getChildren().add((Object)hBox);
        ClientSingleton.getInstance().setMouseCursor((Node)hBox);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbTitle);
        hBox.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.makeClick());
        this.fx_lbTitle.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.makeClick());
    }

    private void collapse() {
        boolean isCollapse = !this.searchObject.isCollapse();
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "collapse isCollapse=" + isCollapse);
        this.searchObject.setCollapse(isCollapse);
        if (isCollapse) {
            this.iSearchSelectionItem.removeCells(this.searchObject);
        } else {
            this.iSearchSelectionItem.addCells(this.searchObject);
        }
    }

    public void makeClick() {
        ClientSingleton.getInstance().runLater(this::click);
    }

    public void click() {
        this.collapse();
        this.fx_ivArrow.makeClick();
    }

    public void update(SearchObject searchObject) {
        this.searchObject = searchObject;
        this.setTitle();
    }
}

