/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.views;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchBaseViewWithTextFlow;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class SearchMessageInfoCellView
extends SearchBaseViewWithTextFlow
implements Comparable<SearchObject> {
    private final HBox headerLine;
    private final TextFlow titleTextArea;
    private VBox secondLine;
    private final int LEFT_PADDING = 15;
    private TextFlow messageTextArea;
    private Label fx_lbMessageTime;

    public SearchMessageInfoCellView(ISearchSelectionItem iSearchSelectionItem, SearchObject searchObject) {
        super(searchObject, iSearchSelectionItem, "transparent");
        this.addMousePressedEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            mouseEvent.consume();
            MessageInfo messageInfo = (MessageInfo)this.searchObject.getItem();
            SessionInfo sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSessionInfo(messageInfo.getSessionId());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "searchInSessions messageInfo=" + messageInfo + " date=" + ClientSingleton.getInstance().getDateTimeString(messageInfo.getTime()) + " messageInfo.getSessionId()=" + messageInfo.getSessionId() + " sessionInfo=" + sessionInfo);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", sessionInfo);
            data.put("messageInfo", messageInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        }));
        this.setItemStyle("transparent");
        this.headerLine = new HBox();
        this.headerLine.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.addChild((Pane)this.headerLine);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.prefWidthProperty().bind((ObservableValue)this.headerLine.widthProperty());
        this.headerLine.setAlignment(Pos.CENTER_LEFT);
        this.titleTextArea = this.addStyledTextArea((Pane)hBox, searchObject.getSessionName(), iSearchSelectionItem.getInputText(), 11);
        HBox.setHgrow((Node)this.titleTextArea, (Priority)Priority.ALWAYS);
        hBox.getChildren().add((Object)this.getMessageTimeLabel());
        this.headerLine.getChildren().add((Object)hBox);
        this.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.headerLine.setPadding(new Insets(5.0, 0.0, 5.0, 30.0));
        this.addMessageTextArea();
    }

    private Label getMessageTimeLabel() {
        this.fx_lbMessageTime = new Label(this.searchObject.getMessageTime());
        this.fx_lbMessageTime.setStyle("-fx-font-size: 8pt;-fx-line-height: 1.19;-fx-text-fill: " + MyStyledTextArea.getFontColor() + ";-fx-font-family: \"Arial\";");
        this.fx_lbMessageTime.setAlignment(Pos.CENTER_LEFT);
        HBox.setMargin((Node)this.fx_lbMessageTime, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        return this.fx_lbMessageTime;
    }

    private void addMessageTextArea() {
        this.messageTextArea = this.addStyledTextArea((Pane)this.getSecondLine(), this.getMessageContent(), this.iSearchSelectionItem.getInputText(), Constants.colorForSmallFont, 10);
        this.addSenderName();
    }

    private void addSenderName() {
        String senderName = this.searchObject.getSenderName();
        if (!senderName.isEmpty()) {
            Text text = new Text(senderName + ":");
            ClientSingleton.getInstance().setStyledTextControl(text, false, MyStyledTextArea.getFontColor(), 10, false);
            this.messageTextArea.getChildren().add(0, (Object)text);
        }
    }

    private String getMessageContent() {
        String inputText = this.iSearchSelectionItem.getInputText();
        Object mContent = this.searchObject.getMessageContent();
        int count = 120;
        if (((String)mContent).length() > count) {
            int index = ((String)mContent).toLowerCase().indexOf(inputText.toLowerCase());
            if (index < count - inputText.length()) {
                mContent = ((String)mContent).substring(0, count) + "...";
            } else {
                int start = index - 50;
                int end = start + count;
                if (end > ((String)mContent).length() - 1) {
                    start = ((String)mContent).length() - count;
                    end = ((String)mContent).length() - 1;
                }
                mContent = "..." + ((String)mContent).substring(start, end) + "...";
            }
        }
        return mContent;
    }

    private VBox getSecondLine() {
        if (this.secondLine == null) {
            this.secondLine = new VBox();
            this.secondLine.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
            this.addChild((Pane)this.secondLine);
            this.secondLine.setPadding(new Insets(0.0, 0.0, 0.0, 30.0));
        }
        return this.secondLine;
    }

    @Override
    public void setItemStyle(String color) {
        this.setStyle(this.getStyle(color));
    }

    @Override
    public int compareTo(SearchObject searchObject2) {
        MessageInfo messageInfo = (MessageInfo)this.searchObject.getItem();
        MessageInfo messageInfo2 = (MessageInfo)searchObject2.getItem();
        return (int)(messageInfo.getTime() - messageInfo2.getTime());
    }

    @Override
    public void dispose() {
        this.headerLine.prefWidthProperty().unbind();
        if (this.secondLine != null) {
            this.secondLine.prefWidthProperty().unbind();
        }
        super.dispose();
    }

    @Override
    public void update(SearchObject searchObject) {
        this.searchObject = searchObject;
        this.setContentToStyledTextArea(this.titleTextArea, searchObject.getSessionName(), 11);
        this.fx_lbMessageTime.setText(searchObject.getMessageTime());
        this.setContentToStyledTextArea(this.messageTextArea, this.getMessageContent(), Constants.colorForSmallFont, 10);
        this.addSenderName();
        this.setManaged(false);
        this.requestLayout();
        this.setItemStyle("transparent");
    }
}

