/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.searchwithtextflow.search.views;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.text.TextFlow;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.ISearchSelectionItem;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchBaseViewWithTextFlow;
import net.sipsnet.client.views.tabs.searchwithtextflow.search.base.SearchObject;
import smile.cti.client.SessionInfo;

public class SearchSessionInfoCellView
extends SearchBaseViewWithTextFlow {
    private HBox sessionInfoPane;
    private TextFlow myStyledTextArea;

    public SearchSessionInfoCellView(ISearchSelectionItem iSearchSelectionItem, SearchObject searchObject) {
        super(searchObject, iSearchSelectionItem, "transparent");
        this.setStyle("-fx-background-color: transparent;");
        this.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        this.initComponents();
    }

    public SearchObject.ITEM_MODE getType() {
        return this.searchObject.getType();
    }

    public String toString() {
        return this.getSessionId();
    }

    public String getSessionId() {
        return this.getType().toString();
    }

    private void initComponents() {
        this.sessionInfoPane = new HBox();
        this.sessionInfoPane.setAlignment(Pos.CENTER_LEFT);
        this.sessionInfoPane.setAlignment(Pos.CENTER_LEFT);
        ImageButton imageButton = new ImageButton();
        imageButton.setBackgroundColor("transparent");
        imageButton.setSize(12, 12);
        imageButton.setImagePath("other/dark_chevron_right.png");
        HBox.setMargin((Node)imageButton, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        ClientSingleton.getInstance().setMouseCursor((Node)imageButton);
        this.addMousePressedEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            SessionInfo tmpSession = (SessionInfo)this.searchObject.getItem();
            SessionInfo sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSessionInfo(tmpSession.getSessionId());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", sessionInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        }));
        this.setItemStyle("transparent");
        this.myStyledTextArea = this.addStyledTextArea((Pane)this.sessionInfoPane, this.searchObject.toString(), this.iSearchSelectionItem.getInputText(), 11);
        HBox.setHgrow((Node)this.myStyledTextArea, (Priority)Priority.ALWAYS);
        this.sessionInfoPane.getChildren().add((Object)imageButton);
        this.sessionInfoPane.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        this.sessionInfoPane.setPadding(new Insets(10.0, 5.0, 10.0, 30.0));
        this.addChild((Pane)this.sessionInfoPane);
    }

    @Override
    public void setItemStyle(String color) {
        String style = this.getStyle(color);
        this.sessionInfoPane.setStyle(style);
    }

    @Override
    public void update(SearchObject searchObject) {
        this.searchObject = searchObject;
        this.setContentToStyledTextArea(this.myStyledTextArea, searchObject.toString(), 11);
        this.setItemStyle("transparent");
    }
}

