/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.sessions.flow;

import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.tabs.sessions.flow.SessionCellView;
import net.sipsnet.client.views.tabs.sessions.flow.SessionHeaderCellView;
import net.sipsnet.client.views.tabs.sessions.flow.TabSessionsController;
import net.sipsnet.client.views.tabs.sessions.flow.utils.SessionInfoHeader;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import org.fxmisc.flowless.Cell;
import smile.cti.client.SessionInfo;

public class SessionInfoCell
implements Cell<SessionInfo, Node> {
    private final INewMessagesNotification iNewMessagesNotification;
    private final TabSessionsController tabSessionsController;
    private Pane sessionCell;

    public SessionInfoCell(SessionInfo sessionInfo, TabSessionsController tabSessionsController, INewMessagesNotification iNewMessagesNotification) {
        this.tabSessionsController = tabSessionsController;
        this.iNewMessagesNotification = iNewMessagesNotification;
        this.initCell(sessionInfo);
    }

    private void initCell(SessionInfo sessionInfo) {
        if (sessionInfo instanceof SessionInfoHeader) {
            this.dispose();
            SessionInfoHeader sessionInfoHeader = (SessionInfoHeader)sessionInfo;
            this.sessionCell = new SessionHeaderCellView(this.tabSessionsController, sessionInfoHeader);
            ClientSingleton.getInstance().setFocusNotTraversable(this.sessionCell);
            this.sessionCell.prefWidthProperty().bind((ObservableValue)this.tabSessionsController.widthProperty().subtract(10));
        } else {
            this.createSessionCell(sessionInfo);
        }
    }

    private void createSessionCell(SessionInfo sessionInfo) {
        if (this.sessionCell instanceof SessionCellView) {
            ((SessionCellView)this.sessionCell).bind(sessionInfo);
        } else {
            this.dispose();
            this.sessionCell = new SessionCellView(BaseCell.ITEM_MODE.SESSION_ITEM, this.tabSessionsController, sessionInfo, this.iNewMessagesNotification);
            ClientSingleton.getInstance().setFocusNotTraversable(this.sessionCell);
            this.sessionCell.prefWidthProperty().bind((ObservableValue)this.tabSessionsController.widthProperty().subtract(10));
        }
        this.iNewMessagesNotification.getSelectedItemId().ifPresent(sessionInfoId -> ((SessionCellView)this.sessionCell).setSelectedCellStyle(Objects.equals(sessionInfoId, ((SessionCellView)this.sessionCell).getSessionInfo().getSessionId())));
    }

    public Pane getNode() {
        return this.sessionCell;
    }

    public boolean isReusable() {
        return false;
    }

    public void updateItem(SessionInfo sessionInfo) {
        this.initCell(sessionInfo);
    }

    public void dispose() {
        if (this.sessionCell != null) {
            this.sessionCell.prefWidthProperty().unbind();
            if (this.sessionCell instanceof SessionCellView) {
                ((SessionCellView)this.sessionCell).dispose();
            } else {
                ClientSingleton.getInstance().releaseViewResources(this.sessionCell);
            }
            this.sessionCell = null;
        }
    }
}

