/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.sessions.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.views.tabs.TabBaseView;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.sessions.flow.SessionCellView;
import net.sipsnet.client.views.tabs.sessions.flow.SessionHeaderCellView;
import net.sipsnet.client.views.tabs.sessions.flow.SessionInfoCell;
import net.sipsnet.client.views.tabs.sessions.flow.utils.SessionInfoHeader;
import net.sipsnet.client.views.tabs.utils.BaseCell;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import net.sipsnet.client.views.tabs.utils.ISessionsTabActions;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class TabSessionsController
extends TabBaseView<SessionInfo>
implements IGUIObservable,
ISessionsTabActions {
    private final List<SessionInfoHeader> headers = new ArrayList<SessionInfoHeader>();

    public TabSessionsController(INewMessagesNotification iNewMessagesNotification) {
        super(3, iNewMessagesNotification);
        this.initObservable();
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this);
        this.setCellFactory(sessionInfo -> new SessionInfoCell((SessionInfo)sessionInfo, this, iNewMessagesNotification), integer -> {
            iNewMessagesNotification.invalidateSessionsNewMessages();
            return UpdateLists.updateSessionsList(this.headers);
        });
        this.addScrollPane();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initiate done");
    }

    @Override
    public void addScrollPane() {
        super.addScrollPane();
    }

    @Override
    public void updateList() {
        this.updateList(SCROLL_TO_TOP);
    }

    @Override
    public void updateList(int mode) {
        this.updateListItems(mode);
    }

    @Override
    public void updateListItems(int mode) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "updateList start");
        if (this.headers.isEmpty()) {
            this.headers.add(new SessionInfoHeader(0));
            this.headers.add(new SessionInfoHeader(1));
        }
        super.updateListItems(mode);
    }

    @Override
    public List<SessionInfo> getListOnSearch(String prefix) {
        ArrayList<SessionInfo> members = new ArrayList<SessionInfo>(this.headers.get(0).getMemberLists());
        members.addAll(this.headers.get(1).getMemberLists());
        if (members.isEmpty()) {
            members.addAll((Collection<SessionInfo>)this.dataInfoList);
        }
        return ClientSingleton.getInstance().getSessions(members, prefix);
    }

    private void initObservable() {
        String[] actions = new String[]{Constants.UPDATE_SESSIONS_LIST};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        if (action.equals(Constants.UPDATE_SESSIONS_LIST)) {
            int tab;
            this.updateList(SCROLL_TO_TOP);
            int n = tab = data.get("tab") == null ? -1 : (Integer)data.get("tab");
            if (tab != -1) {
                ClientSingleton.getInstance().switchTab(tab);
            }
        }
        if (data != null) {
            data.clear();
        }
    }

    public void onMessageReceivedOrUpdated(SessionInfo sessionInfo, MessageInfo messageInfo) {
        ClientSingleton.getInstance().runLater(() -> this.onMessageROrU(sessionInfo, messageInfo));
    }

    private void onMessageROrU(SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (messageInfo != null && sessionInfo != null) {
            if (messageInfo.getType() == 14) {
                this.updateHandler(sessionInfo, 0);
            } else if (messageInfo.getStatus() == 0 || messageInfo.getStatus() == 3 || messageInfo.getStatus() == 1 || messageInfo.getStatus() == 12) {
                boolean noDisturb;
                boolean bl = noDisturb = sessionInfo.getProperty("nodisturb") != null && (Boolean)sessionInfo.getProperty("nodisturb") != false;
                if (noDisturb) {
                    return;
                }
                ClientSingleton.getInstance().runLater(() -> this.onMessageReceived(sessionInfo));
            }
        }
    }

    private void onMessageReceived(SessionInfo sessionInfo) {
        SessionInfoHeader groups = sessionInfo.isGroup() ? this.headers.get(0) : this.headers.get(1);
        SessionHeaderCellView sessionHeaderCellView = this.getSessionHeaderCell(groups.getSessionId());
        if (sessionHeaderCellView != null && !ClientSingleton.getInstance().isPinnedChat(sessionInfo) && groups.isCollapse()) {
            sessionHeaderCellView.click();
        }
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        IntStream.range(0, this.dataInfoList.size()).forEach(i -> {
            SessionInfo sessionInfo1 = (SessionInfo)this.dataInfoList.get(i);
            if (sessionInfo1.getSessionId().equals(sessionInfo.getSessionId())) {
                atomicInteger.set(i);
            }
        });
        if (atomicInteger.get() != -1) {
            if (atomicInteger.get() > 0 && this.dataInfoList.get(atomicInteger.get() - 1) instanceof SessionInfoHeader) {
                if (this.iNewMessagesNotification.isNeedNotifyOnNewMessage(sessionInfo)) {
                    this.updateHandler(sessionInfo, 1);
                }
            } else {
                this.updateSessionsList(atomicInteger);
            }
        } else if (groups.isFirstIndex(sessionInfo.getSessionId())) {
            if (this.iNewMessagesNotification.isNeedNotifyOnNewMessage(sessionInfo)) {
                this.updateHandler(sessionInfo, 1);
            }
        } else {
            TimerExecutor.getInstance().setMyAction(this::updateList).startWithDelay(50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionsList(AtomicInteger atomicInteger) {
        ObservableList observableList = this.dataInfoList;
        synchronized (observableList) {
            SessionInfo sessionInfo1 = (SessionInfo)this.dataInfoList.remove(atomicInteger.get());
            SessionInfoHeader dGroups = this.headers.get(1);
            SessionInfoHeader groups = this.headers.get(0);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "updateSessionsList dGroups.getMemberLists().isEmpty()=" + dGroups.getMemberLists().isEmpty() + " groups.getMemberLists().isEmpty()=" + groups.getMemberLists().isEmpty());
            if (dGroups.getMemberLists().isEmpty() && groups.getMemberLists().isEmpty()) {
                atomicInteger.set(0);
            } else {
                for (int i = atomicInteger.get() - 1; i >= 0; --i) {
                    SessionInfoHeader sessionInfoHeader;
                    SessionInfoHeader sessionInfoHeader2 = sessionInfoHeader = sessionInfo1.isGroup() ? groups : dGroups;
                    if (!ClientSingleton.getInstance().isPinnedChat(sessionInfo1)) {
                        if (!((SessionInfo)this.dataInfoList.get(i)).equals((Object)sessionInfoHeader) && !ClientSingleton.getInstance().isPinnedChat((SessionInfo)this.dataInfoList.get(i))) continue;
                        atomicInteger.set(i + 1);
                        break;
                    }
                    if (!((SessionInfo)this.dataInfoList.get(i)).equals((Object)sessionInfoHeader)) continue;
                    atomicInteger.set(i + 1);
                    break;
                }
            }
            this.dataInfoList.add(atomicInteger.get(), (Object)sessionInfo1);
            if (!groups.getMemberLists().isEmpty()) {
                Collections.sort(groups.getMemberLists());
            }
            if (!dGroups.getMemberLists().isEmpty()) {
                Collections.sort(dGroups.getMemberLists());
            }
            this.updateHandler(sessionInfo1, 1);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "updateSessionsList atomicInteger.get()=" + atomicInteger.get());
            if (atomicInteger.get() == 0) {
                this.virtualFlow.showAsFirst(0);
            }
        }
    }

    private void handlerUpdate(SessionInfo sessionInfo, int mode) {
        BaseCell sessionCell = this.getItemCell(sessionInfo.getSessionId());
        if (sessionCell != null) {
            if (mode == 0) {
                sessionCell.update();
            } else {
                sessionCell.updateNewMessages();
            }
        }
    }

    @Override
    public void updateVisibleHandles() {
        super.updateVisibleHandles();
    }

    public void updateHandler(SessionInfo sessionInfo, int mode) {
        ClientSingleton.getInstance().runLater(() -> this.handlerUpdate(sessionInfo, mode));
    }

    public void setMute(SessionInfo sessionInfo) {
        BaseCell sessionCell = this.getItemCell(sessionInfo.getSessionId());
        if (sessionCell != null) {
            ((SessionCellView)sessionCell).setMute();
        }
    }

    @Override
    public void removeCells(SessionInfoHeader sessionInfoHeader) {
        this.updateList();
    }

    @Override
    public void addCells(SessionInfoHeader sessionInfoHeader) {
        this.updateList();
    }

    private SessionHeaderCellView getSessionHeaderCell(String sessionId) {
        AtomicReference aSessionCell = new AtomicReference();
        try {
            for (int i = this.virtualFlow.getFirstVisibleIndex(); i < this.virtualFlow.getLastVisibleIndex(); ++i) {
                Node node = this.virtualFlow.getCell(i).getNode();
                if (!(node instanceof SessionHeaderCellView)) continue;
                SessionHeaderCellView sessionHeaderCellView = (SessionHeaderCellView)node;
                if (sessionId != null && !sessionId.equals(sessionHeaderCellView.getSessionId() == null ? String.valueOf(((Object)((Object)sessionHeaderCellView)).hashCode()) : sessionHeaderCellView.getSessionId())) continue;
            }
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException ex) {
            ex.printStackTrace();
        }
        return (SessionHeaderCellView)((Object)aSessionCell.get());
    }

    public void setFirstVisibleCell() {
        if (this.virtualFlow.getFirstVisibleIndex() > 0 && !this.dataInfoList.isEmpty()) {
            try {
                this.virtualFlow.getCell(0);
                this.virtualFlow.showAsFirst(0);
                this.setLastScrollMode(SCROLL_TO_TOP);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Error : setFirstVisibleCell dataInfoList dataInfoList.size() =" + this.dataInfoList.size() + " virtualFlow.visibleCells().size()=" + this.virtualFlow.visibleCells().size());
            }
        }
    }
}

