/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.sessions.flow.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sipsnet.client.connector.ClientSingleton;
import smile.cti.client.SessionInfo;

public class SessionInfoHeader
extends SessionInfo {
    public static final int PINNED = 0;
    public static final int UNPINNED = 1;
    public static final String GROUP_COLLAPSED_TAG = "groups_collapsed";
    public static final String DIRECT_SESSIONS_COLLAPSED_TAG = "direct_session_collapsed";
    private final int type;
    private String title;
    private boolean isCollapse;
    private final List<SessionInfo> membersList = new ArrayList<SessionInfo>();

    public SessionInfoHeader(int type) {
        this.type = type;
        this.setTitle();
        super.setSessionId(this.title + ":" + System.currentTimeMillis());
        Optional<Boolean> isCollapsed = ClientSingleton.getInstance().getBooleanProperty(type == 0 ? GROUP_COLLAPSED_TAG : DIRECT_SESSIONS_COLLAPSED_TAG);
        this.setCollapse(isCollapsed.orElse(false));
    }

    public void setCollapse(boolean isCollapse) {
        this.isCollapse = isCollapse;
        ClientSingleton.getInstance().setProperty(this.getType() == 0 ? GROUP_COLLAPSED_TAG : DIRECT_SESSIONS_COLLAPSED_TAG, isCollapse);
    }

    private void setTitle() {
        switch (this.getType()) {
            case 0: {
                this.title = ClientSingleton.getInstance().getString("sessions_pinned");
                break;
            }
            case 1: {
                this.title = ClientSingleton.getInstance().getString("sessions_unpinned");
            }
        }
    }

    public boolean isCollapse() {
        return this.isCollapse;
    }

    public int getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMemberLists(List<SessionInfo> membersList) {
        this.membersList.clear();
        this.membersList.addAll(membersList);
    }

    public List<SessionInfo> getMemberLists() {
        return this.membersList;
    }

    public void clearMembers() {
        this.membersList.clear();
    }

    public boolean isFirstIndex(String id) {
        if (!this.membersList.isEmpty()) {
            return id != null && id.equals(this.membersList.get(0).getSessionId());
        }
        return false;
    }

    public List<SessionInfo> getMemberLists(String prefix) {
        return this.membersList.stream().filter(pane -> pane.toString().toLowerCase().contains(prefix.toLowerCase())).collect(Collectors.toList());
    }

    public boolean isHasNewMessages() {
        return this.membersList.stream().anyMatch(sessionInfo -> ClientSingleton.getInstance().getNewMessagesCount((SessionInfo)sessionInfo) > 0L);
    }

    public SessionInfo getMemberById(String id) {
        List list = this.membersList.stream().filter(sessionInfo -> id.equals(sessionInfo.getSessionId())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (SessionInfo)list.get(0);
    }

    public List<SessionInfo> getUnpinnedMembersList() {
        if (this.isCollapse()) {
            return this.getUnpinnedSessionsList();
        }
        return this.getMemberLists();
    }

    public List<SessionInfo> getUnpinnedSessionsList() {
        return this.membersList.stream().filter(sessionInfo -> !ClientSingleton.getInstance().isPinnedChat((SessionInfo)sessionInfo)).sorted().collect(Collectors.toList());
    }

    public List<SessionInfo> getPinnedMembersList() {
        return this.membersList.stream().filter(ClientSingleton.getInstance()::isPinnedChat).sorted().collect(Collectors.toList());
    }
}

