/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.speeddial.flow.utils;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class BLFTogglePane
extends HBox {
    public static final int BLF_ON = 0;
    public static final int BLF_OFF = 1;
    public static final int BLF_NA = 2;
    private int currentBLFStat = 2;
    private final Label lbState = new Label();
    private final String offBackgroundColor = "#969aae";
    private String currentColor = "#969aae";

    public BLFTogglePane() {
        this.setPrefHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefWidth(40.0);
        this.setMaxWidth(40.0);
        this.setAlignment(Pos.CENTER);
        this.lbState.setFont(Font.font((String)"HelveticaNeue", (FontWeight)FontWeight.SEMI_BOLD, (double)13.0));
        this.lbState.setAlignment(Pos.CENTER);
        this.getChildren().add((Object)this.lbState);
        this.setStyle(this.getThumbAreaStyle());
    }

    public void setBLFState(int state) {
        String currentFillColor;
        String onFillColor = "#ffffff";
        if (state == 0) {
            this.currentBLFStat = 2;
            StackPane.setAlignment((Node)this.lbState, (Pos)Pos.CENTER_LEFT);
            this.lbState.setText("n/a");
            this.currentColor = "#dadde6";
            currentFillColor = "#000000";
        } else if (state == 4) {
            this.currentBLFStat = 1;
            StackPane.setAlignment((Node)this.lbState, (Pos)Pos.CENTER_RIGHT);
            this.lbState.setText("off");
            this.currentColor = "#4b96d5";
            currentFillColor = onFillColor;
        } else {
            this.currentBLFStat = 0;
            StackPane.setAlignment((Node)this.lbState, (Pos)Pos.CENTER_RIGHT);
            this.lbState.setText("on");
            this.currentColor = "#E65D5D";
            currentFillColor = onFillColor;
        }
        this.lbState.setTextFill((Paint)Color.web((String)currentFillColor));
        this.setStyle(this.getThumbAreaStyle());
    }

    private String getThumbAreaStyle() {
        int radius = (int)this.getPrefHeight() / 2;
        return "-fx-control-inner-background:" + this.currentColor + ";-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + ";-fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + ";-fx-background-color: -fx-control-inner-background;";
    }
}

