/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.speeddial.flow.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.ThreeObjects;
import smile.cti.client.ContactInfo;

public class SpeedDialHeader
extends ContactInfo {
    public static final int FEATURE_BLF = 0;
    public static final int CONTACTS = 1;
    public static final String FEATURE_COLLAPSED_TAG = "speed_dial_feature";
    public static final String CONTACTS_COLLAPSED_TAG = "speed_dial_contact";
    private final int type;
    private String title;
    private boolean isCollapse;
    private List<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>> membersList = new ArrayList<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>>();

    public SpeedDialHeader(int type) {
        this.type = type;
        this.setTitle();
        super.setUserId(this.title + ":" + System.currentTimeMillis());
        Optional<Boolean> isCollapsed = ClientSingleton.getInstance().getBooleanProperty(type == 0 ? FEATURE_COLLAPSED_TAG : CONTACTS_COLLAPSED_TAG);
        this.setCollapse(isCollapsed.orElse(false));
    }

    public void setCollapse(boolean isCollapse) {
        this.isCollapse = isCollapse;
        ClientSingleton.getInstance().setProperty(this.getType() == 0 ? FEATURE_COLLAPSED_TAG : CONTACTS_COLLAPSED_TAG, isCollapse);
    }

    private void setTitle() {
        switch (this.getType()) {
            case 0: {
                this.title = ClientSingleton.getInstance().getString(FEATURE_COLLAPSED_TAG);
                break;
            }
            case 1: {
                this.title = ClientSingleton.getInstance().getString(CONTACTS_COLLAPSED_TAG);
            }
        }
    }

    public boolean isCollapse() {
        return this.isCollapse;
    }

    public int getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMemberLists(List<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>> membersList) {
        this.membersList = membersList;
    }

    public List<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>> getMemberLists() {
        return this.membersList;
    }

    public void clearMembers() {
        this.membersList.clear();
    }

    public String toString() {
        return this.title;
    }
}

