/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.speeddial.flow.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.concurrent.Task;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.SpeedDialHeader;
import net.sipsnet.client.views.tabs.speeddial.flow.utils.ThreeObjects;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;

public class UpdateSpeedDialListTask
extends Task<List<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>>> {
    private final String prefix;

    public UpdateSpeedDialListTask(String prefix) {
        this.prefix = prefix;
    }

    protected List<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>> call() throws Exception {
        ArrayList<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>> contactsPair = new ArrayList<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>>();
        List<Object> selectedContacts = new ArrayList();
        Optional<ClientConnector> oClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (oClientConnector.isPresent()) {
            List contacts = oClientConnector.get().getContacts();
            Function<ContactInfo, Integer> classifier1 = contactInfo -> {
                if (contactInfo.isBlf()) {
                    return 0;
                }
                return 1;
            };
            Stream<ContactInfo> stream = contacts.stream().filter(contactInfo -> (contactInfo.isBlf() || contactInfo.isSpeedDial()) && contactInfo.getStatus() != 3);
            if (this.prefix != null && !this.prefix.isEmpty()) {
                stream = stream.filter(contactInfo -> contactInfo.toString().toLowerCase().contains(this.prefix.toLowerCase()));
            }
            selectedContacts = stream.filter(ClientSingleton.getInstance().distinctByKey(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).sorted().collect(Collectors.toList());
            Collector<ContactInfo, ?, Map<Integer, List<ContactInfo>>> collector1 = Collectors.groupingBy(classifier1);
            Map<Integer, List<ContactInfo>> map1 = selectedContacts.stream().collect(collector1);
            map1.forEach((header, list) -> {
                SpeedDialHeader speedDialHeader = new SpeedDialHeader((int)header);
                contactsPair.add(new ThreeObjects<SpeedDialHeader, Object, Object>(speedDialHeader, null, null));
                ArrayList<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>> membersList = new ArrayList<ThreeObjects<ContactInfo, ContactInfo, ContactInfo>>();
                for (int index = 0; index < list.size(); index += 3) {
                    ContactInfo first = (ContactInfo)list.get(index);
                    ContactInfo second = null;
                    ContactInfo third = null;
                    if (index + 1 < list.size()) {
                        second = (ContactInfo)list.get(index + 1);
                    }
                    if (index + 2 < list.size()) {
                        third = (ContactInfo)list.get(index + 2);
                    }
                    membersList.add(new ThreeObjects<ContactInfo, ContactInfo, ContactInfo>(first, second, third));
                }
                speedDialHeader.setMemberLists(membersList);
                if (!speedDialHeader.isCollapse()) {
                    contactsPair.addAll(membersList);
                }
            });
        }
        return contactsPair;
    }
}

