/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.utils;

import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.views.settings.MyRadioButton;
import net.sipsnet.client.views.tabs.utils.ICellSelection;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import net.sipsnet.client.views.tabs.utils.IRemovebleCellInterface;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class BaseCell
extends HBox {
    private AvatarPane avatarPane;
    private MyAction myRadioButtonAction;
    protected final String regularColor = ClientSingleton.getInstance().getStyleValue(Constants.TAB_CELL_TEXT_FILL);
    private CallViewButton videoCallImageButton;
    private CallViewButton audioCallImageButton;
    private final String currentStyle = "";
    private final HBox viewContainer = new HBox();
    private final HBox radioButtonViewContainer = new HBox();
    private final HBox iconViewContainer = new HBox();
    private MyRadioButton myRadioButton;
    private MyAction onMouseEnteredAction;
    private MyAction onMouseExitedAction;
    private ICellSelection iCellSelection = null;
    private boolean isSelectedCell;
    protected final INewMessagesNotification iNewMessagesNotification;
    private final EventHandler<MouseEvent> mouseEvent = mouseEvent -> {
        if (ClientSingleton.getInstance().getCurrentViewMode() == 1) {
            ContactInfo contactInfo;
            SessionInfo sessionInfo;
            this.setSelectedCellStyle(true);
            if (this.onMouseEnteredAction != null) {
                this.onMouseEnteredAction.execute();
            }
            if ((sessionInfo = this.getSessionInfo()) == null && (contactInfo = this.getContactInfo()) != null && (sessionInfo = ClientSingleton.getInstance().getSessionInfo(contactInfo)) == null) {
                sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSession(contactInfo);
            }
            if (sessionInfo != null) {
                if (sessionInfo.canMakeVideoCall()) {
                    if (!this.getChildren().contains((Object)this.videoCallImageButton)) {
                        this.getChildren().add((Object)this.videoCallImageButton);
                    }
                } else {
                    this.getChildren().remove((Object)this.videoCallImageButton);
                }
                if (sessionInfo.canMakeCall()) {
                    if (!this.getChildren().contains((Object)this.audioCallImageButton)) {
                        this.getChildren().add((Object)this.audioCallImageButton);
                    }
                } else {
                    this.getChildren().remove((Object)this.audioCallImageButton);
                }
            } else {
                this.getChildren().remove((Object)this.videoCallImageButton);
                this.getChildren().remove((Object)this.audioCallImageButton);
            }
        }
    };
    private final EventHandler<MouseEvent> releaseMouseEvent = mouseEvent -> {
        if (ClientSingleton.getInstance().getCurrentViewMode() == 1) {
            this.setSelectedCellStyle(false);
            if (this.onMouseExitedAction != null) {
                this.onMouseExitedAction.execute();
            }
        }
    };
    private final EventHandler<MouseEvent> viewContainerMouseEvent = mouseEvent -> {
        try {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "MouseEvent.MOUSE_CLICKED mouseEvent.getClickCount()=" + mouseEvent.getClickCount() + " isSelectedCell=" + this.isSelectedCell + " iCellSelection=" + this.iCellSelection);
            if (this.iCellSelection != null && this.iCellSelection instanceof IRemovebleCellInterface && ((IRemovebleCellInterface)this.iCellSelection).isMultiSelectionMode()) {
                if (this.myRadioButtonAction != null) {
                    this.myRadioButtonAction.execute();
                }
                return;
            }
            if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                if (!this.isSelectedCell) {
                    this.setSelectedCell(null);
                    TimerExecutor.getInstance().setMyAction(() -> this.iCellSelection.showContextMenu(this, (MouseEvent)mouseEvent)).startWithDelayInGUIThread(400L);
                } else {
                    this.setSelectedCell((MouseEvent)mouseEvent);
                    this.iCellSelection.showContextMenu(this, (MouseEvent)mouseEvent);
                }
            } else if (ClientSingleton.getInstance().getCurrentViewMode() == 1) {
                if (mouseEvent.getClickCount() == 2) {
                    this.setSelectedCellStyle(false);
                    this.setSelectedCell(null);
                }
            } else if (!this.isSelectedCell && mouseEvent.getClickCount() == 1) {
                this.setSelectedCell(null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    };
    private Object infoCell;

    protected void setContainerPadding(Insets insets) {
        this.viewContainer.setPadding(insets);
    }

    public MyRadioButton getMyRadioButton() {
        return this.myRadioButton;
    }

    public double computeMinWidth(double height) {
        return this.getViewWidth();
    }

    public double computePrefWidth(double height) {
        return this.getViewWidth();
    }

    public void setOnMouseEnteredAction(MyAction onMouseEnteredAction) {
        this.onMouseEnteredAction = onMouseEnteredAction;
    }

    public void setOnMouseExitedAction(MyAction onMouseExitedAction) {
        this.onMouseExitedAction = onMouseExitedAction;
    }

    public boolean isSelectedCell() {
        return this.isSelectedCell;
    }

    public void setSelectedCellStyle(boolean selected) {
        this.isSelectedCell = selected;
        Theme.getInstance().applyTabCellTo((Pane)this, this.isSelectedCell);
        if (!selected) {
            ClientSingleton.getInstance().runLater(() -> {
                this.getChildren().remove((Object)this.videoCallImageButton);
                this.getChildren().remove((Object)this.audioCallImageButton);
            });
        }
    }

    protected boolean isMultiSelectionMode() {
        return ((IRemovebleCellInterface)this.iCellSelection).isMultiSelectionMode();
    }

    public void setInfoCell(Object infoCell_) {
        this.infoCell = infoCell_;
    }

    public BaseCell(ITEM_MODE item_mode, ICellSelection iCellSelection, Object infoCell_, INewMessagesNotification iNewMessagesNotification) {
        this.setAlignment(Pos.CENTER_LEFT);
        this.infoCell = infoCell_;
        this.iCellSelection = iCellSelection;
        this.iNewMessagesNotification = iNewMessagesNotification;
        this.setMinWidth(this.getViewWidth());
        this.setMaxWidth(this.getViewWidth());
        this.setPrefWidth(this.getViewWidth());
        this.avatarPane = this.getAvatarPane();
        this.addRadioButtonView();
        if (item_mode != ITEM_MODE.NOT_AUTORIZED_CONTACT_ITEM) {
            this.addIconView();
        }
        HBox.setHgrow((Node)this.viewContainer, (Priority)Priority.ALWAYS);
        this.viewContainer.setAlignment(Pos.CENTER_LEFT);
        this.viewContainer.setPadding(new Insets(2.0, 10.0, 2.0, 2.0));
        this.getChildren().add((Object)this.viewContainer);
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        this.audioCallImageButton = new CallViewButton("tab/tab_audio_call.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "makeCall infoCell=" + this.infoCell + " getClass()=" + this.infoCell.getClass());
            if (this.infoCell instanceof ContactInfo) {
                AudioCaller.makeCall((ContactInfo)this.infoCell);
            } else {
                SessionInfo sessionInfo = (SessionInfo)this.infoCell;
                if (sessionInfo.isGroup()) {
                    ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_start_conference"), ClientSingleton.getInstance().getString("alert_dialog_title3"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent1 -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "makeCall sessionInfo=" + sessionInfo);
                        AudioCaller.makeCall(sessionInfo, false);
                    })));
                } else {
                    AudioCaller.makeCall((SessionInfo)this.infoCell, false);
                }
            }
            event.consume();
        }));
        this.videoCallImageButton = new CallViewButton("tab/tab_video_call.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            SessionInfo sessionInfo = this.getSessionInfo();
            if (sessionInfo != null) {
                if (sessionInfo.isGroup() && ClientSingleton.getInstance().hasMeetingServices()) {
                    ClientSingleton.getInstance().createMeeting(sessionInfo);
                } else {
                    AudioCaller.makeCall(sessionInfo, true);
                }
            } else {
                ContactInfo contactInfo = this.getContactInfo();
                sessionInfo = ClientSingleton.getInstance().getSessionInfo(contactInfo);
                if (sessionInfo == null) {
                    sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSession(contactInfo);
                }
                if (sessionInfo != null) {
                    AudioCaller.makeCall(sessionInfo, true);
                }
            }
            event.consume();
        }));
        HBox.setMargin((Node)this.audioCallImageButton, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        this.viewContainer.addEventFilter(MouseEvent.MOUSE_CLICKED, this.viewContainerMouseEvent);
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, this.mouseEvent);
        this.addEventFilter(MouseEvent.MOUSE_EXITED, this.releaseMouseEvent);
        this.setSelectedCellStyle(false);
    }

    private AvatarPane getAvatarPane() {
        AvatarPane avatarPane = AvatarPane.getInstance(this.infoCell, 30, 15, true);
        HBox.setMargin((Node)avatarPane, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        return avatarPane;
    }

    private float getViewWidth() {
        return 280.0f;
    }

    public void setIconViewContainerVisible(boolean mode) {
        if (!mode) {
            this.getChildren().remove((Object)this.iconViewContainer);
        } else if (!this.getChildren().contains((Object)this.iconViewContainer)) {
            this.getChildren().add((Object)this.iconViewContainer);
        }
    }

    public void clearIconContainer() {
        this.iconViewContainer.getChildren().clear();
    }

    public void removeIconContainer() {
        this.iconViewContainer.getChildren().clear();
        this.getChildren().remove((Object)this.iconViewContainer);
    }

    public void addIconContainer() {
        if (!this.getChildren().contains((Object)this.iconViewContainer)) {
            this.getChildren().add((Object)this.iconViewContainer);
        }
    }

    public void setRadioButtonVisibility(boolean mode) {
        if (this.myRadioButton != null) {
            this.myRadioButton.setVisible(mode);
        }
        this.radioButtonViewContainer.getChildren().clear();
        if (mode) {
            this.radioButtonViewContainer.getChildren().add((Object)this.myRadioButton);
        } else {
            this.radioButtonViewContainer.getChildren().add((Object)this.avatarPane);
        }
    }

    public void addToContainerView(Node pane) {
        if (!this.viewContainer.getChildren().contains((Object)pane)) {
            this.viewContainer.getChildren().add((Object)pane);
        }
    }

    public void removeFromContainerView(Node pane) {
        this.viewContainer.getChildren().remove((Object)pane);
    }

    public void setSelectedCell(MouseEvent mouseEvent) {
        if (this.iCellSelection != null) {
            this.iCellSelection.setSelectedTabCell(this, mouseEvent);
        } else {
            this.setSelectedCellStyle(true);
        }
    }

    protected void setCellTextStyle(Label label, boolean isWhite) {
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)label);
    }

    public String getCellId() {
        String id = null;
        if (this.infoCell instanceof ContactInfo) {
            ContactInfo contactInfo = (ContactInfo)this.infoCell;
            id = ClientSingleton.getInstance().getUserID(contactInfo);
        } else {
            SessionInfo sessionInfo = (SessionInfo)this.infoCell;
            if (sessionInfo.getSessionId() != null) {
                id = sessionInfo.getSessionId();
            }
        }
        if (id == null) {
            id = String.valueOf(((Object)((Object)this)).hashCode());
        }
        return id;
    }

    public void update() {
        this.avatarPane = this.getAvatarPane();
        if (this.myRadioButton != null && this.myRadioButton.isVisible()) {
            return;
        }
        this.radioButtonViewContainer.getChildren().clear();
        this.radioButtonViewContainer.getChildren().add((Object)this.avatarPane);
    }

    public void updateNewMessages() {
    }

    public ContactInfo getContactInfo() {
        ContactInfo contactInfo = null;
        if (this.infoCell instanceof ContactInfo) {
            contactInfo = (ContactInfo)this.infoCell;
        } else {
            SessionInfo sessionInfo = (SessionInfo)this.infoCell;
            contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
        }
        return contactInfo;
    }

    public SessionInfo getSessionInfo() {
        if (this.infoCell instanceof ContactInfo) {
            return null;
        }
        return (SessionInfo)this.infoCell;
    }

    public void setName() {
    }

    public String getCellObjectId() {
        return null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.infoCell.toString() + " id=" + this.getCellId();
    }

    public void addMyRadioButton(MyAction myAction) {
        if (this.myRadioButton == null) {
            this.myRadioButtonAction = myAction;
            this.myRadioButton = new MyRadioButton();
            this.myRadioButton.setRadioRadius(13);
            this.myRadioButton.setDotRadius(7);
            this.myRadioButton.setOnMouseClicked(event -> myAction.execute());
            this.radioButtonViewContainer.getChildren().add((Object)this.myRadioButton);
            this.radioButtonViewContainer.setPrefWidth(30.0);
            this.radioButtonViewContainer.setMinWidth(30.0);
            this.radioButtonViewContainer.setMaxWidth(30.0);
        }
    }

    private void addRadioButtonView() {
        this.radioButtonViewContainer.setAlignment(Pos.CENTER);
        this.radioButtonViewContainer.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.radioButtonViewContainer);
        this.setRadioButtonVisibility(false);
    }

    private void addIconView() {
        this.iconViewContainer.setAlignment(Pos.CENTER);
        this.iconViewContainer.setPrefWidth(20.0);
        this.iconViewContainer.setMinWidth(20.0);
        this.iconViewContainer.setMaxWidth(20.0);
        this.iconViewContainer.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.iconViewContainer);
    }

    public void setRadioButtonBorder(String style, boolean mode) {
        if (this.myRadioButton != null) {
            this.myRadioButton.setBorderColor(style);
            this.myRadioButton.setSelected(mode);
        }
    }

    public void dispose() {
        if (this.radioButtonViewContainer != null) {
            this.radioButtonViewContainer.prefHeightProperty().unbind();
        }
        if (this.iconViewContainer != null) {
            this.iconViewContainer.prefHeightProperty().unbind();
        }
        if (this.audioCallImageButton != null) {
            this.audioCallImageButton.onRelease();
        }
        this.viewContainer.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.viewContainerMouseEvent);
        this.removeEventFilter(MouseEvent.MOUSE_ENTERED, this.mouseEvent);
        this.removeEventFilter(MouseEvent.MOUSE_EXITED, this.releaseMouseEvent);
        this.onMouseEnteredAction = null;
        this.onMouseExitedAction = null;
        ClientSingleton.getInstance().releaseViewResources((Pane)this);
    }

    public static enum ITEM_MODE {
        AUTORIZED_CONTACT_ITEM,
        NOT_AUTORIZED_CONTACT_ITEM,
        SESSION_ITEM,
        CALL_ITEM;

    }
}

